/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.trino.operator.PageWithPositionComparator;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SimplePageWithPositionComparator
implements PageWithPositionComparator {
    private final List<Integer> sortChannels;
    private final List<MethodHandle> orderingOperators;

    public SimplePageWithPositionComparator(List<Type> types, List<Integer> sortChannels, List<SortOrder> sortOrders, TypeOperators typeOperators) {
        this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(sortOrders, "sortOrders is null");
        ImmutableList.Builder orderingOperators = ImmutableList.builder();
        for (int index = 0; index < sortChannels.size(); ++index) {
            Type type = types.get(sortChannels.get(index));
            SortOrder sortOrder = sortOrders.get(index);
            orderingOperators.add((Object)typeOperators.getOrderingOperator(type, sortOrder, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION})));
        }
        this.orderingOperators = orderingOperators.build();
    }

    @Override
    public int compareTo(Page left, int leftPosition, Page right, int rightPosition) {
        try {
            for (int i = 0; i < this.sortChannels.size(); ++i) {
                int sortChannel = this.sortChannels.get(i);
                Block leftBlock = left.getBlock(sortChannel);
                Block rightBlock = right.getBlock(sortChannel);
                MethodHandle orderingOperator = this.orderingOperators.get(i);
                int compare = orderingOperator.invokeExact(leftBlock, leftPosition, rightBlock, rightPosition);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
        }
    }
}

