/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.RemoteTask;
import io.trino.execution.scheduler.BucketNodeMap;
import io.trino.execution.scheduler.NodeAssignmentStats;
import io.trino.execution.scheduler.NodeMap;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.ResettableRandomizedIterator;
import io.trino.execution.scheduler.SplitPlacementResult;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.inject.Inject;

public class NodeScheduler {
    private final NodeSelectorFactory nodeSelectorFactory;

    @Inject
    public NodeScheduler(NodeSelectorFactory nodeSelectorFactory) {
        this.nodeSelectorFactory = Objects.requireNonNull(nodeSelectorFactory, "nodeSelectorFactory is null");
    }

    public NodeSelector createNodeSelector(Session session, Optional<CatalogName> catalogName) {
        return this.nodeSelectorFactory.createNodeSelector(Objects.requireNonNull(session, "session is null"), Objects.requireNonNull(catalogName, "catalogName is null"));
    }

    public static List<InternalNode> getAllNodes(NodeMap nodeMap, boolean includeCoordinator) {
        return (List)nodeMap.getNodesByHostAndPort().values().stream().filter(node -> includeCoordinator || !nodeMap.getCoordinatorNodeIds().contains(node.getNodeIdentifier())).collect(ImmutableList.toImmutableList());
    }

    public static List<InternalNode> selectNodes(int limit, Iterator<InternalNode> candidates) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"limit must be at least 1");
        ArrayList<InternalNode> selected = new ArrayList<InternalNode>(limit);
        while (selected.size() < limit && candidates.hasNext()) {
            selected.add(candidates.next());
        }
        return selected;
    }

    public static ResettableRandomizedIterator<InternalNode> randomizedNodes(NodeMap nodeMap, boolean includeCoordinator, Set<InternalNode> excludedNodes) {
        ImmutableList nodes = (ImmutableList)nodeMap.getNodesByHostAndPort().values().stream().filter(node -> includeCoordinator || !nodeMap.getCoordinatorNodeIds().contains(node.getNodeIdentifier())).filter(node -> !excludedNodes.contains(node)).collect(ImmutableList.toImmutableList());
        return new ResettableRandomizedIterator<InternalNode>((Collection<InternalNode>)nodes);
    }

    public static List<InternalNode> selectExactNodes(NodeMap nodeMap, List<HostAddress> hosts, boolean includeCoordinator) {
        InetAddress address;
        LinkedHashSet chosen = new LinkedHashSet();
        Set<String> coordinatorIds = nodeMap.getCoordinatorNodeIds();
        for (HostAddress host : hosts) {
            nodeMap.getNodesByHostAndPort().get((Object)host).stream().filter(node -> includeCoordinator || !coordinatorIds.contains(node.getNodeIdentifier())).forEach(chosen::add);
            try {
                address = host.toInetAddress();
            }
            catch (UnknownHostException e) {
                continue;
            }
            if (host.hasPort()) continue;
            nodeMap.getNodesByHost().get((Object)address).stream().filter(node -> includeCoordinator || !coordinatorIds.contains(node.getNodeIdentifier())).forEach(chosen::add);
        }
        if (chosen.isEmpty() && !includeCoordinator) {
            for (HostAddress host : hosts) {
                chosen.addAll(nodeMap.getNodesByHostAndPort().get((Object)host));
                try {
                    address = host.toInetAddress();
                }
                catch (UnknownHostException e) {
                    continue;
                }
                if (host.hasPort()) continue;
                chosen.addAll(nodeMap.getNodesByHost().get((Object)address));
            }
        }
        return ImmutableList.copyOf(chosen);
    }

    public static SplitPlacementResult selectDistributionNodes(NodeMap nodeMap, NodeTaskMap nodeTaskMap, long maxSplitsWeightPerNode, long maxPendingSplitsWeightPerTask, int maxUnacknowledgedSplitsPerTask, Set<Split> splits, List<RemoteTask> existingTasks, BucketNodeMap bucketNodeMap) {
        HashMultimap assignments = HashMultimap.create();
        NodeAssignmentStats assignmentStats = new NodeAssignmentStats(nodeTaskMap, nodeMap, existingTasks);
        HashSet<InternalNode> blockedNodes = new HashSet<InternalNode>();
        for (Split split : splits) {
            SplitWeight splitWeight;
            InternalNode node = bucketNodeMap.getAssignedNode(split).get();
            if (NodeScheduler.canAssignSplitToDistributionNode(assignmentStats, node, maxSplitsWeightPerNode, maxPendingSplitsWeightPerTask, maxUnacknowledgedSplitsPerTask, splitWeight = split.getSplitWeight())) {
                assignments.put((Object)node, (Object)split);
                assignmentStats.addAssignedSplit(node, splitWeight);
                continue;
            }
            blockedNodes.add(node);
        }
        ListenableFuture<Void> blocked = NodeScheduler.toWhenHasSplitQueueSpaceFuture(blockedNodes, existingTasks, NodeScheduler.calculateLowWatermark(maxPendingSplitsWeightPerTask));
        return new SplitPlacementResult(blocked, (Multimap<InternalNode, Split>)ImmutableMultimap.copyOf((Multimap)assignments));
    }

    private static boolean canAssignSplitToDistributionNode(NodeAssignmentStats assignmentStats, InternalNode node, long maxSplitsWeightPerNode, long maxPendingSplitsWeightPerTask, int maxUnacknowledgedSplitsPerTask, SplitWeight splitWeight) {
        return assignmentStats.getUnacknowledgedSplitCountForStage(node) < maxUnacknowledgedSplitsPerTask && (NodeScheduler.canAssignSplitBasedOnWeight(assignmentStats.getTotalSplitsWeight(node), maxSplitsWeightPerNode, splitWeight) || NodeScheduler.canAssignSplitBasedOnWeight(assignmentStats.getQueuedSplitsWeightForStage(node), maxPendingSplitsWeightPerTask, splitWeight));
    }

    public static boolean canAssignSplitBasedOnWeight(long currentWeight, long weightLimit, SplitWeight splitWeight) {
        return Math.addExact(currentWeight, splitWeight.getRawValue()) <= weightLimit || currentWeight == 0L && weightLimit > 0L;
    }

    public static long calculateLowWatermark(long maxPendingSplitsWeightPerTask) {
        return (long)Math.ceil((double)maxPendingSplitsWeightPerTask * 0.5);
    }

    public static ListenableFuture<Void> toWhenHasSplitQueueSpaceFuture(Set<InternalNode> blockedNodes, List<RemoteTask> existingTasks, long weightSpaceThreshold) {
        if (blockedNodes.isEmpty()) {
            return Futures.immediateVoidFuture();
        }
        HashMap<String, RemoteTask> nodeToTaskMap = new HashMap<String, RemoteTask>();
        for (RemoteTask task : existingTasks) {
            nodeToTaskMap.put(task.getNodeId(), task);
        }
        List blockedFutures = (List)blockedNodes.stream().map(InternalNode::getNodeIdentifier).map(nodeToTaskMap::get).filter(Objects::nonNull).map(remoteTask -> remoteTask.whenSplitQueueHasSpace(weightSpaceThreshold)).collect(ImmutableList.toImmutableList());
        if (blockedFutures.isEmpty()) {
            return Futures.immediateVoidFuture();
        }
        return NodeScheduler.asVoid(MoreFutures.whenAnyCompleteCancelOthers((Iterable)blockedFutures));
    }

    public static ListenableFuture<Void> toWhenHasSplitQueueSpaceFuture(List<RemoteTask> existingTasks, long weightSpaceThreshold) {
        if (existingTasks.isEmpty()) {
            return Futures.immediateVoidFuture();
        }
        List stateChangeFutures = (List)existingTasks.stream().map(remoteTask -> remoteTask.whenSplitQueueHasSpace(weightSpaceThreshold)).collect(ImmutableList.toImmutableList());
        return NodeScheduler.asVoid(MoreFutures.whenAnyCompleteCancelOthers((Iterable)stateChangeFutures));
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }
}

