/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import io.airlift.units.DataSize;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;

public class ExceededMemoryLimitException
extends TrinoException {
    public static ExceededMemoryLimitException exceededGlobalUserLimit(DataSize maxMemory) {
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_GLOBAL_MEMORY_LIMIT, String.format("Query exceeded distributed user memory limit of %s", maxMemory));
    }

    public static ExceededMemoryLimitException exceededGlobalTotalLimit(DataSize maxMemory) {
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_GLOBAL_MEMORY_LIMIT, String.format("Query exceeded distributed total memory limit of %s", maxMemory));
    }

    public static ExceededMemoryLimitException exceededLocalUserMemoryLimit(DataSize maxMemory, String additionalFailureInfo) {
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT, String.format("Query exceeded per-node user memory limit of %s [%s]", maxMemory, additionalFailureInfo));
    }

    public static ExceededMemoryLimitException exceededLocalTotalMemoryLimit(DataSize maxMemory, String additionalFailureInfo) {
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT, String.format("Query exceeded per-node total memory limit of %s [%s]", maxMemory, additionalFailureInfo));
    }

    public static ExceededMemoryLimitException exceededTaskMemoryLimit(DataSize maxMemory, String additionalFailureInfo) {
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT, String.format("Query exceeded per-task total memory limit of %s [%s]", maxMemory, additionalFailureInfo));
    }

    private ExceededMemoryLimitException(StandardErrorCode errorCode, String message) {
        super((ErrorCodeSupplier)errorCode, message);
    }
}

