/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.Table;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Insert
extends Statement {
    private final Table table;
    private final Query query;
    private final Optional<List<Identifier>> columns;

    public Insert(Table table, Optional<List<Identifier>> columns, Query query) {
        this(Optional.empty(), table, columns, query);
    }

    private Insert(Optional<NodeLocation> location, Table table, Optional<List<Identifier>> columns, Query query) {
        super(location);
        this.table = Objects.requireNonNull(table, "target is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.query = Objects.requireNonNull(query, "query is null");
    }

    public Table getTable() {
        return this.table;
    }

    public QualifiedName getTarget() {
        return this.table.getName();
    }

    public Optional<List<Identifier>> getColumns() {
        return this.columns;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInsert(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.query);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.columns, this.query);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Insert o = (Insert)obj;
        return Objects.equals(this.table, o.table) && Objects.equals(this.columns, o.columns) && Objects.equals(this.query, o.query);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("columns", this.columns).add("query", (Object)this.query).toString();
    }
}

