/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.segmentwriter.filebased;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.utils.TarCompressionUtils;
import org.apache.pinot.core.util.SegmentProcessorAvroUtils;
import org.apache.pinot.segment.local.segment.creator.TransformPipeline;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.BatchIngestionConfig;
import org.apache.pinot.spi.data.readers.FileFormat;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.ingestion.batch.BatchConfig;
import org.apache.pinot.spi.ingestion.segment.writer.SegmentWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class FileBasedSegmentWriter
implements SegmentWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedSegmentWriter.class);
    private static final FileFormat BUFFER_FILE_FORMAT = FileFormat.AVRO;
    private TableConfig _tableConfig;
    private String _tableNameWithType;
    private BatchIngestionConfig _batchIngestionConfig;
    private BatchConfig _batchConfig;
    private String _outputDirURI;
    private org.apache.pinot.spi.data.Schema _schema;
    private Set<String> _fieldsToRead;
    private TransformPipeline _transformPipeline;
    private File _stagingDir;
    private File _bufferFile;
    private Schema _avroSchema;
    private DataFileWriter<GenericData.Record> _recordWriter;
    private GenericData.Record _reusableRecord;

    public void init(TableConfig tableConfig, org.apache.pinot.spi.data.Schema schema) throws Exception {
        this.init(tableConfig, schema, Collections.emptyMap());
    }

    public void init(TableConfig tableConfig, org.apache.pinot.spi.data.Schema schema, Map<String, String> batchConfigOverride) throws Exception {
        this._tableConfig = tableConfig;
        this._tableNameWithType = this._tableConfig.getTableName();
        Preconditions.checkState((this._tableConfig.getIngestionConfig() != null && this._tableConfig.getIngestionConfig().getBatchIngestionConfig() != null && CollectionUtils.isNotEmpty((Collection)this._tableConfig.getIngestionConfig().getBatchIngestionConfig().getBatchConfigMaps()) ? 1 : 0) != 0, (String)"Must provide ingestionConfig->batchIngestionConfig->batchConfigMaps in tableConfig for table: %s", (Object)this._tableNameWithType);
        this._batchIngestionConfig = this._tableConfig.getIngestionConfig().getBatchIngestionConfig();
        Preconditions.checkState((this._batchIngestionConfig.getBatchConfigMaps().size() == 1 ? 1 : 0) != 0, (String)"batchConfigMaps must contain only 1 BatchConfig for table: %s", (Object)this._tableNameWithType);
        HashMap<String, String> batchConfigMap = new HashMap<String, String>((Map)this._batchIngestionConfig.getBatchConfigMaps().get(0));
        batchConfigMap.putAll(batchConfigOverride);
        this._batchConfig = new BatchConfig(this._tableNameWithType, batchConfigMap);
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this._batchConfig.getOutputDirURI()), (String)"Must provide: %s in batchConfigs for table: %s", (Object)"outputDirURI", (Object)this._tableNameWithType);
        this._outputDirURI = this._batchConfig.getOutputDirURI();
        Files.createDirectories(Paths.get(this._outputDirURI, new String[0]), new FileAttribute[0]);
        this._schema = schema;
        this._fieldsToRead = this._schema.getColumnNames();
        this._transformPipeline = new TransformPipeline(this._tableConfig, this._schema);
        this._avroSchema = SegmentProcessorAvroUtils.convertPinotSchemaToAvroSchema((org.apache.pinot.spi.data.Schema)this._schema);
        this._reusableRecord = new GenericData.Record(this._avroSchema);
        this._stagingDir = new File(FileUtils.getTempDirectory(), "segment_writer_staging_" + this._tableNameWithType + "_" + System.currentTimeMillis());
        Preconditions.checkState((boolean)this._stagingDir.mkdirs(), (String)"Failed to create staging dir: %s", (Object)this._stagingDir.getAbsolutePath());
        File bufferDir = new File(this._stagingDir, "buffer_dir");
        Preconditions.checkState((boolean)bufferDir.mkdirs(), (String)"Failed to create buffer_dir: %s", (Object)bufferDir.getAbsolutePath());
        this._bufferFile = new File(bufferDir, "buffer_file");
        this.resetBuffer();
        LOGGER.info("Initialized {} for table: {}", (Object)FileBasedSegmentWriter.class.getName(), (Object)this._tableNameWithType);
    }

    private void resetBuffer() throws IOException {
        FileUtils.deleteQuietly((File)this._bufferFile);
        this._recordWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(this._avroSchema));
        this._recordWriter.create(this._avroSchema, this._bufferFile);
    }

    public void collect(GenericRow row) throws Exception {
        TransformPipeline.Result result = this._transformPipeline.processRow(row);
        for (GenericRow transformedRow : result.getTransformedRows()) {
            SegmentProcessorAvroUtils.convertGenericRowToAvroRecord((GenericRow)transformedRow, (GenericData.Record)this._reusableRecord, this._fieldsToRead);
            this._recordWriter.append((Object)this._reusableRecord);
        }
    }

    public URI flush() throws IOException {
        LOGGER.info("Beginning flush for table: {}", (Object)this._tableNameWithType);
        this._recordWriter.close();
        File flushDir = new File(this._stagingDir, "flush_dir_" + System.currentTimeMillis());
        Preconditions.checkState((boolean)flushDir.mkdirs(), (String)"Failed to create flush dir: %s", (Object)flushDir);
        try {
            File segmentDir = new File(flushDir, "segment_dir");
            HashMap<String, String> batchConfigMapOverride = new HashMap<String, String>(this._batchConfig.getBatchConfigMap());
            batchConfigMapOverride.put("inputDirURI", this._bufferFile.getAbsolutePath());
            batchConfigMapOverride.put("outputDirURI", segmentDir.getAbsolutePath());
            batchConfigMapOverride.put("inputFormat", BUFFER_FILE_FORMAT.toString());
            BatchIngestionConfig batchIngestionConfig = new BatchIngestionConfig((List)Lists.newArrayList((Object[])new Map[]{batchConfigMapOverride}), this._batchIngestionConfig.getSegmentIngestionType(), this._batchIngestionConfig.getSegmentIngestionFrequency(), this._batchIngestionConfig.getConsistentDataPush());
            SegmentGeneratorConfig segmentGeneratorConfig = IngestionUtils.generateSegmentGeneratorConfig((TableConfig)this._tableConfig, (org.apache.pinot.spi.data.Schema)this._schema, (BatchIngestionConfig)batchIngestionConfig);
            String segmentName = IngestionUtils.buildSegment((SegmentGeneratorConfig)segmentGeneratorConfig);
            LOGGER.info("Successfully built segment: {} for table: {}", (Object)segmentName, (Object)this._tableNameWithType);
            File segmentTarFile = new File(this._outputDirURI, segmentName + ".tar.gz");
            if (segmentTarFile.exists()) {
                if (!this._batchConfig.isOverwriteOutput()) {
                    throw new IllegalArgumentException("Duplicate segment name generated '" + segmentName + "' in '" + this._outputDirURI + "', please adjust segment name generator config to avoid duplicates, or allow batch config overwrite");
                }
                LOGGER.warn("Duplicate segment name detected '" + segmentName + "' in file '" + String.valueOf(segmentDir) + "', deleting old segment");
                if (segmentTarFile.delete()) {
                    LOGGER.warn("Segment file deleted: '" + this._outputDirURI + "/" + segmentName + "'");
                }
            }
            TarCompressionUtils.createCompressedTarFile((File)new File(segmentDir, segmentName), (File)segmentTarFile);
            LOGGER.info("Created segment tar: {} for segment: {} of table: {}", new Object[]{segmentTarFile.getAbsolutePath(), segmentName, this._tableNameWithType});
            this.resetBuffer();
            URI uRI = segmentTarFile.toURI();
            return uRI;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Caught exception while generating segment from buffer file: %s for table:%s", this._bufferFile.getAbsolutePath(), this._tableNameWithType), e);
        }
        finally {
            FileUtils.deleteQuietly((File)flushDir);
        }
    }

    public void close() throws IOException {
        LOGGER.info("Closing {} for table: {}", (Object)FileBasedSegmentWriter.class.getName(), (Object)this._tableNameWithType);
        this._recordWriter.close();
        FileUtils.deleteQuietly((File)this._stagingDir);
        this._transformPipeline.reportStats();
    }
}

