/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.ingestion.batch.spark;

import java.util.Arrays;
import java.util.List;
import org.apache.pinot.plugin.ingestion.batch.spark.common.BaseSparkSegmentUriPushJobRunner;
import org.apache.pinot.segment.local.utils.SegmentPushUtils;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.spec.PinotFSSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.VoidFunction;

public class SparkSegmentUriPushJobRunner
extends BaseSparkSegmentUriPushJobRunner {
    public SparkSegmentUriPushJobRunner() {
    }

    public SparkSegmentUriPushJobRunner(SegmentGenerationJobSpec spec) {
        super(spec);
    }

    @Override
    public void parallelizeUriPushJob(final List<PinotFSSpec> pinotFSSpecs, List<String> segmentUris, int pushParallelism) {
        JavaSparkContext sparkContext = JavaSparkContext.fromSparkContext((SparkContext)SparkContext.getOrCreate());
        JavaRDD pathRDD = sparkContext.parallelize(segmentUris, pushParallelism);
        pathRDD.foreach((VoidFunction)new VoidFunction<String>(){

            public void call(String segmentUri) throws Exception {
                try {
                    PluginManager.get().init();
                    for (PinotFSSpec pinotFSSpec : pinotFSSpecs) {
                        PinotFSFactory.register((String)pinotFSSpec.getScheme(), (String)pinotFSSpec.getClassName(), (PinotConfiguration)new PinotConfiguration(pinotFSSpec));
                    }
                    SegmentPushUtils.sendSegmentUris((SegmentGenerationJobSpec)SparkSegmentUriPushJobRunner.this._spec, Arrays.asList(segmentUri));
                }
                catch (AttemptsExceededException | RetriableOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

