/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.files;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.AbstractManifestData;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ManifestSuccessData
extends AbstractManifestData<ManifestSuccessData> {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestSuccessData.class);
    public static final int VERSION = 1;
    private static final long serialVersionUID = 4755993198698104085L;
    public static final String NAME = "org.apache.hadoop.fs.s3a.commit.files.SuccessData/1";
    private String name;
    private long timestamp;
    private boolean success = true;
    private String date;
    private String hostname;
    private String committer;
    private String description;
    private String jobId = "";
    private String jobIdSource = "";
    private TreeMap<String, Long> metrics = new TreeMap();
    private TreeMap<String, String> diagnostics = new TreeMap();
    private ArrayList<String> filenames = new ArrayList(0);
    @JsonProperty(value="iostatistics")
    private IOStatisticsSnapshot iostatistics = new IOStatisticsSnapshot();
    private String state;
    private String stage;

    @Override
    public ManifestSuccessData validate() throws IOException {
        ManifestSuccessData.verify(this.name != null, "Incompatible file format: no 'name' field", new Object[0]);
        ManifestSuccessData.verify(NAME.equals(this.name), "Incompatible file format: " + this.name, new Object[0]);
        return this;
    }

    @Override
    public JsonSerialization<ManifestSuccessData> createSerializer() {
        return ManifestSuccessData.serializer();
    }

    @Override
    public byte[] toBytes() throws IOException {
        return ManifestSuccessData.serializer().toBytes((Object)this);
    }

    public String toJson() throws IOException {
        return ManifestSuccessData.serializer().toJson((Object)this);
    }

    @Override
    public void save(FileSystem fs, Path path, boolean overwrite) throws IOException {
        this.name = NAME;
        ManifestSuccessData.serializer().save(fs, path, (Object)this, overwrite);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ManifestSuccessData{");
        sb.append("committer='").append(this.committer).append('\'');
        sb.append(", hostname='").append(this.hostname).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", date='").append(this.date).append('\'');
        sb.append(", filenames=[").append(StringUtils.join(this.filenames, ", ")).append("]");
        sb.append('}');
        return sb.toString();
    }

    public String dumpMetrics(String prefix, String middle, String suffix) {
        return ManifestSuccessData.joinMap(this.metrics, prefix, middle, suffix);
    }

    public String dumpDiagnostics(String prefix, String middle, String suffix) {
        return ManifestSuccessData.joinMap(this.diagnostics, prefix, middle, suffix);
    }

    protected static String joinMap(Map<String, ?> map, String prefix, String middle, String suffix) {
        if (map == null) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>(map.keySet());
        Collections.sort(list);
        StringBuilder sb = new StringBuilder(list.size() * 32);
        for (String k : list) {
            sb.append(prefix).append(k).append(middle).append(map.get(k)).append(suffix);
        }
        return sb.toString();
    }

    public static ManifestSuccessData load(FileSystem fs, Path path) throws IOException {
        LOG.debug("Reading success data from {}", (Object)path);
        ManifestSuccessData instance = (ManifestSuccessData)ManifestSuccessData.serializer().load(fs, path);
        instance.validate();
        return instance;
    }

    public static JsonSerialization<ManifestSuccessData> serializer() {
        return new JsonSerialization(ManifestSuccessData.class, false, true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getCommitter() {
        return this.committer;
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Long> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(TreeMap<String, Long> metrics) {
        this.metrics = metrics;
    }

    public List<String> getFilenames() {
        return this.filenames;
    }

    @JsonIgnore
    public List<Path> getFilenamePaths() {
        return this.getFilenames().stream().map(AbstractManifestData::unmarshallPath).collect(Collectors.toList());
    }

    @JsonIgnore
    public void setFilenamePaths(List<Path> paths) {
        this.setFilenames(new ArrayList<String>(paths.stream().map(AbstractManifestData::marshallPath).collect(Collectors.toList())));
    }

    public void setFilenames(ArrayList<String> filenames) {
        this.filenames = filenames;
    }

    public Map<String, String> getDiagnostics() {
        return this.diagnostics;
    }

    public void setDiagnostics(TreeMap<String, String> diagnostics) {
        this.diagnostics = diagnostics;
    }

    public void putDiagnostic(String key, String value) {
        this.diagnostics.put(key, value);
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobIdSource() {
        return this.jobIdSource;
    }

    public void setJobIdSource(String jobIdSource) {
        this.jobIdSource = jobIdSource;
    }

    public IOStatisticsSnapshot getIOStatistics() {
        return this.iostatistics;
    }

    public void setIOStatistics(IOStatisticsSnapshot ioStatistics) {
        this.iostatistics = ioStatistics;
    }

    public void snapshotIOStatistics(IOStatistics iostats) {
        this.setIOStatistics(IOStatisticsSupport.snapshotIOStatistics((IOStatistics)iostats));
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getStage() {
        return this.stage;
    }

    public void recordJobFailure(Throwable thrown) {
        this.setSuccess(false);
        String stacktrace = ExceptionUtils.getStackTrace(thrown);
        this.diagnostics.put("exception", thrown.toString());
        this.diagnostics.put("stacktrace", stacktrace);
    }
}

