/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.protobuf.Any;
import com.google.protobuf.Struct;
import io.grpc.xds.GcpAuthenticationFilter;
import io.grpc.xds.XdsEndpointResource;
import io.grpc.xds.client.XdsResourceType;
import io.grpc.xds.internal.ProtobufJsonConverter;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Metadata;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableMap;

final class MetadataRegistry {
    private static final MetadataRegistry INSTANCE = new MetadataRegistry();
    private final Map<String, MetadataValueParser> supportedParsers = new HashMap<String, MetadataValueParser>();

    private MetadataRegistry() {
        this.registerParser(new GcpAuthenticationFilter.AudienceMetadataParser());
        this.registerParser(new XdsEndpointResource.AddressMetadataParser());
    }

    static MetadataRegistry getInstance() {
        return INSTANCE;
    }

    MetadataValueParser findParser(String typeUrl) {
        return this.supportedParsers.get(typeUrl);
    }

    @VisibleForTesting
    void registerParser(MetadataValueParser parser) {
        this.supportedParsers.put(parser.getTypeUrl(), parser);
    }

    void removeParser(MetadataValueParser parser) {
        this.supportedParsers.remove(parser.getTypeUrl());
    }

    public ImmutableMap<String, Object> parseMetadata(Metadata metadata) throws XdsResourceType.ResourceInvalidException {
        ImmutableMap.Builder<String, Object> parsedMetadata = ImmutableMap.builder();
        for (Map.Entry<String, Any> entry : metadata.getTypedFilterMetadataMap().entrySet()) {
            String key = entry.getKey();
            Any value = entry.getValue();
            MetadataValueParser parser = this.findParser(value.getTypeUrl());
            if (parser == null) continue;
            try {
                Object parsedValue = parser.parse(value);
                parsedMetadata.put(key, parsedValue);
            }
            catch (XdsResourceType.ResourceInvalidException e) {
                throw new XdsResourceType.ResourceInvalidException(String.format("Failed to parse metadata key: %s, type: %s. Error: %s", key, value.getTypeUrl(), e.getMessage()), e);
            }
        }
        ImmutableMap intermediateParsedMetadata = parsedMetadata.build();
        for (Map.Entry<String, Struct> entry : metadata.getFilterMetadataMap().entrySet()) {
            String key = entry.getKey();
            if (intermediateParsedMetadata.containsKey(key)) continue;
            Struct structValue = entry.getValue();
            Map<String, Object> jsonValue = ProtobufJsonConverter.convertToJson(structValue);
            parsedMetadata.put(key, jsonValue);
        }
        return parsedMetadata.build();
    }

    static interface MetadataValueParser {
        public String getTypeUrl();

        public Object parse(Any var1) throws XdsResourceType.ResourceInvalidException;
    }
}

