/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.protobuf.util.Durations;
import io.grpc.Internal;
import io.grpc.xds.AutoValue_EnvoyServerProtoData_CidrRange;
import io.grpc.xds.AutoValue_EnvoyServerProtoData_FailurePercentageEjection;
import io.grpc.xds.AutoValue_EnvoyServerProtoData_FilterChain;
import io.grpc.xds.AutoValue_EnvoyServerProtoData_FilterChainMatch;
import io.grpc.xds.AutoValue_EnvoyServerProtoData_Listener;
import io.grpc.xds.AutoValue_EnvoyServerProtoData_OutlierDetection;
import io.grpc.xds.AutoValue_EnvoyServerProtoData_SuccessRateEjection;
import io.grpc.xds.HttpConnectionManager;
import io.grpc.xds.TlsContextManager;
import io.grpc.xds.internal.security.SslContextProviderSupplier;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.net.InetAddress;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableList;

@Internal
public final class EnvoyServerProtoData {
    private EnvoyServerProtoData() {
    }

    @AutoValue
    static abstract class FailurePercentageEjection {
        FailurePercentageEjection() {
        }

        @Nullable
        abstract Integer threshold();

        @Nullable
        abstract Integer enforcementPercentage();

        @Nullable
        abstract Integer minimumHosts();

        @Nullable
        abstract Integer requestVolume();

        static FailurePercentageEjection create(@Nullable Integer threshold, @Nullable Integer enforcementPercentage, @Nullable Integer minimumHosts, @Nullable Integer requestVolume) {
            return new AutoValue_EnvoyServerProtoData_FailurePercentageEjection(threshold, enforcementPercentage, minimumHosts, requestVolume);
        }
    }

    @AutoValue
    static abstract class SuccessRateEjection {
        SuccessRateEjection() {
        }

        @Nullable
        abstract Integer stdevFactor();

        @Nullable
        abstract Integer enforcementPercentage();

        @Nullable
        abstract Integer minimumHosts();

        @Nullable
        abstract Integer requestVolume();

        static SuccessRateEjection create(@Nullable Integer stdevFactor, @Nullable Integer enforcementPercentage, @Nullable Integer minimumHosts, @Nullable Integer requestVolume) {
            return new AutoValue_EnvoyServerProtoData_SuccessRateEjection(stdevFactor, enforcementPercentage, minimumHosts, requestVolume);
        }
    }

    @AutoValue
    static abstract class OutlierDetection {
        OutlierDetection() {
        }

        @Nullable
        abstract Long intervalNanos();

        @Nullable
        abstract Long baseEjectionTimeNanos();

        @Nullable
        abstract Long maxEjectionTimeNanos();

        @Nullable
        abstract Integer maxEjectionPercent();

        @Nullable
        abstract SuccessRateEjection successRateEjection();

        @Nullable
        abstract FailurePercentageEjection failurePercentageEjection();

        static OutlierDetection create(@Nullable Long intervalNanos, @Nullable Long baseEjectionTimeNanos, @Nullable Long maxEjectionTimeNanos, @Nullable Integer maxEjectionPercentage, @Nullable SuccessRateEjection successRateEjection, @Nullable FailurePercentageEjection failurePercentageEjection) {
            return new AutoValue_EnvoyServerProtoData_OutlierDetection(intervalNanos, baseEjectionTimeNanos, maxEjectionTimeNanos, maxEjectionPercentage, successRateEjection, failurePercentageEjection);
        }

        static OutlierDetection fromEnvoyOutlierDetection(io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.OutlierDetection envoyOutlierDetection) {
            FailurePercentageEjection failurePercentageEjection;
            SuccessRateEjection successRateEjection;
            Integer maxEjectionPercentage;
            Long intervalNanos = envoyOutlierDetection.hasInterval() ? Long.valueOf(Durations.toNanos(envoyOutlierDetection.getInterval())) : null;
            Long baseEjectionTimeNanos = envoyOutlierDetection.hasBaseEjectionTime() ? Long.valueOf(Durations.toNanos(envoyOutlierDetection.getBaseEjectionTime())) : null;
            Long maxEjectionTimeNanos = envoyOutlierDetection.hasMaxEjectionTime() ? Long.valueOf(Durations.toNanos(envoyOutlierDetection.getMaxEjectionTime())) : null;
            Integer n = maxEjectionPercentage = envoyOutlierDetection.hasMaxEjectionPercent() ? Integer.valueOf(envoyOutlierDetection.getMaxEjectionPercent().getValue()) : null;
            if (envoyOutlierDetection.hasEnforcingSuccessRate() && envoyOutlierDetection.getEnforcingSuccessRate().getValue() == 0) {
                successRateEjection = null;
            } else {
                Integer stdevFactor = envoyOutlierDetection.hasSuccessRateStdevFactor() ? Integer.valueOf(envoyOutlierDetection.getSuccessRateStdevFactor().getValue()) : null;
                Integer enforcementPercentage = envoyOutlierDetection.hasEnforcingSuccessRate() ? Integer.valueOf(envoyOutlierDetection.getEnforcingSuccessRate().getValue()) : null;
                Integer minimumHosts = envoyOutlierDetection.hasSuccessRateMinimumHosts() ? Integer.valueOf(envoyOutlierDetection.getSuccessRateMinimumHosts().getValue()) : null;
                Integer requestVolume = envoyOutlierDetection.hasSuccessRateRequestVolume() ? Integer.valueOf(envoyOutlierDetection.getSuccessRateMinimumHosts().getValue()) : null;
                successRateEjection = SuccessRateEjection.create(stdevFactor, enforcementPercentage, minimumHosts, requestVolume);
            }
            if (envoyOutlierDetection.hasEnforcingFailurePercentage() && envoyOutlierDetection.getEnforcingFailurePercentage().getValue() == 0) {
                failurePercentageEjection = null;
            } else {
                Integer threshold = envoyOutlierDetection.hasFailurePercentageThreshold() ? Integer.valueOf(envoyOutlierDetection.getFailurePercentageThreshold().getValue()) : null;
                Integer enforcementPercentage = envoyOutlierDetection.hasEnforcingFailurePercentage() ? Integer.valueOf(envoyOutlierDetection.getEnforcingFailurePercentage().getValue()) : null;
                Integer minimumHosts = envoyOutlierDetection.hasFailurePercentageMinimumHosts() ? Integer.valueOf(envoyOutlierDetection.getFailurePercentageMinimumHosts().getValue()) : null;
                Integer requestVolume = envoyOutlierDetection.hasFailurePercentageRequestVolume() ? Integer.valueOf(envoyOutlierDetection.getFailurePercentageRequestVolume().getValue()) : null;
                failurePercentageEjection = FailurePercentageEjection.create(threshold, enforcementPercentage, minimumHosts, requestVolume);
            }
            return OutlierDetection.create(intervalNanos, baseEjectionTimeNanos, maxEjectionTimeNanos, maxEjectionPercentage, successRateEjection, failurePercentageEjection);
        }
    }

    @AutoValue
    static abstract class Listener {
        Listener() {
        }

        abstract String name();

        @Nullable
        abstract String address();

        abstract ImmutableList<FilterChain> filterChains();

        @Nullable
        abstract FilterChain defaultFilterChain();

        @Nullable
        abstract SocketAddress.Protocol protocol();

        static Listener create(String name, @Nullable String address, ImmutableList<FilterChain> filterChains, @Nullable FilterChain defaultFilterChain, @Nullable SocketAddress.Protocol protocol) {
            return new AutoValue_EnvoyServerProtoData_Listener(name, address, filterChains, defaultFilterChain, protocol);
        }
    }

    @AutoValue
    static abstract class FilterChain {
        FilterChain() {
        }

        abstract String name();

        abstract FilterChainMatch filterChainMatch();

        abstract HttpConnectionManager httpConnectionManager();

        @Nullable
        abstract SslContextProviderSupplier sslContextProviderSupplier();

        static FilterChain create(String name, FilterChainMatch filterChainMatch, HttpConnectionManager httpConnectionManager, @Nullable DownstreamTlsContext downstreamTlsContext, TlsContextManager tlsContextManager) {
            SslContextProviderSupplier sslContextProviderSupplier = downstreamTlsContext == null ? null : new SslContextProviderSupplier(downstreamTlsContext, tlsContextManager);
            return new AutoValue_EnvoyServerProtoData_FilterChain(name, filterChainMatch, httpConnectionManager, sslContextProviderSupplier);
        }
    }

    @AutoValue
    static abstract class FilterChainMatch {
        FilterChainMatch() {
        }

        abstract int destinationPort();

        abstract ImmutableList<CidrRange> prefixRanges();

        abstract ImmutableList<String> applicationProtocols();

        abstract ImmutableList<CidrRange> sourcePrefixRanges();

        abstract ConnectionSourceType connectionSourceType();

        abstract ImmutableList<Integer> sourcePorts();

        abstract ImmutableList<String> serverNames();

        abstract String transportProtocol();

        public static FilterChainMatch create(int destinationPort, ImmutableList<CidrRange> prefixRanges, ImmutableList<String> applicationProtocols, ImmutableList<CidrRange> sourcePrefixRanges, ConnectionSourceType connectionSourceType, ImmutableList<Integer> sourcePorts, ImmutableList<String> serverNames, String transportProtocol) {
            return new AutoValue_EnvoyServerProtoData_FilterChainMatch(destinationPort, prefixRanges, applicationProtocols, sourcePrefixRanges, connectionSourceType, sourcePorts, serverNames, transportProtocol);
        }
    }

    static enum ConnectionSourceType {
        ANY,
        SAME_IP_OR_LOOPBACK,
        EXTERNAL;

    }

    @AutoValue
    static abstract class CidrRange {
        CidrRange() {
        }

        abstract InetAddress addressPrefix();

        abstract int prefixLen();

        static CidrRange create(InetAddress addressPrefix, int prefixLen) {
            return new AutoValue_EnvoyServerProtoData_CidrRange(addressPrefix, prefixLen);
        }
    }

    public static final class DownstreamTlsContext
    extends BaseTlsContext {
        private final boolean requireClientCertificate;

        @VisibleForTesting
        public DownstreamTlsContext(CommonTlsContext commonTlsContext, boolean requireClientCertificate) {
            super(commonTlsContext);
            this.requireClientCertificate = requireClientCertificate;
        }

        public static DownstreamTlsContext fromEnvoyProtoDownstreamTlsContext(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.DownstreamTlsContext downstreamTlsContext) {
            return new DownstreamTlsContext(downstreamTlsContext.getCommonTlsContext(), downstreamTlsContext.hasRequireClientCertificate());
        }

        public boolean isRequireClientCertificate() {
            return this.requireClientCertificate;
        }

        public String toString() {
            return "DownstreamTlsContext{commonTlsContext=" + this.commonTlsContext + ", requireClientCertificate=" + this.requireClientCertificate + '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DownstreamTlsContext that = (DownstreamTlsContext)o;
            return this.requireClientCertificate == that.requireClientCertificate;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.requireClientCertificate);
        }
    }

    public static final class UpstreamTlsContext
    extends BaseTlsContext {
        @VisibleForTesting
        public UpstreamTlsContext(CommonTlsContext commonTlsContext) {
            super(commonTlsContext);
        }

        public static UpstreamTlsContext fromEnvoyProtoUpstreamTlsContext(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext upstreamTlsContext) {
            return new UpstreamTlsContext(upstreamTlsContext.getCommonTlsContext());
        }

        public String toString() {
            return "UpstreamTlsContext{commonTlsContext=" + this.commonTlsContext + '}';
        }
    }

    public static abstract class BaseTlsContext {
        protected final CommonTlsContext commonTlsContext;

        protected BaseTlsContext(CommonTlsContext commonTlsContext) {
            this.commonTlsContext = Preconditions.checkNotNull(commonTlsContext, "commonTlsContext cannot be null.");
        }

        public CommonTlsContext getCommonTlsContext() {
            return this.commonTlsContext;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BaseTlsContext)) {
                return false;
            }
            BaseTlsContext that = (BaseTlsContext)o;
            return Objects.equals(this.commonTlsContext, that.commonTlsContext);
        }

        public int hashCode() {
            return Objects.hashCode(this.commonTlsContext);
        }
    }
}

