/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.SettableApiFuture;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.storage.HttpClientContext;
import com.google.cloud.storage.HttpContentRange;
import com.google.cloud.storage.JsonResumableSession;
import com.google.cloud.storage.JsonResumableWrite;
import com.google.cloud.storage.ResumableOperationResult;
import com.google.cloud.storage.ResumableSession;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.RewindableContent;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.cloud.storage.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.function.LongConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.checkerframework.checker.nullness.qual.Nullable;

@ParametersAreNonnullByDefault
final class ApiaryUnbufferedWritableByteChannel
implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
    private final JsonResumableSession session;
    private final SettableApiFuture<StorageObject> result;
    private final LongConsumer committedBytesCallback;
    private boolean open;
    private long cumulativeByteCount;
    private boolean finished;

    ApiaryUnbufferedWritableByteChannel(HttpClientContext httpClientContext, Retrying.RetrierWithAlg retrier, JsonResumableWrite resumableWrite, SettableApiFuture<StorageObject> result, LongConsumer committedBytesCallback) {
        this.session = ResumableSession.json(httpClientContext, retrier, resumableWrite);
        this.result = result;
        this.committedBytesCallback = committedBytesCallback;
        this.open = true;
        this.cumulativeByteCount = resumableWrite.getBeginOffset();
        this.finished = false;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.internalWrite(srcs, offset, length, false);
    }

    @Override
    public long writeAndClose(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long write = this.internalWrite(srcs, offset, length, true);
        this.close();
        return write;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        if (!this.finished) {
            try {
                ResumableOperationResult<@Nullable StorageObject> operationResult = this.session.put(RewindableContent.empty(), HttpContentRange.of(this.cumulativeByteCount));
                long persistedSize = operationResult.getPersistedSize();
                this.committedBytesCallback.accept(persistedSize);
                this.result.set(operationResult.getObject());
            }
            catch (Exception e) {
                this.result.setException(e);
                throw StorageException.coalesce(e);
            }
        }
    }

    private long internalWrite(ByteBuffer[] srcs, int offset, int length, boolean finalize) throws ClosedChannelException {
        HttpContentRange header;
        if (!this.open) {
            throw new ClosedChannelException();
        }
        RewindableContent content = RewindableContent.of(Utils.subArray(srcs, offset, length));
        long available = content.getLength();
        if (!finalize && available < 262144L) {
            return 0L;
        }
        long newFinalByteOffset = this.cumulativeByteCount + available;
        ByteRangeSpec rangeSpec = ByteRangeSpec.explicit(this.cumulativeByteCount, newFinalByteOffset);
        if (finalize) {
            header = HttpContentRange.of(rangeSpec, newFinalByteOffset);
            this.finished = true;
        } else {
            header = HttpContentRange.of(rangeSpec);
        }
        try {
            ResumableOperationResult<@Nullable StorageObject> operationResult = this.session.put(content, header);
            long persistedSize = operationResult.getPersistedSize();
            this.committedBytesCallback.accept(persistedSize);
            long written = persistedSize - this.cumulativeByteCount;
            this.cumulativeByteCount = persistedSize;
            if (this.finished) {
                StorageObject storageObject = operationResult.getObject();
                this.result.set(storageObject);
            }
            return written;
        }
        catch (Exception e) {
            this.result.setException(e);
            throw StorageException.coalesce(e);
        }
    }
}

