/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.JsonObjectParser;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.ExternalAccountSupplierContext;
import com.google.auth.oauth2.FileIdentityPoolSubjectTokenSupplier;
import com.google.auth.oauth2.IdentityPoolCredentialSource;
import com.google.auth.oauth2.IdentityPoolSubjectTokenSupplier;
import com.google.auth.oauth2.OAuth2Utils;
import java.io.IOException;
import java.util.Map;

class UrlIdentityPoolSubjectTokenSupplier
implements IdentityPoolSubjectTokenSupplier {
    private static final long serialVersionUID = 4964578313468011844L;
    private final IdentityPoolCredentialSource credentialSource;
    private final transient HttpTransportFactory transportFactory;

    UrlIdentityPoolSubjectTokenSupplier(IdentityPoolCredentialSource credentialSource, HttpTransportFactory transportFactory) {
        this.credentialSource = credentialSource;
        this.transportFactory = transportFactory;
    }

    @Override
    public String getSubjectToken(ExternalAccountSupplierContext context) throws IOException {
        HttpRequest request = this.transportFactory.create().createRequestFactory().buildGetRequest(new GenericUrl(this.credentialSource.getCredentialLocation()));
        request.setParser(new JsonObjectParser(OAuth2Utils.JSON_FACTORY));
        if (this.credentialSource.hasHeaders()) {
            HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map<? extends String, ?>)this.credentialSource.headers);
            request.setHeaders(headers);
        }
        try {
            HttpResponse response = request.execute();
            return FileIdentityPoolSubjectTokenSupplier.parseToken(response.getContent(), this.credentialSource);
        }
        catch (IOException e) {
            throw new IOException(String.format("Error getting subject token from metadata server: %s", e.getMessage()), e);
        }
    }
}

