/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.http.HttpTransportFactory;
import com.google.auth.mtls.MtlsHttpTransportFactory;
import com.google.auth.mtls.X509Provider;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.CertificateIdentityPoolSubjectTokenSupplier;
import com.google.auth.oauth2.EnvironmentProvider;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.auth.oauth2.ExternalAccountSupplierContext;
import com.google.auth.oauth2.FileIdentityPoolSubjectTokenSupplier;
import com.google.auth.oauth2.IdentityPoolCredentialSource;
import com.google.auth.oauth2.IdentityPoolSubjectTokenSupplier;
import com.google.auth.oauth2.StsTokenExchangeRequest;
import com.google.auth.oauth2.UrlIdentityPoolSubjectTokenSupplier;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;

public class IdentityPoolCredentials
extends ExternalAccountCredentials {
    static final String FILE_METRICS_HEADER_VALUE = "file";
    static final String URL_METRICS_HEADER_VALUE = "url";
    static final String CERTIFICATE_METRICS_HEADER_VALUE = "certificate";
    private static final long serialVersionUID = 2471046175477275881L;
    private final IdentityPoolSubjectTokenSupplier subjectTokenSupplier;
    private final ExternalAccountSupplierContext supplierContext;
    private final String metricsHeaderValue;

    IdentityPoolCredentials(Builder builder) {
        super(builder);
        IdentityPoolCredentialSource credentialSource = (IdentityPoolCredentialSource)builder.credentialSource;
        this.supplierContext = ExternalAccountSupplierContext.newBuilder().setAudience(this.getAudience()).setSubjectTokenType(this.getSubjectTokenType()).build();
        if (builder.subjectTokenSupplier != null && credentialSource != null) {
            throw new IllegalArgumentException("IdentityPoolCredentials cannot have both a subjectTokenSupplier and a credentialSource.");
        }
        if (builder.subjectTokenSupplier == null && credentialSource == null) {
            throw new IllegalArgumentException("A subjectTokenSupplier or a credentialSource must be provided.");
        }
        if (builder.subjectTokenSupplier != null) {
            this.subjectTokenSupplier = builder.subjectTokenSupplier;
            this.metricsHeaderValue = "programmatic";
        } else if (credentialSource.credentialSourceType == IdentityPoolCredentialSource.IdentityPoolCredentialSourceType.FILE) {
            this.subjectTokenSupplier = new FileIdentityPoolSubjectTokenSupplier(credentialSource);
            this.metricsHeaderValue = FILE_METRICS_HEADER_VALUE;
        } else if (credentialSource.credentialSourceType == IdentityPoolCredentialSource.IdentityPoolCredentialSourceType.URL) {
            this.subjectTokenSupplier = new UrlIdentityPoolSubjectTokenSupplier(credentialSource, this.transportFactory);
            this.metricsHeaderValue = URL_METRICS_HEADER_VALUE;
        } else if (credentialSource.credentialSourceType == IdentityPoolCredentialSource.IdentityPoolCredentialSourceType.CERTIFICATE) {
            try {
                this.subjectTokenSupplier = this.createCertificateSubjectTokenSupplier(builder, credentialSource);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to initialize IdentityPoolCredentials from certificate source due to an I/O error.", e);
            }
            this.metricsHeaderValue = CERTIFICATE_METRICS_HEADER_VALUE;
        } else {
            throw new IllegalArgumentException("Source type not supported.");
        }
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        String credential = this.retrieveSubjectToken();
        StsTokenExchangeRequest.Builder stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder(credential, this.getSubjectTokenType()).setAudience(this.getAudience());
        Collection<String> scopes = this.getScopes();
        if (scopes != null && !scopes.isEmpty()) {
            stsTokenExchangeRequest.setScopes(new ArrayList<String>(scopes));
        }
        return this.exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest.build());
    }

    @Override
    public String retrieveSubjectToken() throws IOException {
        return this.subjectTokenSupplier.getSubjectToken(this.supplierContext);
    }

    @Override
    String getCredentialSourceType() {
        return this.metricsHeaderValue;
    }

    @VisibleForTesting
    IdentityPoolSubjectTokenSupplier getIdentityPoolSubjectTokenSupplier() {
        return this.subjectTokenSupplier;
    }

    @Override
    public IdentityPoolCredentials createScoped(Collection<String> newScopes) {
        return new IdentityPoolCredentials((Builder)IdentityPoolCredentials.newBuilder(this).setScopes((Collection)newScopes));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(IdentityPoolCredentials identityPoolCredentials) {
        return new Builder(identityPoolCredentials);
    }

    private IdentityPoolSubjectTokenSupplier createCertificateSubjectTokenSupplier(Builder builder, IdentityPoolCredentialSource credentialSource) throws IOException {
        X509Provider x509Provider = this.getX509Provider(builder, credentialSource);
        KeyStore mtlsKeyStore = x509Provider.getKeyStore();
        this.transportFactory = new MtlsHttpTransportFactory(mtlsKeyStore);
        credentialSource.setCredentialLocation(x509Provider.getCertificatePath());
        return new CertificateIdentityPoolSubjectTokenSupplier(credentialSource);
    }

    private X509Provider getX509Provider(Builder builder, IdentityPoolCredentialSource credentialSource) {
        IdentityPoolCredentialSource.CertificateConfig certConfig = credentialSource.getCertificateConfig();
        X509Provider x509Provider = builder.x509Provider;
        if (x509Provider == null) {
            String explicitCertConfigPath = certConfig.useDefaultCertificateConfig() ? null : certConfig.getCertificateConfigLocation();
            x509Provider = new X509Provider(explicitCertConfigPath);
        }
        return x509Provider;
    }

    public static class Builder
    extends ExternalAccountCredentials.Builder {
        private IdentityPoolSubjectTokenSupplier subjectTokenSupplier;
        private X509Provider x509Provider;

        Builder() {
        }

        Builder(IdentityPoolCredentials credentials) {
            super(credentials);
            if (this.credentialSource == null) {
                this.subjectTokenSupplier = credentials.subjectTokenSupplier;
            }
        }

        @CanIgnoreReturnValue
        Builder setX509Provider(X509Provider x509Provider) {
            this.x509Provider = x509Provider;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSubjectTokenSupplier(IdentityPoolSubjectTokenSupplier subjectTokenSupplier) {
            this.subjectTokenSupplier = subjectTokenSupplier;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            super.setHttpTransportFactory(transportFactory);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setAudience(String audience) {
            super.setAudience(audience);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setSubjectTokenType(String subjectTokenType) {
            super.setSubjectTokenType(subjectTokenType);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setSubjectTokenType(ExternalAccountCredentials.SubjectTokenTypes subjectTokenType) {
            super.setSubjectTokenType(subjectTokenType);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setTokenUrl(String tokenUrl) {
            super.setTokenUrl(tokenUrl);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCredentialSource(IdentityPoolCredentialSource credentialSource) {
            super.setCredentialSource(credentialSource);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setServiceAccountImpersonationUrl(String serviceAccountImpersonationUrl) {
            super.setServiceAccountImpersonationUrl(serviceAccountImpersonationUrl);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setTokenInfoUrl(String tokenInfoUrl) {
            super.setTokenInfoUrl(tokenInfoUrl);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setQuotaProjectId(String quotaProjectId) {
            super.setQuotaProjectId(quotaProjectId);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setClientId(String clientId) {
            super.setClientId(clientId);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setClientSecret(String clientSecret) {
            super.setClientSecret(clientSecret);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setScopes(Collection<String> scopes) {
            super.setScopes(scopes);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setWorkforcePoolUserProject(String workforcePoolUserProject) {
            super.setWorkforcePoolUserProject(workforcePoolUserProject);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setServiceAccountImpersonationOptions(Map<String, Object> optionsMap) {
            super.setServiceAccountImpersonationOptions(optionsMap);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setUniverseDomain(String universeDomain) {
            super.setUniverseDomain(universeDomain);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        Builder setEnvironmentProvider(EnvironmentProvider environmentProvider) {
            super.setEnvironmentProvider(environmentProvider);
            return this;
        }

        @Override
        public IdentityPoolCredentials build() {
            return new IdentityPoolCredentials(this);
        }
    }
}

