/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.Serializable;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeperMain;
import org.apache.zookeeper.ZooKeeperMainWithTlsSupportForKafka$;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.cli.CommandNotFoundException;
import org.apache.zookeeper.cli.MalformedCommandException;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$String$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Q<Qa\u0004\t\t\u0002]1Q!\u0007\t\t\u0002iAQ!I\u0001\u0005\u0002\tBqaI\u0001C\u0002\u0013\u0005A\u0005\u0003\u0004.\u0003\u0001\u0006I!\n\u0005\u0006]\u0005!\ta\f\u0004\u00053A\u0001!\t\u0003\u00055\r\t\u0005\t\u0015!\u00036\u0011!IeA!b\u0001\n\u0003Q\u0005\u0002\u0003+\u0007\u0005\u0003\u0005\u000b\u0011B&\t\u000b\u00052A\u0011A+\t\u000be3A\u0011\t.\t\u000b\u001d4A\u0011\u00015\t\u000b%4A\u0011\t6\t\u000b54A\u0011\t8\u0002Gi{wnS3fa\u0016\u0014X*Y5o/&$\b\u000e\u00167t'V\u0004\bo\u001c:u\r>\u00148*\u00194lC*\u0011\u0011CE\u0001\nu>|7.Z3qKJT!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u0001\u0001C\u0001\r\u0002\u001b\u0005\u0001\"a\t.p_.+W\r]3s\u001b\u0006LgnV5uQRc7oU;qa>\u0014HOR8s\u0017\u000647.Y\n\u0003\u0003m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0018\u0003UQ8\u000e\u00167t\u0007>tg-[4GS2,w\n\u001d;j_:,\u0012!\n\t\u0003M-j\u0011a\n\u0006\u0003Q%\nA\u0001\\1oO*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017(\u0005\u0019\u0019FO]5oO\u00061\"p\u001b+mg\u000e{gNZ5h\r&dWm\u00149uS>t\u0007%\u0001\u0003nC&tGC\u0001\u00194!\ta\u0012'\u0003\u00023;\t!QK\\5u\u0011\u0015!T\u00011\u00016\u0003\u0011\t'oZ:\u0011\u0007q1\u0004(\u0003\u00028;\t)\u0011I\u001d:bsB\u0011\u0011\b\u0011\b\u0003uy\u0002\"aO\u000f\u000e\u0003qR!!\u0010\f\u0002\rq\u0012xn\u001c;?\u0013\tyT$\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y\u0005S!aP\u000f\u0014\u0007\u0019\u0019e\t\u0005\u0002\u0019\t&\u0011Q\t\u0005\u0002\u000e5>|7*Z3qKJl\u0015-\u001b8\u0011\u0005a9\u0015B\u0001%\u0011\u0005\u001d9\u0016\r^2iKJ\faB_6DY&,g\u000e^\"p]\u001aLw-F\u0001L!\raBJT\u0005\u0003\u001bv\u0011aa\u00149uS>t\u0007CA(S\u001b\u0005\u0001&BA)\u0011\u0003\u0019\u0019G.[3oi&\u00111\u000b\u0015\u0002\u000f5.\u001bE.[3oi\u000e{gNZ5h\u0003=Q8n\u00117jK:$8i\u001c8gS\u001e\u0004Cc\u0001,X1B\u0011\u0001D\u0002\u0005\u0006i)\u0001\r!\u000e\u0005\u0006\u0013*\u0001\raS\u0001\raJ|7-Z:t5.\u001bU\u000e\u001a\u000b\u00037z\u0003\"\u0001\b/\n\u0005uk\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006?.\u0001\r\u0001Y\u0001\u0003G>\u0004\"!\u00193\u000f\u0005a\u0011\u0017BA2\u0011\u00035Qvn\\&fKB,'/T1j]&\u0011QM\u001a\u0002\u0011\u001bf\u001cu.\\7b]\u0012|\u0005\u000f^5p]NT!a\u0019\t\u0002\u001b-\fgm[1UYN,6/Y4f)\u0005\u0001\u0014aC2p]:,7\r\u001e+p5.#\"\u0001M6\t\u000b1l\u0001\u0019\u0001\u001d\u0002\u000f9,w\u000fS8ti\u00069\u0001O]8dKN\u001cHC\u0001\u0019p\u0011\u0015\u0001h\u00021\u0001r\u0003\u0015)g/\u001a8u!\tA\"/\u0003\u0002t!\taq+\u0019;dQ\u0016$WI^3oi\u0002")
public class ZooKeeperMainWithTlsSupportForKafka
extends ZooKeeperMain
implements Watcher {
    private final Option<ZKClientConfig> zkClientConfig;

    public static void main(String[] stringArray) {
        ZooKeeperMainWithTlsSupportForKafka$.MODULE$.main(stringArray);
    }

    public static String zkTlsConfigFileOption() {
        return ZooKeeperMainWithTlsSupportForKafka$.MODULE$.zkTlsConfigFileOption();
    }

    public Option<ZKClientConfig> zkClientConfig() {
        return this.zkClientConfig;
    }

    @Override
    public boolean processZKCmd(ZooKeeperMain.MyCommandOptions co) {
        String[] args = co.getArgArray();
        String cmd = co.getCommand();
        if (args.length < 1) {
            this.kafkaTlsUsage();
            throw new MalformedCommandException("No command entered");
        }
        if (!ZooKeeperMain.commandMap.containsKey(cmd)) {
            this.kafkaTlsUsage();
            throw new CommandNotFoundException(new StringBuilder(18).append("Command not found ").append(cmd).toString());
        }
        return super.processZKCmd(co);
    }

    public void kafkaTlsUsage() {
        System.err.println("ZooKeeper -server host:port [-zk-tls-config-file <file>] cmd args");
        ((List)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(ZooKeeperMain.commandMap.keySet()).asScala()).toList().sorted((Ordering)Ordering$String$.MODULE$)).foreach((Function1<String, Object> & Serializable & scala.Serializable)cmd -> {
            System.err.println(new StringBuilder(2).append("\t").append(cmd).append(" ").append((Object)ZooKeeperMain.commandMap.get(cmd)).toString());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void connectToZK(String newHost) {
        boolean readOnlyRequested;
        boolean bl = readOnlyRequested = this.cl.getOption("readonly") != null;
        if (readOnlyRequested && this.zkClientConfig().isDefined()) {
            throw new IllegalArgumentException(new StringBuilder(67).append("read-only mode (-r) is not supported with an explicit TLS config (").append(ZooKeeperMainWithTlsSupportForKafka$.MODULE$.zkTlsConfigFileOption()).append(")").toString());
        }
        if (this.zk != null && this.zk.getState().isAlive()) {
            this.zk.close();
        }
        this.host = newHost;
        this.zk = this.zkClientConfig().isDefined() ? new ZooKeeperAdmin(this.host, new StringOps(Predef$.MODULE$.augmentString(this.cl.getOption("timeout"))).toInt(), (Watcher)this, this.zkClientConfig().get()) : new ZooKeeperAdmin(this.host, new StringOps(Predef$.MODULE$.augmentString(this.cl.getOption("timeout"))).toInt(), (Watcher)this, readOnlyRequested);
    }

    @Override
    public void process(WatchedEvent event) {
        if (this.getPrintWatches()) {
            ZooKeeperMain.printMessage("WATCHER::");
            ZooKeeperMain.printMessage(event.toString());
        }
    }

    public ZooKeeperMainWithTlsSupportForKafka(String[] args, Option<ZKClientConfig> zkClientConfig) {
        this.zkClientConfig = zkClientConfig;
        super(args);
    }
}

