/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.record.BaseRecords;

public class Struct {
    private final Schema schema;
    private final Object[] values;

    Struct(Schema schema, Object[] values) {
        this.schema = schema;
        this.values = values;
    }

    public Struct(Schema schema) {
        this.schema = schema;
        this.values = new Object[this.schema.numFields()];
    }

    public Schema schema() {
        return this.schema;
    }

    private Object getFieldOrDefault(BoundField field2) {
        Object value = this.values[field2.index];
        if (value != null) {
            return value;
        }
        if (field2.def.hasDefaultValue) {
            return field2.def.defaultValue;
        }
        if (field2.def.type.isNullable()) {
            return null;
        }
        throw new SchemaException("Missing value for field '" + field2.def.name + "' which has no default value.");
    }

    public Object get(BoundField field2) {
        this.validateField(field2);
        return this.getFieldOrDefault(field2);
    }

    public Byte get(Field.Int8 field2) {
        return this.getByte(field2.name);
    }

    public Integer get(Field.Int32 field2) {
        return this.getInt(field2.name);
    }

    public Long get(Field.Int64 field2) {
        return this.getLong(field2.name);
    }

    public Uuid get(Field.UUID field2) {
        return this.getUuid(field2.name);
    }

    public Integer get(Field.Uint16 field2) {
        return this.getInt(field2.name);
    }

    public Short get(Field.Int16 field2) {
        return this.getShort(field2.name);
    }

    public Double get(Field.Float64 field2) {
        return this.getDouble(field2.name);
    }

    public String get(Field.Str field2) {
        return this.getString(field2.name);
    }

    public String get(Field.NullableStr field2) {
        return this.getString(field2.name);
    }

    public Boolean get(Field.Bool field2) {
        return this.getBoolean(field2.name);
    }

    public Object[] get(Field.Array field2) {
        return this.getArray(field2.name);
    }

    public Object[] get(Field.ComplexArray field2) {
        return this.getArray(field2.name);
    }

    public Long getOrElse(Field.Int64 field2, long alternative) {
        if (this.hasField(field2.name)) {
            return this.getLong(field2.name);
        }
        return alternative;
    }

    public Uuid getOrElse(Field.UUID field2, Uuid alternative) {
        if (this.hasField(field2.name)) {
            return this.getUuid(field2.name);
        }
        return alternative;
    }

    public Short getOrElse(Field.Int16 field2, short alternative) {
        if (this.hasField(field2.name)) {
            return this.getShort(field2.name);
        }
        return alternative;
    }

    public Byte getOrElse(Field.Int8 field2, byte alternative) {
        if (this.hasField(field2.name)) {
            return this.getByte(field2.name);
        }
        return alternative;
    }

    public Integer getOrElse(Field.Int32 field2, int alternative) {
        if (this.hasField(field2.name)) {
            return this.getInt(field2.name);
        }
        return alternative;
    }

    public Double getOrElse(Field.Float64 field2, double alternative) {
        if (this.hasField(field2.name)) {
            return this.getDouble(field2.name);
        }
        return alternative;
    }

    public String getOrElse(Field.NullableStr field2, String alternative) {
        if (this.hasField(field2.name)) {
            return this.getString(field2.name);
        }
        return alternative;
    }

    public String getOrElse(Field.Str field2, String alternative) {
        if (this.hasField(field2.name)) {
            return this.getString(field2.name);
        }
        return alternative;
    }

    public boolean getOrElse(Field.Bool field2, boolean alternative) {
        if (this.hasField(field2.name)) {
            return this.getBoolean(field2.name);
        }
        return alternative;
    }

    public Object[] getOrEmpty(Field.Array field2) {
        if (this.hasField(field2.name)) {
            return this.getArray(field2.name);
        }
        return new Object[0];
    }

    public Object[] getOrEmpty(Field.ComplexArray field2) {
        if (this.hasField(field2.name)) {
            return this.getArray(field2.name);
        }
        return new Object[0];
    }

    public Object get(String name) {
        BoundField field2 = this.schema.get(name);
        if (field2 == null) {
            throw new SchemaException("No such field: " + name);
        }
        return this.getFieldOrDefault(field2);
    }

    public boolean hasField(String name) {
        return this.schema.get(name) != null;
    }

    public boolean hasField(Field def) {
        return this.schema.get(def.name) != null;
    }

    public boolean hasField(Field.ComplexArray def) {
        return this.schema.get(def.name) != null;
    }

    public Struct getStruct(BoundField field2) {
        return (Struct)this.get(field2);
    }

    public Struct getStruct(String name) {
        return (Struct)this.get(name);
    }

    public Byte getByte(BoundField field2) {
        return (Byte)this.get(field2);
    }

    public byte getByte(String name) {
        return (Byte)this.get(name);
    }

    public BaseRecords getRecords(String name) {
        return (BaseRecords)this.get(name);
    }

    public Short getShort(BoundField field2) {
        return (Short)this.get(field2);
    }

    public Short getShort(String name) {
        return (Short)this.get(name);
    }

    public Integer getUnsignedShort(BoundField field2) {
        return (Integer)this.get(field2);
    }

    public Integer getUnsignedShort(String name) {
        return (Integer)this.get(name);
    }

    public Integer getInt(BoundField field2) {
        return (Integer)this.get(field2);
    }

    public Integer getInt(String name) {
        return (Integer)this.get(name);
    }

    public Long getUnsignedInt(String name) {
        return (Long)this.get(name);
    }

    public Long getLong(BoundField field2) {
        return (Long)this.get(field2);
    }

    public Long getLong(String name) {
        return (Long)this.get(name);
    }

    public Uuid getUuid(BoundField field2) {
        return (Uuid)this.get(field2);
    }

    public Uuid getUuid(String name) {
        return (Uuid)this.get(name);
    }

    public Double getDouble(BoundField field2) {
        return (Double)this.get(field2);
    }

    public Double getDouble(String name) {
        return (Double)this.get(name);
    }

    public Object[] getArray(BoundField field2) {
        return (Object[])this.get(field2);
    }

    public Object[] getArray(String name) {
        return (Object[])this.get(name);
    }

    public String getString(BoundField field2) {
        return (String)this.get(field2);
    }

    public String getString(String name) {
        return (String)this.get(name);
    }

    public Boolean getBoolean(BoundField field2) {
        return (Boolean)this.get(field2);
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.get(name);
    }

    public ByteBuffer getBytes(BoundField field2) {
        Object result2 = this.get(field2);
        if (result2 instanceof byte[]) {
            return ByteBuffer.wrap((byte[])result2);
        }
        return (ByteBuffer)result2;
    }

    public ByteBuffer getBytes(String name) {
        Object result2 = this.get(name);
        if (result2 instanceof byte[]) {
            return ByteBuffer.wrap((byte[])result2);
        }
        return (ByteBuffer)result2;
    }

    public byte[] getByteArray(String name) {
        Object result2 = this.get(name);
        if (result2 instanceof byte[]) {
            return (byte[])result2;
        }
        ByteBuffer buf = (ByteBuffer)result2;
        byte[] arr = new byte[buf.remaining()];
        buf.get(arr);
        buf.flip();
        return arr;
    }

    public Struct set(BoundField field2, Object value) {
        this.validateField(field2);
        this.values[field2.index] = value;
        return this;
    }

    public Struct set(String name, Object value) {
        BoundField field2 = this.schema.get(name);
        if (field2 == null) {
            throw new SchemaException("Unknown field: " + name);
        }
        this.values[field2.index] = value;
        return this;
    }

    public Struct set(Field.Str def, String value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.NullableStr def, String value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Int8 def, byte value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Int32 def, int value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Int64 def, long value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.UUID def, Uuid value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Int16 def, short value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Uint16 def, int value) {
        if (value < 0 || value > 65535) {
            throw new RuntimeException("Invalid value for unsigned short for " + def.name + ": " + value);
        }
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Float64 def, double value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Bool def, boolean value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Array def, Object[] value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.ComplexArray def, Object[] value) {
        return this.set(def.name, (Object)value);
    }

    public Struct setByteArray(String name, byte[] value) {
        ByteBuffer buf = value == null ? null : ByteBuffer.wrap(value);
        return this.set(name, (Object)buf);
    }

    public Struct setIfExists(Field.Array def, Object[] value) {
        return this.setIfExists(def.name, (Object)value);
    }

    public Struct setIfExists(Field.ComplexArray def, Object[] value) {
        return this.setIfExists(def.name, (Object)value);
    }

    public Struct setIfExists(Field def, Object value) {
        return this.setIfExists(def.name, value);
    }

    public Struct setIfExists(String fieldName, Object value) {
        BoundField field2 = this.schema.get(fieldName);
        if (field2 != null) {
            this.values[field2.index] = value;
        }
        return this;
    }

    public Struct instance(BoundField field2) {
        this.validateField(field2);
        if (field2.def.type instanceof Schema) {
            return new Struct((Schema)field2.def.type);
        }
        if (field2.def.type.isArray()) {
            return new Struct((Schema)field2.def.type.arrayElementType().get());
        }
        throw new SchemaException("Field '" + field2.def.name + "' is not a container type, it is of type " + field2.def.type);
    }

    public Struct instance(String field2) {
        return this.instance(this.schema.get(field2));
    }

    public Struct instance(Field field2) {
        return this.instance(this.schema.get(field2.name));
    }

    public Struct instance(Field.ComplexArray field2) {
        return this.instance(this.schema.get(field2.name));
    }

    public void clear() {
        Arrays.fill(this.values, null);
    }

    public int sizeOf() {
        return this.schema.sizeOf(this);
    }

    public void writeTo(ByteBuffer buffer) {
        this.schema.write(buffer, this);
    }

    private void validateField(BoundField field2) {
        Objects.requireNonNull(field2, "`field` must be non-null");
        if (this.schema != field2.schema) {
            throw new SchemaException("Attempt to access field '" + field2.def.name + "' from a different schema instance.");
        }
        if (field2.index > this.values.length) {
            throw new SchemaException("Invalid field index: " + field2.index);
        }
    }

    public void validate() {
        this.schema.validate(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        for (int i = 0; i < this.values.length; ++i) {
            BoundField f = this.schema.get(i);
            b.append(f.def.name);
            b.append('=');
            if (f.def.type.isArray() && this.values[i] != null) {
                Object[] arrayValue = (Object[])this.values[i];
                b.append('[');
                for (int j = 0; j < arrayValue.length; ++j) {
                    b.append(arrayValue[j]);
                    if (j >= arrayValue.length - 1) continue;
                    b.append(',');
                }
                b.append(']');
            } else {
                b.append(this.values[i]);
            }
            if (i >= this.values.length - 1) continue;
            b.append(',');
        }
        b.append('}');
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        for (int i = 0; i < this.values.length; ++i) {
            BoundField f = this.schema.get(i);
            if (f.def.type.isArray()) {
                Object[] arrayObject;
                if (this.get(f) == null) continue;
                for (Object arrayItem : arrayObject = (Object[])this.get(f)) {
                    result2 = 31 * result2 + arrayItem.hashCode();
                }
                continue;
            }
            Object field2 = this.get(f);
            if (field2 == null) continue;
            result2 = 31 * result2 + field2.hashCode();
        }
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Struct other = (Struct)obj;
        if (this.schema != other.schema) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            boolean result2;
            BoundField f = this.schema.get(i);
            if (f.def.type.isArray()) {
                result2 = Arrays.equals((Object[])this.get(f), (Object[])other.get(f));
            } else {
                Object thisField = this.get(f);
                Object otherField = other.get(f);
                result2 = Objects.equals(thisField, otherField);
            }
            if (result2) continue;
            return false;
        }
        return true;
    }
}

