/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.deser.table;

import java.io.Closeable;
import java.io.IOException;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.KeyDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.NullValueProvider;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import org.apache.pinot.shaded.com.google.common.collect.Table;

public abstract class TableDeserializer<T extends Table<Object, Object, Object>>
extends StdDeserializer<T>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final MapLikeType _type;
    protected final KeyDeserializer _rowDeserializer;
    protected final KeyDeserializer _colDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final JsonDeserializer<?> _valueDeserializer;
    protected final NullValueProvider _nullProvider;
    protected final boolean _skipNullValues;

    protected TableDeserializer(MapLikeType _type, KeyDeserializer _rowDeserializer, KeyDeserializer _colDeserializer, TypeDeserializer _valueTypeDeserializer, JsonDeserializer<?> _valueDeserializer) {
        this(_type, _rowDeserializer, _colDeserializer, _valueTypeDeserializer, _valueDeserializer, null);
    }

    protected TableDeserializer(MapLikeType _type, KeyDeserializer _rowDeserializer, KeyDeserializer _colDeserializer, TypeDeserializer _valueTypeDeserializer, JsonDeserializer<?> _valueDeserializer, NullValueProvider nvp) {
        super(_type);
        this._type = _type;
        this._rowDeserializer = _rowDeserializer;
        this._colDeserializer = _colDeserializer;
        this._valueTypeDeserializer = _valueTypeDeserializer;
        this._valueDeserializer = _valueDeserializer;
        this._nullProvider = nvp;
        this._skipNullValues = nvp == null ? false : NullsConstantProvider.isSkipper(nvp);
    }

    protected TableDeserializer(MapLikeType type) {
        super(type);
        this._type = type;
        this._rowDeserializer = null;
        this._colDeserializer = null;
        this._valueDeserializer = null;
        this._valueTypeDeserializer = null;
        this._nullProvider = null;
        this._skipNullValues = false;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        KeyDeserializer rkd = this._rowDeserializer;
        if (rkd == null) {
            rkd = ctxt.findKeyDeserializer(this._type.getKeyType(), property);
        }
        MapLikeType columnValueType = (MapLikeType)this._type.getContentType();
        KeyDeserializer ckd = this._colDeserializer;
        if (ckd == null) {
            ckd = ctxt.findKeyDeserializer(columnValueType.getKeyType(), property);
        }
        JsonDeserializer<Object> valueDeser = this._valueDeserializer;
        JavaType vt = columnValueType.getContentType();
        valueDeser = valueDeser == null ? ctxt.findContextualValueDeserializer(vt, property) : ctxt.handleSecondaryContextualization(valueDeser, property, vt);
        TypeDeserializer vtd = this._valueTypeDeserializer;
        if (vtd != null) {
            vtd = vtd.forProperty(property);
        }
        return this._createContextual(this._type, rkd, ckd, vtd, valueDeser, this.findContentNullProvider(ctxt, property, valueDeser));
    }

    protected abstract JsonDeserializer<?> _createContextual(MapLikeType var1, KeyDeserializer var2, KeyDeserializer var3, TypeDeserializer var4, JsonDeserializer<?> var5, NullValueProvider var6);

    protected void expect(JsonParser p, JsonToken token) throws IOException {
        if (p.currentToken() != token) {
            throw new JsonMappingException((Closeable)p, "Expecting " + (Object)((Object)token) + " to start `TABLE` value, found " + (Object)((Object)p.currentToken()), p.currentLocation());
        }
    }
}

