/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util;

import java.util.StringJoiner;
import org.apache.avro.Schema;

public class SchemaUtil {
    private SchemaUtil() {
    }

    public static String describe(Schema schema2) {
        if (schema2 == null) {
            return "unknown";
        }
        switch (schema2.getType()) {
            case UNION: {
                StringJoiner csv = new StringJoiner(", ");
                for (Schema branch : schema2.getTypes()) {
                    csv.add(SchemaUtil.describe(branch));
                }
                return "[" + csv + "]";
            }
            case MAP: {
                return "Map<String, " + SchemaUtil.describe(schema2.getValueType()) + ">";
            }
            case ARRAY: {
                return "List<" + SchemaUtil.describe(schema2.getElementType()) + ">";
            }
        }
        return schema2.getName();
    }

    public static String describe(Object datum) {
        if (datum == null) {
            return "null";
        }
        return datum + " (a " + datum.getClass().getName() + ")";
    }
}

