/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.datalake.models.CopyStatusType;
import com.azure.storage.file.datalake.models.LeaseDurationType;
import com.azure.storage.file.datalake.models.LeaseStateType;
import com.azure.storage.file.datalake.models.LeaseStatusType;
import java.time.OffsetDateTime;
import java.util.Map;

public final class FileQueryHeaders {
    private DateTimeRfc1123 lastModified;
    private Map<String, String> metadata;
    private Long contentLength;
    private String contentType;
    private String contentRange;
    private String eTag;
    private byte[] contentMd5;
    private String contentEncoding;
    private String cacheControl;
    private String contentDisposition;
    private String contentLanguage;
    private DateTimeRfc1123 copyCompletionTime;
    private String copyStatusDescription;
    private String copyId;
    private String copyProgress;
    private String copySource;
    private CopyStatusType copyStatus;
    private LeaseDurationType leaseDuration;
    private LeaseStateType leaseState;
    private LeaseStatusType leaseStatus;
    private String clientRequestId;
    private String requestId;
    private String version;
    private String acceptRanges;
    private DateTimeRfc1123 dateProperty;
    private Boolean serverEncrypted;
    private String encryptionKeySha256;
    private byte[] fileContentMD5;
    private byte[] contentCrc64;
    private String errorCode;

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public FileQueryHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public FileQueryHeaders setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public FileQueryHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public FileQueryHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public FileQueryHeaders setContentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public FileQueryHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone(this.contentMd5);
    }

    public FileQueryHeaders setContentMd5(byte[] contentMd5) {
        this.contentMd5 = CoreUtils.clone(contentMd5);
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public FileQueryHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public FileQueryHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public FileQueryHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public FileQueryHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public OffsetDateTime getCopyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.getDateTime();
    }

    public FileQueryHeaders setCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.copyCompletionTime = copyCompletionTime == null ? null : new DateTimeRfc1123(copyCompletionTime);
        return this;
    }

    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    public FileQueryHeaders setCopyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public FileQueryHeaders setCopyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public String getCopyProgress() {
        return this.copyProgress;
    }

    public FileQueryHeaders setCopyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public FileQueryHeaders setCopySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    public CopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    public FileQueryHeaders setCopyStatus(CopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public FileQueryHeaders setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public FileQueryHeaders setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public FileQueryHeaders setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    public FileQueryHeaders setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public FileQueryHeaders setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public FileQueryHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    public FileQueryHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public FileQueryHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.serverEncrypted;
    }

    public FileQueryHeaders setServerEncrypted(Boolean serverEncrypted) {
        this.serverEncrypted = serverEncrypted;
        return this;
    }

    public String getEncryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public FileQueryHeaders setEncryptionKeySha256(String encryptionKeySha256) {
        this.encryptionKeySha256 = encryptionKeySha256;
        return this;
    }

    public byte[] getFileContentMd5() {
        return CoreUtils.clone(this.fileContentMD5);
    }

    public FileQueryHeaders setFileContentMd5(byte[] fileContentMd5) {
        this.fileContentMD5 = CoreUtils.clone(fileContentMd5);
        return this;
    }

    public byte[] getContentCrc64() {
        return CoreUtils.clone(this.contentCrc64);
    }

    public FileQueryHeaders setContentCrc64(byte[] contentCrc64) {
        this.contentCrc64 = CoreUtils.clone(contentCrc64);
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public FileQueryHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

