/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.ResponseInnerError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;

public final class ResponseError
implements JsonSerializable<ResponseError> {
    @JsonProperty(value="code")
    private final String code;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="target")
    private String target;
    @JsonProperty(value="innererror")
    private ResponseInnerError innerError;
    @JsonProperty(value="details")
    private List<ResponseError> errorDetails;

    @JsonCreator
    public ResponseError(@JsonProperty(value="code", required=true) String code, @JsonProperty(value="message", required=true) String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    String getTarget() {
        return this.target;
    }

    ResponseError setTarget(String target) {
        this.target = target;
        return this;
    }

    ResponseInnerError getInnerError() {
        return this.innerError;
    }

    ResponseError setInnerError(ResponseInnerError innerError) {
        this.innerError = innerError;
        return this;
    }

    List<ResponseError> getErrorDetails() {
        return this.errorDetails;
    }

    ResponseError setErrorDetails(List<ResponseError> errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("code", this.code).writeStringField("message", this.message).writeStringField("target", this.target).writeJsonField("innererror", this.innerError).writeArrayField("details", this.errorDetails, JsonWriter::writeJson).writeEndObject();
    }

    public static ResponseError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JsonReader bufferedReader = reader.bufferObject();
            bufferedReader.nextToken();
            while (bufferedReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = bufferedReader.getFieldName();
                bufferedReader.nextToken();
                if ("error".equals(fieldName)) {
                    return ResponseError.readResponseError(bufferedReader);
                }
                bufferedReader.skipChildren();
            }
            return ResponseError.readResponseError(bufferedReader.reset());
        });
    }

    private static ResponseError readResponseError(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String code = null;
            boolean codeFound = false;
            String message = null;
            boolean messageFound = false;
            String target = null;
            ResponseInnerError innerError = null;
            List<ResponseError> errorDetails = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equalsIgnoreCase(fieldName)) {
                    code = reader.getString();
                    codeFound = true;
                    continue;
                }
                if ("message".equalsIgnoreCase(fieldName)) {
                    message = reader.getString();
                    messageFound = true;
                    continue;
                }
                if ("target".equalsIgnoreCase(fieldName)) {
                    target = reader.getString();
                    continue;
                }
                if ("innererror".equalsIgnoreCase(fieldName)) {
                    innerError = ResponseInnerError.fromJson(reader);
                    continue;
                }
                if ("details".equalsIgnoreCase(fieldName)) {
                    errorDetails = reader.readArray(ResponseError::fromJson);
                    continue;
                }
                reader.skipChildren();
            }
            if (!codeFound && !messageFound) {
                throw new IllegalStateException("Missing required properties: code, message");
            }
            if (!codeFound) {
                throw new IllegalStateException("Missing required property: code");
            }
            if (!messageFound) {
                throw new IllegalStateException("Missing required property: message");
            }
            return new ResponseError(code, message).setTarget(target).setInnerError(innerError).setErrorDetails(errorDetails);
        });
    }
}

