/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.StringBuilderWriter;
import com.azure.core.util.BinaryData;
import java.io.IOException;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.module.SimpleModule;

final class BinaryDataDeserializer
extends JsonDeserializer<BinaryData> {
    BinaryDataDeserializer() {
    }

    public static SimpleModule getModule() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(BinaryData.class, new BinaryDataDeserializer());
        return module;
    }

    @Override
    public BinaryData deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken token = p.currentToken();
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token.isStructStart()) {
            return BinaryData.fromString(BinaryDataDeserializer.bufferStruct(p));
        }
        return BinaryData.fromString(p.getText());
    }

    private static String bufferStruct(JsonParser parser) throws IOException {
        StringBuilder buffer = new StringBuilder(128);
        StringBuilderWriter bufferWriter = new StringBuilderWriter(buffer);
        buffer.append(parser.currentToken() == JsonToken.START_OBJECT ? (char)'{' : '[');
        JsonToken previous = parser.currentToken();
        int depth = 1;
        block5: while (depth > 0) {
            JsonToken next = parser.nextToken();
            if (!previous.isStructStart() && !next.isStructEnd() && previous != JsonToken.FIELD_NAME) {
                buffer.append(',');
            }
            previous = next;
            switch (next) {
                case START_ARRAY: 
                case START_OBJECT: {
                    ++depth;
                    buffer.append(next == JsonToken.START_OBJECT ? (char)'{' : '[');
                    continue block5;
                }
                case END_ARRAY: 
                case END_OBJECT: {
                    --depth;
                    buffer.append(next == JsonToken.END_OBJECT ? (char)'}' : ']');
                    continue block5;
                }
                case FIELD_NAME: 
                case VALUE_STRING: {
                    buffer.append("\"");
                    parser.getText(bufferWriter);
                    buffer.append(next == JsonToken.FIELD_NAME ? "\":" : "\"");
                    continue block5;
                }
            }
            parser.getText(bufferWriter);
        }
        return buffer.toString();
    }
}

