/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.jackson.JacksonJsonReader;
import com.azure.json.JsonOptions;
import com.azure.json.JsonReader;
import java.io.IOException;
import java.util.Objects;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.json.JsonReadFeature;

final class AzureJsonUtils {
    private static final JsonFactory FACTORY = JsonFactory.builder().build();

    static JsonReader createReader(byte[] json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON source cannot be null when creating a JsonReader.");
        return new JacksonJsonReader(AzureJsonUtils.configureParser(FACTORY.createParser(json), options), json, null, true, options);
    }

    static JsonReader createReader(String json, JsonOptions options) throws IOException {
        Objects.requireNonNull(json, "JSON source cannot be null when creating a JsonReader.");
        return new JacksonJsonReader(AzureJsonUtils.configureParser(FACTORY.createParser(json), options), null, json, true, options);
    }

    private static JsonParser configureParser(JsonParser parser, JsonOptions options) {
        boolean nonNumericSupported = options == null || options.isNonNumericNumbersSupported();
        boolean jsoncSupported = options != null && options.isJsoncSupported();
        return parser.configure(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS.mappedFeature(), nonNumericSupported).configure(JsonParser.Feature.ALLOW_COMMENTS, jsoncSupported);
    }

    static JsonReader createReader(JsonParser parser) {
        return new JacksonJsonReader(parser, null, null, false, null);
    }

    private AzureJsonUtils() {
    }
}

