/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.util.ProgressReporter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import java.util.Objects;

public final class RequestProgressReportingHandler
extends ChannelOutboundHandlerAdapter {
    public static final String HANDLER_NAME = "azureRequestProgressHandler";
    private final ProgressReporter progressReporter;

    public RequestProgressReportingHandler(ProgressReporter progressReporter) {
        this.progressReporter = Objects.requireNonNull(progressReporter, "'progressReporter' must not be null");
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            this.progressReporter.reportProgress(((ByteBuf)msg).readableBytes());
        } else if (msg instanceof ByteBufHolder) {
            this.progressReporter.reportProgress(((ByteBufHolder)msg).content().readableBytes());
        } else if (msg instanceof FileRegion) {
            this.progressReporter.reportProgress(((FileRegion)msg).count());
        }
        ctx.write(msg, promise.unvoid());
    }
}

