/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.m3ql.time;

import java.util.HashSet;
import java.util.Set;

public class QueryTimeBoundaryConstraints {
    private final Set<Long> _divisors = new HashSet<Long>();
    private long _leftExtensionSeconds = 0L;
    private long _rightExtensionSeconds = 0L;
    private boolean _leftAligned = false;

    public Set<Long> getDivisors() {
        return this._divisors;
    }

    public long getLeftExtensionSeconds() {
        return this._leftExtensionSeconds;
    }

    public void setLeftExtensionSeconds(long leftExtensionSeconds) {
        this._leftExtensionSeconds = leftExtensionSeconds;
    }

    public long getRightExtensionSeconds() {
        return this._rightExtensionSeconds;
    }

    public void setRightExtensionSeconds(long rightExtensionSeconds) {
        this._rightExtensionSeconds = rightExtensionSeconds;
    }

    public boolean isLeftAligned() {
        return this._leftAligned;
    }

    public void setLeftAligned(boolean leftAligned) {
        this._leftAligned = leftAligned;
    }

    public static QueryTimeBoundaryConstraints merge(QueryTimeBoundaryConstraints left, QueryTimeBoundaryConstraints right) {
        QueryTimeBoundaryConstraints merged = new QueryTimeBoundaryConstraints();
        merged._divisors.addAll(left._divisors);
        merged._divisors.addAll(right._divisors);
        merged._leftExtensionSeconds = Math.max(left._leftExtensionSeconds, right._leftExtensionSeconds);
        merged._rightExtensionSeconds = Math.max(left._rightExtensionSeconds, right._rightExtensionSeconds);
        if (left._leftAligned != right._leftAligned) {
            throw new IllegalArgumentException(String.format("Cannot merge constraints with different alignments. Alignment from plan node on the left and right are %s and %s respectively", left._leftAligned, right._leftAligned));
        }
        merged._leftAligned = left._leftAligned;
        return merged;
    }
}

