/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.ingestion.batch.hadoop;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.segment.local.utils.SegmentPushUtils;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.runner.IngestionJobRunner;
import org.apache.pinot.spi.ingestion.batch.spec.PinotFSSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;

public class HadoopSegmentUriPushJobRunner
implements IngestionJobRunner,
Serializable {
    private SegmentGenerationJobSpec _spec;

    public HadoopSegmentUriPushJobRunner() {
    }

    public HadoopSegmentUriPushJobRunner(SegmentGenerationJobSpec spec) {
        this.init(spec);
    }

    public void init(SegmentGenerationJobSpec spec) {
        this._spec = spec;
        if (this._spec.getPushJobSpec() == null) {
            throw new RuntimeException("Missing PushJobSpec");
        }
    }

    public void run() {
        String[] files;
        URI outputDirURI;
        List pinotFSSpecs = this._spec.getPinotFSSpecs();
        for (PinotFSSpec pinotFSSpec : pinotFSSpecs) {
            PinotFSFactory.register((String)pinotFSSpec.getScheme(), (String)pinotFSSpec.getClassName(), (PinotConfiguration)new PinotConfiguration(pinotFSSpec));
        }
        try {
            outputDirURI = new URI(this._spec.getOutputDirURI());
            if (outputDirURI.getScheme() == null) {
                outputDirURI = new File(this._spec.getOutputDirURI()).toURI();
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("outputDirURI is not valid - '" + this._spec.getOutputDirURI() + "'");
        }
        PinotFS outputDirFS = PinotFSFactory.create((String)outputDirURI.getScheme());
        try {
            files = outputDirFS.listFiles(outputDirURI, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to list all files under outputDirURI - '" + String.valueOf(outputDirURI) + "'");
        }
        ArrayList<String> segmentUris = new ArrayList<String>();
        for (String file : files) {
            URI uri = URI.create(file);
            if (!uri.getPath().endsWith(".tar.gz")) continue;
            URI updatedURI = SegmentPushUtils.generateSegmentTarURI((URI)outputDirURI, (URI)uri, (String)this._spec.getPushJobSpec().getSegmentUriPrefix(), (String)this._spec.getPushJobSpec().getSegmentUriSuffix());
            segmentUris.add(updatedURI.toString());
        }
        try {
            SegmentPushUtils.sendSegmentUris((SegmentGenerationJobSpec)this._spec, segmentUris);
        }
        catch (AttemptsExceededException | RetriableOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

