/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.ingestion.batch.common;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.creator.name.FixedSegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.InputFileSegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.NormalizedDateSegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.SimpleSegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.UploadedRealtimeSegmentNameGenerator;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationTaskSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentNameGeneratorSpec;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.JsonUtils;

public class SegmentGenerationTaskRunner
implements Serializable {
    public static final String SEGMENT_NAME = "segment.name";
    public static final String SEGMENT_NAME_POSTFIX = "segment.name.postfix";
    public static final String SEGMENT_NAME_PREFIX = "segment.name.prefix";
    public static final String EXCLUDE_SEQUENCE_ID = "exclude.sequence.id";
    public static final String FILE_PATH_PATTERN = "file.path.pattern";
    public static final String SEGMENT_NAME_TEMPLATE = "segment.name.template";
    @Deprecated
    public static final String DEPRECATED_USE_LOCAL_DIRECTORY_SEQUENCE_ID = "local.directory.sequence.id";
    public static final String USE_GLOBAL_DIRECTORY_SEQUENCE_ID = "use.global.directory.sequence.id";
    public static final String APPEND_UUID_TO_SEGMENT_NAME = "append.uuid.to.segment.name";
    public static final String EXCLUDE_TIME_IN_SEGMENT_NAME = "exclude.time.in.segment.name";
    private final SegmentGenerationTaskSpec _taskSpec;

    public SegmentGenerationTaskRunner(SegmentGenerationTaskSpec taskSpec) {
        this._taskSpec = taskSpec;
    }

    public String run() throws Exception {
        TableConfig tableConfig = this._taskSpec.getTableConfig();
        String tableName = tableConfig.getTableName();
        Schema schema = this._taskSpec.getSchema();
        String readerConfigClassName = this._taskSpec.getRecordReaderSpec().getConfigClassName();
        RecordReaderConfig recordReaderConfig = null;
        if (readerConfigClassName != null) {
            HashMap configs = this._taskSpec.getRecordReaderSpec().getConfigs();
            if (configs == null) {
                configs = new HashMap();
            }
            JsonNode jsonNode = JsonUtils.objectToJsonNode((Object)configs);
            Class clazz = PluginManager.get().loadClass(readerConfigClassName);
            recordReaderConfig = (RecordReaderConfig)JsonUtils.jsonNodeToObject((JsonNode)jsonNode, (Class)clazz);
        }
        SegmentGeneratorConfig segmentGeneratorConfig = new SegmentGeneratorConfig(tableConfig, schema);
        segmentGeneratorConfig.setTableName(tableName);
        segmentGeneratorConfig.setOutDir(this._taskSpec.getOutputDirectoryPath());
        segmentGeneratorConfig.setSequenceId(this._taskSpec.getSequenceId());
        segmentGeneratorConfig.setReaderConfig(recordReaderConfig);
        segmentGeneratorConfig.setRecordReaderPath(this._taskSpec.getRecordReaderSpec().getClassName());
        segmentGeneratorConfig.setInputFilePath(this._taskSpec.getInputFilePath());
        segmentGeneratorConfig.setCustomProperties(this._taskSpec.getCustomProperties());
        segmentGeneratorConfig.setFailOnEmptySegment(this._taskSpec.isFailOnEmptySegment());
        SegmentNameGenerator segmentNameGenerator = this.getSegmentNameGenerator(segmentGeneratorConfig);
        segmentGeneratorConfig.setSegmentNameGenerator(segmentNameGenerator);
        SegmentIndexCreationDriverImpl segmentIndexCreationDriver = new SegmentIndexCreationDriverImpl();
        segmentIndexCreationDriver.init(segmentGeneratorConfig);
        segmentIndexCreationDriver.build();
        return segmentIndexCreationDriver.getSegmentName();
    }

    private SegmentNameGenerator getSegmentNameGenerator(SegmentGeneratorConfig segmentGeneratorConfig) {
        HashMap segmentNameGeneratorConfigs;
        String segmentNameGeneratorType;
        TableConfig tableConfig = this._taskSpec.getTableConfig();
        String tableName = tableConfig.getTableName();
        Schema schema = this._taskSpec.getSchema();
        SegmentNameGeneratorSpec segmentNameGeneratorSpec = this._taskSpec.getSegmentNameGeneratorSpec();
        if (segmentNameGeneratorSpec == null) {
            segmentNameGeneratorSpec = new SegmentNameGeneratorSpec();
        }
        if ((segmentNameGeneratorType = segmentNameGeneratorSpec.getType()) == null) {
            segmentNameGeneratorType = segmentGeneratorConfig.inferSegmentNameGeneratorType();
        }
        if ((segmentNameGeneratorConfigs = segmentNameGeneratorSpec.getConfigs()) == null) {
            segmentNameGeneratorConfigs = new HashMap();
        }
        boolean appendUUIDToSegmentName = Boolean.parseBoolean((String)segmentNameGeneratorConfigs.get(APPEND_UUID_TO_SEGMENT_NAME));
        boolean excludeTimeInSegmentName = Boolean.parseBoolean((String)segmentNameGeneratorConfigs.get(EXCLUDE_TIME_IN_SEGMENT_NAME));
        switch (segmentNameGeneratorType) {
            case "fixed": {
                return new FixedSegmentNameGenerator((String)segmentNameGeneratorConfigs.get(SEGMENT_NAME));
            }
            case "simple": {
                return new SimpleSegmentNameGenerator(tableName, (String)segmentNameGeneratorConfigs.get(SEGMENT_NAME_POSTFIX), appendUUIDToSegmentName, excludeTimeInSegmentName);
            }
            case "normalizedDate": {
                DateTimeFieldSpec dateTimeFieldSpec;
                SegmentsValidationAndRetentionConfig validationConfig = tableConfig.getValidationConfig();
                DateTimeFormatSpec dateTimeFormatSpec = null;
                String timeColumnName = validationConfig.getTimeColumnName();
                if (timeColumnName != null && (dateTimeFieldSpec = schema.getSpecForTimeColumn(timeColumnName)) != null) {
                    dateTimeFormatSpec = dateTimeFieldSpec.getFormatSpec();
                }
                return new NormalizedDateSegmentNameGenerator(tableName, (String)segmentNameGeneratorConfigs.get(SEGMENT_NAME_PREFIX), Boolean.parseBoolean((String)segmentNameGeneratorConfigs.get(EXCLUDE_SEQUENCE_ID)), IngestionConfigUtils.getBatchSegmentIngestionType((TableConfig)tableConfig), IngestionConfigUtils.getBatchSegmentIngestionFrequency((TableConfig)tableConfig), dateTimeFormatSpec, (String)segmentNameGeneratorConfigs.get(SEGMENT_NAME_POSTFIX), appendUUIDToSegmentName);
            }
            case "inputFile": {
                String inputFileUri = this._taskSpec.getCustomProperty("input.data.file.uri");
                return new InputFileSegmentNameGenerator((String)segmentNameGeneratorConfigs.get(FILE_PATH_PATTERN), (String)segmentNameGeneratorConfigs.get(SEGMENT_NAME_TEMPLATE), inputFileUri, appendUUIDToSegmentName);
            }
            case "uploadedRealtime": {
                int partitionId;
                long uploadTime;
                Preconditions.checkState((segmentNameGeneratorConfigs.get("segment.partitionId") != null ? 1 : 0) != 0, (Object)"Valid partition id must be set for uploaded realtime segment name generator");
                String uploadTimeString = (String)segmentNameGeneratorConfigs.get("segment.uploadTimeMs");
                if (uploadTimeString == null) {
                    uploadTimeString = segmentGeneratorConfig.getCreationTime();
                }
                Preconditions.checkState((uploadTimeString != null ? 1 : 0) != 0, (Object)"Upload time must be set for uploaded realtime segment name generator");
                try {
                    uploadTime = Long.parseLong(uploadTimeString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Upload time must be a valid long value in segmentNameGeneratorSpec");
                }
                try {
                    partitionId = Integer.parseInt((String)segmentNameGeneratorConfigs.get("segment.partitionId"));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Partition Id must be a valid integer value in segmentNameGeneratorSpec");
                }
                return new UploadedRealtimeSegmentNameGenerator(tableName, partitionId, uploadTime, (String)segmentNameGeneratorConfigs.get(SEGMENT_NAME_PREFIX), (String)segmentNameGeneratorConfigs.get(SEGMENT_NAME_POSTFIX));
            }
        }
        throw new UnsupportedOperationException("Unsupported segment name generator type: " + segmentNameGeneratorType);
    }
}

