/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.protobuf;

import com.google.protobuf.Descriptors;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.Schema;

public class ProtoBufSchemaUtils {
    private ProtoBufSchemaUtils() {
    }

    public static Schema getPinotSchemaFromPinotSchemaWithComplexTypeHandling(Descriptors.Descriptor protoSchema, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit, List<String> fieldsToUnnest, String delimiter) {
        Schema pinotSchema = new Schema();
        for (Descriptors.FieldDescriptor field : protoSchema.getFields()) {
            ProtoBufSchemaUtils.extractSchemaWithComplexTypeHandling(field, fieldsToUnnest, delimiter, field.getName(), pinotSchema, fieldTypeMap, timeUnit);
        }
        return pinotSchema;
    }

    static void extractSchemaWithComplexTypeHandling(Descriptors.FieldDescriptor fieldSchema, List<String> fieldsToUnnest, String delimiter, String path, Schema pinotSchema, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit) {
        Descriptors.FieldDescriptor.Type fieldType = fieldSchema.getType();
        if (fieldSchema.isRepeated()) {
            if (ProtoBufSchemaUtils.isPrimitiveType(fieldType)) {
                ProtoBufSchemaUtils.addFieldToPinotSchema(pinotSchema, ProtoBufSchemaUtils.valueOf(fieldType), path, false, fieldTypeMap, timeUnit);
            } else if (fieldsToUnnest.contains(path) && !fieldSchema.isMapField()) {
                for (Descriptors.FieldDescriptor innerField : fieldSchema.getMessageType().getFields()) {
                    ProtoBufSchemaUtils.extractSchemaWithComplexTypeHandling(innerField, fieldsToUnnest, delimiter, String.join((CharSequence)delimiter, path, innerField.getName()), pinotSchema, fieldTypeMap, timeUnit);
                }
            } else if (!fieldSchema.isMapField()) {
                ProtoBufSchemaUtils.addFieldToPinotSchema(pinotSchema, FieldSpec.DataType.STRING, path, true, fieldTypeMap, timeUnit);
            }
        } else if (fieldType == Descriptors.FieldDescriptor.Type.MESSAGE) {
            for (Descriptors.FieldDescriptor innerField : fieldSchema.getMessageType().getFields()) {
                ProtoBufSchemaUtils.extractSchemaWithComplexTypeHandling(innerField, fieldsToUnnest, delimiter, String.join((CharSequence)delimiter, path, innerField.getName()), pinotSchema, fieldTypeMap, timeUnit);
            }
        } else {
            FieldSpec.DataType dataType = ProtoBufSchemaUtils.valueOf(fieldType);
            ProtoBufSchemaUtils.addFieldToPinotSchema(pinotSchema, dataType, path, true, fieldTypeMap, timeUnit);
        }
    }

    public static FieldSpec.DataType valueOf(Descriptors.FieldDescriptor.Type pinotType) {
        switch (pinotType) {
            case INT32: 
            case UINT32: 
            case SINT32: 
            case FIXED32: 
            case SFIXED32: {
                return FieldSpec.DataType.INT;
            }
            case INT64: 
            case UINT64: 
            case FIXED64: 
            case SINT64: 
            case SFIXED64: {
                return FieldSpec.DataType.LONG;
            }
            case DOUBLE: {
                return FieldSpec.DataType.DOUBLE;
            }
            case FLOAT: {
                return FieldSpec.DataType.FLOAT;
            }
            case BOOL: {
                return FieldSpec.DataType.BOOLEAN;
            }
            case BYTES: {
                return FieldSpec.DataType.BYTES;
            }
            case STRING: 
            case ENUM: {
                return FieldSpec.DataType.STRING;
            }
        }
        throw new UnsupportedOperationException("Unsupported ProtoBuf type: " + String.valueOf((Object)pinotType));
    }

    public static boolean isPrimitiveType(Descriptors.FieldDescriptor.Type pinotType) {
        switch (pinotType) {
            case INT32: 
            case UINT32: 
            case SINT32: 
            case FIXED32: 
            case INT64: 
            case UINT64: 
            case FIXED64: 
            case SINT64: 
            case SFIXED64: 
            case DOUBLE: 
            case FLOAT: 
            case BOOL: 
            case BYTES: 
            case STRING: 
            case ENUM: {
                return true;
            }
        }
        return false;
    }

    private static void addFieldToPinotSchema(Schema pinotSchema, FieldSpec.DataType dataType, String name, boolean isSingleValueField, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit) {
        if (fieldTypeMap == null) {
            pinotSchema.addField((FieldSpec)new DimensionFieldSpec(name, dataType, isSingleValueField));
        } else {
            FieldSpec.FieldType fieldType = fieldTypeMap.getOrDefault(name, FieldSpec.FieldType.DIMENSION);
            Preconditions.checkNotNull((Object)fieldType, (String)"Field type not specified for field: %s", (Object)name);
            switch (fieldType) {
                case DIMENSION: {
                    pinotSchema.addField((FieldSpec)new DimensionFieldSpec(name, dataType, isSingleValueField));
                    break;
                }
                case METRIC: {
                    Preconditions.checkState((boolean)isSingleValueField, (String)"Metric field: %s cannot be multi-valued", (Object)name);
                    pinotSchema.addField((FieldSpec)new MetricFieldSpec(name, dataType));
                    break;
                }
                case DATE_TIME: {
                    Preconditions.checkState((boolean)isSingleValueField, (String)"Time field: %s cannot be multi-valued", (Object)name);
                    Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"Time unit cannot be null");
                    String format = "1:" + timeUnit.name() + ":EPOCH";
                    String granularity = "1:" + timeUnit.name();
                    pinotSchema.addField((FieldSpec)new DateTimeFieldSpec(name, dataType, format, granularity));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported field type: " + String.valueOf(fieldType) + " for field: " + name);
                }
            }
        }
    }
}

