/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.purge;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.MinionMetrics;
import org.apache.pinot.common.metrics.MinionTimer;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.core.minion.SegmentPurger;
import org.apache.pinot.plugin.minion.tasks.BaseSingleSegmentConversionExecutor;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeTaskExecutor
extends BaseSingleSegmentConversionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PurgeTaskExecutor.class);
    protected final MinionMetrics _minionMetrics = MinionMetrics.get();
    public static final String RECORD_PURGER_KEY = "recordPurger";
    public static final String RECORD_MODIFIER_KEY = "recordModifier";
    public static final String NUM_RECORDS_PURGED_KEY = "numRecordsPurged";
    public static final String NUM_RECORDS_MODIFIED_KEY = "numRecordsModified";
    private static final ThreadMXBean MX_BEAN = ManagementFactory.getThreadMXBean();

    @Override
    protected SegmentConversionResult convert(PinotTaskConfig pinotTaskConfig, File indexDir, File workingDir) throws Exception {
        Map configs = pinotTaskConfig.getConfigs();
        String tableNameWithType = (String)configs.get("tableName");
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
        String taskType = pinotTaskConfig.getTaskType();
        SegmentPurger.RecordPurgerFactory recordPurgerFactory = MINION_CONTEXT.getRecordPurgerFactory();
        TableConfig tableConfig = this.getTableConfig(tableNameWithType);
        Schema schema = this.getSchema(tableNameWithType);
        SegmentPurger.RecordPurger recordPurger = recordPurgerFactory != null ? recordPurgerFactory.getRecordPurger(pinotTaskConfig, tableConfig, schema) : null;
        SegmentPurger.RecordModifierFactory recordModifierFactory = MINION_CONTEXT.getRecordModifierFactory();
        SegmentPurger.RecordModifier recordModifier = recordModifierFactory != null ? recordModifierFactory.getRecordModifier(rawTableName) : null;
        this._eventObserver.notifyProgress(pinotTaskConfig, (Object)("Purging segment: " + String.valueOf(indexDir)));
        SegmentPurger segmentPurger = new SegmentPurger(indexDir, workingDir, tableConfig, schema, recordPurger, recordModifier, null);
        long purgeTaskStartTimeNs = MX_BEAN.getCurrentThreadCpuTime();
        File purgedSegmentFile = segmentPurger.purgeSegment();
        long purgeTaskEndTimeNs = MX_BEAN.getCurrentThreadCpuTime();
        this._minionMetrics.addTimedTableValue(tableNameWithType, taskType, (AbstractMetrics.Timer)MinionTimer.TASK_THREAD_CPU_TIME_NS, purgeTaskEndTimeNs - purgeTaskStartTimeNs, TimeUnit.NANOSECONDS);
        if (purgedSegmentFile == null) {
            purgedSegmentFile = indexDir;
        }
        return new SegmentConversionResult.Builder().setFile(purgedSegmentFile).setTableNameWithType(tableNameWithType).setSegmentName((String)configs.get("segmentName")).setCustomProperty(RECORD_PURGER_KEY, segmentPurger.getRecordPurger()).setCustomProperty(RECORD_MODIFIER_KEY, segmentPurger.getRecordModifier()).setCustomProperty(NUM_RECORDS_PURGED_KEY, segmentPurger.getNumRecordsPurged()).setCustomProperty(NUM_RECORDS_MODIFIED_KEY, segmentPurger.getNumRecordsModified()).build();
    }

    @Override
    protected SegmentZKMetadataCustomMapModifier getSegmentZKMetadataCustomMapModifier(PinotTaskConfig pinotTaskConfig, SegmentConversionResult segmentConversionResult) {
        return new SegmentZKMetadataCustomMapModifier(SegmentZKMetadataCustomMapModifier.ModifyMode.UPDATE, Collections.singletonMap("PurgeTask.time", String.valueOf(System.currentTimeMillis())));
    }
}

