/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.MinionMeter;
import org.apache.pinot.common.utils.TarCompressionUtils;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.minion.event.MinionEventObserver;
import org.apache.pinot.minion.event.MinionEventObservers;
import org.apache.pinot.minion.exception.TaskCancelledException;
import org.apache.pinot.plugin.minion.tasks.BaseTaskExecutor;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionUtils;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSingleSegmentConversionExecutor
extends BaseTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSingleSegmentConversionExecutor.class);
    protected PinotTaskConfig _pinotTaskConfig;
    protected MinionEventObserver _eventObserver;

    protected abstract SegmentConversionResult convert(PinotTaskConfig var1, File var2, File var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentConversionResult executeTask(PinotTaskConfig pinotTaskConfig) throws Exception {
        this._pinotTaskConfig = pinotTaskConfig;
        this._eventObserver = MinionEventObservers.getInstance().getMinionEventObserver(pinotTaskConfig.getTaskId());
        String taskType = pinotTaskConfig.getTaskType();
        Map configs = pinotTaskConfig.getConfigs();
        String tableNameWithType = (String)configs.get("tableName");
        String segmentName = (String)configs.get("segmentName");
        String downloadURL = (String)configs.get("downloadURL");
        String uploadURL = (String)configs.get("uploadURL");
        String originalSegmentCrc = (String)configs.get("crc");
        AuthProvider authProvider = AuthProviderUtils.makeAuthProvider((String)((String)configs.get("authToken")));
        long currentSegmentCrc = this.getSegmentCrc(tableNameWithType, segmentName);
        if (Long.parseLong(originalSegmentCrc) != currentSegmentCrc) {
            LOGGER.info("Segment CRC does not match, skip the task. Original CRC: {}, current CRC: {}", (Object)originalSegmentCrc, (Object)currentSegmentCrc);
            return new SegmentConversionResult.Builder().setTableNameWithType(tableNameWithType).setSegmentName(segmentName).build();
        }
        LOGGER.info("Start executing {} on table: {}, segment: {} with downloadURL: {}, uploadURL: {}", new Object[]{taskType, tableNameWithType, segmentName, downloadURL, uploadURL});
        File tempDataDir = new File(new File(MINION_CONTEXT.getDataDir(), taskType), "tmp-" + String.valueOf(UUID.randomUUID()));
        Preconditions.checkState((boolean)tempDataDir.mkdirs(), (String)"Failed to create temporary directory: %s", (Object)tempDataDir);
        try {
            File indexDir;
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Downloading and decompressing segment from: " + downloadURL));
            try {
                indexDir = this.downloadSegmentToLocalAndUntar(tableNameWithType, segmentName, downloadURL, taskType, tempDataDir, "");
            }
            catch (Exception e) {
                LOGGER.error("Failed to download segment from download url: {}", (Object)downloadURL, (Object)e);
                this._minionMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)MinionMeter.SEGMENT_DOWNLOAD_FAIL_COUNT, 1L);
                this._eventObserver.notifyTaskError(this._pinotTaskConfig, e);
                throw e;
            }
            this.reportSegmentDownloadMetrics(indexDir, tableNameWithType, taskType);
            File workingDir = new File(tempDataDir, "workingDir");
            Preconditions.checkState((boolean)workingDir.mkdir());
            SegmentConversionResult segmentConversionResult = this.convert(pinotTaskConfig, indexDir, workingDir);
            Preconditions.checkState((boolean)segmentConversionResult.getSegmentName().equals(segmentName), (String)"Converted segment name: %s does not match original segment name: %s", (Object)segmentConversionResult.getSegmentName(), (Object)segmentName);
            File convertedSegmentDir = segmentConversionResult.getFile();
            if (convertedSegmentDir == null) {
                SegmentConversionResult segmentConversionResult2 = segmentConversionResult;
                return segmentConversionResult2;
            }
            this.reportSegmentUploadMetrics(workingDir, tableNameWithType, taskType);
            SegmentMetadataImpl segmentMetadata = new SegmentMetadataImpl(indexDir);
            Object numRecordsPurged = segmentConversionResult.getCustomProperty("numRecordsPurged");
            if (numRecordsPurged != null) {
                this.reportTaskProcessingMetrics(tableNameWithType, taskType, segmentMetadata.getTotalDocs(), (Integer)numRecordsPurged);
            } else {
                this.reportTaskProcessingMetrics(tableNameWithType, taskType, segmentMetadata.getTotalDocs());
            }
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Compressing segment: " + segmentName));
            File convertedTarredSegmentFile = new File(tempDataDir, segmentName + ".tar.gz");
            TarCompressionUtils.createCompressedTarFile((File)convertedSegmentDir, (File)convertedTarredSegmentFile);
            if (!FileUtils.deleteQuietly((File)convertedSegmentDir)) {
                LOGGER.warn("Failed to delete converted segment: {}", (Object)convertedSegmentDir.getAbsolutePath());
            }
            if (indexDir.exists() && !FileUtils.deleteQuietly((File)indexDir)) {
                LOGGER.warn("Failed to delete input segment: {}", (Object)indexDir.getAbsolutePath());
            }
            if (this._cancelled) {
                LOGGER.info("{} on table: {}, segment: {} got cancelled", new Object[]{taskType, tableNameWithType, segmentName});
                throw new TaskCancelledException(taskType + " on table: " + tableNameWithType + ", segment: " + segmentName + " got cancelled");
            }
            BasicHeader ifMatchHeader = new BasicHeader("If-Match", (Object)originalSegmentCrc);
            BasicHeader refreshOnlyHeader = new BasicHeader("REFRESH_ONLY", (Object)"true");
            SegmentZKMetadataCustomMapModifier segmentZKMetadataCustomMapModifier = this.getSegmentZKMetadataCustomMapModifier(pinotTaskConfig, segmentConversionResult);
            BasicHeader segmentZKMetadataCustomMapModifierHeader = new BasicHeader("Pinot-SegmentZKMetadataCustomMapModifier", (Object)segmentZKMetadataCustomMapModifier.toJsonString());
            ArrayList<Header> httpHeaders = new ArrayList<Header>();
            httpHeaders.add((Header)ifMatchHeader);
            httpHeaders.add((Header)refreshOnlyHeader);
            httpHeaders.add((Header)segmentZKMetadataCustomMapModifierHeader);
            httpHeaders.addAll(AuthProviderUtils.toRequestHeaders((AuthProvider)authProvider));
            BasicNameValuePair enableParallelPushProtectionParameter = new BasicNameValuePair("enableParallelPushProtection", "true");
            BasicNameValuePair tableNameParameter = new BasicNameValuePair("tableName", TableNameBuilder.extractRawTableName((String)tableNameWithType));
            BasicNameValuePair tableTypeParameter = new BasicNameValuePair("tableType", TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType).toString());
            List<NameValuePair> parameters = Arrays.asList(enableParallelPushProtectionParameter, tableNameParameter, tableTypeParameter);
            this._eventObserver.notifyProgress(this._pinotTaskConfig, (Object)("Uploading segment: " + segmentName));
            boolean uploadSuccessful = true;
            try {
                SegmentConversionUtils.uploadSegment(configs, httpHeaders, parameters, tableNameWithType, segmentName, uploadURL, convertedTarredSegmentFile);
            }
            catch (Exception e) {
                uploadSuccessful = false;
                this._minionMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)MinionMeter.SEGMENT_UPLOAD_FAIL_COUNT, 1L);
                LOGGER.error("Segment upload failed for segment {}, table {}", new Object[]{segmentName, tableNameWithType, e});
                this._eventObserver.notifyTaskError(this._pinotTaskConfig, e);
            }
            if (!FileUtils.deleteQuietly((File)convertedTarredSegmentFile)) {
                LOGGER.warn("Failed to delete tarred converted segment: {}", (Object)convertedTarredSegmentFile.getAbsolutePath());
            }
            if (uploadSuccessful) {
                LOGGER.info("Done executing {} on table: {}, segment: {}", new Object[]{taskType, tableNameWithType, segmentName});
            }
            SegmentConversionResult segmentConversionResult3 = segmentConversionResult;
            return segmentConversionResult3;
        }
        finally {
            FileUtils.deleteQuietly((File)tempDataDir);
        }
    }

    @VisibleForTesting
    public void setMinionEventObserver(MinionEventObserver observer) {
        this._eventObserver = observer;
    }
}

