/*
 * Decompiled with CFR 0.152.
 */
package com.yscope.clp.compressorfrontend;

import com.yscope.clp.compressorfrontend.EncodedMessage;
import com.yscope.clp.compressorfrontend.NativeLibraryLoader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MessageEncoder {
    public MessageEncoder(@NotNull String variablesSchemaVersion, @NotNull String variableEncodingMethodsVersion) throws UnsupportedOperationException {
        Objects.requireNonNull(variablesSchemaVersion);
        Objects.requireNonNull(variableEncodingMethodsVersion);
        byte[] schemaVersionBytes = variablesSchemaVersion.getBytes(StandardCharsets.ISO_8859_1);
        byte[] encodingMethodsVersionBytes = variableEncodingMethodsVersion.getBytes(StandardCharsets.ISO_8859_1);
        this.setVariableHandlingRuleVersions(schemaVersionBytes, schemaVersionBytes.length, encodingMethodsVersionBytes, encodingMethodsVersionBytes.length);
    }

    private native void setVariableHandlingRuleVersions(byte[] var1, int var2, byte[] var3, int var4) throws UnsupportedOperationException;

    public void encodeMessage(String message, EncodedMessage encodedMessage) throws IOException {
        byte[] messageAsBytes = message.getBytes(StandardCharsets.UTF_8);
        encodedMessage.setMessage(messageAsBytes);
        this.encodeMessageNative(messageAsBytes, encodedMessage);
    }

    private native void encodeMessageNative(byte[] var1, EncodedMessage var2) throws IOException;

    static {
        NativeLibraryLoader.load();
    }
}

