/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.cli.help.TextHelpAppendable;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.api.Command;
import org.apache.nifi.toolkit.cli.api.CommandGroup;
import org.apache.nifi.toolkit.cli.api.Context;

public abstract class AbstractCommandGroup
implements CommandGroup {
    private final String name;
    private PrintStream output;
    private List<Command> commands;

    public AbstractCommandGroup(String name) {
        this.name = name;
        Validate.notBlank((CharSequence)this.name);
    }

    @Override
    public final void initialize(Context context) {
        Objects.requireNonNull(context);
        this.output = context.getOutput();
        this.commands = Collections.unmodifiableList(this.createCommands());
        this.commands.stream().forEach(c -> c.initialize(context));
    }

    protected abstract List<Command> createCommands();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Command> getCommands() {
        return this.commands;
    }

    @Override
    public void printUsage(boolean verbose) {
        if (verbose) {
            PrintWriter printWriter = new PrintWriter(this.output);
            TextHelpAppendable appendable = new TextHelpAppendable((Appendable)printWriter);
            appendable.setMaxWidth(80);
            this.commands.stream().forEach(c -> {
                try {
                    appendable.appendParagraph((CharSequence)"-------------------------------------------------------------------------------");
                    appendable.appendParagraph((CharSequence)("COMMAND: " + this.getName() + " " + c.getName()));
                    appendable.appendParagraph((CharSequence)("- " + c.getDescription()));
                    if (c.isReferencable()) {
                        appendable.appendParagraph((CharSequence)"PRODUCES BACK-REFERENCES");
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to print command usage for " + c.getName(), e);
                }
            });
            printWriter.flush();
        } else {
            this.commands.stream().forEach(c -> this.output.println("\t" + this.getName() + " " + c.getName()));
        }
        this.output.flush();
    }
}

