/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.StandardHttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.WebSocket;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class StandardWebSocketBuilder
implements WebSocket.Builder {
    private final StandardHttpClient<?, ?, ?> httpClient;
    private final StandardHttpRequest.Builder builder;
    private String subprotocol;

    public StandardWebSocketBuilder(StandardHttpClient<?, ?, ?> httpClient) {
        this(httpClient, new StandardHttpRequest.Builder());
    }

    public StandardWebSocketBuilder(StandardHttpClient<?, ?, ?> httpClient, StandardHttpRequest.Builder builder) {
        this.httpClient = httpClient;
        this.builder = builder;
    }

    @Override
    public CompletableFuture<WebSocket> buildAsync(WebSocket.Listener listener) {
        return this.httpClient.buildWebSocket(this, listener);
    }

    @Override
    public StandardWebSocketBuilder subprotocol(String protocol) {
        this.subprotocol = protocol;
        return this;
    }

    @Override
    public StandardWebSocketBuilder header(String name, String value) {
        this.builder.header(name, value);
        return this;
    }

    @Override
    public StandardWebSocketBuilder setHeader(String k, String v) {
        this.builder.setHeader(k, v);
        return this;
    }

    @Override
    public StandardWebSocketBuilder uri(URI uri) {
        this.builder.uri(uri);
        return this;
    }

    public StandardWebSocketBuilder newBuilder() {
        return new StandardWebSocketBuilder(this.httpClient, this.builder.build().newBuilder()).subprotocol(this.subprotocol);
    }

    public StandardHttpRequest asHttpRequest() {
        return this.builder.build();
    }

    @Override
    public WebSocket.Builder connectTimeout(long timeout, TimeUnit timeUnit) {
        this.builder.timeout(timeout, timeUnit);
        return this;
    }

    public StandardHttpClient<?, ?, ?> getHttpClient() {
        return this.httpClient;
    }

    public StandardHttpRequest.Builder getBuilder() {
        return this.builder;
    }

    public String getSubprotocol() {
        return this.subprotocol;
    }
}

