/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.util;

import java.util.regex.Pattern;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.config.KyuubiConf;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class Validator$ {
    public static Validator$ MODULE$;
    private final String dns1123LabelFmt;
    private final Pattern podConfValidator;
    private final int KUBERNETES_DNS_SUBDOMAIN_NAME_MAX_LENGTH;
    private final String KUBERNETES_EXECUTOR_POD_NAME_PREFIX;

    static {
        new Validator$();
    }

    public void validateConf(KyuubiConf kyuubiConf) {
        this.validateSparkK8sConf(kyuubiConf);
    }

    private void validateSparkK8sConf(KyuubiConf kyuubiConf) {
        String prefix = (String)kyuubiConf.getOption(this.KUBERNETES_EXECUTOR_POD_NAME_PREFIX()).orNull(Predef$.MODULE$.$conforms());
        if (prefix != null && !this.isValidExecutorPodNamePrefix(prefix)) {
            throw new KyuubiException(new StringBuilder(191).append("'").append(prefix).append("' ").append("in spark.kubernetes.executor.podNamePrefix is invalid.").append(" must conform https://kubernetes.io/docs/concepts/overview/working-with-objects").append("/names/#dns-subdomain-names and the value length <= 237").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private String dns1123LabelFmt() {
        return this.dns1123LabelFmt;
    }

    private Pattern podConfValidator() {
        return this.podConfValidator;
    }

    public int KUBERNETES_DNS_SUBDOMAIN_NAME_MAX_LENGTH() {
        return this.KUBERNETES_DNS_SUBDOMAIN_NAME_MAX_LENGTH;
    }

    private boolean isValidExecutorPodNamePrefix(String prefix) {
        int reservedLen = Integer.toString(Integer.MAX_VALUE).length() + 6;
        boolean validLength = prefix.length() + reservedLen <= this.KUBERNETES_DNS_SUBDOMAIN_NAME_MAX_LENGTH();
        return validLength && this.podConfValidator().matcher(prefix).matches();
    }

    public String KUBERNETES_EXECUTOR_POD_NAME_PREFIX() {
        return this.KUBERNETES_EXECUTOR_POD_NAME_PREFIX;
    }

    private Validator$() {
        MODULE$ = this;
        this.dns1123LabelFmt = "[a-z0-9]([-a-z0-9]*[a-z0-9])?";
        this.podConfValidator = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(7).append("^").append(this.dns1123LabelFmt()).append("(\\.").append(this.dns1123LabelFmt()).append(")*$").toString())).r().pattern();
        this.KUBERNETES_DNS_SUBDOMAIN_NAME_MAX_LENGTH = 253;
        this.KUBERNETES_EXECUTOR_POD_NAME_PREFIX = "spark.kubernetes.executor.podNamePrefix";
    }
}

