/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.ColumnName;
import org.apache.spark.sql.FunctionEntity;
import org.apache.spark.sql.FunctionEntity$;
import org.apache.spark.sql.catalyst.expressions.ApproxCountDistinctDecode;
import org.apache.spark.sql.catalyst.expressions.CeilDateTime;
import org.apache.spark.sql.catalyst.expressions.DictEncode;
import org.apache.spark.sql.catalyst.expressions.DictEncodeV3;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionUtils$;
import org.apache.spark.sql.catalyst.expressions.FloorDateTime;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InitCap;
import org.apache.spark.sql.catalyst.expressions.KapAddMonths;
import org.apache.spark.sql.catalyst.expressions.KapSubtractMonths;
import org.apache.spark.sql.catalyst.expressions.KylinInstr;
import org.apache.spark.sql.catalyst.expressions.KylinSplitPart;
import org.apache.spark.sql.catalyst.expressions.KylinTimestampAdd;
import org.apache.spark.sql.catalyst.expressions.KylinTimestampDiff;
import org.apache.spark.sql.catalyst.expressions.Like;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.PercentileDecode;
import org.apache.spark.sql.catalyst.expressions.PreciseCountDistinctDecode;
import org.apache.spark.sql.catalyst.expressions.RLike;
import org.apache.spark.sql.catalyst.expressions.StringInstr;
import org.apache.spark.sql.catalyst.expressions.Sum0;
import org.apache.spark.sql.catalyst.expressions.SumLCDecode;
import org.apache.spark.sql.catalyst.expressions.Truncate;
import org.apache.spark.sql.catalyst.expressions.YMDintBetween;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.udaf.ApproxCountDistinct;
import org.apache.spark.sql.udaf.ApproxCountDistinct$;
import org.apache.spark.sql.udaf.BitmapUuidFunc;
import org.apache.spark.sql.udaf.BitmapUuidFunc$;
import org.apache.spark.sql.udaf.IntersectCount;
import org.apache.spark.sql.udaf.IntersectCount$;
import org.apache.spark.sql.udaf.Percentile;
import org.apache.spark.sql.udaf.Percentile$;
import org.apache.spark.sql.udaf.PreciseBitmapBuildBase64Decode;
import org.apache.spark.sql.udaf.PreciseBitmapBuildBase64WithIndex;
import org.apache.spark.sql.udaf.PreciseBitmapBuildBase64WithIndex$;
import org.apache.spark.sql.udaf.PreciseBitmapBuildPushDown;
import org.apache.spark.sql.udaf.PreciseBitmapBuildPushDown$;
import org.apache.spark.sql.udaf.PreciseCardinality;
import org.apache.spark.sql.udaf.PreciseCountDistinct;
import org.apache.spark.sql.udaf.PreciseCountDistinct$;
import org.apache.spark.sql.udaf.PreciseCountDistinctAndArray;
import org.apache.spark.sql.udaf.PreciseCountDistinctAndValue;
import org.apache.spark.sql.udaf.ReusePreciseCountDistinct;
import org.apache.spark.sql.udaf.ReuseSumLC;
import org.apache.spark.sql.udaf.ReuseSumLC$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class KapFunctions$ {
    public static KapFunctions$ MODULE$;
    private final Seq<FunctionEntity> builtin;
    private final FunctionEntity percentileFunction;

    static {
        new KapFunctions$();
    }

    private Column withAggregateFunction(AggregateFunction func, boolean isDistinct) {
        return Column$.MODULE$.apply((Expression)func.toAggregateExpression(isDistinct, func.toAggregateExpression$default$2()));
    }

    private boolean withAggregateFunction$default$2() {
        return false;
    }

    public Column k_add_months(Column startDate, Column numMonths) {
        return Column$.MODULE$.apply((Expression)new KapAddMonths(startDate.expr(), numMonths.expr()));
    }

    public Column k_subtract_months(Column date0, Column date1) {
        return Column$.MODULE$.apply((Expression)new KapSubtractMonths(date0.expr(), date1.expr()));
    }

    public Column k_like(Column left, Column right, char escapeChar) {
        return Column$.MODULE$.apply((Expression)new Like(left.expr(), right.expr(), escapeChar));
    }

    public char k_like$default$3() {
        return '\\';
    }

    public Column k_similar(Column left, Column right) {
        return Column$.MODULE$.apply((Expression)new RLike(left.expr(), right.expr()));
    }

    public Column sum0(Column e) {
        return this.withAggregateFunction((AggregateFunction)new Sum0(e.expr()), this.withAggregateFunction$default$2());
    }

    public Column k_lit(Object literal) {
        Column column;
        Object object = literal;
        if (object instanceof Column) {
            Column column2;
            column = column2 = (Column)object;
        } else if (object instanceof Symbol) {
            Symbol symbol = (Symbol)object;
            column = new ColumnName(symbol.name());
        } else {
            column = Column$.MODULE$.apply((Expression)Literal$.MODULE$.apply(literal));
        }
        return column;
    }

    public Column in(Expression value, Seq<Expression> list) {
        return Column$.MODULE$.apply((Expression)new In(value, list));
    }

    public Column k_sum_lc(Column measureCol, DataType wrapDataType) {
        return Column$.MODULE$.apply((Expression)new ReuseSumLC(measureCol.expr(), wrapDataType, wrapDataType, ReuseSumLC$.MODULE$.apply$default$4(), ReuseSumLC$.MODULE$.apply$default$5()).toAggregateExpression());
    }

    public Column k_sum_lc_decode(Column measureCol, String wrapDataType) {
        return Column$.MODULE$.apply((Expression)new SumLCDecode(measureCol.expr(), (Expression)Literal$.MODULE$.apply((Object)wrapDataType)));
    }

    public Column k_percentile(Column head, Column column, int precision) {
        return Column$.MODULE$.apply((Expression)new Percentile(head.expr(), precision, (Option)new Some((Object)column.expr()), (DataType)DoubleType$.MODULE$, Percentile$.MODULE$.apply$default$5(), Percentile$.MODULE$.apply$default$6()).toAggregateExpression());
    }

    public Column k_percentile_decode(Column column, Column p, int precision) {
        return Column$.MODULE$.apply((Expression)new PercentileDecode(column.expr(), p.expr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)precision))));
    }

    public Column precise_count_distinct(Column column) {
        return Column$.MODULE$.apply((Expression)new PreciseCountDistinct(column.expr(), (DataType)LongType$.MODULE$, PreciseCountDistinct$.MODULE$.apply$default$3(), PreciseCountDistinct$.MODULE$.apply$default$4()).toAggregateExpression());
    }

    public Column precise_count_distinct_decode(Column column) {
        return Column$.MODULE$.apply((Expression)new PreciseCountDistinctDecode(column.expr()));
    }

    public Column precise_bitmap_uuid(Column column) {
        return Column$.MODULE$.apply((Expression)new PreciseCountDistinct(column.expr(), (DataType)BinaryType$.MODULE$, PreciseCountDistinct$.MODULE$.apply$default$3(), PreciseCountDistinct$.MODULE$.apply$default$4()).toAggregateExpression());
    }

    public Column precise_bitmap_build(Column column) {
        return Column$.MODULE$.apply((Expression)new PreciseBitmapBuildBase64WithIndex(column.expr(), (DataType)StringType$.MODULE$, PreciseBitmapBuildBase64WithIndex$.MODULE$.apply$default$3(), PreciseBitmapBuildBase64WithIndex$.MODULE$.apply$default$4()).toAggregateExpression());
    }

    public Column precise_bitmap_build_decode(Column column) {
        return Column$.MODULE$.apply((Expression)new PreciseBitmapBuildBase64Decode(column.expr()));
    }

    public Column precise_bitmap_build_pushdown(Column column) {
        return Column$.MODULE$.apply((Expression)new PreciseBitmapBuildPushDown(column.expr(), PreciseBitmapBuildPushDown$.MODULE$.apply$default$2(), PreciseBitmapBuildPushDown$.MODULE$.apply$default$3()).toAggregateExpression());
    }

    public Column bitmap_uuid_func(Column column, DataType returnDataType, Enumeration.Value funcType) {
        return Column$.MODULE$.apply((Expression)new BitmapUuidFunc(column.expr(), -1, 0, returnDataType, funcType, BitmapUuidFunc$.MODULE$.apply$default$6(), BitmapUuidFunc$.MODULE$.apply$default$7()).toAggregateExpression());
    }

    public Column bitmap_uuid_page_func(Column column, int limit, int offset, DataType returnDataType, Enumeration.Value funcType) {
        if (limit < 0 || offset < 0) {
            throw new UnsupportedOperationException("both limit and offset must be >= 0");
        }
        return Column$.MODULE$.apply((Expression)new BitmapUuidFunc(column.expr(), limit, offset, returnDataType, funcType, BitmapUuidFunc$.MODULE$.apply$default$6(), BitmapUuidFunc$.MODULE$.apply$default$7()).toAggregateExpression());
    }

    public Column approx_count_distinct(Column column, int precision) {
        return Column$.MODULE$.apply((Expression)new ApproxCountDistinct(column.expr(), precision, ApproxCountDistinct$.MODULE$.apply$default$3(), ApproxCountDistinct$.MODULE$.apply$default$4()).toAggregateExpression());
    }

    public Column approx_count_distinct_decode(Column column, int precision) {
        return Column$.MODULE$.apply((Expression)new ApproxCountDistinctDecode(column.expr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)precision))));
    }

    public Column k_truncate(Column column, Column scale) {
        return Column$.MODULE$.apply((Expression)new Truncate(column.expr(), scale.expr()));
    }

    public Column intersect_count(String separator, int upperBound, Seq<Column> columns) {
        Predef$.MODULE$.require(columns.size() == 3, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Input columns size ").append(columns.size()).append(" don't equal to 3.").toString());
        Seq expressions = (Seq)columns.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.expr(), Seq$.MODULE$.canBuildFrom());
        return Column$.MODULE$.apply((Expression)new IntersectCount((Expression)expressions.head(), (Expression)expressions.apply(1), (Expression)expressions.apply(2), this.k_lit(IntersectCount$.MODULE$.RAW_STRING()).expr(), (DataType)LongType$.MODULE$, separator, upperBound, IntersectCount$.MODULE$.apply$default$8(), IntersectCount$.MODULE$.apply$default$9()).toAggregateExpression());
    }

    public Column intersect_value(String separator, int upperBound, Seq<Column> columns) {
        Predef$.MODULE$.require(columns.size() == 3, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Input columns size ").append(columns.size()).append(" don't equal to 3.").toString());
        Seq expressions = (Seq)columns.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.expr(), Seq$.MODULE$.canBuildFrom());
        return Column$.MODULE$.apply((Expression)new IntersectCount((Expression)expressions.head(), (Expression)expressions.apply(1), (Expression)expressions.apply(2), this.k_lit(IntersectCount$.MODULE$.RAW_STRING()).expr(), (DataType)new ArrayType((DataType)LongType$.MODULE$, false), separator, upperBound, IntersectCount$.MODULE$.apply$default$8(), IntersectCount$.MODULE$.apply$default$9()).toAggregateExpression());
    }

    public Column intersect_bitmap(String separator, int upperBound, Seq<Column> columns) {
        Predef$.MODULE$.require(columns.size() == 3, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Input columns size ").append(columns.size()).append(" don't equal to 3.").toString());
        Seq expressions = (Seq)columns.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.expr(), Seq$.MODULE$.canBuildFrom());
        return Column$.MODULE$.apply((Expression)new IntersectCount((Expression)expressions.head(), (Expression)expressions.apply(1), (Expression)expressions.apply(2), this.k_lit(IntersectCount$.MODULE$.RAW_STRING()).expr(), (DataType)BinaryType$.MODULE$, separator, upperBound, IntersectCount$.MODULE$.apply$default$8(), IntersectCount$.MODULE$.apply$default$9()).toAggregateExpression());
    }

    public Column intersect_count_v2(Column filterType, String separator, int upperBound, Seq<Column> columns) {
        Predef$.MODULE$.require(columns.size() == 3, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Input columns size ").append(columns.size()).append(" don't equal to 3.").toString());
        Seq expressions = (Seq)columns.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.expr(), Seq$.MODULE$.canBuildFrom());
        return Column$.MODULE$.apply((Expression)new IntersectCount((Expression)expressions.head(), (Expression)expressions.apply(1), (Expression)expressions.apply(2), filterType.expr(), (DataType)LongType$.MODULE$, separator, upperBound, IntersectCount$.MODULE$.apply$default$8(), IntersectCount$.MODULE$.apply$default$9()).toAggregateExpression());
    }

    public Column intersect_value_v2(Column filterType, String separator, int upperBound, Seq<Column> columns) {
        Predef$.MODULE$.require(columns.size() == 3, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Input columns size ").append(columns.size()).append(" don't equal to 3.").toString());
        Seq expressions = (Seq)columns.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.expr(), Seq$.MODULE$.canBuildFrom());
        return Column$.MODULE$.apply((Expression)new IntersectCount((Expression)expressions.head(), (Expression)expressions.apply(1), (Expression)expressions.apply(2), filterType.expr(), (DataType)new ArrayType((DataType)LongType$.MODULE$, false), separator, upperBound, IntersectCount$.MODULE$.apply$default$8(), IntersectCount$.MODULE$.apply$default$9()).toAggregateExpression());
    }

    public Column intersect_bitmap_v2(Column filterType, String separator, int upperBound, Seq<Column> columns) {
        Predef$.MODULE$.require(columns.size() == 3, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Input columns size ").append(columns.size()).append(" don't equal to 3.").toString());
        Seq expressions = (Seq)columns.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.expr(), Seq$.MODULE$.canBuildFrom());
        return Column$.MODULE$.apply((Expression)new IntersectCount((Expression)expressions.head(), (Expression)expressions.apply(1), (Expression)expressions.apply(2), filterType.expr(), (DataType)BinaryType$.MODULE$, separator, upperBound, IntersectCount$.MODULE$.apply$default$8(), IntersectCount$.MODULE$.apply$default$9()).toAggregateExpression());
    }

    public Column dict_encode(Column column, Column dictParams, Column bucketSize, Column buildVersion) {
        return Column$.MODULE$.apply((Expression)new DictEncode(column.expr(), dictParams.expr(), bucketSize.expr(), buildVersion.expr()));
    }

    public Column dict_encode_v3(Column column, String colName) {
        return Column$.MODULE$.apply((Expression)new DictEncodeV3(column.expr(), colName));
    }

    public Seq<FunctionEntity> builtin() {
        return this.builtin;
    }

    public FunctionEntity percentileFunction() {
        return this.percentileFunction;
    }

    private KapFunctions$() {
        MODULE$ = this;
        this.builtin = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FunctionEntity[]{FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("split_part", ClassTag$.MODULE$.apply(KylinSplitPart.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("initcapb", ClassTag$.MODULE$.apply(InitCap.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("strpos", ClassTag$.MODULE$.apply(StringInstr.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("instr", ClassTag$.MODULE$.apply(KylinInstr.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("TRUNCATE", ClassTag$.MODULE$.apply(Truncate.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("bitmap_or", ClassTag$.MODULE$.apply(ReusePreciseCountDistinct.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("bitmap_cardinality", ClassTag$.MODULE$.apply(PreciseCardinality.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("bitmap_and_value", ClassTag$.MODULE$.apply(PreciseCountDistinctAndValue.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("bitmap_and_ids", ClassTag$.MODULE$.apply(PreciseCountDistinctAndArray.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("bitmap_build", ClassTag$.MODULE$.apply(PreciseBitmapBuildPushDown.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("precise_count_distinct_decode", ClassTag$.MODULE$.apply(PreciseCountDistinctDecode.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("approx_count_distinct_decode", ClassTag$.MODULE$.apply(ApproxCountDistinctDecode.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("percentile_decode", ClassTag$.MODULE$.apply(PercentileDecode.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("DICTENCODE", ClassTag$.MODULE$.apply(DictEncode.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("TIMESTAMPADD", ClassTag$.MODULE$.apply(KylinTimestampAdd.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("TIMESTAMPDIFF", ClassTag$.MODULE$.apply(KylinTimestampDiff.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("floor_datetime", ClassTag$.MODULE$.apply(FloorDateTime.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("ceil_datetime", ClassTag$.MODULE$.apply(CeilDateTime.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("_ymdint_between", ClassTag$.MODULE$.apply(YMDintBetween.class)))}));
        this.percentileFunction = FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("percentile_approx", ClassTag$.MODULE$.apply(Percentile.class)));
    }
}

