/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.rest.constant.ModelAttributeEnum;
import org.apache.kylin.rest.response.NDataModelLiteResponse;
import org.apache.kylin.rest.response.NDataModelResponse;
import org.apache.kylin.rest.response.NDataSegmentResponse;

public class ModelUtils {
    private ModelUtils() {
    }

    public static String computeExpansionRate(long storageBytesSize, long sourceBytesSize) {
        if (storageBytesSize == 0L) {
            return "0";
        }
        if (sourceBytesSize == 0L) {
            return "-1";
        }
        BigDecimal divide = new BigDecimal(storageBytesSize).divide(new BigDecimal(sourceBytesSize), 4, 4);
        BigDecimal bigDecimal = divide.multiply(new BigDecimal(100)).setScale(2);
        return bigDecimal.toString();
    }

    public static void checkPartitionColumn(NDataModel model, PartitionDesc partitionDesc, String errMsg) {
        if (!model.isBroken() && model.isStreaming() && ModelUtils.isPartitionEmptyAndNotTimeStamp(partitionDesc)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARTITION_COLUMN, errMsg);
        }
    }

    private static boolean isPartitionEmptyAndNotTimeStamp(PartitionDesc partitionDesc) {
        return PartitionDesc.isEmptyPartitionDesc((PartitionDesc)partitionDesc) || !DateFormat.isTimestampFormat((String)partitionDesc.getPartitionDateFormat());
    }

    public static void checkPartitionColumn(String project, String modelId, String errMsg) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataModelManager modelMgr = NDataModelManager.getInstance((KylinConfig)config, (String)project);
        NDataModel model = modelMgr.getDataModelDesc(modelId);
        if (!model.isBroken() && model.isStreaming()) {
            PartitionDesc partitionDesc = model.getPartitionDesc();
            ModelUtils.checkPartitionColumn(model, partitionDesc, errMsg);
        }
    }

    public static boolean isArgMatch(String valueToMatch, boolean exactMatch, String originValue) {
        return StringUtils.isEmpty((CharSequence)valueToMatch) || exactMatch && originValue.equalsIgnoreCase(valueToMatch) || !exactMatch && originValue.toLowerCase(Locale.ROOT).contains(valueToMatch.toLowerCase(Locale.ROOT));
    }

    public static Set<NDataModel> getFilteredModels(List<ModelAttributeEnum> modelAttributes, List<NDataModel> models) {
        HashSet modelAttributeSet = Sets.newHashSet(modelAttributes == null ? Collections.emptyList() : modelAttributes);
        HashSet<NDataModel> filteredModels = new HashSet<NDataModel>();
        for (ModelAttributeEnum attr : modelAttributeSet) {
            filteredModels.addAll(attr.filter(models));
        }
        return filteredModels;
    }

    public static boolean isModelHasAnyData(NDataModelResponse modelResponse, IndexPlan indexPlan) {
        if (modelResponse.getTotalIndexes() == 0L) {
            return false;
        }
        List<NDataSegmentResponse> segments = modelResponse.getSegments();
        if (modelResponse instanceof NDataModelLiteResponse) {
            segments = ((NDataModelLiteResponse)modelResponse).getRealSegments();
        }
        if (segments.isEmpty()) {
            return false;
        }
        return indexPlan.getAllLayouts().stream().anyMatch(layoutEntity -> !layoutEntity.isBaseIndex());
    }

    public static enum MessageType {
        SEGMENT,
        PARTITION,
        MODEL;

    }
}

