/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.util.Util;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.event.ModelAddEvent;
import org.apache.kylin.common.event.ModelDropEvent;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.JobErrorCode;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.transaction.TransactionException;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkContext;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.SqlIdentifierFormatterVisitor;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.common.util.ThreadUtil;
import org.apache.kylin.engine.spark.utils.ComputedColumnEvalUtil;
import org.apache.kylin.fileseg.FileSegments;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.base.Strings;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.common.SegmentUtil;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.manager.JobManager;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.acl.AclTCRDigest;
import org.apache.kylin.metadata.acl.AclTCRManager;
import org.apache.kylin.metadata.acl.NDataModelAclParams;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataLayoutDetails;
import org.apache.kylin.metadata.cube.model.NDataLayoutDetailsManager;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.model.AntiFlatChecker;
import org.apache.kylin.metadata.model.AutoMergeTimeEnum;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.DataCheckDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.FusionModel;
import org.apache.kylin.metadata.model.FusionModelManager;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.ManagementType;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.RetentionRange;
import org.apache.kylin.metadata.model.SegmentConfig;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.SegmentStatusEnumToDisplay;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.UpdateImpact;
import org.apache.kylin.metadata.model.VolatileRange;
import org.apache.kylin.metadata.model.schema.AffectedModelContext;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;
import org.apache.kylin.metadata.model.util.MultiPartitionUtil;
import org.apache.kylin.metadata.model.util.scd2.SCD2CondChecker;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.streaming.KafkaConfig;
import org.apache.kylin.query.util.PushDownUtil;
import org.apache.kylin.query.util.QueryParams;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.constant.ModelAttributeEnum;
import org.apache.kylin.rest.constant.ModelStatusToDisplayEnum;
import org.apache.kylin.rest.request.AddSegmentRequest;
import org.apache.kylin.rest.request.MergeSegmentRequest;
import org.apache.kylin.rest.request.ModelConfigRequest;
import org.apache.kylin.rest.request.ModelParatitionDescRequest;
import org.apache.kylin.rest.request.ModelRequest;
import org.apache.kylin.rest.request.MultiPartitionMappingRequest;
import org.apache.kylin.rest.request.OptimizeLayoutDataRequest;
import org.apache.kylin.rest.request.OwnerChangeRequest;
import org.apache.kylin.rest.request.SegmentTimeRequest;
import org.apache.kylin.rest.response.AffectedModelsResponse;
import org.apache.kylin.rest.response.AggGroupResponse;
import org.apache.kylin.rest.response.BuildBaseIndexResponse;
import org.apache.kylin.rest.response.CheckSegmentResponse;
import org.apache.kylin.rest.response.ComputedColumnCheckResponse;
import org.apache.kylin.rest.response.ComputedColumnConflictResponse;
import org.apache.kylin.rest.response.ComputedColumnUsageResponse;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.ExistedDataRangeResponse;
import org.apache.kylin.rest.response.FusionModelResponse;
import org.apache.kylin.rest.response.IndicesResponse;
import org.apache.kylin.rest.response.InvalidIndexesResponse;
import org.apache.kylin.rest.response.JobInfoResponse;
import org.apache.kylin.rest.response.LayoutRecDetailResponse;
import org.apache.kylin.rest.response.ModelConfigResponse;
import org.apache.kylin.rest.response.ModelSaveCheckResponse;
import org.apache.kylin.rest.response.MultiPartitionValueResponse;
import org.apache.kylin.rest.response.NCubeDescResponse;
import org.apache.kylin.rest.response.NDataModelLiteResponse;
import org.apache.kylin.rest.response.NDataModelOldParams;
import org.apache.kylin.rest.response.NDataModelResponse;
import org.apache.kylin.rest.response.NDataSegmentResponse;
import org.apache.kylin.rest.response.NModelDescResponse;
import org.apache.kylin.rest.response.PurgeModelAffectedResponse;
import org.apache.kylin.rest.response.RelatedModelResponse;
import org.apache.kylin.rest.response.SegmentCheckResponse;
import org.apache.kylin.rest.response.SegmentPartitionResponse;
import org.apache.kylin.rest.response.SegmentRangeResponse;
import org.apache.kylin.rest.response.SimplifiedMeasure;
import org.apache.kylin.rest.service.AbstractModelService;
import org.apache.kylin.rest.service.BaseIndexUpdateHelper;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.FusionIndexService;
import org.apache.kylin.rest.service.IndexPlanService;
import org.apache.kylin.rest.service.ModelBuildSupporter;
import org.apache.kylin.rest.service.ModelChangeSupporter;
import org.apache.kylin.rest.service.ModelQuerySupporter;
import org.apache.kylin.rest.service.ModelSemanticHelper;
import org.apache.kylin.rest.service.ModelSmartServiceSupporter;
import org.apache.kylin.rest.service.ProjectModelSupporter;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.TableModelSupporter;
import org.apache.kylin.rest.service.params.FullBuildSegmentParams;
import org.apache.kylin.rest.service.params.IncrementBuildSegmentParams;
import org.apache.kylin.rest.service.params.MergeSegmentParams;
import org.apache.kylin.rest.service.params.ModelQueryParams;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.kylin.rest.util.ModelTriple;
import org.apache.kylin.rest.util.ModelUtils;
import org.apache.kylin.rest.util.PagingUtil;
import org.apache.kylin.source.SourceFactory;
import org.apache.kylin.source.adhocquery.PushDownConverterKeyWords;
import org.apache.kylin.streaming.event.StreamingJobDropEvent;
import org.apache.kylin.streaming.event.StreamingJobKillEvent;
import org.apache.kylin.streaming.manager.StreamingJobManager;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component(value="modelService")
public class ModelService
extends AbstractModelService
implements TableModelSupporter,
ProjectModelSupporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelService.class);
    private static final Logger logger = LoggerFactory.getLogger(ModelService.class);
    private static final String LAST_MODIFY = "last_modify";
    public static final String RECOMMENDATIONS_COUNT_LOWER_UNDERSCORE = "recommendations_count";
    public static final Pattern VALID_NAME_FOR_DIMENSION = Pattern.compile("^[\\u4E00-\\u9FA5a-zA-Z0-9 _\\-()%?\uff08\uff09]+$");
    public static final Pattern VALID_NAME_FOR_MEASURE = Pattern.compile("^[\\u4E00-\\u9FA5a-zA-Z0-9 _\\-()%?\uff08\uff09.]+$");
    private static final List<String> MODEL_CONFIG_BLOCK_LIST = Lists.newArrayList((Object[])new String[]{"kylin.index.rule-scheduler-data"});
    private static final Set<String> STRING_TYPE_SET = Sets.newHashSet((Object[])new String[]{"STRING", "CHAR", "VARCHAR"});
    private static final List<String> SUPPORTED_FORMATS = ImmutableList.of((Object)"ZZ", (Object)"DD", (Object)"D", (Object)"Do", (Object)"dddd", (Object)"ddd", (Object)"dd", (Object)"d", (Object)"MMM", (Object)"MM", (Object)"M", (Object)"yyyy", (Object[])new String[]{"yy", "hh", "hh", "h", "HH", "H", "m", "mm", "ss", "s", "SSS", "SS", "S", "A", "a"});
    private static final Pattern QUOTE_PATTERN = Pattern.compile("'(.*?)'");
    @Autowired
    private ModelSemanticHelper semanticUpdater;
    @Autowired
    private ProjectService projectService;
    @Autowired(required=false)
    private ModelQuerySupporter modelQuerySupporter;
    @Autowired
    private IndexPlanService indexPlanService;
    @Autowired(required=false)
    @Qualifier(value="modelBuildService")
    private ModelBuildSupporter modelBuildService;
    @Autowired(required=false)
    private ModelSmartServiceSupporter modelSmartServiceSupporter;
    @Autowired(required=false)
    private List<ModelChangeSupporter> modelChangeSupporters = Lists.newArrayList();

    @Override
    public NDataModel getModelById(String modelId, String project) {
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        NDataModel nDataModel = modelManager.getDataModelDesc(modelId);
        if (null == nDataModel) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_ID_NOT_EXIST, new Object[]{modelId});
        }
        return nDataModel;
    }

    @Override
    public NDataModel getModelByAlias(String modelAlias, String project) {
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        NDataModel nDataModel = modelManager.getDataModelDescByAlias(modelAlias);
        if (null == nDataModel) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_NOT_EXIST, new Object[]{modelAlias});
        }
        return nDataModel;
    }

    public NDataModel getModel(String modelAliasOrUuid, String project) {
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).listAllModels().stream().filter(dataModel -> dataModel.getUuid().equals(modelAliasOrUuid) || dataModel.getAlias().equalsIgnoreCase(modelAliasOrUuid)).findFirst().orElse(null);
        if (model == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_NOT_EXIST, new Object[]{modelAliasOrUuid});
        }
        if (model.isBroken()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_BROKEN, String.format(Locale.ROOT, MsgPicker.getMsg().getBrokenModelOperationDenied(), modelAliasOrUuid));
        }
        return model;
    }

    public NDataModel getModelWithoutBrokenCheck(String modelAliasOrUuid, String project) {
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).listAllModels().stream().filter(dataModel -> dataModel.getUuid().equals(modelAliasOrUuid) || dataModel.getAlias().equalsIgnoreCase(modelAliasOrUuid)).findFirst().orElse(null);
        if (model == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_NOT_EXIST, new Object[]{modelAliasOrUuid});
        }
        return model;
    }

    public List<String> getModelNamesByFuzzyName(String fuzzyName, String project, boolean exact) {
        if (StringUtils.isNotEmpty((CharSequence)project)) {
            NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
            return this.matchModelNameByAlias(modelManager, fuzzyName, exact);
        }
        ArrayList<String> modelAlias = new ArrayList<String>();
        List projectInstances = this.projectService.getReadableProjects(null, false);
        for (ProjectInstance projectInstance : projectInstances) {
            NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, projectInstance.getName());
            modelAlias.addAll(this.matchModelNameByAlias(modelManager, fuzzyName, exact));
        }
        return modelAlias;
    }

    private List<String> matchModelNameByAlias(NDataModelManager modelManager, String fuzzyName, boolean exact) {
        if (!exact) {
            return modelManager.getModelNamesByFuzzyName(fuzzyName);
        }
        ArrayList modelAlias = Lists.newArrayList();
        NDataModel nDataModel = modelManager.getDataModelDescByAlias(fuzzyName);
        if (null != nDataModel) {
            modelAlias.add(nDataModel.getAlias());
        }
        return modelAlias;
    }

    public List<NDataModel> addOldParams(String project, List<NDataModel> modelList) {
        List<AbstractExecutable> executables = this.getAllRunningExecutable(project);
        modelList.forEach(model -> {
            NDataModelOldParams oldParams = new NDataModelOldParams();
            oldParams.setName(model.getAlias());
            oldParams.setJoinTables(model.getJoinTables());
            if (!model.isBroken()) {
                this.addOldSegmentParams((NDataModel)model, oldParams, executables);
            }
            if (model instanceof NDataModelResponse) {
                oldParams.setProjectName(model.getProject());
                oldParams.setSizeKB(((NDataModelResponse)((Object)model)).getStorage() / 1024L);
                oldParams.setDimensions(((NDataModelResponse)((Object)model)).getNamedColumns());
                ((NDataModelResponse)((Object)model)).setOldParams(oldParams);
            } else if (model instanceof RelatedModelResponse) {
                ((RelatedModelResponse)((Object)model)).setOldParams(oldParams);
            }
        });
        return modelList;
    }

    private void addOldSegmentParams(NDataModel model, NDataModelOldParams oldParams, List<AbstractExecutable> executables) {
        FusionModel fusionModel;
        NDataModel batchModel;
        List<NDataSegmentResponse> segments = this.getSegmentsResponse(model.getId(), model.getProject(), "1", String.valueOf(0x7FFFFFFFFFFFFFFEL), null, executables, LAST_MODIFY, true, model instanceof NDataModelLiteResponse);
        this.calculateRecordSizeAndCount(segments, oldParams);
        if (model instanceof NDataModelResponse) {
            ((NDataModelResponse)model).setSegments(segments);
            ((NDataModelResponse)model).setHasSegments(((NDataModelResponse)model).isHasSegments() || CollectionUtils.isNotEmpty(segments));
            this.checkSegmentOverlap((NDataModelResponse)model, segments);
        }
        if (model.isFusionModel() && !(batchModel = (fusionModel = ((FusionModelManager)this.getManager(FusionModelManager.class, model.getProject())).getFusionModel(model.getId())).getBatchModel()).isBroken()) {
            List<NDataSegmentResponse> batchSegments = this.getSegmentsResponse(batchModel.getUuid(), model.getProject(), "1", String.valueOf(0x7FFFFFFFFFFFFFFEL), null, executables, LAST_MODIFY, true, false);
            this.calculateRecordSizeAndCount(batchSegments, oldParams);
            if (model instanceof FusionModelResponse) {
                ((FusionModelResponse)model).setBatchSegments(batchSegments);
            }
        }
    }

    private void calculateRecordSizeAndCount(List<NDataSegmentResponse> segments, NDataModelOldParams oldParams) {
        long inputRecordCnt = oldParams.getInputRecordCnt();
        long inputRecordSizeBytes = oldParams.getInputRecordSizeBytes();
        for (NDataSegmentResponse segment : segments) {
            long sourceRows = segment.getSourceCount();
            inputRecordCnt += sourceRows;
            inputRecordSizeBytes += segment.getSourceBytesSize();
            NDataSegmentResponse.OldParams segmentOldParams = new NDataSegmentResponse.OldParams();
            segmentOldParams.setSizeKB(segment.getBytesSize() / 1024L);
            segmentOldParams.setInputRecords(sourceRows);
            segment.setOldParams(segmentOldParams);
        }
        oldParams.setInputRecordCnt(inputRecordCnt);
        oldParams.setInputRecordSizeBytes(inputRecordSizeBytes);
    }

    @VisibleForTesting
    public Set<String> getAllProjects() {
        return this.projectService.getReadableProjects().stream().map(ProjectInstance::getName).collect(Collectors.toSet());
    }

    public boolean isProjectNotExist(String project) {
        List projectInstances = this.projectService.getReadableProjects(project, true);
        return CollectionUtils.isEmpty((Collection)projectInstances);
    }

    public NDataModelResponse getCube(String modelAlias, String projectName) {
        if (Objects.nonNull(projectName)) {
            List<NDataModelResponse> cubes = this.getCubes(modelAlias, projectName);
            if (!CollectionUtils.isEmpty(cubes)) {
                return cubes.get(0);
            }
        } else {
            for (String project : this.getAllProjects()) {
                List<NDataModelResponse> cubes = this.getCubes(modelAlias, project);
                if (CollectionUtils.isEmpty(cubes)) continue;
                return cubes.get(0);
            }
        }
        return null;
    }

    public List<NDataModelResponse> getCubes(String modelAlias, String projectName) {
        if (Objects.nonNull(projectName)) {
            return this.getCubes0(modelAlias, projectName);
        }
        ArrayList cubes = Lists.newArrayList();
        for (String project : this.getAllProjects()) {
            cubes.addAll(this.getCubes0(modelAlias, project));
        }
        return cubes;
    }

    private boolean isAggGroupIncludeAllJoinCol(List<Set<String>> aggIncludes, List<String> needCols) {
        for (Set<String> includes : aggIncludes) {
            boolean allIn = includes.containsAll(needCols);
            if (!allIn) continue;
            return true;
        }
        return false;
    }

    private List<NCubeDescResponse.Dimension3X> getDimension3XES(IndexPlan indexPlan, NDataModelResponse cube, List<AggGroupResponse> aggGroupResponses, NDataModel dataModel) {
        String rootFactTable = cube.getRootFactTableName();
        ArrayList<NCubeDescResponse.Dimension3X> dims = new ArrayList<NCubeDescResponse.Dimension3X>();
        HashMap fk2Pk = Maps.newHashMap();
        cube.getJoinTables().forEach(join -> {
            String[] pks = join.getJoin().getPrimaryKey();
            String[] fks = join.getJoin().getForeignKey();
            for (int i = 0; i < pks.length; ++i) {
                fk2Pk.put(fks[i], pks[i]);
            }
        });
        HashMap tableToAllDim = Maps.newHashMap();
        cube.getNamedColumns().forEach(namedColumn -> {
            String aliasDotColumn = namedColumn.getAliasDotColumn();
            String table = aliasDotColumn.split("\\.")[0];
            String column = aliasDotColumn.split("\\.")[1];
            if (!tableToAllDim.containsKey(table)) {
                tableToAllDim.put(table, Lists.newArrayList());
            }
            ((List)tableToAllDim.get(table)).add(column);
        });
        HashSet allAggDim = Sets.newHashSet();
        indexPlan.getRuleBasedIndex().getDimensions().stream().map(x -> (TblColRef)dataModel.getEffectiveDimensions().get(x)).forEach(x -> allAggDim.add(x.getIdentity()));
        ArrayList aggIncludes = new ArrayList();
        aggGroupResponses.forEach(agg -> aggIncludes.add(Sets.newHashSet((Object[])agg.getIncludes())));
        cube.getNamedColumns().forEach(namedColumn -> {
            String aliasDotColumn = namedColumn.getAliasDotColumn();
            String table = aliasDotColumn.split("\\.")[0];
            boolean isRootFactTable = rootFactTable.endsWith("." + table);
            if (isRootFactTable) {
                if (allAggDim.contains(aliasDotColumn)) {
                    dims.add(new NCubeDescResponse.Dimension3X((NDataModel.NamedColumn)namedColumn, false));
                }
            } else {
                ArrayList<String> needCols = new ArrayList<String>();
                List dimTableCol = (List)tableToAllDim.get(table);
                dimTableCol.stream().filter(x -> fk2Pk.containsKey(table + "." + x)).forEach(x -> {
                    needCols.add((String)x);
                    needCols.add((String)fk2Pk.get(x));
                });
                if (this.isAggGroupIncludeAllJoinCol(aggIncludes, needCols)) {
                    boolean isDerived = !allAggDim.contains(aliasDotColumn);
                    dims.add(new NCubeDescResponse.Dimension3X((NDataModel.NamedColumn)namedColumn, isDerived));
                }
            }
        });
        return dims;
    }

    public NCubeDescResponse getCubeWithExactModelName(String modelAlias, String projectName) {
        NDataModel dataModel = ((NDataModelManager)this.getManager(NDataModelManager.class, projectName)).getDataModelDescByAlias(modelAlias);
        if (dataModel == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_NOT_EXIST, new Object[]{modelAlias});
        }
        NDataModelResponse cube = new NDataModelResponse(dataModel);
        NCubeDescResponse result = new NCubeDescResponse();
        result.setUuid(cube.getUuid());
        result.setName(cube.getAlias());
        result.setMeasures(cube.getMeasures().stream().map(NCubeDescResponse.Measure3X::new).collect(Collectors.toList()));
        IndexPlan indexPlan = this.getIndexPlan(result.getUuid(), projectName);
        if (!dataModel.isBroken() && indexPlan.getRuleBasedIndex() != null) {
            List<AggGroupResponse> aggGroupResponses = indexPlan.getRuleBasedIndex().getAggregationGroups().stream().map(x -> new AggGroupResponse(dataModel, (NAggregationGroup)x)).collect(Collectors.toList());
            result.setAggregationGroups(aggGroupResponses);
            result.setDimensions(this.getDimension3XES(indexPlan, cube, aggGroupResponses, dataModel));
        } else {
            result.setAggregationGroups(new ArrayList<AggGroupResponse>());
            result.setDimensions(new ArrayList<NCubeDescResponse.Dimension3X>());
        }
        return result;
    }

    public List<NDataModelResponse> getCubes0(String modelAlias, String project) {
        Preconditions.checkNotNull((Object)project);
        List<NDataModelResponse> modelResponseList = this.getModels(modelAlias, project, true, null, null, LAST_MODIFY, true);
        modelResponseList.forEach(modelResponse -> {
            NDataModelOldParams oldParams = new NDataModelOldParams();
            long inputRecordCnt = 0L;
            long inputRecordSizeBytes = 0L;
            if (!modelResponse.isModelBroken()) {
                List<NDataSegmentResponse> segments = this.getSegmentsResponse(modelResponse.getId(), project, "1", String.valueOf(0x7FFFFFFFFFFFFFFEL), null, LAST_MODIFY, true);
                for (NDataSegmentResponse segment : segments) {
                    long sourceRows = segment.getSourceCount();
                    inputRecordCnt += sourceRows;
                    inputRecordSizeBytes += segment.getSourceBytesSize();
                    NDataSegmentResponse.OldParams segmentOldParams = new NDataSegmentResponse.OldParams();
                    segmentOldParams.setSizeKB(segment.getBytesSize() / 1024L);
                    segmentOldParams.setInputRecords(sourceRows);
                    segment.setOldParams(segmentOldParams);
                }
                modelResponse.setSegments(segments);
                modelResponse.setHasSegments(modelResponse.isHasSegments() || CollectionUtils.isNotEmpty(segments));
                this.checkSegmentOverlap((NDataModelResponse)((Object)modelResponse), segments);
            }
            oldParams.setName(modelResponse.getAlias());
            oldParams.setProjectName(project);
            oldParams.setStreaming(false);
            oldParams.setSizeKB(modelResponse.getStorage() / 1024L);
            oldParams.setInputRecordSizeBytes(inputRecordSizeBytes);
            oldParams.setInputRecordCnt(inputRecordCnt);
            oldParams.setJoinTables(modelResponse.getJoinTables());
            modelResponse.setOldParams(oldParams);
        });
        return modelResponseList;
    }

    private boolean isListContains(List<String> status, ModelStatusToDisplayEnum modelStatus) {
        return status == null || status.isEmpty() || modelStatus != null && status.contains(modelStatus.name());
    }

    public List<NDataModelResponse> getModels(String modelAlias, String projectName, boolean exactMatch, String owner, List<String> status, String sortBy, boolean reverse) {
        return this.getModels(modelAlias, projectName, exactMatch, owner, status, sortBy, reverse, null, null, null);
    }

    public List<NDataModelResponse> getSCD2ModelsByStatus(String projectName, List<String> status) {
        return this.getModels(null, projectName, false, null, status, LAST_MODIFY, true, null, null, null).stream().filter(arg_0 -> ((SCD2CondChecker)SCD2CondChecker.INSTANCE).isScd2Model(arg_0)).collect(Collectors.toList());
    }

    public List<String> getSCD2ModelsAliasByStatus(String projectName, List<String> status) {
        return this.getSCD2ModelsByStatus(projectName, status).stream().map(NDataModel::getAlias).collect(Collectors.toList());
    }

    private List<String> getSCD2Models(String projectName) {
        return this.getSCD2ModelsByStatus(projectName, null).stream().map(RootPersistentEntity::getId).collect(Collectors.toList());
    }

    public List<String> getModelNonOffOnlineStatus() {
        return Arrays.asList(ModelStatusToDisplayEnum.ONLINE.name(), ModelStatusToDisplayEnum.WARNING.name());
    }

    public List<String> getMultiPartitionModelsAlias(String projectName, List<String> status) {
        return this.getMultiPartitionModelsByStatus(projectName, status).stream().map(NDataModel::getAlias).collect(Collectors.toList());
    }

    public List<NDataModelResponse> getMultiPartitionModelsByStatus(String projectName, List<String> status) {
        return this.getModels(null, projectName, false, null, status, LAST_MODIFY, true, null, null, null).stream().filter(NDataModel::isMultiPartitionModel).collect(Collectors.toList());
    }

    public DataResult<List<NDataModel>> getModels(ModelQueryParams params) {
        List<Object> models = new ArrayList<NDataModel>();
        String table = params.getTable();
        String project = params.getProjectName();
        List<ModelAttributeEnum> modelAttributes = params.getModelAttributes();
        String modelId = params.getModelId();
        Integer offset = params.getOffset();
        Integer limit = params.getLimit();
        if (StringUtils.isEmpty((CharSequence)table)) {
            List<ModelTriple> tripleList = this.modelQuerySupporter.getModels(params);
            Pair<List<NDataModelResponse>, Integer> pair = this.getModelsOfCurrentPage(params, tripleList, params.isLite());
            models.addAll((Collection)pair.getFirst());
            DataResult filterModels = new DataResult(models, ((Integer)pair.getSecond()).intValue(), offset.intValue(), limit.intValue());
            filterModels.setValue(this.addOldParams(project, (List)filterModels.getValue()));
            filterModels.setValue(this.updateResponseAcl((List)filterModels.getValue(), project));
            return filterModels;
        }
        Set<NDataModel> filteredModels = ModelUtils.getFilteredModels(modelAttributes, models);
        if (CollectionUtils.isNotEmpty(modelAttributes)) {
            models = models.stream().filter(filteredModels::contains).collect(Collectors.toList());
        }
        if (StringUtils.isNotEmpty((CharSequence)modelId)) {
            models.removeIf(model -> !model.getUuid().equals(modelId));
        }
        DataResult filterModels = DataResult.get(models, (int)offset, (int)limit);
        filterModels.setValue(this.addOldParams(project, (List)filterModels.getValue()));
        filterModels.setValue(this.updateResponseAcl((List)filterModels.getValue(), project));
        return filterModels;
    }

    public Pair<List<NDataModelResponse>, Integer> getModelsOfCurrentPage(ModelQueryParams queryElem, List<ModelTriple> modelTripleList, boolean lite) {
        String projectName = queryElem.getProjectName();
        Integer offset = queryElem.getOffset();
        Integer limit = queryElem.getLimit();
        List<String> status = queryElem.getStatus();
        NDataflowManager dfManager = (NDataflowManager)this.getManager(NDataflowManager.class, projectName);
        ArrayList filterModels = new ArrayList();
        AtomicInteger totalSize = new AtomicInteger();
        modelTripleList.stream().map(t -> {
            if ((status == null || status.isEmpty()) && !PagingUtil.isInCurrentPage((int)totalSize.get(), (int)offset, (int)limit)) {
                totalSize.getAndIncrement();
                return null;
            }
            NDataModel dataModel = t.getDataModel();
            try {
                NDataModelResponse nDataModelResponse = this.convertToDataModelResponse(dataModel, projectName, dfManager, status, queryElem.isOnlyNormalDim());
                if (lite && nDataModelResponse != null) {
                    return new NDataModelLiteResponse(nDataModelResponse, dataModel);
                }
                return nDataModelResponse;
            }
            catch (Exception e) {
                String errorMsg = String.format(Locale.ROOT, "convert NDataModelResponse failed, mark to broken. %s, %s", dataModel.getAlias(), dataModel.getUuid());
                logger.error(errorMsg, (Throwable)e);
                return this.convertToDataModelResponseBroken(dataModel);
            }
        }).filter(Objects::nonNull).forEach(nDataModelResponse -> {
            if (PagingUtil.isInCurrentPage((int)totalSize.get(), (int)offset, (int)limit)) {
                filterModels.add(nDataModelResponse);
            }
            totalSize.getAndIncrement();
        });
        return new Pair(filterModels, (Object)totalSize.get());
    }

    public NDataModelResponse convertToDataModelResponseBroken(NDataModel modelDesc) {
        NDataModelResponse response = new NDataModelResponse(modelDesc);
        response.setStatus(ModelStatusToDisplayEnum.BROKEN);
        return response;
    }

    public List<NDataModelResponse> getModels(String modelAlias, String projectName, boolean exactMatch, String owner, List<String> status, String sortBy, boolean reverse, String modelAliasOrOwner, Long lastModifyFrom, Long lastModifyTo) {
        return this.getModels(modelAlias, projectName, exactMatch, owner, status, sortBy, reverse, modelAliasOrOwner, lastModifyFrom, lastModifyTo, true);
    }

    public List<NDataModelResponse> getModels(String modelAlias, String projectName, boolean exactMatch, String owner, List<String> status, String sortBy, boolean reverse, String modelAliasOrOwner, Long lastModifyFrom, Long lastModifyTo, boolean onlyNormalDim) {
        this.aclEvaluate.checkProjectReadPermission(projectName);
        List<Pair<NDataflow, NDataModel>> pairs = this.getFirstMatchModels(modelAlias, projectName, exactMatch, owner, modelAliasOrOwner, lastModifyFrom, lastModifyTo);
        NDataflowManager dfManager = (NDataflowManager)this.getManager(NDataflowManager.class, projectName);
        ArrayList<NDataModelResponse> filterModels = new ArrayList<NDataModelResponse>();
        pairs.forEach(p -> {
            NDataModel modelDesc = (NDataModel)p.getValue();
            NDataModelResponse dataModelResponse = this.convertToDataModelResponse(modelDesc, projectName, dfManager, status, onlyNormalDim);
            if (dataModelResponse != null) {
                filterModels.add(dataModelResponse);
            }
        });
        if ("expansionrate".equalsIgnoreCase(sortBy)) {
            return this.sortExpansionRate(reverse, filterModels);
        }
        if (((NProjectManager)this.getManager(NProjectManager.class)).getProject(projectName).isSemiAutoMode() || RECOMMENDATIONS_COUNT_LOWER_UNDERSCORE.equalsIgnoreCase(sortBy)) {
            Comparator comparator = BasicService.propertyComparator((String)(StringUtils.isEmpty((CharSequence)sortBy) ? RECOMMENDATIONS_COUNT_LOWER_UNDERSCORE : sortBy), (!reverse ? 1 : 0) != 0);
            filterModels.sort(comparator);
            return filterModels;
        }
        Comparator comparator = BasicService.propertyComparator((String)(StringUtils.isEmpty((CharSequence)sortBy) ? LAST_MODIFY : sortBy), (!reverse ? 1 : 0) != 0);
        filterModels.sort(comparator);
        return filterModels;
    }

    public NDataModelResponse convertToDataModelResponse(NDataModel modelDesc, String projectName, NDataflowManager dfManager, List<String> status, boolean onlyNormalDim) {
        boolean isModelStatusMatch;
        long inconsistentSegmentCount = dfManager.getDataflow(modelDesc.getId()).getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.WARNING}).size();
        ModelStatusToDisplayEnum modelResponseStatus = this.convertModelStatusToDisplay(modelDesc, projectName, inconsistentSegmentCount);
        if (modelDesc.isFusionModel()) {
            modelResponseStatus = this.convertFusionModelStatusToDisplay(modelDesc, modelResponseStatus, projectName, dfManager);
        }
        if (isModelStatusMatch = this.isListContains(status, modelResponseStatus)) {
            boolean isScd2ForbiddenOnline = this.checkSCD2ForbiddenOnline(modelDesc, projectName);
            NDataModelResponse nDataModelResponse = this.enrichModelResponse(modelDesc, projectName);
            nDataModelResponse.computedInfo(inconsistentSegmentCount, modelResponseStatus, isScd2ForbiddenOnline, modelDesc, onlyNormalDim);
            return nDataModelResponse;
        }
        return null;
    }

    private ModelStatusToDisplayEnum convertFusionModelStatusToDisplay(NDataModel modelDesc, ModelStatusToDisplayEnum modelResponseStatus, String projectName, NDataflowManager dfManager) {
        FusionModel fusionModel = FusionModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)projectName).getFusionModel(modelDesc.getFusionId());
        NDataModel batchModel = fusionModel.getBatchModel();
        long inconsistentBatchSegmentCount = dfManager.getDataflow(batchModel.getId()).getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.WARNING}).size();
        ModelStatusToDisplayEnum batchModelResponseStatus = this.convertModelStatusToDisplay(batchModel, projectName, inconsistentBatchSegmentCount);
        if (!batchModel.isBroken() && !modelDesc.isBroken()) {
            switch (modelResponseStatus) {
                case ONLINE: {
                    return batchModelResponseStatus == ModelStatusToDisplayEnum.WARNING ? ModelStatusToDisplayEnum.WARNING : modelResponseStatus;
                }
                case OFFLINE: {
                    return batchModelResponseStatus;
                }
            }
            return modelResponseStatus;
        }
        return modelResponseStatus;
    }

    private List<Pair<NDataflow, NDataModel>> getFirstMatchModels(String modelAlias, String projectName, boolean exactMatch, String owner, String modelAliasOrOwner, Long lastModifyFrom, Long lastModifyTo) {
        return ((NDataflowManager)this.getManager(NDataflowManager.class, projectName)).listAllDataflows(true).stream().map(df -> Pair.newPair((Object)df, (Object)(df.checkBrokenWithRelatedInfo() ? this.modelQuerySupporter.getBrokenModel(projectName, df.getId()) : df.getModel()))).filter(p -> !(Objects.nonNull(lastModifyFrom) && lastModifyFrom > ((NDataModel)p.getValue()).getLastModified() || Objects.nonNull(lastModifyTo) && lastModifyTo <= ((NDataModel)p.getValue()).getLastModified() || !ModelUtils.isArgMatch(modelAliasOrOwner, exactMatch, ((NDataModel)p.getValue()).getAlias()) && !ModelUtils.isArgMatch(modelAliasOrOwner, exactMatch, ((NDataModel)p.getValue()).getOwner()) || !ModelUtils.isArgMatch(modelAlias, exactMatch, ((NDataModel)p.getValue()).getAlias()) || !ModelUtils.isArgMatch(owner, exactMatch, ((NDataModel)p.getValue()).getOwner()) || ((NDataModel)p.getValue()).fusionModelBatchPart())).collect(Collectors.toList());
    }

    public ModelStatusToDisplayEnum convertModelStatusToDisplay(NDataModel modelDesc, String projectName, long inconsistentSegmentCount) {
        RealizationStatusEnum modelStatus = modelDesc.isBroken() ? RealizationStatusEnum.BROKEN : this.getModelStatus(modelDesc.getUuid(), projectName);
        ModelStatusToDisplayEnum modelResponseStatus = ModelStatusToDisplayEnum.convert(modelStatus);
        List segmentHoles = ((NDataflowManager)this.getManager(NDataflowManager.class, projectName)).calculateSegHoles(modelDesc.getUuid());
        if (modelResponseStatus == ModelStatusToDisplayEnum.BROKEN || modelResponseStatus == ModelStatusToDisplayEnum.OFFLINE) {
            return modelResponseStatus;
        }
        if (this.getEmptyIndexesCount(projectName, modelDesc.getId()) > 0L || CollectionUtils.isNotEmpty((Collection)segmentHoles) || inconsistentSegmentCount > 0L) {
            modelResponseStatus = ModelStatusToDisplayEnum.WARNING;
        }
        return modelResponseStatus;
    }

    private long getEmptyIndexesCount(String project, String modelId) {
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(modelId);
        return (long)indexPlan.getAllLayoutsReadOnly().size() - indexPlanManager.getAvailableIndexesCount(project, modelId);
    }

    private List<NDataModelResponse> sortExpansionRate(boolean reverse, List<NDataModelResponse> filterModels) {
        List sorted = !reverse ? filterModels.stream().sorted(Comparator.comparing(a -> new BigDecimal(a.getExpansionrate()))).collect(Collectors.toList()) : filterModels.stream().sorted((a, b) -> new BigDecimal(b.getExpansionrate()).compareTo(new BigDecimal(a.getExpansionrate()))).collect(Collectors.toList());
        List unknowModels = sorted.stream().filter(modle -> "-1".equalsIgnoreCase(modle.getExpansionrate())).collect(Collectors.toList());
        List<NDataModelResponse> nDataModelResponses = sorted.stream().filter(modle -> !"-1".equalsIgnoreCase(modle.getExpansionrate())).collect(Collectors.toList());
        nDataModelResponses.addAll(unknowModels);
        return nDataModelResponses;
    }

    private NDataModelResponse enrichModelResponse(NDataModel modelDesc, String projectName) {
        NDataModelResponse nDataModelResponse;
        NDataModelResponse nDataModelResponse2 = nDataModelResponse = modelDesc.isFusionModel() ? new FusionModelResponse(modelDesc) : new NDataModelResponse(modelDesc);
        if (modelDesc.isBroken()) {
            NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)projectName);
            if (tableManager.getTableDesc(modelDesc.getRootFactTableName()) == null) {
                nDataModelResponse.setRootFactTableName(nDataModelResponse.getRootFactTableName() + " deleted");
                nDataModelResponse.setRootFactTableDeleted(true);
            }
            nDataModelResponse.setBroken(modelDesc.isBroken());
            return nDataModelResponse;
        }
        nDataModelResponse.setAllTableRefs(modelDesc.getAllTables());
        nDataModelResponse.setBroken(modelDesc.isBroken());
        if (ManagementType.MODEL_BASED == modelDesc.getManagementType()) {
            Segments<NDataSegment> segments = this.getSegmentsByRange(modelDesc.getUuid(), projectName, "0", "9223372036854775807");
            if (CollectionUtils.isNotEmpty(segments)) {
                NDataSegment lastSegment = (NDataSegment)segments.get(segments.size() - 1);
                nDataModelResponse.setLastBuildEnd(lastSegment.getSegRange().getEnd().toString());
            } else {
                nDataModelResponse.setLastBuildEnd("");
            }
        }
        return nDataModelResponse;
    }

    private boolean checkSCD2ForbiddenOnline(NDataModel modelDesc, String projectName) {
        boolean isSCD2 = SCD2CondChecker.INSTANCE.isScd2Model(modelDesc);
        return !((NProjectManager)this.getManager(NProjectManager.class)).getProject(projectName).getConfig().isQueryNonEquiJoinModelEnabled() && isSCD2;
    }

    public RealizationStatusEnum getModelStatus(String modelId, String projectName) {
        IndexPlan indexPlan = this.getIndexPlan(modelId, projectName);
        if (indexPlan != null) {
            return ((NDataflowManager)this.getManager(NDataflowManager.class, projectName)).getDataflow(indexPlan.getUuid()).getStatus();
        }
        return null;
    }

    public List<NDataSegmentResponse> getSegmentsResponse(String modelId, String project, String start, String end, String status, String sortBy, boolean reverse) {
        return this.getSegmentsResponse(modelId, project, start, end, status, null, null, false, sortBy, reverse, null);
    }

    public List<NDataSegmentResponse> getSegmentsResponse(String modelId, String project, String start, String end, String status, List<AbstractExecutable> executables, String sortBy, boolean reverse, boolean lite) {
        return this.getSegmentsResponse(modelId, project, start, end, status, null, null, executables, false, sortBy, reverse, lite, null);
    }

    private List<AbstractExecutable> getAllRunningExecutable(String project) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ExecutableManager execManager = ExecutableManager.getInstance((KylinConfig)kylinConfig, (String)project);
        return execManager.getNotFinalExecutablesByType((List)Lists.newArrayList((Object[])new JobTypeEnum[]{JobTypeEnum.INDEX_BUILD, JobTypeEnum.SUB_PARTITION_BUILD}));
    }

    private List<AbstractExecutable> getPartialRunningExecutable(String project, String modelId) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ExecutableManager execManager = ExecutableManager.getInstance((KylinConfig)kylinConfig, (String)project);
        return execManager.listPartialExec(modelId, ExecutableState::isRunning, new JobTypeEnum[]{JobTypeEnum.INDEX_BUILD, JobTypeEnum.SUB_PARTITION_BUILD}).stream().map(arg_0 -> ((ExecutableManager)execManager).fromPO(arg_0)).collect(Collectors.toList());
    }

    public List<NDataSegmentResponse> getSegmentsResponse(String modelId, String project, String start, String end, String status, Collection<Long> withAllIndexes, Collection<Long> withoutAnyIndexes, boolean allToComplement, String sortBy, boolean reverse, List<String> statuses) {
        List<AbstractExecutable> executables = this.getPartialRunningExecutable(project, modelId);
        return this.getSegmentsResponse(modelId, project, start, end, status, withAllIndexes, withoutAnyIndexes, executables, allToComplement, sortBy, reverse, false, statuses);
    }

    public List<NDataSegmentResponse> getSegmentsResponse(String modelId, String project, String start, String end, String status, Collection<Long> withAllIndexes, Collection<Long> withoutAnyIndexes, List<AbstractExecutable> executables, boolean allToComplement, String sortBy, boolean reverse, boolean lite, List<String> statuses) {
        this.aclEvaluate.checkProjectReadPermission(project);
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        NDataflow dataflow = dataflowManager.getDataflow(modelId);
        List<NDataSegmentResponse> segmentResponseList = this.getSegmentsResponseCore(modelId, project, start, end, status, withAllIndexes, withoutAnyIndexes, executables, allToComplement, dataflow);
        segmentResponseList = this.segmentResponseFilter(statuses, segmentResponseList);
        this.segmentsResponseListSort(sortBy, reverse, segmentResponseList);
        return segmentResponseList;
    }

    public List<NDataSegmentResponse> getSegmentsResponseByJob(String modelId, String project, AbstractExecutable job) {
        this.aclEvaluate.checkProjectReadPermission(project);
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        NDataflow dataflow = dataflowManager.getDataflow(modelId);
        List<NDataSegmentResponse> segmentResponseList = this.getSegmentsResponseCoreByJob(job, dataflow);
        return segmentResponseList;
    }

    private List<NDataSegmentResponse> getSegmentsResponseCoreByJob(AbstractExecutable job, NDataflow dataflow) {
        if (CollectionUtils.isEmpty((Collection)job.getSegmentIds())) {
            return Lists.newArrayList();
        }
        HashSet segmentIds = Sets.newHashSet((Iterable)job.getSegmentIds());
        Segments segs = dataflow == null ? Segments.empty() : dataflow.getSegments((Set)segmentIds);
        ArrayList runningJob = job.getStatus() == ExecutableState.RUNNING ? Lists.newArrayList((Object[])new AbstractExecutable[]{job}) : Lists.newArrayList();
        return segs.stream().map(segment -> new NDataSegmentResponse(dataflow, (Segments<NDataSegment>)segs, (NDataSegment)segment, runningJob)).collect(Collectors.toList());
    }

    public void segmentsResponseListSort(String sortBy, boolean reverse, List<NDataSegmentResponse> segmentResponseList) {
        Comparator comparator = BasicService.propertyComparator((String)(StringUtils.isEmpty((CharSequence)sortBy) ? "create_time_utc" : sortBy), (boolean)reverse);
        segmentResponseList.sort(comparator);
    }

    public List<NDataSegmentResponse> getSegmentsResponseCore(String modelId, String project, String start, String end, String status, Collection<Long> withAllIndexes, Collection<Long> withoutAnyIndexes, List<AbstractExecutable> executables, boolean allToComplement, NDataflow dataflow) {
        Segments<NDataSegment> segs = this.getSegmentsByRange(modelId, project, start, end);
        IndexPlan indexPlan = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getIndexPlan(modelId);
        Set allIndexes = indexPlan.getAllLayoutIds(true);
        if (CollectionUtils.isNotEmpty(withAllIndexes)) {
            for (Long idx : withAllIndexes) {
                if (allIndexes.contains(idx)) continue;
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_SEGMENT_PARAMETER, "Invalid index id " + idx);
            }
        }
        if (CollectionUtils.isNotEmpty(withoutAnyIndexes)) {
            for (Long idx : withoutAnyIndexes) {
                if (allIndexes.contains(idx)) continue;
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_SEGMENT_PARAMETER, "Invalid index id " + idx);
            }
        }
        List<NDataSegmentResponse> segmentResponseList = segs.stream().filter(segment -> this.filterSeg(withAllIndexes, withoutAnyIndexes, allToComplement, indexPlan.getAllLayoutIds(false), (NDataSegment)segment)).filter(segment -> !StringUtils.isNotEmpty((CharSequence)status) || status.equalsIgnoreCase(SegmentUtil.getSegmentStatusToDisplay((Segments)segs, (ISegment)segment, (List)executables, null).toString())).map(segment -> new NDataSegmentResponse(dataflow, segs, (NDataSegment)segment, executables)).collect(Collectors.toList());
        return segmentResponseList;
    }

    public List<NDataSegmentResponse> segmentResponseFilter(List<String> statuses, List<NDataSegmentResponse> segmentResponseList) {
        if (CollectionUtils.isEmpty(statuses)) {
            return segmentResponseList;
        }
        Set statusEnumSet = statuses.stream().map(SegmentStatusEnumToDisplay::getByName).filter(Objects::nonNull).collect(Collectors.toSet());
        return segmentResponseList.stream().filter(segmentResponse -> CollectionUtils.isEmpty((Collection)statusEnumSet) || statusEnumSet.contains(segmentResponse.getStatusToDisplay())).collect(Collectors.toList());
    }

    private boolean filterSeg(Collection<Long> withAllIndexes, Collection<Long> withoutAnyIndexes, boolean allToComplement, Set<Long> allIndexWithoutTobeDel, NDataSegment segment) {
        if (allToComplement) {
            Set segLayoutIds = segment.getSegDetails().getEffectiveLayouts().stream().map(NDataLayout::getLayoutId).collect(Collectors.toSet());
            return !Sets.difference(allIndexWithoutTobeDel, segLayoutIds).isEmpty();
        }
        if (CollectionUtils.isNotEmpty(withAllIndexes)) {
            return segment.getLayoutIds().containsAll(withAllIndexes);
        }
        if (CollectionUtils.isNotEmpty(withoutAnyIndexes)) {
            return !segment.getLayoutIds().containsAll(withoutAnyIndexes);
        }
        return true;
    }

    public Segments<NDataSegment> getSegmentsByRange(String modelId, String project, String start, String end) {
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        NDataflow df = dataflowManager.getDataflow(modelId);
        if (df == null) {
            return Segments.empty();
        }
        NDataModel model = df.getModel();
        if (model == null || model.isBroken()) {
            return Segments.empty();
        }
        SegmentRange filterRange = this.getSegmentRangeByModel(project, modelId, start, end);
        return df.getSegmentsByRange(filterRange);
    }

    public IndicesResponse getAggIndices(String project, String modelId, Long indexId, String contentSeg, boolean isCaseSensitive, Integer pageOffset, Integer pageSize, String sortBy, Boolean reverse) {
        IndicesResponse result;
        this.aclEvaluate.checkProjectReadPermission(project);
        logger.debug("find project={}, model={}, index={}, content={}, isCaseSensitive={}, sortBy={}, reverse={}", new Object[]{project, modelId, indexId, contentSeg, isCaseSensitive, sortBy, reverse});
        if (Objects.nonNull(indexId)) {
            result = this.getIndicesById(project, modelId, indexId);
        } else {
            IndexPlan indexPlan = this.getIndexPlan(modelId, project);
            result = new IndicesResponse(indexPlan);
            indexPlan.getAllIndexes().stream().filter(e -> e.getId() < 20000000000L).forEach(result::addIndexEntity);
        }
        List<IndicesResponse.Index> indices = result.getIndices();
        if (Objects.nonNull(contentSeg)) {
            indices = this.filterFuzzyMatchedIndices(indices, contentSeg, isCaseSensitive);
        }
        result.setSize(indices.size());
        result.setIndices(this.sortIndicesThenCutPage(indices, sortBy, reverse, pageOffset, pageSize));
        return result;
    }

    private List<IndicesResponse.Index> filterFuzzyMatchedIndices(List<IndicesResponse.Index> indices, String contentSeg, boolean isCaseSensitive) {
        if (StringUtils.isBlank((CharSequence)contentSeg)) {
            return indices;
        }
        return indices.stream().filter(index -> this.fuzzyMatched(contentSeg, isCaseSensitive, String.valueOf(index.getId())) || index.getDimensions().stream().anyMatch(d -> this.fuzzyMatched(contentSeg, isCaseSensitive, (String)d)) || index.getMeasures().stream().anyMatch(m -> this.fuzzyMatched(contentSeg, isCaseSensitive, (String)m))).collect(Collectors.toList());
    }

    private List<IndicesResponse.Index> sortIndicesThenCutPage(List<IndicesResponse.Index> indices, String sortBy, boolean reverse, int pageOffset, int pageSize) {
        Comparator comparator = BasicService.propertyComparator((String)(StringUtils.isEmpty((CharSequence)sortBy) ? "last_modify_time" : sortBy), (!reverse ? 1 : 0) != 0);
        indices.sort(comparator);
        return PagingUtil.cutPage(indices, (int)pageOffset, (int)pageSize);
    }

    private boolean fuzzyMatched(String contentSeg, boolean isCaseSensitive, String content) {
        if (isCaseSensitive) {
            return StringUtils.contains((CharSequence)content, (CharSequence)contentSeg);
        }
        return StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)contentSeg);
    }

    @VisibleForTesting
    public IndicesResponse getIndicesById(String project, String modelId, Long indexId) {
        this.aclEvaluate.checkProjectReadPermission(project);
        IndexPlan indexPlan = this.getIndexPlan(modelId, project);
        IndicesResponse result = new IndicesResponse(indexPlan);
        result.addIndexEntity(indexPlan.getIndexEntity(indexId.longValue()));
        return result;
    }

    public IndicesResponse getTableIndices(String modelId, String project) {
        this.aclEvaluate.checkProjectReadPermission(project);
        IndexPlan indexPlan = this.getIndexPlan(modelId, project);
        IndicesResponse result = new IndicesResponse(indexPlan);
        indexPlan.getAllIndexes().stream().filter(e -> IndexEntity.isTableIndex((long)e.getId())).forEach(result::addIndexEntity);
        return result;
    }

    @VisibleForTesting
    IndicesResponse getIndices(String modelId, String project) {
        IndexPlan indexPlan = this.getIndexPlan(modelId, project);
        IndicesResponse result = new IndicesResponse(indexPlan);
        indexPlan.getAllIndexes().forEach(result::addIndexEntity);
        return result;
    }

    public String getModelJson(String modelId, String project) throws JsonProcessingException {
        this.aclEvaluate.checkProjectReadPermission(project);
        NDataModel modelDesc = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        return JsonUtil.writeValueAsIndentString((Object)modelDesc);
    }

    public String getModelSql(String modelId, String project) {
        this.aclEvaluate.checkProjectReadPermission(project);
        try (QueryContext queryContext = QueryContext.current();){
            queryContext.setAclInfo(AclPermissionUtil.createAclInfo((String)project, (Set)this.getCurrentUserGroups()));
            NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
            String string = PushDownUtil.generateFlatTableSql((NDataModel)model, (boolean)false);
            return string;
        }
    }

    private void checkAliasIsExceededLimit(String newAlias) {
        if (newAlias.length() > 127) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_TOO_LONG, new Object[0]);
        }
    }

    private void checkAliasExist(String modelId, String newAlias, String project) {
        if (!this.checkModelAliasUniqueness(modelId, newAlias, project)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_DUPLICATE, new Object[]{newAlias});
        }
    }

    public boolean checkModelAliasUniqueness(String modelId, String newAlias, String project) {
        this.aclEvaluate.checkProjectWritePermission(project);
        List models = ((NDataflowManager)this.getManager(NDataflowManager.class, project)).listUnderliningDataModels();
        for (NDataModel model : models) {
            if (!StringUtils.isNotEmpty((CharSequence)modelId) && model.getUuid().equals(modelId) || !model.getAlias().equalsIgnoreCase(newAlias)) continue;
            return false;
        }
        return true;
    }

    @Transaction(project=1)
    public void dropModel(String modelId, String project) {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.checkModelPermission(project, modelId);
        NDataModel model = this.getModelById(modelId, project);
        String modelName = model.getAlias();
        this.innerDropModel(modelId, project);
        EventBusFactory.getInstance().postSync((Object)new ModelDropEvent(project, modelId, modelName));
    }

    void innerDropModel(String modelId, String project) {
        NDataModel dataModelDesc = this.getModelById(modelId, project);
        boolean isStreamingModel = false;
        if (dataModelDesc.isStreaming()) {
            isStreamingModel = true;
        } else if (dataModelDesc.getModelType() == NDataModel.ModelType.UNKNOWN) {
            StreamingJobManager streamingJobMgr = StreamingJobManager.getInstance((KylinConfig)this.getConfig(), (String)project);
            boolean bl = isStreamingModel = streamingJobMgr.getStreamingJobByUuid(modelId + "_build") != null || streamingJobMgr.getStreamingJobByUuid(modelId + "_merge") != null;
        }
        if (isStreamingModel) {
            EventBusFactory.getInstance().postSync((Object)new StreamingJobKillEvent(project, modelId));
            EventBusFactory.getInstance().postSync((Object)new StreamingJobDropEvent(project, modelId));
        }
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        NDataModelManager dataModelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        dataflowManager.dropDataflow(modelId);
        indexPlanManager.dropIndexPlan(modelId);
        dataModelManager.dropModel(dataModelDesc);
    }

    @Transaction(project=1)
    public void purgeModel(String modelId, String project) {
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        IndexPlan indexPlan = this.getIndexPlan(modelId, project);
        ArrayList segments = new ArrayList();
        if (indexPlan != null) {
            NDataflow dataflow = dataflowManager.getDataflow(indexPlan.getUuid());
            NDataflowUpdate nDataflowUpdate = new NDataflowUpdate(dataflow.getUuid());
            segments.addAll(dataflow.getSegments());
            NDataSegment[] segmentsArray = new NDataSegment[segments.size()];
            NDataSegment[] nDataSegments = segments.toArray(segmentsArray);
            nDataflowUpdate.setToRemoveSegs(nDataSegments);
            dataflowManager.updateDataflow(nDataflowUpdate);
        }
        this.offlineModelIfNecessary(dataflowManager, modelId);
    }

    @Transaction(project=1)
    public void purgeModelManually(String modelId, String project) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        NDataModel dataModelDesc = this.getModelById(modelId, project);
        if (ManagementType.TABLE_ORIENTED == dataModelDesc.getManagementType()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, String.format(Locale.ROOT, MsgPicker.getMsg().getModelCanNotPurge(), dataModelDesc.getAlias()));
        }
        this.purgeModel(modelId, project);
    }

    public void cloneModel(String modelId, String newModelName, String project) {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.checkAliasExist("", newModelName, project);
        this.checkAliasIsExceededLimit(newModelName);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NDataModelManager dataModelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
            NDataModel dataModelDesc = this.getModelById(modelId, project);
            NDataModel nDataModel = this.semanticUpdater.deepCopyModel(dataModelDesc);
            nDataModel.setUuid(RandomUtil.randomUUIDStr());
            nDataModel.setAlias(newModelName);
            nDataModel.setLastModified(System.currentTimeMillis());
            nDataModel.setRecommendationsCount(0);
            nDataModel.setMvcc(-1L);
            nDataModel.setProject(project);
            nDataModel.setComputedColumnDescs(dataModelDesc.getComputedColumnDescs());
            this.changeModelOwner(nDataModel);
            NDataModel newModel = dataModelManager.createDataModelDesc(nDataModel, nDataModel.getOwner());
            this.cloneIndexPlan(modelId, project, nDataModel.getOwner(), newModel.getUuid(), RealizationStatusEnum.OFFLINE);
            return null;
        }, (String)project);
    }

    private void cloneIndexPlan(String modelId, String project, String owner, String newModelId, RealizationStatusEnum realizationStatusEnum) {
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(modelId);
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        IndexPlan copy = indexPlanManager.copy(indexPlan);
        copy.setUuid(newModelId);
        copy.setLastModified(System.currentTimeMillis());
        copy.setMvcc(-1L);
        Set toBeDeletedLayouts = copy.getToBeDeletedIndexes().stream().flatMap(indexEntity -> indexEntity.getLayouts().stream()).map(LayoutEntity::getId).collect(Collectors.toSet());
        copy.removeLayouts(toBeDeletedLayouts, true, true);
        indexPlanManager.createIndexPlan(copy);
        dataflowManager.createDataflow(copy, owner, realizationStatusEnum);
    }

    @Transaction(project=0)
    public void renameDataModel(String project, String modelId, String newAlias, String description) {
        this.aclEvaluate.checkProjectWritePermission(project);
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        modelManager.updateDataModel(modelId, nDataModel -> {
            if (description != null && nDataModel.getAlias().equalsIgnoreCase(newAlias)) {
                nDataModel.setDescription(description);
            } else {
                this.checkAliasExist(modelId, newAlias, project);
                this.checkAliasIsExceededLimit(newAlias);
                nDataModel.setAlias(newAlias);
                if (description != null) {
                    nDataModel.setDescription(description);
                }
            }
        });
    }

    @Transaction(project=0)
    public void offlineAllModelsInProject(String project) {
        this.aclEvaluate.checkProjectWritePermission(project);
        Set<String> ids = this.listAllModelIdsInProject(project);
        for (String id : ids) {
            this.updateDataModelStatus(id, project, "OFFLINE");
        }
    }

    @Transaction(project=0)
    public void offlineMultiPartitionModelsInProject(String project) {
        this.aclEvaluate.checkProjectWritePermission(project);
        List multiPartitionModels = this.getMultiPartitionModelsByStatus(project, this.getModelNonOffOnlineStatus()).stream().map(RootPersistentEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(multiPartitionModels)) {
            return;
        }
        this.offlineModelsInProjectById(project, new HashSet<String>(multiPartitionModels));
    }

    @Transaction(project=0)
    public void offlineModelsInProjectById(String project, Set<String> modelIds) {
        this.aclEvaluate.checkProjectWritePermission(project);
        for (String id : modelIds) {
            if (!modelIds.contains(id)) continue;
            this.updateDataModelStatus(id, project, ModelStatusToDisplayEnum.OFFLINE.name());
        }
    }

    @Transaction(project=0)
    public void updateSCD2ModelStatusInProjectById(String project, ModelStatusToDisplayEnum status) {
        this.aclEvaluate.checkProjectWritePermission(project);
        List<String> scd2Models = this.getSCD2Models(project);
        if (CollectionUtils.isEmpty(scd2Models)) {
            return;
        }
        this.updateModelStatusInProjectById(project, new HashSet<String>(scd2Models), status);
    }

    @Transaction(project=0)
    public void updateModelStatusInProjectById(String project, Set<String> modelIds, ModelStatusToDisplayEnum status) {
        this.aclEvaluate.checkProjectWritePermission(project);
        for (String id : modelIds) {
            try {
                this.updateDataModelStatus(id, project, status.name());
            }
            catch (Exception e) {
                logger.warn("Failed update model {} status to {}, {}", new Object[]{id, status.name(), e.getMessage()});
            }
        }
    }

    @Transaction(project=0)
    public void onlineAllModelsInProject(String project) {
        this.aclEvaluate.checkProjectWritePermission(project);
        Set<String> ids = this.listAllModelIdsInProject(project);
        for (String id : ids) {
            this.updateDataModelStatus(id, project, "ONLINE");
        }
    }

    @Transaction(project=1)
    public void updateDataModelStatus(String modelId, String project, String status) {
        NDataModel nDataModel = this.getModelById(modelId, project);
        if (nDataModel.isFusionModel()) {
            NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
            NDataflow dataflow = dataflowManager.getDataflow(nDataModel.getUuid());
            if (CollectionUtils.isNotEmpty((Collection)dataflow.getSegments())) {
                this.doUpdateDataModelStatus(nDataModel, project, status);
            }
            String fusionId = nDataModel.getFusionId();
            FusionModelManager fusionModelMgr = FusionModelManager.getInstance((KylinConfig)this.getConfig(), (String)project);
            NDataModel batchModel = fusionModelMgr.getFusionModel(fusionId).getBatchModel();
            if (batchModel != null && CollectionUtils.isNotEmpty((Collection)(dataflow = dataflowManager.getDataflow(batchModel.getUuid())).getSegments())) {
                this.doUpdateDataModelStatus(batchModel, project, status);
            }
        } else {
            this.doUpdateDataModelStatus(nDataModel, project, status);
        }
    }

    private void doUpdateDataModelStatus(NDataModel nDataModel, String project, String status) {
        boolean needChangeStatus;
        String modelId = nDataModel.getUuid();
        this.aclEvaluate.checkProjectWritePermission(project);
        IndexPlan indexPlan = this.getIndexPlan(nDataModel.getUuid(), project);
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        NDataflow dataflow = dataflowManager.getDataflow(indexPlan.getUuid());
        this.checkDataflowStatus(dataflow, modelId);
        boolean bl = needChangeStatus = status.equals(RealizationStatusEnum.OFFLINE.name()) && RealizationStatusEnum.ONLINE == dataflow.getStatus() || status.equals(RealizationStatusEnum.ONLINE.name()) && RealizationStatusEnum.OFFLINE == dataflow.getStatus();
        if (needChangeStatus) {
            NDataflowUpdate nDataflowUpdate = new NDataflowUpdate(dataflow.getUuid());
            if (status.equals(RealizationStatusEnum.OFFLINE.name())) {
                nDataflowUpdate.setStatus(RealizationStatusEnum.OFFLINE);
            } else if (status.equals(RealizationStatusEnum.ONLINE.name())) {
                if (SCD2CondChecker.INSTANCE.isScd2Model(dataflow.getModel()) && !this.projectService.getProjectConfig(project).isScd2Enabled()) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_ONLINE_ABANDON, MsgPicker.getMsg().getScd2ModelOnlineWithScd2ConfigOff());
                }
                if (dataflow.getSegments().isEmpty() && !KylinConfig.getInstanceFromEnv().isUTEnv()) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_ONLINE_ABANDON, MsgPicker.getMsg().getModelOnlineWithEmptySeg());
                }
                if (dataflowManager.isOfflineModel(dataflow)) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_ONLINE_ABANDON, MsgPicker.getMsg().getModelOnlineForbidden());
                }
                nDataflowUpdate.setStatus(RealizationStatusEnum.ONLINE);
            }
            dataflowManager.updateDataflow(nDataflowUpdate);
        }
    }

    private void checkDataflowStatus(NDataflow dataflow, String modelId) {
        if (RealizationStatusEnum.BROKEN == dataflow.getStatus()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_JOIN_CONDITION, String.format(Locale.ROOT, MsgPicker.getMsg().getBrokenModelCannotOnoffline(), modelId));
        }
    }

    public SegmentRange getSegmentRangeByModel(String project, String modelId, String start, String end) {
        TableRef tableRef = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId).getRootFactTable();
        TableDesc tableDesc = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getTableDesc(tableRef.getTableIdentity());
        return SourceFactory.getSource((ISourceAware)tableDesc).getSegmentRange(start, end);
    }

    public boolean isModelsUsingTable(String table, String project) {
        TableDesc tableDesc = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getTableDesc(table);
        return CollectionUtils.isNotEmpty((Collection)((NDataflowManager)this.getManager(NDataflowManager.class, project)).getModelsUsingTable(tableDesc));
    }

    public List<NDataModel> getModelsUsingTable(String table, String project) {
        return ((NDataflowManager)this.getManager(NDataflowManager.class, project)).getModelsUsingTable(((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getTableDesc(table));
    }

    @VisibleForTesting
    public void checkFlatTableSql(NDataModel model) {
        if (this.skipCheckFlatTable(model)) {
            return;
        }
        long rangePartitionTableCount = model.getAllTableRefs().stream().filter(p -> p.getTableDesc().isRangePartition()).count();
        if (rangePartitionTableCount > 0L) {
            logger.info("Range partitioned tables do not support pushdown, so do not need to perform subsequent logic");
            return;
        }
        try (QueryContext queryContext = QueryContext.current();){
            String project = model.getProject();
            ProjectInstance prjInstance = ((NProjectManager)this.getManager(NProjectManager.class)).getProject(project);
            queryContext.setAclInfo(AclPermissionUtil.createAclInfo((String)project, (Set)this.getCurrentUserGroups()));
            if (prjInstance.getSourceType() == 9 && model.getModelType() == NDataModel.ModelType.BATCH) {
                SparkSession ss = SparderEnv.getSparkSession();
                String flatTableSql = PushDownUtil.generateFlatTableSql((NDataModel)model, (boolean)false);
                QueryParams queryParams = new QueryParams(project, flatTableSql, "default", false);
                queryParams.setKylinConfig((KylinConfig)prjInstance.getConfig());
                queryParams.setAclInfo(AclPermissionUtil.createAclInfo((String)project, (Set)this.getCurrentUserGroups()));
                ss.sql(PushDownUtil.massagePushDownSql((QueryParams)queryParams));
            }
        }
        catch (Exception e) {
            this.buildExceptionMessage(model, e);
        }
    }

    private boolean skipCheckFlatTable(NDataModel model) {
        if (KylinConfig.getInstanceFromEnv().isUTEnv()) {
            return true;
        }
        IndexPlan indexPlan = this.getIndexPlan(model.getId(), model.getProject());
        KylinConfig config = indexPlan == null || indexPlan.getConfig() == null ? NProjectManager.getProjectConfig((String)model.getProject()) : indexPlan.getConfig();
        return config.skipCheckFlatTable();
    }

    private void buildExceptionMessage(NDataModel dataModel, Exception e) {
        Pattern pattern = Pattern.compile("cannot resolve '(.*?)' given input columns");
        Matcher matcher = pattern.matcher(e.getMessage().replace("`", ""));
        if (matcher.find()) {
            String column = matcher.group(1);
            String table = column.contains(".") ? column.split("\\.")[0] : dataModel.getRootFactTableName();
            String error = String.format(Locale.ROOT, MsgPicker.getMsg().saveModelFail(), dataModel.getAlias(), column, table);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.TABLE_NOT_EXIST, error);
        }
        String errorMsg = String.format(Locale.ROOT, "model [%s], %s", dataModel.getAlias(), String.format(Locale.ROOT, MsgPicker.getMsg().getDefaultReason(), null != e.getMessage() ? e.getMessage() : "null"));
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_EXECUTE_MODEL_SQL, errorMsg);
    }

    private void validatePartitionDateColumn(ModelRequest modelRequest) {
        if (Objects.nonNull(modelRequest.getPartitionDesc())) {
            if (StringUtils.isNotEmpty((CharSequence)modelRequest.getPartitionDesc().getPartitionDateColumn())) {
                Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)modelRequest.getPartitionDesc().getPartitionDateFormat()), (Object)"Partition column format can not be empty!");
            } else {
                modelRequest.getPartitionDesc().setPartitionDateFormat("");
            }
            this.validateFusionModelDimension(modelRequest);
        }
    }

    public void validateFusionModelDimension(ModelRequest modelRequest) {
        NTableMetadataManager mgr;
        TableDesc tableDesc;
        String rootFactTableName = modelRequest.getRootFactTableName();
        NDataModel.ModelType modelType = modelRequest.getModelType();
        if (!StringUtils.isEmpty((CharSequence)rootFactTableName) && modelType != NDataModel.ModelType.BATCH && modelType != NDataModel.ModelType.STREAMING && (tableDesc = (mgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)modelRequest.getProject())).getTableDesc(rootFactTableName)) != null && tableDesc.isKafkaTable() && tableDesc.getKafkaConfig().hasBatchTable()) {
            String fullColumnName = modelRequest.getPartitionDesc().getPartitionDateColumn();
            String columnName = fullColumnName.substring(fullColumnName.indexOf(".") + 1);
            boolean hasPartitionColumn = modelRequest.getSimplifiedDimensions().stream().anyMatch(column -> column.getName().equalsIgnoreCase(columnName));
            if (!hasPartitionColumn && !modelRequest.getDimensionNameIdMap().containsKey(fullColumnName)) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.TIMESTAMP_COLUMN_NOT_EXIST, MsgPicker.getMsg().getTimestampPartitionColumnNotExist());
            }
        }
    }

    public void batchCreateModel(String project, List<ModelRequest> newModels, List<ModelRequest> reusedModels) {
        this.checkNewModels(project, newModels);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            this.saveNewModelsAndIndexes(project, newModels);
            this.updateReusedModelsAndIndexPlans(project, reusedModels);
            return null;
        }, (String)project);
    }

    public void updateRecommendationsCount(String project, String modelId, int size) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NDataModelManager mgr = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            NDataModel dataModel = mgr.getDataModelDesc(modelId);
            if (dataModel != null && !dataModel.isBroken() && dataModel.getRecommendationsCount() != size) {
                mgr.updateDataModel(modelId, copyForWrite -> copyForWrite.setRecommendationsCount(size));
            }
            return null;
        }, (String)project);
    }

    public void checkNewModels(String project, List<ModelRequest> newModels) {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.checkDuplicateAliasInModelRequests(newModels);
        for (ModelRequest modelRequest : newModels) {
            this.validatePartitionDateColumn(modelRequest);
            modelRequest.setProject(project);
            this.doCheckBeforeModelSave(project, modelRequest);
        }
    }

    public void saveNewModelsAndIndexes(String project, List<ModelRequest> newModels) {
        this.saveNewModelsAndIndexes(project, null, newModels);
    }

    public void saveNewModelsAndIndexes(String project, String saveIndexesStrategy, List<ModelRequest> newModels) {
        if (CollectionUtils.isEmpty(newModels)) {
            return;
        }
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NDataModelManager dataModelManager = NDataModelManager.getInstance((KylinConfig)kylinConfig, (String)project);
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)kylinConfig, (String)project);
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project);
        for (ModelRequest modelRequest : newModels) {
            if (modelRequest.getIndexPlan() == null) continue;
            NDataModel model = (NDataModel)JsonUtil.deepCopyQuietly((Object)((Object)modelRequest), NDataModel.class);
            model.setProject(project);
            model.setComputedColumnDescs(modelRequest.getComputedColumnDescs());
            IndexPlan indexPlan = modelRequest.getIndexPlan();
            indexPlan.setProject(project);
            NDataModel saved = dataModelManager.getDataModelDesc(model.getUuid()) != null ? dataModelManager.updateDataModelDesc(model) : dataModelManager.createDataModelDesc(model, model.getOwner());
            this.semanticUpdater.deleteExpandableMeasureInternalMeasures(saved);
            this.semanticUpdater.expandExpandableMeasure(saved);
            this.preProcessBeforeModelSave(saved, project);
            NDataModel expanded = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).updateDataModelDesc(saved);
            IndexPlan emptyIndex = new IndexPlan();
            emptyIndex.setUuid(expanded.getUuid());
            indexPlanManager.createIndexPlan(emptyIndex);
            this.indexPlanService.expandIndexPlanRequest(indexPlan, expanded);
            if ("single_dim_and_reduce_hc".equalsIgnoreCase(saveIndexesStrategy)) {
                indexPlan.setBaseAggIndexReduceHighCardinalityDim(true);
            }
            this.addBaseIndex(modelRequest, expanded, indexPlan);
            NDataflow df = dataflowManager.createDataflow(emptyIndex, expanded.getOwner());
            if (modelRequest.isWithEmptySegment() && !modelRequest.isStreaming()) {
                dataflowManager.appendSegment(df, (SegmentRange)SegmentRange.TimePartitionedSegmentRange.createInfinite(), SegmentStatusEnum.READY);
            }
            if (modelRequest.isWithModelOnline()) {
                dataflowManager.updateDataflowStatus(df.getId(), RealizationStatusEnum.ONLINE);
            }
            this.createStreamingJob(project, expanded, modelRequest);
            this.updateIndexPlan(project, indexPlan, expanded, saveIndexesStrategy);
            UnitOfWorkContext context = UnitOfWork.get();
            context.doAfterUnit(() -> EventBusFactory.getInstance().postSync((Object)new ModelAddEvent(project, expanded.getId(), expanded.getAlias())));
        }
    }

    private void updateReusedModelsAndIndexPlans(String project, List<ModelRequest> modelRequestList) {
        if (CollectionUtils.isEmpty(modelRequestList)) {
            return;
        }
        if (modelRequestList.stream().anyMatch(modelRequest -> !FusionIndexService.checkUpdateIndexEnabled(project, modelRequest.getId()))) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.STREAMING_INDEX_UPDATE_DISABLE, MsgPicker.getMsg().getStreamingIndexesConvert());
        }
        for (ModelRequest modelRequest2 : modelRequestList) {
            modelRequest2.setProject(project);
            this.semanticUpdater.expandModelRequest(modelRequest2);
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)kylinConfig, (String)project);
            NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)kylinConfig, (String)project);
            HashMap columnMap = Maps.newHashMap();
            modelRequest2.getAllNamedColumns().forEach(column -> {
                Preconditions.checkArgument((!columnMap.containsKey(column.getAliasDotColumn()) ? 1 : 0) != 0);
                columnMap.put(column.getAliasDotColumn(), column);
            });
            BaseIndexUpdateHelper baseIndexUpdater = new BaseIndexUpdateHelper(modelManager.getDataModelDesc(modelRequest2.getId()), false);
            List<LayoutRecDetailResponse> recItems = modelRequest2.getRecItems();
            NDataModel updated = modelManager.updateDataModel(modelRequest2.getId(), copyForWrite -> {
                copyForWrite.setJoinTables(modelRequest2.getJoinTables());
                List allNamedColumns = copyForWrite.getAllNamedColumns();
                HashMap namedColumnMap = Maps.newHashMap();
                allNamedColumns.forEach(col -> namedColumnMap.put(col.getId(), col));
                LinkedHashMap newCCMap = Maps.newLinkedHashMap();
                LinkedHashMap newDimMap = Maps.newLinkedHashMap();
                LinkedHashMap newMeasureMap = Maps.newLinkedHashMap();
                recItems.forEach(recItem -> {
                    recItem.getComputedColumns().stream().filter(LayoutRecDetailResponse.RecComputedColumn::isNew).forEach(recCC -> {
                        ComputedColumnDesc cc = recCC.getCc();
                        newCCMap.putIfAbsent(cc.getFullName(), cc);
                    });
                    recItem.getDimensions().stream().filter(LayoutRecDetailResponse.RecDimension::isNew).forEach(recDim -> {
                        NDataModel.NamedColumn dim = recDim.getDimension();
                        newDimMap.putIfAbsent(dim.getAliasDotColumn(), dim);
                    });
                    recItem.getMeasures().stream().filter(LayoutRecDetailResponse.RecMeasure::isNew).forEach(recMeasure -> {
                        NDataModel.Measure measure = recMeasure.getMeasure();
                        newMeasureMap.putIfAbsent(measure.getName(), measure);
                    });
                });
                newCCMap.forEach((ccName, cc) -> {
                    copyForWrite.getComputedColumnDescs().add(cc);
                    NDataModel.NamedColumn column = (NDataModel.NamedColumn)columnMap.get(cc.getFullName());
                    allNamedColumns.add(column);
                    namedColumnMap.putIfAbsent(column.getId(), column);
                });
                newDimMap.forEach((colName, dim) -> {
                    if (namedColumnMap.containsKey(dim.getId())) {
                        ((NDataModel.NamedColumn)namedColumnMap.get(dim.getId())).setStatus(NDataModel.ColumnStatus.DIMENSION);
                    } else {
                        allNamedColumns.add(dim);
                    }
                });
                Set namedColumnIds = allNamedColumns.stream().map(NDataModel.NamedColumn::getId).collect(Collectors.toSet());
                modelRequest2.getAllNamedColumns().forEach(col -> {
                    if (!namedColumnIds.contains(col.getId())) {
                        allNamedColumns.add(col);
                        namedColumnIds.add(col.getId());
                    }
                });
                newMeasureMap.forEach((measureName, measure) -> copyForWrite.getAllMeasures().add(measure));
                copyForWrite.keepColumnOrder();
                copyForWrite.keepMeasureOrder();
            });
            this.semanticUpdater.deleteExpandableMeasureInternalMeasures(updated);
            this.semanticUpdater.expandExpandableMeasure(updated);
            this.preProcessBeforeModelSave(updated, project);
            NDataModel expanded = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).updateDataModelDesc(updated);
            IndexPlan indexPlan = modelRequest2.getIndexPlan();
            this.indexPlanService.expandIndexPlanRequest(indexPlan, expanded);
            HashMap layoutMap = Maps.newHashMap();
            indexPlan.getAllLayouts().forEach(layout -> layoutMap.putIfAbsent(layout.getId(), layout));
            indexPlanManager.updateIndexPlan(modelRequest2.getId(), copyForWrite -> {
                IndexPlan.IndexPlanUpdateHandler updateHandler = copyForWrite.createUpdateHandler();
                for (LayoutRecDetailResponse recItem : recItems) {
                    long layoutId = recItem.getIndexId();
                    LayoutEntity layout = (LayoutEntity)layoutMap.get(layoutId);
                    updateHandler.add(layout, IndexEntity.isAggIndex((long)recItem.getIndexId()));
                }
                updateHandler.complete();
            });
            this.modelChangeSupporters.forEach(listener -> listener.onUpdateSingle(project, modelRequest2.getUuid()));
            baseIndexUpdater.update(this.indexPlanService);
        }
    }

    public NDataModel createModel(String project, ModelRequest modelRequest) {
        this.checkNewModels(project, Lists.newArrayList((Object[])new ModelRequest[]{modelRequest}));
        UnitOfWorkParams params = UnitOfWorkParams.builder().unitName(project).processor(() -> {
            NDataModel model = this.saveModel(project, modelRequest);
            modelRequest.setUuid(model.getUuid());
            this.updateExcludedCheckerResult(project, modelRequest);
            return ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(model.getUuid());
        }).build();
        return (NDataModel)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry((UnitOfWorkParams)params);
    }

    private NDataModel doCheckBeforeModelSave(String project, ModelRequest modelRequest) {
        this.checkAliasExist(modelRequest.getUuid(), modelRequest.getAlias(), project);
        this.checkAliasIsExceededLimit(modelRequest.getAlias());
        modelRequest.setOwner(AclPermissionUtil.getCurrentUsername());
        modelRequest.setLastModified(modelRequest.getCreateTime());
        this.checkModelRequest(modelRequest);
        NDataModel dataModel = this.semanticUpdater.convertToDataModel(modelRequest);
        if (ManagementType.TABLE_ORIENTED == dataModel.getManagementType()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_CREATE_MODEL, MsgPicker.getMsg().getInvalidCreateModel());
        }
        this.preProcessBeforeModelSave(dataModel, project);
        this.checkFlatTableSql(dataModel);
        return dataModel;
    }

    private NDataModel saveModel(String project, ModelRequest modelRequest) {
        this.validatePartitionDateColumn(modelRequest);
        NDataModel dataModel = this.semanticUpdater.convertToDataModel(modelRequest);
        this.preProcessBeforeModelSave(dataModel, project);
        this.createStreamingJob(project, dataModel, modelRequest);
        NDataModel created = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).createDataModelDesc(dataModel, dataModel.getOwner());
        this.semanticUpdater.expandExpandableMeasure(created);
        this.preProcessBeforeModelSave(created, project);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).updateDataModelDesc(created);
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)config, (String)model.getProject());
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)config, (String)model.getProject());
        IndexPlan indexPlan = new IndexPlan();
        indexPlan.setUuid(model.getUuid());
        indexPlan.setLastModified(System.currentTimeMillis());
        this.addBaseIndex(modelRequest, model, indexPlan);
        indexPlanManager.createIndexPlan(indexPlan);
        NDataflow df = dataflowManager.createDataflow(indexPlan, model.getOwner(), RealizationStatusEnum.OFFLINE);
        SegmentRange.TimePartitionedSegmentRange range = null;
        if (PartitionDesc.isEmptyPartitionDesc((PartitionDesc)model.getPartitionDesc())) {
            range = SegmentRange.TimePartitionedSegmentRange.createInfinite();
        } else if (StringUtils.isNotEmpty((CharSequence)modelRequest.getStart()) && StringUtils.isNotEmpty((CharSequence)modelRequest.getEnd())) {
            range = this.getSegmentRangeByModel(project, model.getUuid(), modelRequest.getStart(), modelRequest.getEnd());
        }
        if (range != null) {
            dataflowManager.fillDfManually(df, (List)Lists.newArrayList((Object[])new SegmentRange[]{range}));
        }
        UnitOfWorkContext context = UnitOfWork.get();
        context.doAfterUnit(() -> EventBusFactory.getInstance().postSync((Object)new ModelAddEvent(project, model.getId(), model.getAlias())));
        return ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(model.getUuid());
    }

    public void addBaseIndex(ModelRequest modelRequest, NDataModel model, IndexPlan indexPlan) {
        if (NDataModel.ModelType.BATCH == model.getModelType()) {
            List<IndexEntity.Source> sources = this.needHandleBaseIndexType(modelRequest);
            indexPlan.createAndAddBaseIndex(model, sources);
        }
    }

    private List<IndexEntity.Source> needHandleBaseIndexType(ModelRequest modelRequest) {
        ArrayList sources = Lists.newArrayList();
        Set<IndexEntity.Source> requestSource = modelRequest.getBaseIndexType();
        if (requestSource != null) {
            if (requestSource.contains(IndexEntity.Source.BASE_AGG_INDEX)) {
                sources.add(IndexEntity.Source.BASE_AGG_INDEX);
            }
            if (requestSource.contains(IndexEntity.Source.BASE_TABLE_INDEX)) {
                sources.add(IndexEntity.Source.BASE_TABLE_INDEX);
            }
        } else if (modelRequest.isWithBaseIndex()) {
            sources.add(IndexEntity.Source.BASE_AGG_INDEX);
            sources.add(IndexEntity.Source.BASE_TABLE_INDEX);
        }
        return sources;
    }

    private void createStreamingJob(String project, NDataModel model, ModelRequest request) {
        if (NDataModel.ModelType.BATCH != model.getModelType()) {
            StreamingJobManager jobManager = StreamingJobManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject());
            jobManager.createStreamingJob(model);
            this.createBatchModelInFusion(project, model, request);
        }
    }

    private void createBatchModelInFusion(String project, NDataModel model, ModelRequest request) {
        KafkaConfig kafkaConfig = model.getRootFactTableRef().getTableDesc().getKafkaConfig();
        if (kafkaConfig.hasBatchTable()) {
            String tableName = kafkaConfig.getBatchTable();
            ModelRequest copy = (ModelRequest)((Object)JsonUtil.deepCopyQuietly((Object)((Object)request), ModelRequest.class));
            copy.setAlias(FusionModel.getBatchName((String)request.getAlias(), (String)model.getUuid()));
            copy.setRootFactTableName(tableName);
            copy.setFusionId(model.getUuid());
            copy.setProject(project);
            model.setFusionId(model.getUuid());
            String tableAlias = kafkaConfig.getBatchTableAlias();
            String oldAliasName = model.getRootFactTableRef().getTableName();
            this.convertToDataModelResponse(copy, tableAlias, oldAliasName);
            NDataModel copyModel = this.saveModel(project, copy);
            this.createFusionModel(project, model, copyModel);
        }
    }

    private void createFusionModel(String project, NDataModel model, NDataModel copyModel) {
        FusionModel fusionModel = new FusionModel(model, copyModel);
        FusionModelManager fusionModelManager = FusionModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        fusionModelManager.createModel(fusionModel);
    }

    private void convertToDataModelResponse(ModelRequest copy, String tableName, String oldAliasName) {
        copy.getSimplifiedJoinTableDescs().forEach(x -> x.getSimplifiedJoinDesc().changeFKTableAlias(oldAliasName, tableName));
        copy.getSimplifiedDimensions().forEach(x -> x.changeTableAlias(oldAliasName, tableName));
        copy.getSimplifiedMeasures().forEach(x -> x.changeTableAlias(oldAliasName, tableName));
        copy.getPartitionDesc().changeTableAlias(oldAliasName, tableName);
    }

    void updateIndexPlan(String project, IndexPlan indexPlan, NDataModel model, String saveIndexesStrategy) {
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        indexPlanManager.updateIndexPlan(indexPlan.getId(), copyForWrite -> {
            if ("single_dim_and_reduce_hc".equalsIgnoreCase(saveIndexesStrategy)) {
                copyForWrite.setBaseAggIndexReduceHighCardinalityDim(true);
                this.splitIndexesIntoSingleDimIndexes(model, indexPlan);
            }
            if (indexPlan.getAggShardByColumns() != null) {
                copyForWrite.setAggShardByColumns(indexPlan.getAggShardByColumns());
            }
            if (CollectionUtils.isNotEmpty((Collection)indexPlan.getIndexes())) {
                copyForWrite.setIndexes(indexPlan.getIndexes());
            }
            copyForWrite.setEngineType(indexPlan.getEngineType());
            copyForWrite.setIndexPlanOverrideIndexes((Map)indexPlan.getIndexPlanOverrideIndexes());
            copyForWrite.setLastModified(System.currentTimeMillis());
        });
    }

    private void checkModelRequest(ModelRequest request) {
        this.checkModelOwner(request);
        this.checkModelDimensions(request);
        this.checkModelMeasures(request);
        this.checkModelJoinConditions(request);
    }

    private void checkModelOwner(ModelRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getOwner())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, "Invalid parameter, model owner is empty.");
        }
    }

    @VisibleForTesting
    public void checkModelDimensions(ModelRequest request) {
        HashSet<String> dimensionNames = new HashSet<String>();
        KylinConfigExt kylinConfig = ((NProjectManager)this.getManager(NProjectManager.class)).getProject(request.getProject()).getConfig();
        int maxModelDimensionMeasureNameLength = kylinConfig.getMaxModelDimensionMeasureNameLength();
        for (NDataModel.NamedColumn dimension : request.getSimplifiedDimensions()) {
            dimension.setName(StringUtils.trim((String)dimension.getName()));
            if (StringUtils.length((CharSequence)dimension.getName()) > maxModelDimensionMeasureNameLength || !VALID_NAME_FOR_DIMENSION.matcher(dimension.getName()).matches()) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_NAME, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidDimensionName(), dimension.getName(), maxModelDimensionMeasureNameLength));
            }
            if (dimensionNames.contains(dimension.getName())) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_DIMENSION_NAME, String.format(Locale.ROOT, MsgPicker.getMsg().getDuplicateDimensionName(), dimension.getName()));
            }
            dimensionNames.add(dimension.getName());
        }
    }

    private void checkMeasureNameValid(ModelRequest request) {
        int maxLen = NProjectManager.getProjectConfig((String)request.getProject()).getMaxModelDimensionMeasureNameLength();
        String invalidPattern = MsgPicker.getMsg().getInvalidMeasureName();
        for (SimplifiedMeasure measure : request.getSimplifiedMeasures()) {
            String name = measure.getName();
            if (StringUtils.length((CharSequence)name) <= maxLen && this.checkIsValidMeasureName(name)) continue;
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_NAME, String.format(Locale.ROOT, invalidPattern, name, maxLen));
        }
    }

    private void checkMeasureNameDuplicate(ModelRequest modelRequest) {
        HashSet measureNames = Sets.newHashSet();
        for (SimplifiedMeasure measure : modelRequest.getSimplifiedMeasures()) {
            if (measureNames.contains(measure.getName())) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_MEASURE_NAME, String.format(Locale.ROOT, MsgPicker.getMsg().getDuplicateMeasureName(), measure.getName()));
            }
            measureNames.add(measure.getName());
        }
    }

    @VisibleForTesting
    public void checkModelMeasures(ModelRequest request) {
        HashSet<SimplifiedMeasure> measures = new HashSet<SimplifiedMeasure>();
        request.getSimplifiedMeasures().forEach(measure -> measure.setName(StringUtils.trim((String)measure.getName())));
        this.checkMeasureNameValid(request);
        this.checkMeasureNameDuplicate(request);
        for (SimplifiedMeasure measure2 : request.getSimplifiedMeasures()) {
            SimplifiedMeasure dupMeasure = null;
            for (SimplifiedMeasure m : measures) {
                if (!this.isDupMeasure(measure2, m)) continue;
                dupMeasure = m;
                break;
            }
            if (dupMeasure != null) {
                NDataModel.Measure existingMeasure;
                SimplifiedMeasure simplifiedMeasure = dupMeasure = dupMeasure.getId() != 0 ? dupMeasure : measure2;
                if (request.getId() != null && (existingMeasure = (NDataModel.Measure)this.getModelById(request.getId(), request.getProject()).getEffectiveMeasures().get((Object)dupMeasure.getId())) != null && existingMeasure.getType() == NDataModel.MeasureType.INTERNAL) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_MEASURE_EXPRESSION, String.format(Locale.ROOT, MsgPicker.getMsg().getDuplicateInternalMeasureDefinition(), measure2.getName()));
                }
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_MEASURE_EXPRESSION, String.format(Locale.ROOT, MsgPicker.getMsg().getDuplicateMeasureDefinition(), measure2.getName()));
            }
            measures.add(measure2);
        }
    }

    private boolean checkIsValidMeasureName(String measureName) {
        if (!KylinConfig.getInstanceFromEnv().isMeasureNameCheckEnabled()) {
            return true;
        }
        return VALID_NAME_FOR_MEASURE.matcher(measureName).matches();
    }

    private boolean isDupMeasure(SimplifiedMeasure measure, SimplifiedMeasure measure1) {
        if (measure.getExpression().equalsIgnoreCase(measure1.getExpression()) && Objects.equals(measure.getParameterValue(), measure1.getParameterValue()) && Objects.equals(measure.getConfiguration(), measure1.getConfiguration())) {
            if (!Strings.isNullOrEmpty((String)measure1.getReturnType()) && !Strings.isNullOrEmpty((String)measure.getReturnType())) {
                return Objects.equals(measure1.getReturnType(), measure.getReturnType());
            }
            return true;
        }
        return false;
    }

    private void checkModelJoinConditions(ModelRequest request) {
        for (JoinTableDesc joinTableDesc : request.getJoinTables()) {
            HashSet<Pair> joinKeys = new HashSet<Pair>();
            JoinDesc joinDesc = joinTableDesc.getJoin();
            int size = joinDesc.getPrimaryKey().length;
            String[] primaryKeys = joinDesc.getPrimaryKey();
            String[] foreignKey = joinDesc.getForeignKey();
            for (int i = 0; i < size; ++i) {
                if (joinKeys.contains(Pair.newPair((Object)primaryKeys[i], (Object)foreignKey[i]))) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_JOIN_CONDITION, String.format(Locale.ROOT, MsgPicker.getMsg().getDuplicateJoinConditions(), primaryKeys[i], foreignKey[i]));
                }
                joinKeys.add(Pair.newPair((Object)primaryKeys[i], (Object)foreignKey[i]));
            }
        }
    }

    public String probeDateFormatIfNotExist(String project, NDataModel model) throws SQLException {
        PartitionDesc partitionDesc = model.getPartitionDesc();
        if (PartitionDesc.isEmptyPartitionDesc((PartitionDesc)partitionDesc) || StringUtils.isNotEmpty((CharSequence)partitionDesc.getPartitionDateFormat())) {
            return "";
        }
        if (StringUtils.isNotEmpty((CharSequence)partitionDesc.getPartitionDateColumn()) && StringUtils.isNotEmpty((CharSequence)partitionDesc.getPartitionDateFormat())) {
            return partitionDesc.getPartitionDateColumn();
        }
        String partitionColumn = model.getPartitionDesc().getPartitionDateColumnRef().getBackTickExp();
        String date = PushDownUtil.probeColFormat((String)model.getRootFactTableName(), (String)partitionColumn, (String)project);
        return DateFormat.proposeDateFormat((String)date);
    }

    public void saveDateFormatIfNotExist(String project, String modelId, String format) {
        if (StringUtils.isEmpty((CharSequence)format)) {
            return;
        }
        ((NDataModelManager)this.getManager(NDataModelManager.class, project)).updateDataModel(modelId, model -> model.getPartitionDesc().setPartitionDateFormat(format));
    }

    public NDataSegment appendSegment(AddSegmentRequest request) {
        String project = request.getProject();
        return (NDataSegment)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NDataflow df = ((NDataflowManager)this.getManager(NDataflowManager.class, project)).getDataflow(request.getModelId());
            return ((NDataflowManager)this.getManager(NDataflowManager.class, project)).appendSegment(df, request.getSegRange(), request.getStatus(), request.getMultiPartitionValues());
        }, (String)project);
    }

    private Pair<String, String> getPartitionColMinMaxValue(String project, String table, PartitionDesc desc) throws Exception {
        Preconditions.checkNotNull((Object)desc);
        String partitionColumn = desc.getPartitionDateColumn();
        String dateFormat = desc.getPartitionDateFormat();
        Preconditions.checkArgument((StringUtils.isNotEmpty((CharSequence)dateFormat) && StringUtils.isNotEmpty((CharSequence)partitionColumn) ? 1 : 0) != 0);
        Pair minAndMaxTime = PushDownUtil.probeMinMaxTsWithTimeout((String)partitionColumn, (String)table, (String)project);
        return new Pair((Object)DateFormat.getFormattedDate((String)((String)minAndMaxTime.getFirst()), (String)dateFormat), (Object)DateFormat.getFormattedDate((String)((String)minAndMaxTime.getSecond()), (String)dateFormat));
    }

    public SegmentCheckResponse checkSegHoleExistIfNewRangeBuild(String project, String modelId, String start, String end, boolean isBuildAllIndexes, List<Long> batchIndexIds) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        Preconditions.checkArgument((!PushDownUtil.needPushdown((String)start, (String)end) ? 1 : 0) != 0, (Object)"Load data must set start and end date");
        NDataModel dataModelDesc = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        TableDesc table = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getTableDesc(dataModelDesc.getRootFactTableName());
        SegmentRange segmentRangeToBuild = SourceFactory.getSource((ISourceAware)table).getSegmentRange(start, end);
        List segmentGaps = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).checkHoleIfNewSegBuild(modelId, segmentRangeToBuild);
        List<NDataSegment> overlapSegments = this.checkSegmentToBuildOverlapsBuilt(project, dataModelDesc, (SegmentRange<Long>)segmentRangeToBuild, isBuildAllIndexes, batchIndexIds);
        List<SegmentRangeResponse> overlapSegmentResponses = overlapSegments.stream().map(segment -> new SegmentRangeResponse(segment.getTSRange().getStart(), segment.getTSRange().getEnd())).collect(Collectors.toList());
        SegmentCheckResponse segmentCheckResponse = new SegmentCheckResponse();
        List<SegmentRangeResponse> segHoles = segmentGaps.stream().map(seg -> new SegmentRangeResponse(seg.getTSRange().getStart(), seg.getTSRange().getEnd())).collect(Collectors.toList());
        segmentCheckResponse.setSegmentHoles(segHoles);
        segmentCheckResponse.setOverlapSegments(overlapSegmentResponses);
        return segmentCheckResponse;
    }

    public SegmentCheckResponse checkSegHoleIfSegDeleted(String model, String project, String[] ids) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        NDataModel dataModel = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(model);
        if (ManagementType.TABLE_ORIENTED == dataModel.getManagementType()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, String.format(Locale.ROOT, MsgPicker.getMsg().getModelSegmentCanNotRemove(), dataModel.getAlias()));
        }
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        this.checkSegmentsExistById(model, project, ids);
        this.checkSegmentsStatus(model, project, ids, SegmentStatusEnumToDisplay.LOCKED);
        NDataflow dataflow = dataflowManager.getDataflow(model);
        List toDeletedSeg = dataflow.getSegments().stream().filter(seg -> Arrays.asList(ids).contains(seg.getId())).collect(Collectors.toList());
        List remainSegs = dataflow.getSegments().stream().filter(seg -> !Arrays.asList(ids).contains(seg.getId())).collect(Collectors.toList());
        List<SegmentRangeResponse> segHoles = dataflowManager.calculateHoles(model, remainSegs).stream().filter(seg -> toDeletedSeg.stream().anyMatch(deletedSeg -> deletedSeg.getSegRange().overlaps(seg.getSegRange()))).map(seg -> new SegmentRangeResponse(seg.getTSRange().getStart(), seg.getTSRange().getEnd())).collect(Collectors.toList());
        SegmentCheckResponse response = new SegmentCheckResponse();
        response.setSegmentHoles(segHoles);
        return response;
    }

    public JobInfoResponse fixSegmentHoles(String project, String modelId, List<SegmentTimeRequest> segmentHoles, Set<String> ignoredSnapshotTables) throws SQLException {
        this.aclEvaluate.checkProjectOperationPermission(project);
        NDataModel modelDesc = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        this.checkModelAndIndexManually(project, modelId);
        String format = this.probeDateFormatIfNotExist(project, modelDesc);
        List jobIds = (List)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            ArrayList jobInfos = Lists.newArrayList();
            List<String[]> allPartitions = null;
            if (modelDesc.isMultiPartitionModel()) {
                allPartitions = modelDesc.getMultiPartitionDesc().getPartitions().stream().map(MultiPartitionDesc.PartitionInfo::getValues).collect(Collectors.toList());
            }
            for (SegmentTimeRequest hole : segmentHoles) {
                jobInfos.add(this.modelBuildService.constructIncrementBuild((IncrementBuildSegmentParams)new IncrementBuildSegmentParams(project, modelId, hole.getStart(), hole.getEnd(), format, true, allPartitions).withIgnoredSnapshotTables((Set)ignoredSnapshotTables)));
            }
            return jobInfos;
        }, (String)project);
        JobInfoResponse jobInfoResponse = new JobInfoResponse();
        jobInfoResponse.setJobs(jobIds);
        return jobInfoResponse;
    }

    @Transaction(project=0)
    public JobInfoResponse optimizeLayoutData(String project, String modelId, OptimizeLayoutDataRequest request) throws Exception {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.checkModelPermission(project, modelId);
        Set<Long> targetLayout = this.updateOptimizeSettings(project, modelId, request);
        JobParam jobParam = new JobParam(modelId, BasicService.getUsername()).withProject(project).withJobTypeEnum(JobTypeEnum.LAYOUT_DATA_OPTIMIZE).withPriority(request.getPriority()).withYarnQueue(request.getYarnQueue()).withTargetLayouts(targetLayout);
        String jobId = JobManager.getInstance((KylinConfig)this.getConfig(), (String)project).addJob(jobParam);
        JobInfoResponse.JobInfo jobInfo = new JobInfoResponse.JobInfo(JobTypeEnum.LAYOUT_DATA_OPTIMIZE.toString(), jobId);
        JobInfoResponse jobInfoResponse = new JobInfoResponse();
        jobInfoResponse.setJobs(Lists.newArrayList((Object[])new JobInfoResponse.JobInfo[]{jobInfo}));
        return jobInfoResponse;
    }

    public Set<Long> updateOptimizeSettings(String project, String modelId, OptimizeLayoutDataRequest request) {
        HashSet targetLayout = Sets.newHashSet();
        Set<Long> toOptimizeModelLayouts = this.updateModelOptimizeSettings(project, modelId, request.getModelOptimizationSetting());
        targetLayout.addAll(toOptimizeModelLayouts);
        Set<Long> toOptimizeLayouts = this.updateLayoutOptimizeSettings(project, modelId, request.getLayoutDataOptimizationSettingList());
        targetLayout.addAll(toOptimizeLayouts);
        return targetLayout;
    }

    private Set<Long> updateModelOptimizeSettings(String project, String modelId, OptimizeLayoutDataRequest.DataOptimizationSetting modelSettings) {
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)this.getConfig(), (String)project);
        HashSet toOptimizeLayouts = Sets.newHashSet();
        AtomicReference<Boolean> modelConfigChange = new AtomicReference<Boolean>(false);
        if (modelSettings != null) {
            indexPlanManager.updateIndexPlan(modelId, indexPlan -> {
                LinkedHashMap oldProps = indexPlan.getOverrideProps();
                List<String> partitionByCols = modelSettings.getRepartitionByColumns();
                List<String> zorderByCols = modelSettings.getZorderByColumns();
                long maxFileSize = modelSettings.getMaxCompactionFileSize();
                long minFileSize = modelSettings.getMinCompactionFileSize();
                if (partitionByCols != null) {
                    oldProps.put("kylin.model.layout.storage.v3-partition-by-columns", String.join((CharSequence)"\u0001", partitionByCols));
                    modelConfigChange.set(true);
                }
                if (zorderByCols != null) {
                    oldProps.put("kylin.model.layout.storage.v3-zorder-by-columns", String.join((CharSequence)"\u0001", zorderByCols));
                    modelConfigChange.set(true);
                }
                if (maxFileSize > 0L) {
                    oldProps.put("kylin.model.layout.storage.v3-max-file-size-in-bytes", Long.toString(maxFileSize));
                    modelConfigChange.set(true);
                }
                if (minFileSize > 0L) {
                    oldProps.put("kylin.model.layout.storage.v3-min-file-size-in-bytes", Long.toString(minFileSize));
                    modelConfigChange.set(true);
                }
            });
        }
        if (modelConfigChange.get().booleanValue()) {
            toOptimizeLayouts.addAll(indexPlanManager.getIndexPlan(modelId).getAllLayoutIds(false));
        }
        return toOptimizeLayouts;
    }

    private Set<Long> updateLayoutOptimizeSettings(String project, String modelId, List<OptimizeLayoutDataRequest.LayoutDataOptimizationSetting> layoutSettings) {
        NDataLayoutDetailsManager layoutDetailsManager = NDataLayoutDetailsManager.getInstance((KylinConfig)this.getConfig(), (String)project);
        HashSet toOptimizeLayouts = Sets.newHashSet();
        if (layoutSettings == null) {
            return toOptimizeLayouts;
        }
        layoutSettings.forEach(optimizeRequest -> optimizeRequest.getLayoutIdList().forEach(layoutId -> {
            if (optimizeRequest.getSetting() != null) {
                this.updateLayoutOptimizeSettings(optimizeRequest.getSetting(), modelId, (Long)layoutId, layoutDetailsManager, toOptimizeLayouts);
            }
        }));
        return toOptimizeLayouts;
    }

    private void updateLayoutOptimizeSettings(OptimizeLayoutDataRequest.DataOptimizationSetting layoutSetting, String modelId, Long layoutId, NDataLayoutDetailsManager layoutDetailsManager, HashSet<Long> toOptimizeLayouts) {
        layoutDetailsManager.updateLayoutDetails(modelId, layoutId.longValue(), copy -> {
            if (layoutSetting.getMinCompactionFileSize() > 0L) {
                copy.setMinCompactionFileSizeInBytes(layoutSetting.getMinCompactionFileSize());
            }
            if (layoutSetting.getMaxCompactionFileSize() > 0L) {
                copy.setMaxCompactionFileSizeInBytes(layoutSetting.getMaxCompactionFileSize());
            }
            if (layoutSetting.getZorderByColumns() != null) {
                copy.setZorderByColumns(layoutSetting.getZorderByColumns());
            }
            if (layoutSetting.getRepartitionByColumns() != null) {
                copy.setPartitionColumns(layoutSetting.getRepartitionByColumns());
            }
            copy.setCompactionAfterUpdate(layoutSetting.isCompaction());
            toOptimizeLayouts.add(layoutId);
        });
    }

    @Transaction(project=0)
    public void setStorageType(String project, String modelId, int storageType) {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.checkModelPermission(project, modelId);
        NDataModelManager manager = NDataModelManager.getInstance((KylinConfig)this.getConfig(), (String)project);
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)project);
        NDataflow dataflow = dataflowManager.getDataflow(modelId);
        if (!dataflow.getSegments().isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_STORAGE_UPDATE_FAILED, MsgPicker.getMsg().getModelStorageUpdateFailed());
        }
        manager.updateDataModel(modelId, model -> model.setStorageType(storageType));
    }

    public NDataLayoutDetails getLayoutDetail(String project, String modelId, long layoutId) {
        this.aclEvaluate.checkProjectReadPermission(project);
        return NDataLayoutDetailsManager.getInstance((KylinConfig)this.getConfig(), (String)project).getNDataLayoutDetails(modelId, layoutId);
    }

    public void removeIndexesFromSegments(String project, String modelId, List<String> segmentIds, List<Long> indexIds) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        this.checkModelPermission(project, modelId);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NDataflowManager dfManger = (NDataflowManager)this.getManager(NDataflowManager.class, project);
            NDataLayoutDetailsManager layoutDetailsManger = NDataLayoutDetailsManager.getInstance((KylinConfig)this.getConfig(), (String)project);
            NDataflow dataflow = dfManger.getDataflow(modelId);
            for (String segmentId : segmentIds) {
                NDataSegment seg = dataflow.getSegment(segmentId);
                dfManger.updateDataflowDetailsLayouts(seg, indexIds, Collections.emptyList());
                for (Long toRemoveIndex : indexIds) {
                    layoutDetailsManger.updateLayoutDetails(modelId, toRemoveIndex.longValue(), layoutDetail -> layoutDetail.getFragmentRangeSet().remove(seg.getRange()));
                }
            }
            ((NIndexPlanManager)this.getManager(NIndexPlanManager.class, project)).updateIndexPlan(dataflow.getUuid(), IndexPlan::removeTobeDeleteIndexIfNecessary);
            return null;
        }, (String)project);
    }

    @Transaction(project=0)
    public NDataSegment appendPartitions(String project, String dfId, String segId, List<String[]> partitionValues) {
        return NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).appendPartitions(dfId, segId, partitionValues);
    }

    @Transaction(project=0)
    public NDataSegment mergeSegments(String project, MergeSegmentRequest mergeSegmentRequest) {
        NDataflow df = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getDataflow(mergeSegmentRequest.getIndexPlanUuid());
        return NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).mergeSegments(df, mergeSegmentRequest.getSegRange(), mergeSegmentRequest.isForce(), mergeSegmentRequest.getFileLayer(), mergeSegmentRequest.getNewSegId());
    }

    public ModelRequest convertToRequest(NDataModel modelDesc) throws IOException {
        ModelRequest request = new ModelRequest((NDataModel)JsonUtil.deepCopy((Object)modelDesc, NDataModel.class));
        request.setSimplifiedMeasures(modelDesc.getEffectiveMeasures().values().stream().map(SimplifiedMeasure::fromMeasure).collect(Collectors.toList()));
        request.setSimplifiedDimensions(modelDesc.getAllNamedColumns().stream().filter(NDataModel.NamedColumn::isDimension).collect(Collectors.toList()));
        request.setComputedColumnDescs(modelDesc.getComputedColumnDescs());
        return request;
    }

    @Transaction(project=0)
    public void updatePartitionColumn(String project, String modelId, PartitionDesc partitionDesc, MultiPartitionDesc multiPartitionDesc) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.checkModelPermission(project, modelId);
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        NDataflow df = dataflowManager.getDataflow(modelId);
        NDataModel model = df.getModel();
        ModelUtils.checkPartitionColumn(model, partitionDesc, MsgPicker.getMsg().getPartitionColumnSaveError());
        if (PartitionDesc.isEmptyPartitionDesc((PartitionDesc)model.getPartitionDesc()) && df.getFirstSegment() == null && !model.isMultiPartitionModel()) {
            dataflowManager.fillDfManually(df, (List)Lists.newArrayList((Object[])new SegmentRange[]{SegmentRange.TimePartitionedSegmentRange.createInfinite()}));
        }
        if (!Objects.equals(partitionDesc, model.getPartitionDesc()) || !ModelSemanticHelper.isMultiPartitionDescSame(model.getMultiPartitionDesc(), multiPartitionDesc)) {
            ModelRequest request = this.convertToRequest(model);
            request.setProject(project);
            request.setPartitionDesc(partitionDesc);
            request.setSaveOnly(true);
            request.setMultiPartitionDesc(multiPartitionDesc);
            this.updateDataModelSemantic(project, request);
        }
    }

    public List<MultiPartitionValueResponse> getMultiPartitionValues(String project, String modelId) {
        NDataModel model = this.getModelById(modelId, project);
        MultiPartitionDesc multiPartitionDesc = model.getMultiPartitionDesc();
        Segments segments = ((NDataflowManager)this.getManager(NDataflowManager.class, project)).getDataflow(modelId).getSegments();
        int totalSegCount = segments.size();
        ArrayList responses = Lists.newArrayList();
        if (multiPartitionDesc == null || CollectionUtils.isEmpty((Collection)multiPartitionDesc.getPartitions())) {
            return responses;
        }
        for (MultiPartitionDesc.PartitionInfo partition : multiPartitionDesc.getPartitions()) {
            int builtSegmentCount = (int)segments.stream().filter(segment -> segment.getMultiPartitionIds().contains(partition.getId())).count();
            responses.add(new MultiPartitionValueResponse(partition.getId(), partition.getValues(), builtSegmentCount, totalSegCount));
        }
        return responses;
    }

    @Transaction(project=0)
    public NDataModel batchUpdateMultiPartition(String project, String modelId, List<String[]> partitionValues) {
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        NDataModel dataModel = modelManager.getDataModelDesc(modelId);
        if (dataModel == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_ID_NOT_EXIST, new Object[]{modelId});
        }
        MultiPartitionDesc multiPartitionDesc = dataModel.getMultiPartitionDesc();
        Set<Long> tobeDeletedPartitions = multiPartitionDesc.getPartitions().stream().filter(partitionInfo -> partitionValues.stream().noneMatch(pv -> Objects.deepEquals(pv, partitionInfo.getValues()))).map(MultiPartitionDesc.PartitionInfo::getId).collect(Collectors.toSet());
        if (!tobeDeletedPartitions.isEmpty()) {
            logger.debug("Import model {} delete partitions {}", (Object)dataModel.getAlias(), tobeDeletedPartitions);
            this.deletePartitions(dataModel.getProject(), null, dataModel.getUuid(), tobeDeletedPartitions);
        }
        dataModel = modelManager.getDataModelDesc(modelId);
        modelManager.addPartitionsIfAbsent(dataModel, partitionValues);
        return modelManager.getDataModelDesc(modelId);
    }

    @Transaction(project=0)
    public void addMultiPartitionValues(String project, String modelId, List<String[]> subPartitionValues) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        NDataModel model = modelManager.getDataModelDesc(modelId);
        modelManager.addPartitionsIfAbsent(model, subPartitionValues);
    }

    private void checkModelAndIndexManually(String project, String modelId) {
        this.checkModelAndIndexManually(new FullBuildSegmentParams(project, modelId, true));
    }

    public void checkModelAndIndexManually(FullBuildSegmentParams params) {
        if (params.isNeedBuild()) {
            if (this.modelSmartServiceSupporter != null && this.modelSmartServiceSupporter.isAutoIndexPlanEnabled(params.getModelId(), params.getProject())) {
                return;
            }
            IndexPlan indexPlan = this.getIndexPlan(params.getModelId(), params.getProject());
            if (indexPlan == null || indexPlan.getAllLayouts().isEmpty()) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getCanNotBuildSegment());
            }
        }
    }

    public List<NDataSegment> checkSegmentToBuildOverlapsBuilt(String project, NDataModel model, SegmentRange<Long> segmentRangeToBuild, boolean isBuildAllIndexes, List<Long> batchIndexIds) {
        Segments<NDataSegment> segments = this.getSegmentsByRange(model.getId(), project, "0", "9223372036854775807");
        ArrayList overlapsBuiltSegment = Lists.newArrayListWithCapacity((int)segments.size());
        if (CollectionUtils.isEmpty(segments)) {
            return overlapsBuiltSegment;
        }
        boolean buildSegmentOverlapEnable = this.getIndexPlan(model.getId(), project).getConfig().isBuildSegmentOverlapEnabled();
        boolean isBuildAllIndexesFinally = CollectionUtils.isEmpty(batchIndexIds) || batchIndexIds.size() == this.getIndexPlan(model.getId(), project).getAllIndexes().size();
        for (NDataSegment existedSegment : segments) {
            boolean isOverlap = buildSegmentOverlapEnable && NDataModel.ModelType.BATCH == model.getModelType() && !model.isMultiPartitionModel() && isBuildAllIndexes && isBuildAllIndexesFinally ? existedSegment.getSegRange().overlaps(segmentRangeToBuild) && !segmentRangeToBuild.contains(existedSegment.getSegRange()) : existedSegment.getSegRange().overlaps(segmentRangeToBuild);
            if (!isOverlap) continue;
            overlapsBuiltSegment.add(existedSegment);
        }
        return overlapsBuiltSegment;
    }

    public ComputedColumnUsageResponse getComputedColumnUsages(String project) {
        this.aclEvaluate.checkProjectWritePermission(project);
        ComputedColumnUsageResponse ret = new ComputedColumnUsageResponse();
        List models = ((NDataflowManager)this.getManager(NDataflowManager.class, project)).listUnderliningDataModels();
        for (NDataModel model : models) {
            for (ComputedColumnDesc computedColumnDesc : model.getComputedColumnDescs()) {
                ret.addUsage(computedColumnDesc, model.getUuid());
            }
        }
        return ret;
    }

    public ComputedColumnCheckResponse checkComputedColumn(NDataModel model, String project, String ccInCheck) {
        this.aclEvaluate.checkProjectWritePermission(project);
        if (model.getUuid() == null) {
            model.updateRandomUuid();
        }
        model.init(this.getConfig(), project, ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getCCRelatedModels(model));
        model.getComputedColumnDescs().forEach(cc -> {
            String innerExp = PushDownUtil.massageComputedColumn((NDataModel)model, (String)project, (ComputedColumnDesc)cc, null);
            cc.setInnerExpression(innerExp);
        });
        if (model.isSeekingCCAdvice()) {
            throw new IllegalStateException("No advice could be provided");
        }
        this.checkCCNameAmbiguity(model);
        ComputedColumnDesc checkedCC = null;
        QueryContext.AclInfo aclInfo = AclPermissionUtil.createAclInfo((String)project, (Set)this.getCurrentUserGroups());
        AntiFlatChecker checker = new AntiFlatChecker(model.getJoinTables(), model);
        for (ComputedColumnDesc cc2 : model.getComputedColumnDescs()) {
            ModelService.checkCCName(cc2.getColumnName());
            if (!StringUtils.isEmpty((CharSequence)ccInCheck) && !StringUtils.equalsIgnoreCase((CharSequence)cc2.getFullName(), (CharSequence)ccInCheck)) {
                this.checkCascadeErrorOfNestedCC(cc2, ccInCheck);
                continue;
            }
            String antiFlattenLookup = checker.detectAntiFlattenLookup(cc2);
            if (antiFlattenLookup != null) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.COMPUTED_COLUMN_DEPENDS_ANTI_FLATTEN_LOOKUP, String.format(Locale.ROOT, MsgPicker.getMsg().getccOnAntiFlattenLookup(), antiFlattenLookup));
            }
            ComputedColumnDesc.simpleParserCheck((String)cc2.getExpression(), model.getAliasMap().keySet());
            String innerExpression = PushDownUtil.massageComputedColumn((NDataModel)model, (String)project, (ComputedColumnDesc)cc2, (QueryContext.AclInfo)aclInfo);
            cc2.setInnerExpression(innerExpression);
            long ts = System.currentTimeMillis();
            ComputedColumnEvalUtil.evaluateExprAndType((NDataModel)model, (ComputedColumnDesc)cc2);
            logger.debug("Spent {} ms to visit data source to validate computed column expression: {}", (Object)(System.currentTimeMillis() - ts), (Object)cc2.getExpression());
            checkedCC = cc2;
        }
        Preconditions.checkState((checkedCC != null ? 1 : 0) != 0, (String)"No computed column match: {}", (Object)ccInCheck);
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, model.getProject());
        NDataModel oldDataModel = modelManager.getDataModelDesc(model.getUuid());
        if (oldDataModel == null) {
            return this.getComputedColumnCheckResponse(checkedCC, new ArrayList<String>());
        }
        NDataModel copyModel = modelManager.copyForWrite(oldDataModel);
        ModelRequest request = new ModelRequest(model);
        request.setProject(model.getProject());
        request.setMeasures(model.getAllMeasures());
        UpdateImpact updateImpact = this.semanticUpdater.updateModelColumns(copyModel, request);
        Set removedMeasures = updateImpact.getInvalidMeasures();
        List<String> measureNames = oldDataModel.getAllMeasures().stream().filter(m -> removedMeasures.contains(m.getId())).map(MeasureDesc::getName).collect(Collectors.toList());
        Set removedRequestMeasures = updateImpact.getInvalidRequestMeasures();
        List requestMeasureNames = request.getAllMeasures().stream().filter(m -> removedRequestMeasures.contains(m.getId())).map(MeasureDesc::getName).collect(Collectors.toList());
        measureNames.addAll(requestMeasureNames);
        return this.getComputedColumnCheckResponse(checkedCC, measureNames);
    }

    static void checkCCName(String name) {
        if (PushDownConverterKeyWords.CALCITE.contains((Object)name.toUpperCase(Locale.ROOT)) || PushDownConverterKeyWords.HIVE.contains((Object)name.toUpperCase(Locale.ROOT))) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_NAME, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidComputerColumnNameWithKeyword(), name));
        }
        if (!Pattern.compile("^[a-zA-Z]+\\w*$").matcher(name).matches()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_NAME, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidComputerColumnName(), name));
        }
    }

    public void checkCCNameAmbiguity(NDataModel model) {
        HashSet ambiguousCCNameSet = Sets.newHashSet();
        HashSet ccColumnNames = Sets.newHashSet();
        for (ComputedColumnDesc cc : model.getComputedColumnDescs()) {
            if (ccColumnNames.contains(cc.getColumnName())) {
                ambiguousCCNameSet.add(cc.getColumnName());
                continue;
            }
            ccColumnNames.add(cc.getColumnName());
        }
        if (CollectionUtils.isEmpty((Collection)ccColumnNames)) {
            return;
        }
        for (TableRef table : model.getFactTables()) {
            for (TblColRef tblColRef : table.getColumns()) {
                if (tblColRef.getColumnDesc().isComputedColumn() || !ccColumnNames.contains(tblColRef.getName())) continue;
                ambiguousCCNameSet.add(tblColRef.getName());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)ambiguousCCNameSet)) {
            this.buildDuplicateCCException(ambiguousCCNameSet);
        }
    }

    private void buildDuplicateCCException(Set<String> ambiguousCCNameSet) {
        StringBuilder error = new StringBuilder();
        ambiguousCCNameSet.forEach(name -> {
            error.append(String.format(Locale.ROOT, MsgPicker.getMsg().getCheckCcAmbiguity(), name));
            error.append("\r\n");
        });
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_COMPUTED_COLUMN_NAME, error.toString());
    }

    void preProcessBeforeModelSave(NDataModel model, String project) {
        model.init(this.getConfig(), project, Collections.emptyList(), true);
        this.massageModelFilterCondition(model);
        this.checkCCNameAmbiguity(model);
        QueryContext.AclInfo aclInfo = AclPermissionUtil.createAclInfo((String)project, (Set)this.getCurrentUserGroups());
        for (ComputedColumnDesc ccDesc : model.getComputedColumnDescs()) {
            String ccExpression = PushDownUtil.massageComputedColumn((NDataModel)model, (String)project, (ComputedColumnDesc)ccDesc, (QueryContext.AclInfo)aclInfo);
            ccDesc.setInnerExpression(ccExpression);
            TblColRef tblColRef = model.findColumn(ccDesc.getTableAlias(), ccDesc.getColumnName());
            tblColRef.getColumnDesc().setComputedColumnExpr(ccExpression);
        }
        ComputedColumnEvalUtil.evalDataTypeOfCCInBatch((NDataModel)model, (List)model.getComputedColumnDescs());
    }

    @Transaction(project=0)
    public void updateModelDataCheckDesc(String project, String modelId, long checkOptions, long faultThreshold, long faultActions) {
        this.aclEvaluate.checkProjectWritePermission(project);
        NDataModel dataModel = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        if (dataModel == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_ID_NOT_EXIST, new Object[]{modelId});
        }
        dataModel.setDataCheckDesc(DataCheckDesc.valueOf((long)checkOptions, (long)faultThreshold, (long)faultActions));
        ((NDataModelManager)this.getManager(NDataModelManager.class, project)).updateDataModelDesc(dataModel);
    }

    @Transaction(project=1)
    public void deleteSegmentById(String model, String project, String[] ids, boolean force) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        NDataModel dataModel = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(model);
        if (ManagementType.TABLE_ORIENTED == dataModel.getManagementType()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, String.format(Locale.ROOT, MsgPicker.getMsg().getModelSegmentCanNotRemove(), dataModel.getAlias()));
        }
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        this.checkSegmentsExistById(model, project, ids);
        this.checkSegmentsStatus(model, project, ids, SegmentStatusEnumToDisplay.LOCKED);
        IndexPlan indexPlan = this.getIndexPlan(model, project);
        NDataflow dataflow = dataflowManager.getDataflow(indexPlan.getUuid());
        HashSet idsToDelete = Sets.newHashSet();
        for (String id : ids) {
            if (dataflow.getSegment(id) == null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, MsgPicker.getMsg().getSegNotFound(), id, dataflow.getModelAlias()));
            }
            idsToDelete.add(id);
        }
        this.removeSegment(project, dataflow.getUuid(), idsToDelete);
        this.offlineModelIfNecessary(dataflowManager, model);
    }

    public FileSegments.ModelFileSegments getModelFileSegments(String project, String modelAlias) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        NDataflowManager dfManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        NDataflow df = dfManager.getDataflowByModelAlias(modelAlias);
        if (df == null || df.isBroken() || df.getModel().isBroken()) {
            return FileSegments.ModelFileSegments.broken((String)project, (String)modelAlias);
        }
        return FileSegments.getModelFileSegments((String)project, (String)df.getModel().getId(), (boolean)true);
    }

    @Transaction(project=0)
    public void forceFileSegments(String project, String modelId, String storageLocation, Optional<List<String>> fileHashs, SegmentStatusEnum initStatus) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        NDataflowManager dfManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        FileSegments.forceFileSegments((String)project, (String)modelId, (String)storageLocation, fileHashs, fileSegRangeToCreate -> {
            NDataSegment newSeg;
            if (initStatus == SegmentStatusEnum.NEW) {
                IncrementBuildSegmentParams incrParams = new IncrementBuildSegmentParams(project, modelId, (SegmentRange<?>)fileSegRangeToCreate, true);
                this.modelBuildService.constructIncrementBuild(incrParams);
                newSeg = dfManager.getDataflow(modelId).getSegmentByName(fileSegRangeToCreate.proposeSegmentName());
            } else {
                newSeg = dfManager.appendSegment(dfManager.getDataflow(modelId), (SegmentRange)fileSegRangeToCreate, initStatus, null);
            }
            return newSeg;
        }, segmentIdToDelete -> {
            this.deleteSegmentById(modelId, project, new String[]{segmentIdToDelete}, true);
            return true;
        });
    }

    public void removeSegment(String project, String dataflowId, Set<String> tobeRemoveSegmentIds) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project);
        NDataflow df = dfMgr.getDataflow(dataflowId);
        if (CollectionUtils.isEmpty(tobeRemoveSegmentIds)) {
            return;
        }
        ArrayList dataSegments = Lists.newArrayList();
        for (String tobeRemoveSegmentId : tobeRemoveSegmentIds) {
            NDataSegment dataSegment = df.getSegment(tobeRemoveSegmentId);
            if (dataSegment == null) continue;
            dataSegments.add(dataSegment);
        }
        if (CollectionUtils.isNotEmpty((Collection)dataSegments)) {
            NDataflowUpdate update = new NDataflowUpdate(df.getUuid());
            update.setToRemoveSegs(dataSegments.toArray(new NDataSegment[0]));
            dfMgr.updateDataflow(update);
        }
    }

    @Transaction(project=0)
    public NDataSegment refreshSegment(String project, String indexPlanUuid, String segmentId) {
        NDataflowManager dfManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        NDataflow df = dfManager.getDataflow(indexPlanUuid);
        NDataSegment segment = df.getSegment(segmentId);
        return dfManager.refreshSegment(df, segment.getSegRange());
    }

    private void offlineModelIfNecessary(NDataflowManager dfManager, String modelId) {
        NDataflow df = dfManager.getDataflow(modelId);
        if (df.getSegments().isEmpty() && RealizationStatusEnum.ONLINE == df.getStatus()) {
            dfManager.updateDataflowStatus(df.getId(), RealizationStatusEnum.OFFLINE);
        }
    }

    public void checkSegmentsExistById(String modelId, String project, String[] ids) {
        this.checkSegmentsExistById(modelId, project, ids, true);
    }

    public boolean checkSegmentsExistById(String modelId, String project, String[] ids, boolean shouldThrown) {
        Preconditions.checkNotNull((Object)modelId);
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkNotNull((Object)ids);
        this.aclEvaluate.checkProjectOperationPermission(project);
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        IndexPlan indexPlan = this.getIndexPlan(modelId, project);
        NDataflow dataflow = dataflowManager.getDataflow(indexPlan.getUuid());
        List notExistIds = Stream.of(ids).filter(segmentId -> !dataflow.getSegmentUuids().contains(segmentId)).filter(Objects::nonNull).collect(Collectors.toList());
        if (shouldThrown && !CollectionUtils.isEmpty(notExistIds)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_NOT_EXIST_ID, new Object[]{StringUtils.join(notExistIds, (String)",")});
        }
        return CollectionUtils.isEmpty(notExistIds);
    }

    private void checkSegmentsExistByName(String model, String project, String[] names) {
        this.checkSegmentsExistByName(model, project, names, true);
    }

    public boolean checkSegmentsExistByName(String model, String project, String[] names, boolean shouldThrow) {
        Preconditions.checkNotNull((Object)model);
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkNotNull((Object)names);
        this.aclEvaluate.checkProjectOperationPermission(project);
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        IndexPlan indexPlan = this.getIndexPlan(model, project);
        NDataflow dataflow = dataflowManager.getDataflow(indexPlan.getUuid());
        List notExistNames = Stream.of(names).filter(segmentName -> null == dataflow.getSegmentByName(segmentName)).filter(Objects::nonNull).collect(Collectors.toList());
        if (shouldThrow && !CollectionUtils.isEmpty(notExistNames)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_NOT_EXIST_NAME, new Object[]{StringUtils.join(notExistNames, (String)",")});
        }
        return CollectionUtils.isEmpty(notExistNames);
    }

    public void checkSegmentsStatus(String model, String project, String[] ids, SegmentStatusEnumToDisplay ... statuses) {
        for (SegmentStatusEnumToDisplay status : statuses) {
            this.checkSegmentsStatus(model, project, ids, status);
        }
    }

    public void checkSegmentsStatus(String model, String project, String[] ids, SegmentStatusEnumToDisplay status) {
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        IndexPlan indexPlan = this.getIndexPlan(model, project);
        NDataflow dataflow = dataflowManager.getDataflow(indexPlan.getUuid());
        Segments segments = dataflow.getSegments();
        ErrorCodeServer serverErrorCode = SegmentStatusEnumToDisplay.LOCKED == status ? ErrorCodeServer.SEGMENT_LOCKED : ErrorCodeServer.SEGMENT_STATUS;
        Set allIndexJobRunningSegments = SegmentUtil.getAllIndexJobRunningSegments((NDataModel)dataflow.getModel());
        for (String id : ids) {
            NDataSegment segment = dataflow.getSegment(id);
            if (SegmentUtil.getSegmentStatusToDisplay((Segments)segments, (ISegment)segment, null, (Set)allIndexJobRunningSegments) != status) continue;
            throw new KylinException((ErrorCodeProducer)serverErrorCode, new Object[]{segment.displayIdName(), status});
        }
    }

    private void checkSegmentsContinuous(String modelId, String project, String[] ids) {
        NDataflowManager dfManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        IndexPlan indexPlan = this.getIndexPlan(modelId, project);
        NDataflow df = dfManager.getDataflow(indexPlan.getUuid());
        List segmentList = Arrays.stream(ids).map(arg_0 -> ((NDataflow)df).getSegment(arg_0)).sorted(NDataSegment::compareTo).collect(Collectors.toList());
        for (int i = 0; i < segmentList.size() - 1; ++i) {
            if (((NDataSegment)segmentList.get(i)).getSegRange().connects(((NDataSegment)segmentList.get(i + 1)).getSegRange())) continue;
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_MERGE_CONTAINS_GAPS, new Object[0]);
        }
    }

    public Pair<Long, Long> checkMergeSegments(MergeSegmentParams params) {
        String project = params.getProject();
        String modelId = params.getModelId();
        String[] ids = params.getSegmentIds();
        this.aclEvaluate.checkProjectOperationPermission(project);
        NDataflowManager dfManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        NDataflow df = dfManager.getDataflow(modelId);
        this.checkSegmentsExistById(modelId, project, ids);
        this.checkSegmentsStatus(modelId, project, ids, SegmentStatusEnumToDisplay.LOADING, SegmentStatusEnumToDisplay.REFRESHING, SegmentStatusEnumToDisplay.MERGING, SegmentStatusEnumToDisplay.LOCKED);
        this.checkSegmentsContinuous(modelId, project, ids);
        long start = Long.MAX_VALUE;
        long end = -1L;
        for (String id : ids) {
            NDataSegment segment = df.getSegment(id);
            if (segment == null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, MsgPicker.getMsg().getSegNotFound(), id, df.getModelAlias()));
            }
            if (SegmentStatusEnum.READY != segment.getStatus() && SegmentStatusEnum.WARNING != segment.getStatus()) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getInvalidMergeSegment());
            }
            long segmentStart = segment.getTSRange().getStart();
            long segmentEnd = segment.getTSRange().getEnd();
            if (segmentStart < start) {
                start = segmentStart;
            }
            if (segmentEnd <= end) continue;
            end = segmentEnd;
        }
        return Pair.newPair((Object)start, (Object)end);
    }

    public BuildBaseIndexResponse updateDataModelSemantic(String project, ModelRequest request) {
        return this.updateDataModelSemantic(project, request, true);
    }

    public BuildBaseIndexResponse updateDataModelSemantic(String project, ModelRequest request, boolean isCheckFlat) {
        try {
            UnitOfWorkParams params = UnitOfWorkParams.builder().unitName(project).processor(() -> {
                this.aclEvaluate.checkProjectWritePermission(project);
                this.semanticUpdater.expandModelRequest(request);
                this.checkModelRequest(request);
                this.checkModelPermission(project, request.getUuid());
                this.validatePartitionDateColumn(request);
                String modelId = request.getUuid();
                NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
                NDataModel originModel = modelManager.getDataModelDesc(modelId);
                NDataModel copyModel = modelManager.copyForWrite(originModel);
                UpdateImpact updateImpact = this.semanticUpdater.updateModelColumns(copyModel, request, true);
                copyModel.init(modelManager.getConfig(), project, modelManager.getCCRelatedModels(copyModel));
                BaseIndexUpdateHelper baseIndexUpdater = new BaseIndexUpdateHelper(originModel, this.needHandleBaseIndexType(request));
                this.preProcessBeforeModelSave(copyModel, project);
                NDataModel updated = modelManager.updateDataModelDesc(copyModel);
                this.semanticUpdater.deleteExpandableMeasureInternalMeasures(updated);
                this.semanticUpdater.expandExpandableMeasure(updated);
                this.preProcessBeforeModelSave(updated, project);
                ((NDataModelManager)this.getManager(NDataModelManager.class, project)).updateDataModelDesc(updated);
                this.indexPlanService.checkPartitionDimensionForV3Storage(project, modelId, this.getConfig());
                this.indexPlanService.updateForMeasureChange(project, modelId, updateImpact.getInvalidMeasures(), updateImpact.getReplacedMeasures());
                Set affectedSet = updateImpact.getAffectedIds();
                Set<Long> affectedLayoutSet = this.getAffectedLayouts(project, modelId, affectedSet);
                if (affectedLayoutSet.size() > 0) {
                    this.indexPlanService.reloadLayouts(project, modelId, affectedLayoutSet);
                }
                this.indexPlanService.clearShardColIfNotDim(project, modelId);
                NDataModel newModel = modelManager.getDataModelDesc(modelId);
                this.checkIndexColumnExist(project, modelId, originModel);
                if (isCheckFlat) {
                    this.checkFlatTableSql(newModel);
                }
                boolean needBuild = this.semanticUpdater.doHandleSemanticUpdate(project, modelId, originModel, request.getStart(), request.getEnd());
                this.updateExcludedCheckerResult(project, request);
                BuildBaseIndexResponse baseIndexResponse = baseIndexUpdater.update(this.indexPlanService);
                if (!request.isSaveOnly() && (needBuild || baseIndexResponse.hasIndexChange())) {
                    Set<String> targetSegments = SegmentUtil.getValidSegments((String)modelId, (String)project).stream().map(RootPersistentEntity::getId).collect(Collectors.toSet());
                    this.semanticUpdater.buildForModelSegments(project, modelId, targetSegments);
                }
                this.modelChangeSupporters.forEach(listener -> listener.onUpdate(project, modelId));
                return baseIndexResponse;
            }).build();
            return (BuildBaseIndexResponse)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry((UnitOfWorkParams)params);
        }
        catch (TransactionException te) {
            Throwable root = te.getCause();
            if (root instanceof RuntimeException) {
                throw (RuntimeException)root;
            }
            throw te;
        }
    }

    public void updateExcludedCheckerResult(String project, ModelRequest request) {
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
        String uuid = request.getUuid();
        NDataModel convertedModel = modelManager.getDataModelDesc(uuid);
        List joinTables = convertedModel.getJoinTables();
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(uuid);
        AntiFlatChecker checker = new AntiFlatChecker(joinTables, convertedModel);
        List invalidCCList = checker.getInvalidComputedColumns(convertedModel);
        Set invalidDimensions = checker.getInvalidDimensions(convertedModel);
        Set invalidMeasures = checker.getInvalidMeasures(convertedModel);
        HashSet invalidScope = Sets.newHashSet();
        invalidScope.addAll(invalidDimensions);
        invalidScope.addAll(invalidMeasures);
        Set invalidIndexes = checker.getInvalidIndexes(indexPlan, (Set)invalidScope);
        HashMap invalidCCMap = Maps.newHashMap();
        invalidCCList.forEach(cc -> invalidCCMap.put(cc.getColumnName(), cc));
        if (!invalidIndexes.isEmpty()) {
            this.indexPlanService.removeIndexes(project, uuid, invalidIndexes, invalidDimensions, invalidMeasures);
        }
        modelManager.updateDataModel(uuid, copyForWrite -> {
            copyForWrite.getComputedColumnDescs().removeIf(cc -> invalidCCMap.containsKey(cc.getColumnName()));
            copyForWrite.getAllMeasures().forEach(measure -> {
                if (invalidMeasures.contains(measure.getId())) {
                    measure.setTomb(true);
                }
            });
            copyForWrite.getAllNamedColumns().forEach(column -> {
                if (!column.isExist()) {
                    return;
                }
                if (invalidDimensions.contains(column.getId())) {
                    column.setStatus(NDataModel.ColumnStatus.EXIST);
                }
                if (invalidCCMap.containsKey(column.getName())) {
                    String colName = column.getAliasDotColumn();
                    String fullName = ((ComputedColumnDesc)invalidCCMap.get(column.getName())).getFullName();
                    if (fullName.equalsIgnoreCase(colName)) {
                        column.setStatus(NDataModel.ColumnStatus.TOMB);
                    }
                }
            });
        });
    }

    public String[] convertSegmentIdWithName(String modelId, String project, String[] segIds, String[] segNames) {
        String[] ids = segIds;
        if (ArrayUtils.isEmpty((Object[])segNames)) {
            return ids;
        }
        this.aclEvaluate.checkProjectOperationPermission(project);
        this.checkSegmentsExistByName(modelId, project, segNames);
        NDataflow dataflow = ((NDataflowManager)this.getManager(NDataflowManager.class, project)).getDataflow(modelId);
        ids = (String[])Stream.of(segNames).map(segmentName -> {
            NDataSegment segmentByName = dataflow.getSegmentByName(segmentName);
            return Objects.isNull(segmentByName) ? null : segmentByName.getId();
        }).toArray(String[]::new);
        return ids;
    }

    private Set<Long> getAffectedLayouts(String project, String modelId, Set<Integer> modifiedSet) {
        HashSet<Long> affectedLayoutSet = new HashSet<Long>();
        NIndexPlanManager indePlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        IndexPlan indexPlan = indePlanManager.getIndexPlan(modelId);
        for (LayoutEntity layoutEntity : indexPlan.getAllLayouts()) {
            if (!layoutEntity.getColOrder().stream().anyMatch(modifiedSet::contains)) continue;
            affectedLayoutSet.add(layoutEntity.getId());
        }
        return affectedLayoutSet;
    }

    private void checkIndexColumnExist(String project, String modelId, NDataModel originModel) {
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(modelId);
        NDataModel newModel = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        RuleBasedIndex rule = indexPlan.getRuleBasedIndex();
        if (rule != null) {
            if (!newModel.getEffectiveDimensions().keySet().containsAll((Collection)rule.getDimensions())) {
                List allDimensions = rule.getDimensions();
                List dimensionNames = allDimensions.stream().filter(id -> !newModel.getEffectiveDimensions().containsKey(id)).map(arg_0 -> ((NDataModel)originModel).getColumnNameByColumnId(arg_0)).collect(Collectors.toList());
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_MODEL, String.format(Locale.ROOT, MsgPicker.getMsg().getDimensionNotfound(), StringUtils.join(dimensionNames, (String)",")));
            }
            for (NAggregationGroup agg : rule.getAggregationGroups()) {
                if (newModel.getEffectiveMeasures().keySet().containsAll((Collection)Sets.newHashSet((Object[])agg.getMeasures()))) continue;
                List measureNames = Arrays.stream(agg.getMeasures()).filter(measureId -> !newModel.getEffectiveMeasures().containsKey(measureId)).map(arg_0 -> ((NDataModel)originModel).getMeasureNameByMeasureId(arg_0)).collect(Collectors.toList());
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_MODEL, String.format(Locale.ROOT, MsgPicker.getMsg().getMeasureNotfound(), StringUtils.join(measureNames, (String)",")));
            }
        }
        Set tableIndexColumns = indexPlan.getIndexes().stream().filter(IndexEntity::isTableIndex).map(IndexEntity::getDimensions).flatMap(Collection::stream).collect(Collectors.toSet());
        List allSelectedColumns = newModel.getAllSelectedColumns().stream().map(NDataModel.NamedColumn::getId).collect(Collectors.toList());
        if (!allSelectedColumns.containsAll(tableIndexColumns)) {
            List columnNames = tableIndexColumns.stream().filter(x -> !allSelectedColumns.contains(x)).map(arg_0 -> ((NDataModel)originModel).getColumnNameByColumnId(arg_0)).collect(Collectors.toList());
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_MODEL, String.format(Locale.ROOT, MsgPicker.getMsg().getDimensionNotfound(), StringUtils.join(columnNames, (String)",")));
        }
        List recommendAggIndex = indexPlan.getIndexes().stream().filter(x -> !x.isTableIndex()).collect(Collectors.toList());
        for (IndexEntity aggIndex : recommendAggIndex) {
            if (!newModel.getEffectiveDimensions().keySet().containsAll((Collection)aggIndex.getDimensions())) {
                List allDimensions = aggIndex.getDimensions();
                List dimensionNames = allDimensions.stream().filter(id -> !newModel.getEffectiveDimensions().containsKey(id)).map(arg_0 -> ((NDataModel)originModel).getColumnNameByColumnId(arg_0)).collect(Collectors.toList());
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_MODEL, String.format(Locale.ROOT, MsgPicker.getMsg().getDimensionNotfound(), StringUtils.join(dimensionNames, (String)",")));
            }
            if (newModel.getEffectiveMeasures().keySet().containsAll((Collection)aggIndex.getMeasures())) continue;
            List measureNames = aggIndex.getMeasures().stream().filter(measureId -> !newModel.getEffectiveMeasures().containsKey(measureId)).map(arg_0 -> ((NDataModel)originModel).getMeasureNameByMeasureId(arg_0)).collect(Collectors.toList());
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_MODEL, String.format(Locale.ROOT, MsgPicker.getMsg().getMeasureNotfound(), StringUtils.join(measureNames, (String)",")));
        }
    }

    public void updateBrokenModel(String project, ModelRequest modelRequest, Set<Integer> columnIds) {
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        NDataModel origin = modelManager.getDataModelDesc(modelRequest.getUuid());
        NDataModel copyModel = modelManager.copyForWrite(origin);
        try {
            this.semanticUpdater.updateModelColumns(copyModel, modelRequest);
        }
        catch (Exception e) {
            log.warn("Update existing model failed.{}", (Object)ThreadUtil.getKylinStackTrace());
        }
        copyModel.setBrokenReason(NDataModel.BrokenReason.SCHEMA);
        copyModel.getAllNamedColumns().forEach(namedColumn -> {
            if (columnIds.contains(namedColumn.getId())) {
                namedColumn.setStatus(NDataModel.ColumnStatus.TOMB);
            }
        });
        modelManager.updateDataModelDesc(copyModel);
    }

    public NDataModel repairBrokenModel(String project, ModelRequest modelRequest) throws Exception {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.semanticUpdater.expandModelRequest(modelRequest);
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        NDataModel origin = modelManager.getDataModelDesc(modelRequest.getId());
        NDataModel broken = this.modelQuerySupporter.getBrokenModel(project, origin.getId());
        if (ManagementType.TABLE_ORIENTED == broken.getManagementType()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_MODEL, "Can not repair model manually smart mode!");
        }
        broken.setPartitionDesc(modelRequest.getPartitionDesc());
        broken.setMultiPartitionDesc(modelRequest.getMultiPartitionDesc());
        broken.setMultiPartitionKeyMapping(modelRequest.getMultiPartitionKeyMapping());
        broken.setFilterCondition(modelRequest.getFilterCondition());
        broken.setJoinTables(modelRequest.getJoinTables());
        this.discardInvalidColumnAndMeasure(broken, modelRequest);
        broken.init(this.getConfig(), project, ((NDataflowManager)this.getManager(NDataflowManager.class, project)).listUnderliningDataModels());
        broken.setBrokenReason(NDataModel.BrokenReason.NULL);
        String format = this.probeDateFormatIfNotExist(project, broken);
        return (NDataModel)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NDataModelManager modelMgr = (NDataModelManager)this.getManager(NDataModelManager.class, project);
            this.semanticUpdater.updateModelColumns(broken, modelRequest);
            NDataModel copy = modelManager.copyForWrite(broken);
            NDataModel model = modelMgr.updateDataModelDesc(copy);
            modelMgr.updateDataModel(model.getUuid(), copyForWrite -> {
                this.modelChangeSupporters.forEach(listener -> listener.onUpdateSingle(project, model.getUuid()));
                this.saveDateFormatIfNotExist(project, model.getUuid(), format);
            });
            ((NDataflowManager)this.getManager(NDataflowManager.class, project)).updateDataflowStatus(broken.getId(), RealizationStatusEnum.ONLINE);
            return modelMgr.getDataModelDesc(model.getUuid());
        }, (String)project);
    }

    public void discardInvalidColumnAndMeasure(NDataModel brokenModel, ModelRequest modelRequest) {
        NDataModel newModel = this.convertAndInitDataModel(modelRequest, brokenModel.getProject());
        Set aliasDotColumns = newModel.getAllNamedColumns().stream().filter(NDataModel.NamedColumn::isExist).map(NDataModel.NamedColumn::getAliasDotColumn).collect(Collectors.toSet());
        for (NDataModel.NamedColumn column : brokenModel.getAllNamedColumns()) {
            if (aliasDotColumns.contains(column.getAliasDotColumn())) continue;
            column.setStatus(NDataModel.ColumnStatus.TOMB);
        }
        block1: for (NDataModel.Measure measure : brokenModel.getAllMeasures()) {
            if (measure.isTomb()) continue;
            FunctionDesc function = measure.getFunction();
            for (ParameterDesc param : function.getParameters()) {
                if (param.isConstant() || aliasDotColumns.contains(param.getValue())) continue;
                measure.setTomb(true);
                continue block1;
            }
        }
    }

    public NDataModel convertToDataModel(ModelRequest modelDesc) {
        return this.semanticUpdater.convertToDataModel(modelDesc);
    }

    public AffectedModelsResponse getAffectedModelsByDeletingTable(String tableName, String project) {
        this.aclEvaluate.checkProjectReadPermission(project);
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        TableDesc table = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getTableDesc(tableName);
        AffectedModelsResponse response = new AffectedModelsResponse();
        List<String> models = dataflowManager.getModelsUsingTable(table).stream().map(RootPersistentEntity::getUuid).collect(Collectors.toList());
        int size = 0;
        response.setModels(models);
        for (String model : models) {
            size = (int)((long)size + dataflowManager.getDataflowStorageSize(model));
        }
        response.setByteSize(size);
        return response;
    }

    public List<ModelConfigResponse> getModelConfig(String project, String modelName) {
        this.aclEvaluate.checkProjectReadPermission(project);
        ArrayList responseList = Lists.newArrayList();
        boolean streamingEnabled = this.getConfig().isStreamingEnabled();
        ((NDataflowManager)this.getManager(NDataflowManager.class, project)).listUnderliningDataModels().stream().filter(model -> StringUtils.isEmpty((CharSequence)modelName) || model.getAlias().contains(modelName)).filter(model -> model.isAccessible(streamingEnabled) && !model.fusionModelBatchPart()).forEach(dataModel -> {
            ModelConfigResponse response = new ModelConfigResponse();
            response.setModel(dataModel.getUuid());
            response.setAlias(dataModel.getAlias());
            SegmentConfig segmentConfig = dataModel.getSegmentConfig();
            response.setAutoMergeEnabled(segmentConfig.getAutoMergeEnabled());
            response.setAutoMergeTimeRanges(segmentConfig.getAutoMergeTimeRanges());
            response.setVolatileRange(segmentConfig.getVolatileRange());
            response.setRetentionRange(segmentConfig.getRetentionRange());
            response.setConfigLastModified(dataModel.getConfigLastModified());
            response.setConfigLastModifier(dataModel.getConfigLastModifier());
            IndexPlan indexPlan = this.getIndexPlan(dataModel.getUuid(), project);
            if (indexPlan != null) {
                LinkedHashMap overrideProps = indexPlan.getOverrideProps();
                response.getOverrideProps().putAll(overrideProps);
                MODEL_CONFIG_BLOCK_LIST.forEach(item -> {
                    String cfr_ignored_0 = (String)response.getOverrideProps().remove(item);
                });
            }
            responseList.add(response);
        });
        return responseList;
    }

    @Transaction(project=0)
    public void updateModelConfig(String project, String modelId, ModelConfigRequest request) {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.checkModelConfigParameters(request);
        NDataModelManager dataModelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        dataModelManager.updateDataModel(modelId, copyForWrite -> {
            SegmentConfig segmentConfig = copyForWrite.getSegmentConfig();
            segmentConfig.setAutoMergeEnabled(request.getAutoMergeEnabled());
            segmentConfig.setAutoMergeTimeRanges(request.getAutoMergeTimeRanges());
            segmentConfig.setVolatileRange(request.getVolatileRange());
            segmentConfig.setRetentionRange(request.getRetentionRange());
            copyForWrite.setConfigLastModified(System.currentTimeMillis());
            copyForWrite.setConfigLastModifier(BasicService.getUsername());
        });
        IndexPlan indexPlan = this.getIndexPlan(modelId, project);
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
        LinkedHashMap<String, String> overrideProps = request.getOverrideProps();
        indexPlanManager.updateIndexPlan(indexPlan.getUuid(), copyForWrite -> {
            boolean affectedByProp;
            String affectProp = "kylin.cube.aggrgroup.is-base-cuboid-always-valid";
            String oldProp = (String)copyForWrite.getOverrideProps().get(affectProp);
            copyForWrite.setOverrideProps((Map)overrideProps);
            String newProp = (String)copyForWrite.getOverrideProps().get(affectProp);
            boolean bl = affectedByProp = !StringUtils.equals((CharSequence)oldProp, (CharSequence)newProp);
            if (affectedByProp && copyForWrite.getRuleBasedIndex() != null) {
                RuleBasedIndex newRule = (RuleBasedIndex)JsonUtil.deepCopyQuietly((Object)copyForWrite.getRuleBasedIndex(), RuleBasedIndex.class);
                newRule.setLastModifiedTime(System.currentTimeMillis());
                newRule.setLayoutIdMapping((List)Lists.newArrayList());
                copyForWrite.setRuleBasedIndex(newRule);
            }
        });
    }

    private void checkPropParameter(ModelConfigRequest request) {
        LinkedHashMap<String, String> props = request.getOverrideProps();
        if (props == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidNullValue(), "override_props"));
        }
        for (Map.Entry<String, String> pair : props.entrySet()) {
            if (!Objects.isNull(pair.getValue())) continue;
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidNullValue(), pair.getKey()));
        }
        String cores = props.get("kylin.engine.spark-conf.spark.executor.cores");
        String instances = props.get("kylin.engine.spark-conf.spark.executor.instances");
        String pattitions = props.get("kylin.engine.spark-conf.spark.sql.shuffle.partitions");
        String memory = props.get("kylin.engine.spark-conf.spark.executor.memory");
        String baseCuboidAllowed = props.get("kylin.cube.aggrgroup.is-base-cuboid-always-valid");
        if (null != cores && !StringHelper.validateNumber((String)cores)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidIntegerFormat(), "spark.executor.cores"));
        }
        if (null != instances && !StringHelper.validateNumber((String)instances)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidIntegerFormat(), "spark.executor.instances"));
        }
        if (null != pattitions && !StringHelper.validateNumber((String)pattitions)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidIntegerFormat(), "spark.sql.shuffle.partitions"));
        }
        if (!(null == memory || memory.endsWith("g") && StringHelper.validateNumber((String)memory.substring(0, memory.length() - 1)))) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidMemorySize(), "spark.executor.memory"));
        }
        if (null != baseCuboidAllowed && !StringHelper.validateBoolean((String)baseCuboidAllowed)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidBooleanFormat(), "is-base-cuboid-always-valid"));
        }
    }

    @VisibleForTesting
    public void checkModelConfigParameters(ModelConfigRequest request) {
        Boolean autoMergeEnabled = request.getAutoMergeEnabled();
        List<AutoMergeTimeEnum> timeRanges = request.getAutoMergeTimeRanges();
        VolatileRange volatileRange = request.getVolatileRange();
        RetentionRange retentionRange = request.getRetentionRange();
        if (Boolean.TRUE.equals(autoMergeEnabled) && (null == timeRanges || timeRanges.isEmpty())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getInvalidAutoMergeConfig());
        }
        if (null != volatileRange && volatileRange.isVolatileRangeEnabled() && (volatileRange.getVolatileRangeNumber() < 0L || null == volatileRange.getVolatileRangeType())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getInvalidVolatileRangeConfig());
        }
        if (null != retentionRange && retentionRange.isRetentionRangeEnabled() && retentionRange.getRetentionRangeNumber() < 0L) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getInvalidRetentionRangeConfig());
        }
        this.checkPropParameter(request);
    }

    public ExistedDataRangeResponse getLatestDataRange(String project, String modelId, PartitionDesc desc) {
        this.aclEvaluate.checkProjectReadPermission(project);
        Preconditions.checkNotNull((Object)modelId);
        try {
            NDataflow df = ((NDataflowManager)this.getManager(NDataflowManager.class, project)).getDataflow(modelId);
            NDataModel model = df.getModel();
            String table = model.getRootFactTableName();
            if (Objects.nonNull(desc) && !desc.equals((Object)model.getPartitionDesc())) {
                Pair<String, String> pushdownResult = this.getPartitionColMinMaxValue(project, table, desc);
                return new ExistedDataRangeResponse((String)pushdownResult.getFirst(), (String)pushdownResult.getSecond());
            }
            Pair<String, String> pushdownResult = this.getPartitionColMinMaxValue(project, table, model.getPartitionDesc());
            pushdownResult.setFirst((Object)PushDownUtil.calcStart((String)((String)pushdownResult.getFirst()), (SegmentRange)df.getCoveredRange()));
            if (Long.parseLong((String)pushdownResult.getFirst()) > Long.parseLong((String)pushdownResult.getSecond())) {
                pushdownResult.setSecond(pushdownResult.getFirst());
            }
            return new ExistedDataRangeResponse((String)pushdownResult.getFirst(), (String)pushdownResult.getSecond());
        }
        catch (Exception e) {
            if (e instanceof KylinTimeoutException) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_DETECT_DATA_RANGE, MsgPicker.getMsg().getpushdownDatarangeTimeout());
            }
            Throwable cause = e.getCause();
            if (cause instanceof KylinException) {
                ServerErrorCode code = ServerErrorCode.VIEW_PARTITION_DATE_FORMAT_DETECTION_FORBIDDEN;
                if (((KylinException)cause).getErrorCode().equals(code.toErrorCode())) {
                    throw new KylinException((ErrorCodeSupplier)code, MsgPicker.getMsg().getViewDateFormatDetectionError());
                }
            }
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_RANGE, MsgPicker.getMsg().getPushdownDatarangeError());
        }
    }

    public PurgeModelAffectedResponse getPurgeModelAffectedResponse(String project, String model) {
        this.aclEvaluate.checkProjectWritePermission(project);
        PurgeModelAffectedResponse response = new PurgeModelAffectedResponse();
        long byteSize = ((NDataflowManager)this.getManager(NDataflowManager.class, project)).getDataflowStorageSize(model);
        response.setByteSize(byteSize);
        long jobSize = ((ExecutableManager)this.getManager(ExecutableManager.class, project)).countByModelAndStatus(model, ExecutableState::isProgressing);
        response.setRelatedJobSize(jobSize);
        return response;
    }

    public ComputedColumnCheckResponse getComputedColumnCheckResponse(ComputedColumnDesc ccDesc, List<String> removedMeasures) {
        ComputedColumnCheckResponse response = new ComputedColumnCheckResponse();
        response.setComputedColumnDesc(ccDesc);
        response.setRemovedMeasures(removedMeasures);
        return response;
    }

    public ModelSaveCheckResponse checkBeforeModelSave(ModelRequest modelRequest) {
        this.aclEvaluate.checkProjectWritePermission(modelRequest.getProject());
        this.semanticUpdater.expandModelRequest(modelRequest);
        this.checkModelDimensions(modelRequest);
        this.checkModelMeasures(modelRequest);
        this.checkModelJoinConditions(modelRequest);
        this.validateFusionModelDimension(modelRequest);
        NDataModel model = this.semanticUpdater.convertToDataModel(modelRequest);
        for (NDataModel.Measure measure : model.getAllMeasures()) {
            measure.getFunction().init(model);
        }
        if (modelRequest.getPartitionDesc() != null && !KylinConfig.getInstanceFromEnv().isUseBigIntAsTimestampForPartitionColumn()) {
            PartitionDesc partitionDesc = modelRequest.getPartitionDesc();
            partitionDesc.init(model);
            if (!partitionDesc.checkIntTypeDateFormat()) {
                throw new KylinException((ErrorCodeSupplier)JobErrorCode.JOB_INT_DATE_FORMAT_NOT_MATCH_ERROR, "int/bigint data type only support yyyymm/yyyymmdd format");
            }
        }
        NDataModel oldDataModel = ((NDataModelManager)this.getManager(NDataModelManager.class, model.getProject())).getDataModelDesc(model.getUuid());
        Set<Object> affectedLayouts = Sets.newHashSet();
        if (oldDataModel != null && !oldDataModel.isBroken()) {
            model = ((NDataModelManager)this.getManager(NDataModelManager.class, model.getProject())).copyForWrite(oldDataModel);
            UpdateImpact updateImpact = this.semanticUpdater.updateModelColumns(model, modelRequest);
            Set modifiedSet = updateImpact.getAffectedIds();
            affectedLayouts = this.getAffectedLayouts(oldDataModel.getProject(), oldDataModel.getId(), modifiedSet);
        }
        try {
            this.massageModelFilterCondition(model);
        }
        catch (Exception e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_FILTER_CONDITION, (Throwable)e);
        }
        if (!affectedLayouts.isEmpty()) {
            return new ModelSaveCheckResponse(true);
        }
        return new ModelSaveCheckResponse();
    }

    private void checkCascadeErrorOfNestedCC(ComputedColumnDesc cc, String ccInCheck) {
        final String upperCcInCheck = ccInCheck.toUpperCase(Locale.ROOT);
        try {
            SqlBasicVisitor<Void> sqlVisitor = new SqlBasicVisitor<Void>(){

                public Void visit(SqlIdentifier id) {
                    if (id.toString().equals(upperCcInCheck)) {
                        throw new Util.FoundOne((Object)id);
                    }
                    return null;
                }
            };
            CalciteParser.getExpNode((String)cc.getExpression()).accept((SqlVisitor)sqlVisitor);
        }
        catch (Util.FoundOne e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.COMPUTED_COLUMN_CASCADE_ERROR, String.format(Locale.ROOT, MsgPicker.getMsg().getNestedCcCascadeError(), ccInCheck, cc.getFullName()));
        }
    }

    void massageModelFilterCondition(NDataModel model) {
        String filterCondition = model.getFilterCondition();
        if (StringUtils.isBlank((CharSequence)filterCondition)) {
            return;
        }
        filterCondition = QueryUtil.adaptCalciteSyntax((String)filterCondition);
        String newFilterCondition = this.addTableNameIfNotExist(filterCondition, model);
        QueryContext.AclInfo aclInfo = AclPermissionUtil.createAclInfo((String)model.getProject(), (Set)this.getCurrentUserGroups());
        String massaged = PushDownUtil.massageExpression((NDataModel)model, (String)model.getProject(), (String)newFilterCondition, (QueryContext.AclInfo)aclInfo);
        model.setFilterCondition(massaged);
    }

    @VisibleForTesting
    String addTableNameIfNotExist(String expr, NDataModel model) {
        AntiFlatChecker checker;
        String antiFlatLookup;
        SqlNode sqlNode = CalciteParser.getExpNode((String)expr);
        SqlIdentifierFormatterVisitor sqlVisitor = new SqlIdentifierFormatterVisitor(expr, model.getAllNamedColumns());
        sqlNode.accept((SqlVisitor)sqlVisitor);
        if (!NProjectManager.getProjectConfig((String)model.getProject()).isBuildExcludedTableEnabled() && (antiFlatLookup = (checker = new AntiFlatChecker(model.getJoinTables(), model)).detectFilterCondition(sqlNode.toString())) != null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FILTER_CONDITION_DEPENDS_ANTI_FLATTEN_LOOKUP, String.format(Locale.ROOT, MsgPicker.getMsg().getFilterConditionOnAntiFlattenLookup(), antiFlatLookup));
        }
        String exp = sqlNode.toSqlString(CalciteSqlDialect.DEFAULT, true).toString();
        return CalciteParser.normalize((String)exp);
    }

    public NModelDescResponse getModelDesc(String modelAlias, String project) {
        if (((NProjectManager)this.getManager(NProjectManager.class)).getProject(project) == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{project});
        }
        NDataModel dataModel = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDescByAlias(modelAlias);
        if (dataModel == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_NOT_EXIST, new Object[]{modelAlias});
        }
        NDataModelResponse model = new NDataModelResponse(dataModel);
        NModelDescResponse response = new NModelDescResponse();
        response.setUuid(model.getUuid());
        response.setLastModified(model.getLastModified());
        response.setCreateTime(model.getCreateTime());
        response.setVersion(model.getVersion());
        response.setName(model.getAlias());
        response.setProject(model.getProject());
        response.setDescription(model.getDescription());
        response.setComputedColumnDescs(model.getComputedColumnDescs());
        response.setFactTable(model.getRootFactTableName());
        response.setJoinTables(model.getJoinTables());
        response.setMeasures(model.getMeasures());
        List<NModelDescResponse.Dimension> dims = model.getNamedColumns().stream().map(namedColumn -> new NModelDescResponse.Dimension((NDataModel.NamedColumn)namedColumn, false)).collect(Collectors.toList());
        response.setDimensions(dims);
        IndexPlan indexPlan = this.getIndexPlan(response.getUuid(), project);
        if (indexPlan.getRuleBasedIndex() != null) {
            List<AggGroupResponse> aggGroupResponses = indexPlan.getRuleBasedIndex().getAggregationGroups().stream().map(x -> new AggGroupResponse(dataModel, (NAggregationGroup)x)).collect(Collectors.toList());
            response.setAggregationGroups(aggGroupResponses);
        } else {
            response.setAggregationGroups(new ArrayList<AggGroupResponse>());
        }
        return response;
    }

    public void updateModelPartitionColumn(String project, String modelAlias, ModelParatitionDescRequest modelParatitionDescRequest) {
        this.aclEvaluate.checkProjectWritePermission(project);
        if (((NProjectManager)this.getManager(NProjectManager.class)).getProject(project) == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{project});
        }
        NDataModel oldDataModel = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDescByAlias(modelAlias);
        if (oldDataModel == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_NOT_EXIST, new Object[]{modelAlias});
        }
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(oldDataModel.getUuid());
            if (model == null) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_NOT_EXIST, new Object[]{modelAlias});
            }
            this.checkModelPermission(project, oldDataModel.getId());
            PartitionDesc partitionColumn = modelParatitionDescRequest.getPartitionDesc();
            if (partitionColumn != null) {
                String rootFactTable = oldDataModel.getRootFactTableName().split("\\.")[1];
                if (!StringUtils.startsWithIgnoreCase((CharSequence)partitionColumn.getPartitionDateColumn(), (CharSequence)(rootFactTable + "."))) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARTITION_COLUMN, MsgPicker.getMsg().getInvalidPartitionColumn());
                }
            }
            ((NDataModelManager)this.getManager(NDataModelManager.class, project)).updateDataModel(oldDataModel.getUuid(), copyForWrite -> copyForWrite.setPartitionDesc(modelParatitionDescRequest.getPartitionDesc()));
            this.semanticUpdater.handleSemanticUpdate(project, oldDataModel.getUuid(), oldDataModel, modelParatitionDescRequest.getStart(), modelParatitionDescRequest.getEnd());
            return null;
        }, (String)project);
    }

    @Transaction(project=0)
    public void updateModelOwner(String project, String modelId, OwnerChangeRequest ownerChangeRequest) {
        try {
            this.aclEvaluate.checkProjectAdminPermission(project);
            this.checkTargetOwnerPermission(project, modelId, ownerChangeRequest.getOwner());
        }
        catch (AccessDeniedException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getModelChangePermission());
        }
        catch (IOException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getOwnerChangeError());
        }
        ((NDataModelManager)this.getManager(NDataModelManager.class, project)).updateDataModel(modelId, copyForWrite -> copyForWrite.setOwner(ownerChangeRequest.getOwner()));
    }

    private void checkTargetOwnerPermission(String project, String modelId, String owner) throws IOException {
        Set projectManagementUsers = this.accessService.getProjectManagementUsers(project);
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        if (Objects.isNull(model) || model.isBroken()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_ID_NOT_EXIST, new Object[]{modelId});
        }
        projectManagementUsers.remove(model.getOwner());
        if (CollectionUtils.isEmpty((Collection)projectManagementUsers) || !projectManagementUsers.contains(owner)) {
            Message msg = MsgPicker.getMsg();
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, msg.getModelOwnerChangeInvalidUser());
        }
    }

    @Transaction(project=0)
    public void updateMultiPartitionMapping(String project, String modelId, MultiPartitionMappingRequest request) {
        this.aclEvaluate.checkProjectWritePermission(project);
        NDataModel model = this.checkModelIsMLP(modelId, project);
        this.checkModelPermission(project, modelId);
        MultiPartitionDesc multiPartitionDesc = model.getMultiPartitionDesc();
        Message msg = MsgPicker.getMsg();
        if (CollectionUtils.isNotEmpty(request.getPartitionCols())) {
            Preconditions.checkArgument((request.getAliasCols().size() == multiPartitionDesc.getColumns().size() ? 1 : 0) != 0, (Object)((Object)new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_MULTI_PARTITION_MAPPING_REQUEST, msg.getMultiPartitionMappingReqeustNotValid())));
            for (int i = 0; i < request.getPartitionCols().size(); ++i) {
                String partitionCol = request.getPartitionCols().get(i);
                TblColRef columnRef = model.findColumn(partitionCol);
                if (columnRef.equals(multiPartitionDesc.getColumnRefs().get(i))) continue;
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_MULTI_PARTITION_MAPPING_REQUEST, msg.getMultiPartitionMappingReqeustNotValid());
            }
            List partitionValues = request.getValueMapping().stream().map(pair -> ((List)pair.getOrigin()).toArray(new String[0])).collect(Collectors.toList());
            for (MultiPartitionDesc.PartitionInfo partitionInfo : multiPartitionDesc.getPartitions()) {
                if (!partitionValues.stream().noneMatch(value -> Arrays.equals(value, partitionInfo.getValues()))) continue;
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_MULTI_PARTITION_MAPPING_REQUEST, msg.getMultiPartitionMappingReqeustNotValid());
            }
        }
        ((NDataModelManager)this.getManager(NDataModelManager.class, project)).updateDataModel(modelId, copyForWrite -> copyForWrite.setMultiPartitionKeyMapping(request.convertToMultiPartitionMapping()));
    }

    private void changeModelOwner(NDataModel model) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (Objects.nonNull(auth) && Objects.nonNull(auth.getPrincipal())) {
            if (auth.getPrincipal() instanceof UserDetails) {
                model.setOwner(((UserDetails)auth.getPrincipal()).getUsername());
            } else {
                model.setOwner(auth.getPrincipal().toString());
            }
        }
    }

    public List<NDataModel> updateResponseAcl(List<NDataModel> models, String project) {
        Set groups = this.getCurrentUserGroups();
        if (AclPermissionUtil.hasProjectAdminPermission((String)project, (Set)groups)) {
            models.forEach(model -> {
                NDataModelAclParams aclParams = new NDataModelAclParams();
                aclParams.setUnauthorizedTables((Set)Sets.newHashSet());
                aclParams.setUnauthorizedColumns((Set)Sets.newHashSet());
                if (model instanceof NDataModelResponse) {
                    ((NDataModelResponse)((Object)model)).setAclParams(aclParams);
                } else if (model instanceof RelatedModelResponse) {
                    ((RelatedModelResponse)((Object)model)).setAclParams(aclParams);
                }
            });
            return models;
        }
        String username = AclPermissionUtil.getCurrentUsername();
        HashSet allAuthTables = Sets.newHashSet();
        HashSet allAuthColumns = Sets.newHashSet();
        AclTCRDigest auths = ((AclTCRManager)this.getManager(AclTCRManager.class, project)).getAuthTablesAndColumns(project, username, true);
        allAuthTables.addAll(auths.getTables());
        allAuthColumns.addAll(auths.getColumns());
        for (String group : groups) {
            auths = ((AclTCRManager)this.getManager(AclTCRManager.class, project)).getAuthTablesAndColumns(project, group, false);
            allAuthTables.addAll(auths.getTables());
            allAuthColumns.addAll(auths.getColumns());
        }
        ArrayList normalModel = new ArrayList();
        ArrayList noVisibleModel = new ArrayList();
        models.forEach(model -> {
            HashSet tablesNoAcl = Sets.newHashSet();
            HashSet columnsNoAcl = Sets.newHashSet();
            HashSet tables = Sets.newHashSet();
            model.getJoinTables().forEach(table -> tables.add(table.getTable()));
            tables.add(model.getRootFactTableName());
            tables.stream().filter(table -> !allAuthTables.contains(table)).forEach(tablesNoAcl::add);
            tables.stream().filter(allAuthTables::contains).forEach(table -> {
                ColumnDesc[] columnDescs = NTableMetadataManager.getInstance((KylinConfig)this.getConfig(), (String)project).getTableDesc(table).getColumns();
                Arrays.stream(columnDescs).map(column -> table + "." + column.getName()).filter(column -> !allAuthColumns.contains(column)).forEach(columnsNoAcl::add);
            });
            NDataModelAclParams aclParams = new NDataModelAclParams();
            aclParams.setUnauthorizedTables((Set)tablesNoAcl);
            aclParams.setUnauthorizedColumns((Set)columnsNoAcl);
            if (model instanceof NDataModelResponse) {
                ((NDataModelResponse)((Object)model)).setAclParams(aclParams);
            } else if (model instanceof RelatedModelResponse) {
                ((RelatedModelResponse)((Object)model)).setAclParams(aclParams);
            }
            (aclParams.isVisible() ? normalModel : noVisibleModel).add(model);
        });
        ArrayList<NDataModel> result = new ArrayList<NDataModel>(normalModel);
        result.addAll(noVisibleModel);
        return result;
    }

    public NDataModel updateResponseAcl(NDataModel model, String project) {
        List<NDataModel> models = this.updateResponseAcl(Collections.singletonList(model), project);
        return models.get(0);
    }

    public void checkDuplicateAliasInModelRequests(Collection<ModelRequest> modelRequests) {
        Map aliasModelRequestMap = modelRequests.stream().collect(Collectors.groupingBy(modelRequest -> modelRequest.getAlias().toLowerCase(Locale.ROOT), Collectors.toList()));
        aliasModelRequestMap.forEach((alias, requests) -> {
            if (requests.size() > 1) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_NAME, String.format(Locale.ROOT, MsgPicker.getMsg().getModelAliasDuplicated(), requests.stream().map(NDataModel::getAlias).collect(Collectors.joining(", "))));
            }
        });
    }

    public void validateCCType(String modelId, String project) {
        StringBuilder errorSb = new StringBuilder();
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        try {
            ArrayList ccListCopy = Lists.newArrayList();
            for (ComputedColumnDesc computedColumnDesc : model.getComputedColumnDescs()) {
                ccListCopy.add(JsonUtil.deepCopy((Object)computedColumnDesc, ComputedColumnDesc.class));
            }
            ComputedColumnEvalUtil.evalDataTypeOfCCInBatch((NDataModel)model, (List)ccListCopy);
            for (int n = 0; n < ccListCopy.size(); ++n) {
                ComputedColumnDesc cc = (ComputedColumnDesc)model.getComputedColumnDescs().get(n);
                ComputedColumnDesc ccCopy = (ComputedColumnDesc)ccListCopy.get(n);
                if (this.matchCCDataType(cc.getDatatype(), ccCopy.getDatatype())) continue;
                errorSb.append(new MessageFormat(MsgPicker.getMsg().getCheckCCType(), Locale.ROOT).format(new String[]{cc.getFullName(), ccCopy.getDatatype(), cc.getDatatype()}));
            }
        }
        catch (Exception e) {
            logger.error("Error validating computed column ", (Throwable)e);
        }
        if (errorSb.length() > 0) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_COMPUTED_COLUMN_EXPRESSION, errorSb.toString());
        }
    }

    private boolean matchCCDataType(String actual, String expected) {
        if (actual == null) {
            return false;
        }
        actual = actual.toUpperCase(Locale.ROOT);
        expected = expected.toUpperCase(Locale.ROOT);
        if (STRING_TYPE_SET.contains(actual)) {
            return STRING_TYPE_SET.contains(expected);
        }
        if (actual.equals("DECIMAL")) {
            return expected.startsWith("DECIMAL");
        }
        return actual.equalsIgnoreCase(expected);
    }

    public CheckSegmentResponse checkSegments(String project, String modelAlias, String start, String end) {
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDescByAlias(modelAlias);
        if (model == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_NOT_EXIST, new Object[]{modelAlias});
        }
        if (model.isBroken()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_BROKEN, "Failed to get segment information as " + modelAlias + " is broken. Please fix it and try again.");
        }
        Segments<NDataSegment> segments = this.getSegmentsByRange(model.getUuid(), project, start, end);
        CheckSegmentResponse checkSegmentResponse = new CheckSegmentResponse();
        segments.forEach(seg -> checkSegmentResponse.getSegmentsOverlap().add(new CheckSegmentResponse.SegmentInfo(seg.getId(), seg.getName())));
        return checkSegmentResponse;
    }

    public String getPartitionColumnFormatById(String project, String modelId) {
        NDataModel dataModelDesc = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        if (dataModelDesc.isBroken()) {
            return null;
        }
        return dataModelDesc.getPartitionDesc() == null ? null : dataModelDesc.getPartitionDesc().getPartitionDateFormat();
    }

    public String getPartitionColumnFormatByAlias(String project, String modelAlias) {
        NDataModel dataModelDesc = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDescByAlias(modelAlias);
        if (dataModelDesc.isBroken()) {
            return null;
        }
        return dataModelDesc.getPartitionDesc() == null ? null : dataModelDesc.getPartitionDesc().getPartitionDateFormat();
    }

    public List<SegmentPartitionResponse> getSegmentPartitions(String project, String modelId, String segmentId, List<String> status, String sortBy, boolean reverse) {
        this.aclEvaluate.checkProjectReadPermission(project);
        this.checkModelPermission(project, modelId);
        NDataModel model = this.getModelById(modelId, project);
        MultiPartitionDesc partitionDesc = model.getMultiPartitionDesc();
        NDataflow dataflow = ((NDataflowManager)this.getManager(NDataflowManager.class, project)).getDataflow(modelId);
        NDataSegment segment = dataflow.getSegment(segmentId);
        if (segment == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_NOT_EXIST_ID, new Object[]{segmentId});
        }
        Comparator comparator = BasicService.propertyComparator((String)(StringUtils.isEmpty((CharSequence)sortBy) ? "last_modified_time" : sortBy), (!reverse ? 1 : 0) != 0);
        return segment.getMultiPartitions().stream().map(partition -> {
            MultiPartitionDesc.PartitionInfo partitionInfo = partitionDesc.getPartitionInfo(partition.getPartitionId());
            long lastModifiedTime = partition.getLastBuildTime() != 0L ? partition.getLastBuildTime() : partition.getCreateTimeUTC();
            return new SegmentPartitionResponse(partitionInfo.getId(), partitionInfo.getValues(), partition.getStatus(), lastModifiedTime, partition.getSourceCount(), partition.getStorageSize());
        }).filter(partitionResponse -> CollectionUtils.isEmpty((Collection)status) || status.contains(partitionResponse.getStatus().name())).sorted(comparator).collect(Collectors.toList());
    }

    @Transaction(project=0)
    public void deletePartitionsByValues(String project, String segmentId, String modelId, List<String[]> subPartitionValues) {
        NDataModel model = this.checkModelIsMLP(modelId, project);
        this.checkPartitionValues(model, subPartitionValues);
        Set ids = model.getMultiPartitionDesc().getPartitionIdsByValues(subPartitionValues);
        this.deletePartitions(project, segmentId, model.getId(), ids);
    }

    private void checkPartitionValues(NDataModel model, List<String[]> subPartitionValues) {
        List modelPartitionValues = model.getMultiPartitionDesc().getPartitions().stream().map(MultiPartitionDesc.PartitionInfo::getValues).collect(Collectors.toList());
        List absentValues = MultiPartitionUtil.findAbsentValues(modelPartitionValues, subPartitionValues);
        if (!absentValues.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARTITION_VALUES, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidPartitionValue(), absentValues.stream().map(arr -> String.join((CharSequence)", ", arr)).collect(Collectors.joining(", "))));
        }
    }

    @Transaction(project=0)
    public void deletePartitions(String project, String segmentId, String modelId, Set<Long> partitions) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        this.checkModelPermission(project, modelId);
        this.checkSegmentsExistById(modelId, project, new String[]{segmentId});
        this.checkModelIsMLP(modelId, project);
        if (CollectionUtils.isEmpty(partitions)) {
            return;
        }
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        if (StringUtils.isNotEmpty((CharSequence)segmentId)) {
            dataflowManager.removeLayoutPartition(modelId, partitions, (Set)Sets.newHashSet((Object[])new String[]{segmentId}));
            dataflowManager.removeSegmentPartition(modelId, partitions, (Set)Sets.newHashSet((Object[])new String[]{segmentId}));
        } else {
            dataflowManager.removeLayoutPartition(modelId, (Set)Sets.newHashSet(partitions), null);
            dataflowManager.removeSegmentPartition(modelId, (Set)Sets.newHashSet(partitions), null);
            ((NDataModelManager)this.getManager(NDataModelManager.class, project)).updateDataModel(modelId, copyForWrite -> {
                MultiPartitionDesc multiPartitionDesc = copyForWrite.getMultiPartitionDesc();
                multiPartitionDesc.removePartitionValue((List)Lists.newArrayList((Iterable)partitions));
            });
        }
    }

    public NDataModel checkModelIsMLP(String modelId, String project) {
        NDataModel model = this.getModelById(modelId, project);
        if (!model.isMultiPartitionModel()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_MODEL_TYPE, String.format(Locale.ROOT, MsgPicker.getMsg().getModelIsNotMlp(), model.getAlias()));
        }
        return model;
    }

    public InvalidIndexesResponse detectInvalidIndexes(ModelRequest request) {
        String project = request.getProject();
        this.aclEvaluate.checkProjectReadPermission(project);
        String modelId = request.getId();
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            if (modelId != null && this.getModelById(modelId, project).isBroken()) {
                this.discardInvalidDataForBrokenModel(modelId, project);
            }
            return null;
        }, (String)project);
        request.setPartitionDesc(null);
        request.setMultiPartitionDesc(null);
        request.setMultiPartitionKeyMapping(null);
        NDataModel model = this.convertAndInitDataModel(request, project);
        String uuid = model.getUuid();
        List joinTables = model.getJoinTables();
        IndexPlan indexPlan = ((NIndexPlanManager)this.getManager(NIndexPlanManager.class, project)).getIndexPlan(uuid);
        AntiFlatChecker checker = new AntiFlatChecker(joinTables, model);
        List invalidCCList = checker.getInvalidComputedColumns(model);
        Set invalidDimensions = checker.getInvalidDimensions(model);
        Set invalidMeasures = checker.getInvalidMeasures(model);
        HashSet invalidScope = Sets.newHashSet();
        invalidScope.addAll(invalidDimensions);
        invalidScope.addAll(invalidMeasures);
        Set invalidIndexes = checker.getInvalidIndexes(indexPlan, (Set)invalidScope);
        AtomicInteger aggIndexCount = new AtomicInteger();
        AtomicInteger tableIndexCount = new AtomicInteger();
        invalidIndexes.forEach(layoutId -> {
            if (layoutId > 20000000000L) {
                tableIndexCount.getAndIncrement();
            } else {
                aggIndexCount.getAndIncrement();
            }
        });
        List<String> invalidDimensionNames = model.getAllNamedColumns().stream().filter(col -> invalidDimensions.contains(col.getId())).map(NDataModel.NamedColumn::getAliasDotColumn).collect(Collectors.toList());
        List<String> invalidMeasureNames = model.getAllMeasures().stream().filter(measure -> invalidMeasures.contains(measure.getId())).map(MeasureDesc::getName).collect(Collectors.toList());
        InvalidIndexesResponse response = new InvalidIndexesResponse();
        response.setCcList(invalidCCList);
        response.setDimensions(invalidDimensionNames);
        response.setMeasures(invalidMeasureNames);
        response.setIndexes(Lists.newArrayList((Iterable)invalidIndexes));
        response.setInvalidAggIndexCount(aggIndexCount.get());
        response.setInvalidTableIndexCount(tableIndexCount.get());
        response.setAntiFlattenLookups(Lists.newArrayList((Iterable)checker.getAntiFlattenLookups()));
        return response;
    }

    public void validatePartitionDesc(PartitionDesc partitionDesc) {
        if (partitionDesc != null) {
            if (partitionDesc.isEmpty()) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARTITION_COLUMN, MsgPicker.getMsg().getPartitionColumnNotExist());
            }
            if (!this.isSupportFormats(partitionDesc)) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.DATETIME_FORMAT_PARSE_ERROR, new Object[]{partitionDesc.getPartitionDateFormat()});
            }
            if (partitionDesc.getPartitionDateFormat() != null && !partitionDesc.partitionColumnIsTimestamp()) {
                this.validateDateTimeFormatPattern(partitionDesc.getPartitionDateFormat());
            }
        }
    }

    public void validateDateTimeFormatPattern(String pattern) {
        if (pattern.isEmpty()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.DATETIME_FORMAT_EMPTY, new Object[0]);
        }
        try {
            new SimpleDateFormat(pattern, Locale.getDefault(Locale.Category.FORMAT));
        }
        catch (IllegalArgumentException e) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.DATETIME_FORMAT_PARSE_ERROR, (Throwable)e, new Object[]{pattern});
        }
    }

    private boolean isSupportFormats(PartitionDesc partitionDesc) {
        if (partitionDesc.partitionColumnIsTimestamp()) {
            return false;
        }
        String dateFormat = partitionDesc.getPartitionDateFormat();
        Matcher matcher = QUOTE_PATTERN.matcher(dateFormat);
        while (matcher.find()) {
            dateFormat = dateFormat.replaceAll(matcher.group(), "");
        }
        for (String frontEndFormat : SUPPORTED_FORMATS) {
            dateFormat = dateFormat.replaceAll(frontEndFormat, "");
        }
        int length = dateFormat.length();
        for (int i = 0; i < length; ++i) {
            char c = dateFormat.charAt(i);
            if ((c < 'a' || c > 'z') && (c < 'A' || c > 'Z')) continue;
            return false;
        }
        return true;
    }

    private void discardInvalidDataForBrokenModel(String modelId, String project) {
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        NDataModel brokenModel = this.modelQuerySupporter.getBrokenModel(project, modelId);
        NDataModel copyForWrite = modelManager.copyForWrite(brokenModel);
        this.semanticUpdater.discardInvalidColsAndMeasForBrokenModel(project, copyForWrite);
        modelManager.updateDataBrokenModelDesc(copyForWrite);
    }

    private NDataModel convertAndInitDataModel(ModelRequest request, String project) {
        NDataModel model = this.convertToDataModel(request);
        this.semanticUpdater.discardInvalidColsAndMeasForBrokenModel(project, model);
        model.init(KylinConfig.getInstanceFromEnv(), project, ((NDataflowManager)this.getManager(NDataflowManager.class, project)).listUnderliningDataModels());
        for (ComputedColumnDesc cc : model.getComputedColumnDescs()) {
            String innerExp = cc.getInnerExpression();
            if (cc.getExpression().equalsIgnoreCase(innerExp)) {
                innerExp = PushDownUtil.massageComputedColumn((NDataModel)model, (String)project, (ComputedColumnDesc)cc, null);
            }
            cc.setInnerExpression(innerExp);
        }
        return model;
    }

    private void setRequest(ModelRequest request, NDataModel model, AffectedModelContext removeAffectedModel, AffectedModelContext changeTypeAffectedModel, String projectName) {
        request.setSimplifiedMeasures(model.getEffectiveMeasures().values().stream().filter(m -> !removeAffectedModel.getMeasures().contains(m.getId()) && !changeTypeAffectedModel.getMeasures().contains(m.getId())).map(SimplifiedMeasure::fromMeasure).collect(Collectors.toList()));
        request.setSimplifiedMeasures(request.getSimplifiedMeasures().stream().map(simplifiedMeasure -> {
            int measureId = simplifiedMeasure.getId();
            NDataModel.Measure updateMeasure = (NDataModel.Measure)changeTypeAffectedModel.getUpdateMeasureMap().get(measureId);
            if (updateMeasure != null) {
                simplifiedMeasure = SimplifiedMeasure.fromMeasure(updateMeasure);
            }
            return simplifiedMeasure;
        }).collect(Collectors.toList()));
        request.setSimplifiedDimensions(model.getAllNamedColumns().stream().filter(col -> !removeAffectedModel.getDimensions().contains(col.getId()) && col.isDimension()).collect(Collectors.toList()));
        request.setComputedColumnDescs(model.getComputedColumnDescs().stream().filter(cc -> !removeAffectedModel.getComputedColumns().contains(cc.getColumnName())).collect(Collectors.toList()));
        request.getAllNamedColumns().stream().filter(col -> removeAffectedModel.getColumns().contains(col.getId())).forEach(col -> col.setStatus(NDataModel.ColumnStatus.TOMB));
        String factTableAlias = model.getRootFactTable().getAlias();
        Set ccFullNameSet = removeAffectedModel.getComputedColumns().stream().map(ccName -> factTableAlias + "." + ccName).collect(Collectors.toSet());
        request.getAllNamedColumns().stream().filter(col -> ccFullNameSet.contains(col.getAliasDotColumn())).forEach(col -> col.setStatus(NDataModel.ColumnStatus.TOMB));
        request.setProject(projectName);
    }

    public void checkCCEmpty(ModelRequest modelRequest) {
        List<ComputedColumnDesc> ccList = modelRequest.getComputedColumnDescs();
        if (CollectionUtils.isEmpty(ccList)) {
            return;
        }
        boolean matchEmpty = ccList.stream().anyMatch(cc -> StringUtils.isEmpty((CharSequence)cc.getColumnName()) || StringUtils.isEmpty((CharSequence)cc.getExpression()));
        if (matchEmpty) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.COMPUTED_COLUMN_NAME_OR_EXPR_EMPTY, new Object[0]);
        }
    }

    public void checkSegmentOverlap(NDataModelResponse model, List<NDataSegmentResponse> segments) {
        boolean hasAnyOverlapSegment;
        if (ModelStatusToDisplayEnum.BROKEN != model.getStatus() && (hasAnyOverlapSegment = segments.stream().anyMatch(seg -> SegmentStatusEnumToDisplay.OVERLAP == seg.getStatusToDisplay()))) {
            logger.warn("model {} segments overlap found, mark as broken!", (Object)model.getId());
            model.setBroken(true);
            model.setBrokenReason(NDataModel.BrokenReason.SEGMENT_OVERLAP);
            model.setStatus(ModelStatusToDisplayEnum.BROKEN);
        }
    }

    public Pair<ModelRequest, ComputedColumnConflictResponse> checkCCConflict(ModelRequest modelRequest) {
        String project = modelRequest.getProject();
        this.validatePartitionDateColumn(modelRequest);
        NDataModel dataModel = this.semanticUpdater.convertToDataModel(modelRequest);
        NDataModelManager modelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        List ccRelatedModels = modelManager.getCCRelatedModels(dataModel);
        ComputedColumnUtil.CCConflictInfo ccConflictInfo = dataModel.checkCCFailAtEnd(this.getConfig(), project, ccRelatedModels, true);
        boolean autoAdjust = modelRequest.isComputedColumnNameAutoAdjust();
        if (ccConflictInfo.noneConflict()) {
            return Pair.newPair((Object)((Object)modelRequest), (Object)new ComputedColumnConflictResponse());
        }
        if (ccConflictInfo.hasSameNameConflict()) {
            ComputedColumnConflictResponse response = this.handleOnConflictResponse(ccConflictInfo.getAllConflictException());
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.COMPUTED_COLUMN_CONFLICT, new Object[0]).withData((Object)response);
        }
        if (!autoAdjust) {
            ComputedColumnConflictResponse response = this.handleOnConflictResponse(ccConflictInfo.getSameExprConflictException());
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.COMPUTED_COLUMN_CONFLICT, new Object[0]).withData((Object)response);
        }
        ArrayList inputCCDescList = Lists.newArrayList(modelRequest.getComputedColumnDescs());
        Pair pair = ccConflictInfo.getAdjustedCCList((List)inputCCDescList);
        List<KylinException> adjustExceptions = ((List)pair.getSecond()).stream().map(ComputedColumnUtil.CCConflictDetail::getAdjustKylinException).collect(Collectors.toList());
        ModelRequest resultModelRequest = this.adjustModelRequestCCName(modelRequest, (Pair<List<ComputedColumnDesc>, List<ComputedColumnUtil.CCConflictDetail>>)pair);
        return Pair.newPair((Object)((Object)resultModelRequest), (Object)this.handleOnConflictResponse(adjustExceptions));
    }

    public ModelRequest adjustModelRequestCCName(ModelRequest modelRequest, Pair<List<ComputedColumnDesc>, List<ComputedColumnUtil.CCConflictDetail>> pair) {
        List adjustDetails = (List)pair.getSecond();
        modelRequest.setComputedColumnDescs((List)pair.getFirst());
        List<NDataModel.NamedColumn> dimensions = modelRequest.getSimplifiedDimensions();
        List<SimplifiedMeasure> measures = modelRequest.getSimplifiedMeasures();
        for (ComputedColumnUtil.CCConflictDetail detail : adjustDetails) {
            String newCCFullName = detail.getNewCC().getFullName();
            String existingCCFullName = detail.getExistingCC().getFullName();
            dimensions.stream().filter(NDataModel.NamedColumn::isExist).filter(d -> StringUtils.equalsIgnoreCase((CharSequence)d.getAliasDotColumn(), (CharSequence)newCCFullName)).forEach(d -> d.setAliasDotColumn(existingCCFullName));
            measures.forEach(m -> m.getParameterValue().stream().filter(pr -> StringUtils.equalsIgnoreCase((CharSequence)pr.getType(), (CharSequence)"column")).filter(pr -> StringUtils.equalsIgnoreCase((CharSequence)pr.getValue(), (CharSequence)newCCFullName)).forEach(pr -> pr.setValue(existingCCFullName)));
        }
        String filterCondition = modelRequest.getFilterCondition();
        if (StringUtils.isEmpty((CharSequence)filterCondition)) {
            return modelRequest;
        }
        for (ComputedColumnUtil.CCConflictDetail detail : adjustDetails) {
            String newCCFullName = detail.getNewCC().getFullName();
            String existingCCFullName = detail.getExistingCC().getFullName();
            if (!StringUtils.containsIgnoreCase((CharSequence)filterCondition, (CharSequence)newCCFullName)) continue;
            filterCondition = this.replaceAllIgnoreCase(filterCondition, newCCFullName, existingCCFullName);
        }
        modelRequest.setFilterCondition(filterCondition);
        return modelRequest;
    }

    public String replaceAllIgnoreCase(String input, String regex, String replacement) {
        return Pattern.compile(regex, 2).matcher(input).replaceAll(replacement);
    }

    public ComputedColumnConflictResponse handleOnConflictResponse(List<KylinException> exceptionList) {
        ComputedColumnConflictResponse response = new ComputedColumnConflictResponse();
        exceptionList.stream().filter(Objects::nonNull).forEach(e -> {
            ErrorCodeProducer producer = e.getErrorCodeProducer();
            String code = producer.getErrorCode().getCode();
            String msg = producer.getMsg(e.getArgs());
            response.addConflictDetail(code, msg);
        });
        return response;
    }

    public boolean isAutoIndexPlanEnabled(String project, String modelId) {
        if (this.modelSmartServiceSupporter == null) {
            return false;
        }
        return this.modelSmartServiceSupporter.isAutoIndexPlanEnabled(modelId, project);
    }

    public void onUpdateBrokenModel(NDataModel model, AffectedModelContext removeAffectedModel, AffectedModelContext changeTypeAffectedModel, String projectName) throws Exception {
        ModelRequest request = new ModelRequest((NDataModel)JsonUtil.deepCopy((Object)model, NDataModel.class));
        this.setRequest(request, model, removeAffectedModel, changeTypeAffectedModel, projectName);
        this.updateBrokenModel(projectName, request, removeAffectedModel.getColumns());
    }

    public void onUpdateDataModel(NDataModel model, AffectedModelContext removeAffectedModel, AffectedModelContext changeTypeAffectedModel, String projectName, TableDesc tableDesc) throws Exception {
        ModelRequest request = new ModelRequest((NDataModel)JsonUtil.deepCopy((Object)model, NDataModel.class));
        this.setRequest(request, model, removeAffectedModel, changeTypeAffectedModel, projectName);
        request.setColumnsFetcher((tableRef, isFilterCC) -> TableRef.filterColumns((TableDesc)(tableRef.getIdentity().equals(tableDesc.getIdentity()) ? tableDesc : tableRef), (boolean)isFilterCC));
        this.updateDataModelSemantic(projectName, request, false);
    }

    public NDataModel onGetModelByAlias(String modelAlias, String project) {
        return this.getModelByAlias(modelAlias, project);
    }

    public NDataModel onGetModelById(String modelId, String project) {
        return this.getModelById(modelId, project);
    }

    public void onModelUpdate(String project, String modelId) {
        this.modelChangeSupporters.forEach(listener -> listener.onUpdate(project, modelId));
    }

    public void onUpdateSCD2ModelStatus(String project, RealizationStatusEnum status) {
        this.updateSCD2ModelStatusInProjectById(project, ModelStatusToDisplayEnum.convert(status));
    }

    public void onOfflineMultiPartitionModels(String project) {
        this.offlineMultiPartitionModelsInProject(project);
    }

    @Generated
    public void setSemanticUpdater(ModelSemanticHelper semanticUpdater) {
        this.semanticUpdater = semanticUpdater;
    }

    @Generated
    public void setModelQuerySupporter(ModelQuerySupporter modelQuerySupporter) {
        this.modelQuerySupporter = modelQuerySupporter;
    }

    @Generated
    public void setIndexPlanService(IndexPlanService indexPlanService) {
        this.indexPlanService = indexPlanService;
    }

    @Generated
    public void setModelChangeSupporters(List<ModelChangeSupporter> modelChangeSupporters) {
        this.modelChangeSupporters = modelChangeSupporters;
    }
}

