/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.InMemResourceStore;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.metadata.FileSystemMetadataStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.MetadataChecker;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.apache.kylin.helper.RoutineToolHelper;
import org.apache.kylin.metadata.Manager;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.model.CcModelRelationDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnManager;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.SegmentConfig;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.schema.ImportModelContext;
import org.apache.kylin.metadata.model.schema.ModelImportChecker;
import org.apache.kylin.metadata.model.schema.SchemaChangeCheckResult;
import org.apache.kylin.metadata.model.schema.SchemaNodeType;
import org.apache.kylin.metadata.model.schema.SchemaUtil;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.recommendation.candidate.JdbcRawRecStore;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.candidate.RawRecManager;
import org.apache.kylin.metadata.recommendation.entity.RecItemSet;
import org.apache.kylin.metadata.recommendation.ref.OptRecManagerV2;
import org.apache.kylin.metadata.recommendation.ref.OptRecV2;
import org.apache.kylin.metadata.table.ATable;
import org.apache.kylin.metadata.view.LogicalView;
import org.apache.kylin.metadata.view.LogicalViewManager;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.constant.ModelStatusToDisplayEnum;
import org.apache.kylin.rest.request.ModelImportRequest;
import org.apache.kylin.rest.request.StorageCleanupRequest;
import org.apache.kylin.rest.request.UpdateRuleBasedCuboidRequest;
import org.apache.kylin.rest.response.LoadTableResponse;
import org.apache.kylin.rest.response.ModelPreviewResponse;
import org.apache.kylin.rest.response.SimplifiedTablePreviewResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.IndexPlanService;
import org.apache.kylin.rest.service.ModelChangeSupporter;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.RouteService;
import org.apache.kylin.rest.service.TableExtService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceFactory;
import org.apache.kylin.tool.garbage.CleanTaskExecutorService;
import org.apache.kylin.tool.util.HashFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="metaStoreService")
public class MetaStoreService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(MetaStoreService.class);
    private static final String BASE_CUBOID_ALWAYS_VALID_KEY = "kylin.cube.aggrgroup.is-base-cuboid-always-valid";
    private static final Pattern MD5_PATTERN = Pattern.compile(".*([a-fA-F\\d]{32})\\.zip");
    private static final String RULE_SCHEDULER_DATA_KEY = "kylin.index.rule-scheduler-data";
    @Autowired
    public AclEvaluate aclEvaluate;
    @Autowired
    public ModelService modelService;
    @Autowired
    public IndexPlanService indexPlanService;
    @Autowired
    public TableExtService tableExtService;
    @Autowired
    private RouteService routeService;
    @Autowired(required=false)
    private List<ModelChangeSupporter> modelChangeSupporters = Lists.newArrayList();

    public List<ModelPreviewResponse> getPreviewModels(String project, List<String> ids) {
        this.aclEvaluate.checkProjectWritePermission(project);
        return ((NDataflowManager)this.modelService.getManager(NDataflowManager.class, project)).listAllDataflows(true).stream().filter(df -> ids.isEmpty() || ids.contains(df.getUuid())).map(df -> {
            if (df.checkBrokenWithRelatedInfo()) {
                NDataModel dataModel = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDescWithoutInit(df.getUuid());
                dataModel.setBroken(true);
                return dataModel;
            }
            return df.getModel();
        }).filter(model -> !model.isFusionModel() && model.getModelType() != NDataModel.ModelType.STREAMING).map(modelDesc -> this.getSimplifiedModelResponse(project, (NDataModel)modelDesc)).collect(Collectors.toList());
    }

    private ModelPreviewResponse getSimplifiedModelResponse(String project, NDataModel modelDesc) {
        NIndexPlanManager indexPlanManager;
        IndexPlan indexPlan;
        int rawRecItemCount;
        NProjectManager projectManager = (NProjectManager)this.getManager(NProjectManager.class);
        ProjectInstance projectInstance = projectManager.getProject(project);
        ModelPreviewResponse modelPreviewResponse = new ModelPreviewResponse();
        modelPreviewResponse.setName(modelDesc.getAlias());
        modelPreviewResponse.setUuid(modelDesc.getUuid());
        NDataflowManager dfManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)modelDesc.getProject());
        if (modelDesc.isBroken()) {
            modelPreviewResponse.setStatus(ModelStatusToDisplayEnum.BROKEN);
            return modelPreviewResponse;
        }
        long inconsistentSegmentCount = dfManager.getDataflow(modelDesc.getId()).getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.WARNING}).size();
        ModelStatusToDisplayEnum status = this.modelService.convertModelStatusToDisplay(modelDesc, modelDesc.getProject(), inconsistentSegmentCount);
        modelPreviewResponse.setStatus(status);
        if (!projectInstance.isExpertMode() && (rawRecItemCount = this.modelChangeSupporters.stream().map(listener -> listener.getRecItemSize(project, modelDesc.getUuid())).reduce((a, b) -> a + b).orElse(0).intValue()) > 0) {
            modelPreviewResponse.setHasRecommendation(true);
        }
        if (projectInstance.getConfig().isMultiPartitionEnabled() && modelDesc.isMultiPartitionModel()) {
            modelPreviewResponse.setHasMultiplePartitionValues(!modelDesc.getMultiPartitionDesc().getPartitions().isEmpty());
        }
        if (!this.isEmptyAfterExcludeBlockData(indexPlan = (indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, modelDesc.getProject())).getIndexPlan(modelDesc.getUuid())) || modelDesc.getSegmentConfig() != null && modelDesc.getSegmentConfig().getAutoMergeEnabled() != null && modelDesc.getSegmentConfig().getAutoMergeEnabled().booleanValue()) {
            modelPreviewResponse.setHasOverrideProps(true);
        }
        ArrayList<SimplifiedTablePreviewResponse> tables = new ArrayList<SimplifiedTablePreviewResponse>();
        SimplifiedTablePreviewResponse factTable = new SimplifiedTablePreviewResponse(modelDesc.getRootFactTableName(), NDataModel.TableKind.FACT);
        tables.add(factTable);
        List joinTableDescs = modelDesc.getJoinTables();
        for (JoinTableDesc joinTableDesc : joinTableDescs) {
            SimplifiedTablePreviewResponse lookupTable = new SimplifiedTablePreviewResponse(joinTableDesc.getTable(), joinTableDesc.getKind());
            tables.add(lookupTable);
        }
        modelPreviewResponse.setTables(tables);
        return modelPreviewResponse;
    }

    private boolean isEmptyAfterExcludeBlockData(IndexPlan indexPlan) {
        LinkedHashMap overrideProps = indexPlan.getOverrideProps();
        boolean isEmpty = overrideProps.isEmpty();
        if (overrideProps.size() == 1 && overrideProps.containsKey(RULE_SCHEDULER_DATA_KEY)) {
            isEmpty = true;
        }
        return isEmpty;
    }

    public ByteArrayOutputStream getCompressedModelMetadata(String project, List<String> modelList, boolean exportRecommendations, boolean exportOverProps, boolean exportMultiplePartition) throws Exception {
        this.aclEvaluate.checkProjectWritePermission(project);
        NDataModelManager modelManager = (NDataModelManager)this.modelService.getManager(NDataModelManager.class, project);
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.modelService.getManager(NIndexPlanManager.class, project);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);){
            ResourceStore oldResourceStore = modelManager.getStore();
            KylinConfig newConfig = KylinConfig.createKylinConfig((KylinConfig)KylinConfig.getInstanceFromEnv());
            InMemResourceStore newResourceStore = new InMemResourceStore(newConfig);
            ResourceStore.setRS((KylinConfig)newConfig, (ResourceStore)newResourceStore);
            RawResourceFilter projectFilter = RawResourceFilter.equalFilter((String)"project", (String)project);
            for (String modelId : modelList) {
                NDataModel dataModelDesc = modelManager.getDataModelDesc(modelId);
                if (Objects.isNull(dataModelDesc)) {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_ID_NOT_EXIST, new Object[]{modelId});
                }
                if (dataModelDesc.isBroken()) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_EXPORT_ERROR, String.format(Locale.ROOT, MsgPicker.getMsg().getExportBrokenModel(), modelId));
                }
                NDataModel modelDesc = modelManager.copyForWrite(dataModelDesc);
                IndexPlan copyIndexPlan = indexPlanManager.copy(indexPlanManager.getIndexPlan(modelId));
                if (!exportOverProps) {
                    LinkedHashMap overridePropes = Maps.newLinkedHashMap();
                    if (copyIndexPlan.getOverrideProps().get(BASE_CUBOID_ALWAYS_VALID_KEY) != null) {
                        overridePropes.put(BASE_CUBOID_ALWAYS_VALID_KEY, copyIndexPlan.getOverrideProps().get(BASE_CUBOID_ALWAYS_VALID_KEY));
                    }
                    if (copyIndexPlan.getOverrideProps().containsKey(RULE_SCHEDULER_DATA_KEY)) {
                        overridePropes.put(RULE_SCHEDULER_DATA_KEY, copyIndexPlan.getOverrideProps().get(RULE_SCHEDULER_DATA_KEY));
                    }
                    copyIndexPlan.setOverrideProps((Map)overridePropes);
                    modelDesc.setSegmentConfig(new SegmentConfig());
                }
                if (!exportMultiplePartition && modelDesc.isMultiPartitionModel()) {
                    modelDesc.setMultiPartitionDesc(new MultiPartitionDesc(modelDesc.getMultiPartitionDesc().getColumns()));
                }
                newResourceStore.putResourceWithoutCheck(modelDesc.getResourcePath(), ByteSource.wrap((byte[])JsonUtil.writeValueAsIndentBytes((Object)modelDesc)), modelDesc.getLastModified(), modelDesc.getMvcc());
                newResourceStore.putResourceWithoutCheck(copyIndexPlan.getResourcePath(), ByteSource.wrap((byte[])JsonUtil.writeValueAsIndentBytes((Object)copyIndexPlan)), copyIndexPlan.getLastModified(), copyIndexPlan.getMvcc());
                Set<String> tables = modelDesc.getAllTables().stream().map(TableRef::getTableDesc).map(RootPersistentEntity::getResourcePath).filter(arg_0 -> MetaStoreService.lambda$getCompressedModelMetadata$6((ResourceStore)newResourceStore, projectFilter, arg_0)).collect(Collectors.toSet());
                tables.forEach(arg_0 -> MetaStoreService.lambda$getCompressedModelMetadata$7(oldResourceStore, (ResourceStore)newResourceStore, arg_0));
                if (!exportRecommendations) continue;
                this.exportRecommendations(project, modelId, (ResourceStore)newResourceStore);
            }
            if (CollectionUtils.isEmpty((Collection)newResourceStore.listResourcesRecursively(MetadataType.MODEL.name()))) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_METADATA_FILE_ERROR, MsgPicker.getMsg().getExportAtLeastOneModel());
            }
            this.addComputedColumns(project, modelList, (ResourceStore)newResourceStore);
            String version = System.getProperty("ke.version") == null ? "unknown" : System.getProperty("ke.version");
            StringEntity versionEntity = new StringEntity("VERSION", version);
            newResourceStore.putResourceWithoutCheck(ResourceStore.VERSION_FILE, ByteSource.wrap((byte[])JsonUtil.writeValueAsIndentBytes((Object)versionEntity)), System.currentTimeMillis(), -1L);
            oldResourceStore.copy(ResourceStore.METASTORE_UUID_TAG, (ResourceStore)newResourceStore);
            this.writeMetadataToZipOutputStream(zipOutputStream, (ResourceStore)newResourceStore);
        }
        return byteArrayOutputStream;
    }

    private void addComputedColumns(String project, List<String> modelList, ResourceStore newResourceStore) throws JsonProcessingException {
        ComputedColumnManager ccManager = (ComputedColumnManager)this.modelService.getManager(ComputedColumnManager.class, project);
        Manager relationManager = Manager.getInstance((KylinConfig)this.getConfig(), (String)project, CcModelRelationDesc.class);
        List relations = relationManager.listByFilter(new RawResourceFilter().addConditions("modelUuid", new ArrayList<String>(modelList), RawResourceFilter.Operator.IN));
        List usedCcs = ccManager.listByFilter(new RawResourceFilter().addConditions("metaKey", relations.stream().map(CcModelRelationDesc::getCcUuid).collect(Collectors.toList()), RawResourceFilter.Operator.IN));
        for (ComputedColumnDesc cc : usedCcs) {
            newResourceStore.putResourceWithoutCheck(cc.getResourcePath(), ByteSource.wrap((byte[])JsonUtil.writeValueAsIndentBytes((Object)cc)), cc.getLastModified(), cc.getMvcc());
        }
    }

    private void exportRecommendations(String project, String modelId, ResourceStore resourceStore) throws Exception {
        NProjectManager projectManager = (NProjectManager)this.getManager(NProjectManager.class);
        ProjectInstance projectInstance = projectManager.getProject(project);
        if (projectInstance.isExpertMode()) {
            logger.info("Skip export recommendations because project {} is expert mode.", (Object)project);
            return;
        }
        JdbcRawRecStore jdbcRawRecStore = new JdbcRawRecStore(KylinConfig.getInstanceFromEnv());
        OptRecV2 optRecV2 = OptRecManagerV2.getInstance((String)project).loadOptRecV2(modelId);
        Set rawRecIds = Stream.of(optRecV2.getCcRefs().keySet(), optRecV2.getMeasureRefs().keySet(), optRecV2.getDimensionRefs().keySet(), optRecV2.getAdditionalLayoutRefs().keySet(), optRecV2.getRemovalLayoutRefs().keySet()).flatMap(Collection::stream).filter(dependId -> dependId < 0).map(dependId -> -dependId.intValue()).filter(dependId -> !optRecV2.getBrokenRefIds().contains(dependId)).collect(Collectors.toSet());
        if (rawRecIds.isEmpty()) {
            return;
        }
        List rawRecItems = jdbcRawRecStore.list(rawRecIds).stream().sorted(Comparator.comparingInt(RawRecItem::getId)).collect(Collectors.toList());
        RecItemSet recEntity = new RecItemSet(modelId, project, rawRecItems);
        resourceStore.putResourceWithoutCheck(recEntity.getResourcePath(), ByteSource.wrap((byte[])JsonUtil.writeValueAsIndentBytes((Object)recEntity)), System.currentTimeMillis(), -1L);
    }

    private void writeMetadataToZipOutputStream(ZipOutputStream zipOutputStream, ResourceStore resourceStore) throws IOException {
        for (String resPath : resourceStore.listResourcesRecursively(MetadataType.ALL.name())) {
            zipOutputStream.putNextEntry(new ZipEntry(resPath + ".json"));
            zipOutputStream.write(resourceStore.getResource(resPath).getByteSource().read());
        }
    }

    @VisibleForTesting
    protected static Map<String, RawResource> getRawResourceFromUploadFile(MultipartFile uploadFile) throws IOException {
        Map resourceMap = FileSystemMetadataStore.getFilesFromCompressedFileByStream((InputStream)uploadFile.getInputStream(), (FileSystemMetadataStore.CompressHandlerInterface)new FileSystemMetadataStore.CompressHandler());
        HashMap filesFromCompressedFile = Maps.newHashMap();
        resourceMap.forEach((k, v) -> filesFromCompressedFile.put(k.replaceAll(".json", ""), v));
        return filesFromCompressedFile;
    }

    private ImportModelContext getImportModelContext(String targetProject, Map<String, RawResource> rawResourceMap, ModelImportRequest request) {
        String srcProject = MetaStoreService.getModelMetadataProjectName(rawResourceMap);
        if (request != null) {
            Map<String, String> newModels = request.getModels().stream().filter(modelImport -> modelImport.getImportType() == ModelImportRequest.ImportType.NEW).collect(Collectors.toMap(ModelImportRequest.ModelImport::getOriginalName, ModelImportRequest.ModelImport::getTargetName));
            List unImportModels = request.getModels().stream().filter(modelImport -> modelImport.getImportType() == ModelImportRequest.ImportType.UN_IMPORT).map(ModelImportRequest.ModelImport::getOriginalName).collect(Collectors.toList());
            return new ImportModelContext(targetProject, srcProject, rawResourceMap, newModels, unImportModels);
        }
        return new ImportModelContext(targetProject, srcProject, rawResourceMap);
    }

    public SchemaChangeCheckResult checkModelMetadata(String targetProject, MultipartFile uploadFile, ModelImportRequest request) throws IOException {
        Throwable throwable;
        String originalFilename = uploadFile.getOriginalFilename();
        Matcher matcher = MD5_PATTERN.matcher(originalFilename);
        boolean valid = false;
        if (matcher.matches()) {
            String signature = matcher.group(1);
            throwable = null;
            try (InputStream inputStream = uploadFile.getInputStream();){
                byte[] md5 = HashFunction.MD5.checksum(inputStream);
                valid = StringUtils.equalsIgnoreCase((CharSequence)signature, (CharSequence)DatatypeConverter.printHexBinary((byte[])md5));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if (!valid) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_METADATA_FILE_ERROR, MsgPicker.getMsg().getIllegalModelMetadataFile());
        }
        Map<String, RawResource> rawResourceMap = MetaStoreService.getRawResourceFromUploadFile(uploadFile);
        throwable = null;
        try (ImportModelContext context = this.getImportModelContext(targetProject, rawResourceMap, request);){
            SchemaChangeCheckResult schemaChangeCheckResult = this.checkModelMetadata(targetProject, context, uploadFile);
            return schemaChangeCheckResult;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    public SchemaChangeCheckResult checkModelMetadata(String targetProject, ImportModelContext context, MultipartFile uploadFile) throws IOException {
        KylinConfig targetKylinConfig = context.getTargetKylinConfig();
        Map<String, RawResource> rawResourceMap = MetaStoreService.getRawResourceFromUploadFile(uploadFile);
        this.checkModelMetadataFile(ResourceStore.getKylinMetaStore((KylinConfig)targetKylinConfig).getMetadataStore(), rawResourceMap.keySet());
        List<TableDesc> existTableList = this.searchTablesInDataSource(targetProject, context.getTargetMissTableList());
        SchemaUtil.SchemaDifference diff = SchemaUtil.diff((String)targetProject, (KylinConfig)KylinConfig.getInstanceFromEnv(), (KylinConfig)targetKylinConfig, existTableList);
        SchemaChangeCheckResult checkResult = ModelImportChecker.check((SchemaUtil.SchemaDifference)diff, (ImportModelContext)context);
        checkResult.getExistTableList().addAll(existTableList);
        return checkResult;
    }

    public List<TableDesc> searchTablesInDataSource(String targetProject, List<TableDesc> missTableList) {
        if (CollectionUtils.isEmpty(missTableList)) {
            return Collections.emptyList();
        }
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(targetProject);
        ISourceMetadataExplorer explorer = SourceFactory.getSource((ISourceAware)projectInstance).getSourceMetadataExplorer();
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ArrayList existTableSet = Lists.newArrayList();
        for (TableDesc missTableDesc : missTableList) {
            LogicalView logicalView;
            try {
                TableDesc newTableDesc = (TableDesc)explorer.loadTableMetadata(missTableDesc.getDatabase(), missTableDesc.getName(), targetProject).getFirst();
                newTableDesc.init(targetProject);
                existTableSet.add(newTableDesc);
            }
            catch (Exception e) {
                logger.warn("try load table: {} failed.", (Object)missTableDesc.getIdentity(), (Object)e);
            }
            if (!config.isDDLLogicalViewEnabled() || !missTableDesc.isLogicalView() || (logicalView = LogicalViewManager.getInstance((KylinConfig)config).get(missTableDesc.getName())) == null || targetProject.equalsIgnoreCase(logicalView.getCreatedProject())) continue;
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_CREATE_MODEL, String.format(Locale.ROOT, " Logical View %s can only add in project %s", missTableDesc.getName(), logicalView.getCreatedProject()));
        }
        return existTableSet;
    }

    private void checkModelMetadataFile(MetadataStore metadataStore, Set<String> rawResourceList) {
        MetadataChecker metadataChecker = new MetadataChecker(metadataStore);
        MetadataChecker.VerifyResult verifyResult = metadataChecker.verifyModelMetadata((List)Lists.newArrayList(rawResourceList));
        if (!verifyResult.isModelMetadataQualified()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_METADATA_FILE_ERROR, MsgPicker.getMsg().getModelMetadataPackageInvalid());
        }
    }

    @VisibleForTesting
    public static String getModelMetadataProjectName(Map<String, RawResource> rawResourceMap) {
        RawResource raw = rawResourceMap.values().stream().filter(rawResource -> rawResource != null && rawResource.getProject() != null && rawResource.getMetaType() == MetadataType.MODEL).findAny().orElse(null);
        if (raw == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_METADATA_FILE_ERROR, MsgPicker.getMsg().getModelMetadataPackageInvalid());
        }
        return raw.getProject();
    }

    private void createNewModel(NDataModel nDataModel, ModelImportRequest.ModelImport modelImport, String project, NIndexPlanManager importIndexPlanManager) {
        NDataModelManager dataModelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        nDataModel.setProject(project);
        nDataModel.setAlias(modelImport.getTargetName());
        nDataModel.setUuid(RandomUtil.randomUUIDStr());
        nDataModel.setLastModified(System.currentTimeMillis());
        nDataModel.setMvcc(-1L);
        dataModelManager.createDataModelDesc(nDataModel, AclPermissionUtil.getCurrentUsername());
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        IndexPlan indexPlan = importIndexPlanManager.getIndexPlanByModelAlias(modelImport.getTargetName()).copy();
        indexPlan.setUuid(nDataModel.getUuid());
        indexPlan = indexPlanManager.copy(indexPlan);
        indexPlan.setLastModified(System.currentTimeMillis());
        indexPlan.setMvcc(-1L);
        indexPlanManager.createIndexPlan(indexPlan);
        dataflowManager.createDataflow(indexPlan, nDataModel.getOwner(), RealizationStatusEnum.OFFLINE);
        this.indexPlanService.checkPartitionDimensionForV3Storage(project, nDataModel.getId(), this.getConfig());
    }

    private void updateModel(String project, NDataModel nDataModel, ModelImportRequest.ModelImport modelImport, boolean hasModelOverrideProps) {
        NDataModelManager dataModelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        NDataModel originalDataModel = dataModelManager.getDataModelDescByAlias(modelImport.getOriginalName());
        nDataModel.setProject(project);
        nDataModel.setUuid(originalDataModel.getUuid());
        nDataModel.setLastModified(System.currentTimeMillis());
        if (nDataModel.isMultiPartitionModel()) {
            if (!nDataModel.getMultiPartitionDesc().getPartitions().isEmpty()) {
                originalDataModel = this.modelService.batchUpdateMultiPartition(project, nDataModel.getUuid(), nDataModel.getMultiPartitionDesc().getPartitions().stream().map(MultiPartitionDesc.PartitionInfo::getValues).collect(Collectors.toList()));
            } else {
                nDataModel.setMultiPartitionKeyMapping(originalDataModel.getMultiPartitionKeyMapping());
            }
            nDataModel.setMultiPartitionDesc(originalDataModel.getMultiPartitionDesc());
        }
        if (!hasModelOverrideProps) {
            nDataModel.setSegmentConfig(originalDataModel.getSegmentConfig());
        }
        nDataModel.setMvcc(originalDataModel.getMvcc());
        dataModelManager.updateDataModelDesc(nDataModel);
    }

    private void updateIndexPlan(String project, NDataModel nDataModel, IndexPlan targetIndexPlan, boolean hasModelOverrideProps) {
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
        indexPlanManager.updateIndexPlan(nDataModel.getUuid(), copyForWrite -> {
            List toBeDeletedIndexes = copyForWrite.getToBeDeletedIndexes();
            toBeDeletedIndexes.clear();
            toBeDeletedIndexes.addAll(targetIndexPlan.getToBeDeletedIndexes());
            copyForWrite.updateNextId();
        });
        if (targetIndexPlan.getRuleBasedIndex() != null) {
            this.indexPlanService.updateRuleBasedCuboid(project, UpdateRuleBasedCuboidRequest.convertToRequest(project, nDataModel.getUuid(), false, targetIndexPlan.getRuleBasedIndex()));
        } else {
            this.indexPlanService.updateRuleBasedCuboid(project, UpdateRuleBasedCuboidRequest.convertToRequest(project, nDataModel.getUuid(), false, new RuleBasedIndex()));
        }
        indexPlanManager.updateIndexPlan(nDataModel.getUuid(), copyForWrite -> {
            if (hasModelOverrideProps) {
                copyForWrite.setOverrideProps((Map)targetIndexPlan.getOverrideProps());
            }
            if (targetIndexPlan.getAggShardByColumns() != null) {
                copyForWrite.setRuleBasedIndex(targetIndexPlan.getRuleBasedIndex());
                copyForWrite.setAggShardByColumns(targetIndexPlan.getAggShardByColumns());
            }
        });
    }

    private void removeIndexes(String project, SchemaChangeCheckResult.ModelSchemaChange modelSchemaChange, IndexPlan targetIndexPlan) {
        if (modelSchemaChange != null) {
            Set<SchemaChangeCheckResult.ChangedItem> newLockedItems = modelSchemaChange.getNewItems().stream().filter(item -> item.getType() == SchemaNodeType.TO_BE_DELETED_INDEX).collect(Collectors.toSet());
            HashMap newLockedItemKeyAttrMap = Maps.newHashMap();
            newLockedItems.forEach(newLockedItem -> newLockedItemKeyAttrMap.put(newLockedItem.getSchemaNode().getKey(), newLockedItem.getAttributes()));
            Set<Long> toBeRemovedIndexes = Stream.concat(modelSchemaChange.getReduceItems().stream().filter(schemaChange -> schemaChange.getType() == SchemaNodeType.WHITE_LIST_INDEX || schemaChange.getType() == SchemaNodeType.RULE_BASED_INDEX).filter(schemaChange -> {
                String reduceItemKey = schemaChange.getSchemaNode().getKey();
                Map reduceItemAttr = schemaChange.getAttributes();
                return !reduceItemAttr.equals(newLockedItemKeyAttrMap.get(reduceItemKey));
            }).map(SchemaChangeCheckResult.ChangedItem::getDetail), modelSchemaChange.getUpdateItems().stream().filter(schemaUpdate -> schemaUpdate.getType() == SchemaNodeType.WHITE_LIST_INDEX || schemaUpdate.getType() == SchemaNodeType.RULE_BASED_INDEX).map(SchemaChangeCheckResult.UpdatedItem::getFirstDetail)).map(Long::parseLong).collect(Collectors.toSet());
            if (!toBeRemovedIndexes.isEmpty()) {
                this.indexPlanService.removeIndexes(project, targetIndexPlan.getId(), toBeRemovedIndexes);
            }
            Set<Long> newLockedIndexIds = newLockedItems.stream().map(SchemaChangeCheckResult.ChangedItem::getDetail).map(Long::parseLong).collect(Collectors.toSet());
            this.removeLockedLayoutFromIndexes(newLockedIndexIds, targetIndexPlan, project);
        }
    }

    private void removeLockedLayoutFromIndexes(Set<Long> newLockedIndexIds, IndexPlan targetIndexPlan, String project) {
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)this.getConfig(), (String)project);
        indexPlanManager.updateIndexPlan(targetIndexPlan.getId(), copyForWrite -> {
            copyForWrite.removeLayouts(newLockedIndexIds, true, true);
            List toBeDeletedIndexes = copyForWrite.getToBeDeletedIndexes();
            toBeDeletedIndexes.clear();
            toBeDeletedIndexes.addAll(targetIndexPlan.getToBeDeletedIndexes());
        });
    }

    private void addWhiteListIndex(String project, SchemaChangeCheckResult.ModelSchemaChange modelSchemaChange, IndexPlan targetIndexPlan) {
        if (modelSchemaChange != null) {
            List newIndexes = Stream.concat(modelSchemaChange.getNewItems().stream().filter(schemaChange -> schemaChange.getType() == SchemaNodeType.WHITE_LIST_INDEX).map(SchemaChangeCheckResult.ChangedItem::getDetail), modelSchemaChange.getUpdateItems().stream().filter(schemaUpdate -> schemaUpdate.getType() == SchemaNodeType.WHITE_LIST_INDEX).map(SchemaChangeCheckResult.UpdatedItem::getSecondDetail)).map(Long::parseLong).collect(Collectors.toList());
            NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            indexPlanManager.updateIndexPlan(targetIndexPlan.getUuid(), copyForWrite -> {
                IndexPlan.IndexPlanUpdateHandler updateHandler = copyForWrite.createUpdateHandler();
                targetIndexPlan.getWhitelistLayouts().stream().filter(layout -> newIndexes.contains(layout.getId())).forEach(layout -> updateHandler.add(layout, IndexEntity.isAggIndex((long)layout.getId())));
                updateHandler.complete();
            });
        }
    }

    private void addRuleBasedIndex(String project, SchemaChangeCheckResult.ModelSchemaChange modelSchemaChange, IndexPlan targetIndexPlan) {
        if (modelSchemaChange != null) {
            List newIndexes = Stream.concat(modelSchemaChange.getNewItems().stream().filter(schemaChange -> schemaChange.getType() == SchemaNodeType.RULE_BASED_INDEX).map(SchemaChangeCheckResult.ChangedItem::getDetail), modelSchemaChange.getUpdateItems().stream().filter(schemaUpdate -> schemaUpdate.getType() == SchemaNodeType.RULE_BASED_INDEX).map(SchemaChangeCheckResult.UpdatedItem::getSecondDetail)).map(Long::parseLong).collect(Collectors.toList());
            NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            indexPlanManager.updateIndexPlan(targetIndexPlan.getUuid(), copyForWrite -> {
                IndexPlan.IndexPlanUpdateHandler updateHandler = copyForWrite.createUpdateHandler();
                targetIndexPlan.getRuleBaseLayouts().stream().filter(layout -> newIndexes.contains(layout.getId())).forEach(layout -> updateHandler.add(layout, IndexEntity.isAggIndex((long)layout.getId())));
                updateHandler.complete();
            });
        }
    }

    @Transaction(project=0, retry=1)
    public void importModelMetadata(String project, MultipartFile metadataFile, ModelImportRequest request) throws Exception {
        this.aclEvaluate.checkProjectWritePermission(project);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Map<String, RawResource> rawResourceMap = MetaStoreService.getRawResourceFromUploadFile(metadataFile);
        try (ImportModelContext importModelContext = this.getImportModelContext(project, rawResourceMap, request);){
            this.innerImportModelMetadata(project, metadataFile, request, importModelContext, exceptions);
        }
        if (!exceptions.isEmpty()) {
            String details = exceptions.stream().map(Throwable::getMessage).collect(Collectors.joining("\n"));
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_IMPORT_ERROR, String.format(Locale.ROOT, "%s%n%s", MsgPicker.getMsg().getImportModelException(), details), exceptions);
        }
    }

    public LoadTableResponse innerLoadTables(String project, Set<String> needLoadTables) throws Exception {
        return this.tableExtService.loadDbTables(needLoadTables.toArray(new String[0]), project, false);
    }

    public Pair<Set<String>, Map<String, Set<String>>> checkNewModelTables(SchemaChangeCheckResult checkResult, ModelImportRequest request) {
        List existTableList = checkResult.getExistTableList().stream().map(ATable::getIdentity).collect(Collectors.toList());
        List newImportModelList = request.getModels().stream().filter(modelRequest -> modelRequest.getImportType() == ModelImportRequest.ImportType.NEW).map(ModelImportRequest.ModelImport::getTargetName).collect(Collectors.toList());
        HashSet needLoadTableSet = Sets.newHashSet();
        HashMap modelTablesMap = Maps.newHashMap();
        checkResult.getModels().forEach((modelName, change) -> {
            if (!newImportModelList.contains(modelName) || !change.creatable()) {
                return;
            }
            HashSet modelTables = Sets.newHashSet();
            change.getNewItems().stream().filter(item -> item.getSchemaNode().getType() == SchemaNodeType.MODEL_DIM || item.getSchemaNode().getType() == SchemaNodeType.MODEL_FACT).map(SchemaChangeCheckResult.ChangedItem::getDetail).filter(existTableList::contains).forEach(table -> {
                needLoadTableSet.add(table);
                modelTables.add(table);
            });
            modelTablesMap.put(modelName, modelTables);
        });
        return Pair.newPair((Object)needLoadTableSet, (Object)modelTablesMap);
    }

    private void innerImportModelMetadata(String project, MultipartFile metadataFile, ModelImportRequest request, ImportModelContext context, List<Exception> exceptions) throws Exception {
        SchemaChangeCheckResult schemaChangeCheckResult = this.checkModelMetadata(project, context, metadataFile);
        Pair<Set<String>, Map<String, Set<String>>> pair = this.checkNewModelTables(schemaChangeCheckResult, request);
        Set needLoadTableSet = (Set)pair.getFirst();
        Map modelTablesMap = (Map)pair.getSecond();
        LoadTableResponse loadTableResponse = null;
        boolean needLoadTable = CollectionUtils.isNotEmpty((Collection)needLoadTableSet);
        if (needLoadTable) {
            String needLoadTableStr = String.join((CharSequence)",", needLoadTableSet);
            logger.info("try load tables: [{}]", (Object)needLoadTableStr);
            loadTableResponse = this.innerLoadTables(project, needLoadTableSet);
            if (CollectionUtils.isNotEmpty((Collection)loadTableResponse.getFailed())) {
                String loadFailedTables = String.join((CharSequence)",", loadTableResponse.getFailed());
                logger.warn("Load Table failed: [{}]", (Object)loadFailedTables);
            }
        }
        KylinConfig targetKylinConfig = context.getTargetKylinConfig();
        NDataModelManager importDataModelManager = NDataModelManager.getInstance((KylinConfig)targetKylinConfig, (String)project);
        NIndexPlanManager importIndexPlanManager = NIndexPlanManager.getInstance((KylinConfig)targetKylinConfig, (String)project);
        for (ModelImportRequest.ModelImport modelImport : request.getModels()) {
            try {
                NDataModel nDataModel;
                NDataModel importDataModel;
                this.validateModelImport(project, modelImport, schemaChangeCheckResult);
                if (modelImport.getImportType() == ModelImportRequest.ImportType.NEW) {
                    if (needLoadTable) {
                        Set needLoadTables = modelTablesMap.getOrDefault(modelImport.getTargetName(), Collections.emptySet());
                        if (!loadTableResponse.getLoaded().containsAll(needLoadTables)) {
                            logger.warn("Import model [{}] failed, skip import.", (Object)modelImport.getOriginalName());
                            continue;
                        }
                    }
                    importDataModel = importDataModelManager.getDataModelDescByAlias(modelImport.getTargetName());
                    nDataModel = importDataModelManager.copyForWrite(importDataModel);
                    this.createNewModel(nDataModel, modelImport, project, importIndexPlanManager);
                    this.importRecommendations(project, nDataModel.getUuid(), importDataModel.getUuid(), targetKylinConfig);
                    continue;
                }
                if (modelImport.getImportType() != ModelImportRequest.ImportType.OVERWRITE) continue;
                importDataModel = importDataModelManager.getDataModelDescByAlias(modelImport.getOriginalName());
                nDataModel = importDataModelManager.copyForWrite(importDataModel);
                this.indexPlanService.checkPartitionDimensionForV3Storage(project, importDataModel.getId(), targetKylinConfig);
                IndexPlan targetIndexPlan = importIndexPlanManager.getIndexPlanByModelAlias(modelImport.getOriginalName()).copy();
                boolean hasModelOverrideProps = nDataModel.getSegmentConfig() != null && nDataModel.getSegmentConfig().getAutoMergeEnabled() != null && nDataModel.getSegmentConfig().getAutoMergeEnabled() != false || !targetIndexPlan.getOverrideProps().isEmpty();
                SchemaChangeCheckResult.ModelSchemaChange modelSchemaChange = (SchemaChangeCheckResult.ModelSchemaChange)schemaChangeCheckResult.getModels().get(modelImport.getTargetName());
                this.removeIndexes(project, modelSchemaChange, targetIndexPlan);
                this.updateModel(project, nDataModel, modelImport, hasModelOverrideProps);
                this.updateIndexPlan(project, nDataModel, targetIndexPlan, hasModelOverrideProps);
                this.addWhiteListIndex(project, modelSchemaChange, targetIndexPlan);
                this.addRuleBasedIndex(project, modelSchemaChange, targetIndexPlan);
                this.importRecommendations(project, nDataModel.getUuid(), importDataModel.getUuid(), targetKylinConfig);
            }
            catch (Exception e) {
                logger.warn("Import model {} exception", (Object)modelImport.getOriginalName(), (Object)e);
                exceptions.add(e);
            }
        }
    }

    private void validateModelImport(String project, ModelImportRequest.ModelImport modelImport, SchemaChangeCheckResult checkResult) {
        Message msg = MsgPicker.getMsg();
        if (modelImport.getImportType() == ModelImportRequest.ImportType.OVERWRITE) {
            NDataModel dataModel = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getDataModelDescByAlias(modelImport.getOriginalName());
            if (dataModel == null) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_IMPORT_ERROR, String.format(Locale.ROOT, msg.getCanNotOverwriteModel(), new Object[]{modelImport.getOriginalName(), modelImport.getImportType()}));
            }
            SchemaChangeCheckResult.ModelSchemaChange modelSchemaChange = (SchemaChangeCheckResult.ModelSchemaChange)checkResult.getModels().get(modelImport.getOriginalName());
            if (modelSchemaChange == null || !modelSchemaChange.overwritable()) {
                String createType = null;
                if (modelSchemaChange != null && modelSchemaChange.creatable()) {
                    createType = "NEW";
                }
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_IMPORT_ERROR, String.format(Locale.ROOT, msg.getUnSuitableImportType(createType), new Object[]{modelImport.getImportType(), modelImport.getOriginalName()}));
            }
        } else if (modelImport.getImportType() == ModelImportRequest.ImportType.NEW) {
            if (!StringUtils.containsOnly((CharSequence)modelImport.getTargetName(), (String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_")) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_INVALID, new Object[]{modelImport.getTargetName()});
            }
            NDataModel dataModel = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getDataModelDescByAlias(modelImport.getTargetName());
            if (dataModel != null) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_DUPLICATE, new Object[]{modelImport.getTargetName()});
            }
            SchemaChangeCheckResult.ModelSchemaChange modelSchemaChange = (SchemaChangeCheckResult.ModelSchemaChange)checkResult.getModels().get(modelImport.getTargetName());
            if (modelSchemaChange == null || !modelSchemaChange.creatable()) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.MODEL_IMPORT_ERROR, String.format(Locale.ROOT, msg.getUnSuitableImportType(null), new Object[]{modelImport.getImportType(), modelImport.getTargetName()}));
            }
        }
    }

    private void importRecommendations(String project, String targetModelId, String srcModelId, KylinConfig kylinConfig) throws IOException {
        NProjectManager projectManager = (NProjectManager)this.getManager(NProjectManager.class);
        ProjectInstance projectInstance = projectManager.getProject(project);
        if (projectInstance.isExpertMode()) {
            this.modelChangeSupporters.forEach(listener -> listener.onUpdateSingle(project, targetModelId));
            logger.info("Skip import recommendations because project {} is expert mode.", (Object)project);
            return;
        }
        RawRecManager manager = RawRecManager.getInstance((String)project);
        List rawRecItems = ImportModelContext.parseRawRecItems((ResourceStore)ResourceStore.getKylinMetaStore((KylinConfig)kylinConfig), (String)project, (String)srcModelId);
        manager.importRecommendations(project, targetModelId, rawRecItems);
        this.modelChangeSupporters.forEach(listener -> listener.onUpdateSingle(project, targetModelId));
    }

    public void cleanupMeta(String project) {
        if (project.equals("_global")) {
            RoutineToolHelper.cleanGlobalSourceUsage();
            RoutineToolHelper.cleanQueryHistoriesAsync().join();
        } else {
            RoutineToolHelper.cleanMetaByProject((String)project);
        }
    }

    public void cleanupStorage(String[] projectsToClean, boolean cleanupStorage) {
        CleanTaskExecutorService.getInstance().cleanStorageForService(cleanupStorage, Arrays.asList(projectsToClean), 0.0, 0);
    }

    public void cleanupStorage(StorageCleanupRequest request, HttpServletRequest servletRequest) {
        if (this.routeService.needRoute()) {
            String url = StringUtils.stripEnd((String)servletRequest.getRequestURI(), (String)"/") + "/tenant_node";
            this.routeService.asyncRouteForMultiTenantMode(servletRequest, url);
            return;
        }
        this.cleanupStorage(request.getProjectsToClean(), request.isCleanupStorage());
    }

    @Generated
    public void setModelChangeSupporters(List<ModelChangeSupporter> modelChangeSupporters) {
        this.modelChangeSupporters = modelChangeSupporters;
    }

    private static /* synthetic */ void lambda$getCompressedModelMetadata$7(ResourceStore oldResourceStore, ResourceStore newResourceStore, String resourcePath) {
        oldResourceStore.copy(resourcePath, newResourceStore);
    }

    private static /* synthetic */ boolean lambda$getCompressedModelMetadata$6(ResourceStore newResourceStore, RawResourceFilter projectFilter, String resPath) {
        return !newResourceStore.listResourcesRecursively(MetadataType.TABLE_INFO.name(), projectFilter).contains(resPath);
    }
}

