/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.job.common.SegmentUtil;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.SegmentStatusEnumToDisplay;
import org.apache.kylin.metadata.model.Segments;

public class NDataSegmentResponse
extends NDataSegment {
    private static final String SEGMENT_PATH = "segment_path";
    private static final String FILE_COUNT = "file_count";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="bytes_size")
    private long bytesSize;
    @JsonProperty(value="hit_count")
    private long hitCount;
    @JsonProperty(value="source_bytes_size")
    private long sourceBytesSize;
    @JsonProperty(value="status_to_display")
    private SegmentStatusEnumToDisplay statusToDisplay;
    @JsonProperty(value="index_count")
    private long indexCount;
    @JsonProperty(value="locked_index_count")
    private long lockedIndexCount;
    @JsonProperty(value="index_count_total")
    private long indexCountTotal;
    @JsonProperty(value="multi_partition_count")
    private long multiPartitionCount;
    @JsonProperty(value="multi_partition_count_total")
    private long multiPartitionCountTotal;
    @JsonProperty(value="source_count")
    private long sourceCount;
    @JsonProperty(value="row_count")
    private long rowCount;
    private long createTime;
    private long startTime;
    private long endTime;
    private long storage;
    @JsonProperty(value="has_base_table_index")
    private boolean hasBaseTableIndex;
    @JsonProperty(value="has_base_agg_index")
    private boolean hasBaseAggIndex;
    @JsonProperty(value="has_base_table_index_data")
    private boolean hasBaseTableIndexData;
    @JsonUnwrapped
    private OldParams oldParams;
    @JsonProperty(value="last_modified_time")
    private long lastModifiedTime;

    public NDataSegmentResponse() {
        super(false);
    }

    public NDataSegmentResponse(NDataflow dataflow, Segments<NDataSegment> segments, NDataSegment segment) {
        this(dataflow, segments, segment, null);
    }

    public NDataSegmentResponse(NDataflow dataflow, Segments<NDataSegment> segments, NDataSegment segment, List<AbstractExecutable> executables) {
        super(segment);
        this.id = segment.getUuid();
        this.createTime = this.getCreateTimeUTC();
        this.startTime = Long.parseLong(this.getSegRange().getStart().toString());
        this.endTime = Long.parseLong(this.getSegRange().getEnd().toString());
        this.storage = this.bytesSize;
        this.indexCount = segment.getEffectiveLayoutSize();
        this.indexCountTotal = segment.getIndexPlan().getAllLayoutsSize(true);
        this.multiPartitionCount = segment.getMultiPartitions().size();
        this.hasBaseAggIndex = segment.getIndexPlan().containBaseAggLayout();
        this.hasBaseTableIndex = segment.getIndexPlan().containBaseTableLayout();
        if (segment.getIndexPlan().getBaseTableLayout() != null) {
            IndexPlan indexPlan = segment.getDataflow().getIndexPlan();
            long segmentFileCount = segment.getSegDetails().getEffectiveLayouts().stream().filter(layout -> indexPlan.getLayoutEntity(Long.valueOf(layout.getLayoutId())) != null && indexPlan.getLayoutEntity(Long.valueOf(layout.getLayoutId())).isBaseIndex()).mapToLong(NDataLayout::getFileCount).sum();
            this.hasBaseTableIndexData = segmentFileCount > 0L;
        } else {
            this.hasBaseTableIndexData = false;
        }
        this.lockedIndexCount = segment.getIndexPlan().getAllToBeDeleteLayoutId().stream().filter(layoutId -> segment.getLayoutsMap().containsKey(layoutId)).count();
        if (dataflow.getModel().getMultiPartitionDesc() != null) {
            this.multiPartitionCountTotal = dataflow.getModel().getMultiPartitionDesc().getPartitions().size();
        }
        this.sourceCount = segment.getSourceCount();
        this.rowCount = segment.getSegDetails().getTotalRowCount();
        this.setBytesSize(segment.getStorageBytesSize());
        this.getAdditionalInfo().put(SEGMENT_PATH, dataflow.getSegmentHdfsPath(segment.getId()));
        this.getAdditionalInfo().put(FILE_COUNT, segment.getStorageFileCount() + "");
        this.setStatusToDisplay(SegmentUtil.getSegmentStatusToDisplay(segments, (ISegment)segment, executables, null));
        this.setSourceBytesSize(segment.getSourceBytesSize());
        this.setLastBuildTime(segment.getLastBuildTime());
        this.setMaxBucketId(segment.getMaxBucketId());
        this.lastModifiedTime = this.getLastBuildTime() != 0L ? this.getLastBuildTime() : this.getCreateTime();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public long getBytesSize() {
        return this.bytesSize;
    }

    @Generated
    public long getHitCount() {
        return this.hitCount;
    }

    @Generated
    public long getSourceBytesSize() {
        return this.sourceBytesSize;
    }

    @Generated
    public SegmentStatusEnumToDisplay getStatusToDisplay() {
        return this.statusToDisplay;
    }

    @Generated
    public long getIndexCount() {
        return this.indexCount;
    }

    @Generated
    public long getLockedIndexCount() {
        return this.lockedIndexCount;
    }

    @Generated
    public long getIndexCountTotal() {
        return this.indexCountTotal;
    }

    @Generated
    public long getMultiPartitionCount() {
        return this.multiPartitionCount;
    }

    @Generated
    public long getMultiPartitionCountTotal() {
        return this.multiPartitionCountTotal;
    }

    @Generated
    public long getSourceCount() {
        return this.sourceCount;
    }

    @Generated
    public long getRowCount() {
        return this.rowCount;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public long getStorage() {
        return this.storage;
    }

    @Generated
    public boolean isHasBaseTableIndex() {
        return this.hasBaseTableIndex;
    }

    @Generated
    public boolean isHasBaseAggIndex() {
        return this.hasBaseAggIndex;
    }

    @Generated
    public boolean isHasBaseTableIndexData() {
        return this.hasBaseTableIndexData;
    }

    @Generated
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setBytesSize(long bytesSize) {
        this.bytesSize = bytesSize;
    }

    @Generated
    public void setHitCount(long hitCount) {
        this.hitCount = hitCount;
    }

    @Generated
    public void setSourceBytesSize(long sourceBytesSize) {
        this.sourceBytesSize = sourceBytesSize;
    }

    @Generated
    public void setStatusToDisplay(SegmentStatusEnumToDisplay statusToDisplay) {
        this.statusToDisplay = statusToDisplay;
    }

    @Generated
    public void setIndexCount(long indexCount) {
        this.indexCount = indexCount;
    }

    @Generated
    public void setLockedIndexCount(long lockedIndexCount) {
        this.lockedIndexCount = lockedIndexCount;
    }

    @Generated
    public void setIndexCountTotal(long indexCountTotal) {
        this.indexCountTotal = indexCountTotal;
    }

    @Generated
    public void setMultiPartitionCount(long multiPartitionCount) {
        this.multiPartitionCount = multiPartitionCount;
    }

    @Generated
    public void setMultiPartitionCountTotal(long multiPartitionCountTotal) {
        this.multiPartitionCountTotal = multiPartitionCountTotal;
    }

    @Generated
    public void setSourceCount(long sourceCount) {
        this.sourceCount = sourceCount;
    }

    @Generated
    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    @Generated
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setStorage(long storage) {
        this.storage = storage;
    }

    @Generated
    public void setHasBaseTableIndex(boolean hasBaseTableIndex) {
        this.hasBaseTableIndex = hasBaseTableIndex;
    }

    @Generated
    public void setHasBaseAggIndex(boolean hasBaseAggIndex) {
        this.hasBaseAggIndex = hasBaseAggIndex;
    }

    @Generated
    public void setHasBaseTableIndexData(boolean hasBaseTableIndexData) {
        this.hasBaseTableIndexData = hasBaseTableIndexData;
    }

    @Generated
    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    @Generated
    public OldParams getOldParams() {
        return this.oldParams;
    }

    @Generated
    public void setOldParams(OldParams oldParams) {
        this.oldParams = oldParams;
    }

    public static class OldParams
    implements Serializable {
        @JsonProperty(value="size_kb")
        private long sizeKB;
        @JsonProperty(value="input_records")
        private long inputRecords;

        @Generated
        public long getSizeKB() {
            return this.sizeKB;
        }

        @Generated
        public long getInputRecords() {
            return this.inputRecords;
        }

        @Generated
        public void setSizeKB(long sizeKB) {
            this.sizeKB = sizeKB;
        }

        @Generated
        public void setInputRecords(long inputRecords) {
            this.inputRecords = inputRecords;
        }
    }
}

