/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.util;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.rec.common.SmartConfig;

public class CubeUtils {
    private CubeUtils() {
    }

    public static FunctionDesc newFunctionDesc(NDataModel modelDesc, String expression, List<ParameterDesc> params, String colDataType) {
        String returnType = FunctionDesc.proposeReturnType((String)expression, (String)colDataType, Collections.singletonMap("COUNT_DISTINCT", SmartConfig.wrap(KylinConfig.getInstanceFromEnv()).getMeasureCountDistinctType()));
        if ("COUNT_DISTINCT".equalsIgnoreCase(expression) && CollectionUtils.isNotEmpty(params) && params.size() > 1) {
            returnType = "hllc(10)";
        }
        FunctionDesc ret = FunctionDesc.newInstance((String)expression, params, (String)returnType);
        ret.init(modelDesc);
        return ret;
    }

    public static FunctionDesc newCountStarFuncDesc(NDataModel modelDesc) {
        return CubeUtils.newFunctionDesc(modelDesc, "COUNT", Lists.newArrayList((Object[])new ParameterDesc[]{ParameterDesc.newInstance((Object)"1")}), "bigint");
    }

    public static NDataModel.Measure newMeasure(FunctionDesc func, String name, int id) {
        NDataModel.Measure measure = new NDataModel.Measure();
        measure.setName(name);
        measure.setFunction(func);
        measure.setId(id);
        return measure;
    }

    public static boolean isValidMeasure(FunctionDesc functionDesc) {
        List colRefs = functionDesc.getColRefs();
        if (colRefs == null || colRefs.isEmpty()) {
            return true;
        }
        for (TblColRef colRef : colRefs) {
            if (colRef.isQualified()) continue;
            return false;
        }
        return !functionDesc.isGrouping();
    }
}

