/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.query.validator;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.rec.query.SQLResult;
import org.apache.kylin.rec.query.advisor.SQLAdvice;

public class SQLValidateResult
implements Serializable {
    private static final long serialVersionUID = -1L;
    private boolean capable;
    private SQLResult result;
    private Set<SQLAdvice> sqlAdvices = Sets.newHashSet();

    static SQLValidateResult successStats(SQLResult sqlResult) {
        SQLValidateResult stats = new SQLValidateResult();
        stats.setCapable(true);
        stats.setResult(sqlResult);
        return stats;
    }

    static SQLValidateResult failedStats(List<SQLAdvice> sqlAdvices, SQLResult sqlResult) {
        SQLValidateResult stats = new SQLValidateResult();
        stats.setCapable(false);
        stats.setSqlAdvices(Sets.newHashSet(sqlAdvices));
        stats.setResult(sqlResult);
        return stats;
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        this.getSqlAdvices().forEach(sqlAdvice -> {
            message.append("\n");
            message.append(String.format(Locale.ROOT, "reason: %s", sqlAdvice.getIncapableReason().replace(",", "\uff0c")));
            message.append(";");
            message.append(String.format(Locale.ROOT, "suggest: %s", sqlAdvice.getSuggestion().replace(",", "\uff0c")));
        });
        return String.format(Locale.ROOT, "capable:%s %s", this.isCapable(), message.toString());
    }

    @Generated
    public boolean isCapable() {
        return this.capable;
    }

    @Generated
    public SQLResult getResult() {
        return this.result;
    }

    @Generated
    public Set<SQLAdvice> getSqlAdvices() {
        return this.sqlAdvices;
    }

    @Generated
    public void setCapable(boolean capable) {
        this.capable = capable;
    }

    @Generated
    public void setResult(SQLResult result) {
        this.result = result;
    }

    @Generated
    public void setSqlAdvices(Set<SQLAdvice> sqlAdvices) {
        this.sqlAdvices = sqlAdvices;
    }
}

