/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.ManagementType;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.recommendation.candidate.RawRecManager;
import org.apache.kylin.rec.AbstractContext;

public abstract class AbstractSemiContext
extends AbstractContext {
    protected AbstractSemiContext(KylinConfig kylinConfig, String project, String[] sqlArray) {
        this(kylinConfig, project, sqlArray, "");
    }

    protected AbstractSemiContext(KylinConfig kylinConfig, String project, String[] sqlArray, String modelName) {
        super(kylinConfig, project, sqlArray, modelName);
        this.getExistingNonLayoutRecItemMap().putAll(RawRecManager.getInstance((String)project).queryNonLayoutRecItems(null));
    }

    @Override
    public List<NDataModel> getOriginModels() {
        return this.getRelatedModels().stream().filter(model -> this.getExtraMeta().getOnlineModelIds().contains(model.getUuid())).collect(Collectors.toList());
    }

    @Override
    public IndexPlan getOriginIndexPlan(String modelId) {
        return NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject()).getIndexPlan(modelId);
    }

    @Override
    public void changeModelMainType(NDataModel model) {
        model.setManagementType(ManagementType.MODEL_BASED);
    }

    @Override
    public void saveMetadata() {
    }

    @Override
    public String getIdentifier() {
        return "Auto-Recommendation-Version2";
    }
}

