/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;

public class TableUtils {
    private TableUtils() {
    }

    public static void checkTimestampColumn(TableDesc tableDesc) {
        ColumnDesc[] columns = tableDesc.getColumns();
        Optional<ColumnDesc> result = Arrays.stream(columns).filter(column -> "timestamp".equals(column.getDatatype())).findAny();
        if (!result.isPresent()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.TIMESTAMP_COLUMN_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getTimestampColumnNotExist(), new Object[0]));
        }
    }

    public static int calculateTableSize(int pageOffset, int pageSize) {
        return pageOffset * pageSize + pageSize;
    }
}

