/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffset;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffsetManager;
import org.apache.kylin.metadata.query.RDBMSQueryHistoryDAO;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class QueryHistoryOffsetUtil {
    private static RDBMSQueryHistoryDAO queryHistoryDAO = RDBMSQueryHistoryDAO.getInstance();

    public static void resetOffsetId(String project) {
        QueryHistoryOffsetUtil.resetOffsetId(project, queryHistoryDAO);
    }

    public static void resetOffsetId(String project, RDBMSQueryHistoryDAO queryHistoryDAO) {
        QueryHistoryIdOffsetManager qhIdOffsetManager = QueryHistoryIdOffsetManager.getInstance((String)project);
        JdbcUtil.withTxAndRetry((DataSourceTransactionManager)qhIdOffsetManager.getTransactionManager(), () -> {
            long maxId = queryHistoryDAO.getQueryHistoryMaxId(project);
            QueryHistoryIdOffsetManager manager = QueryHistoryIdOffsetManager.getInstance((String)project);
            QueryHistoryIdOffset queryHistoryAccIdOffset = manager.get(QueryHistoryIdOffset.OffsetType.ACCELERATE);
            QueryHistoryIdOffset queryHistoryStatIdOffset = manager.get(QueryHistoryIdOffset.OffsetType.META);
            if (queryHistoryAccIdOffset.getOffset() > maxId || queryHistoryStatIdOffset.getOffset() > maxId) {
                manager.updateOffset(QueryHistoryIdOffset.OffsetType.ACCELERATE, copyForWrite -> copyForWrite.setOffset(maxId));
                manager.updateOffset(QueryHistoryIdOffset.OffsetType.META, copyForWrite -> copyForWrite.setOffset(maxId));
            }
            return null;
        });
    }
}

