/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.metadata.user.NKylinUserManager;
import org.apache.kylin.metadata.usergroup.NUserGroupManager;
import org.apache.kylin.metadata.usergroup.UserGroup;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.response.UserGroupResponseKI;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component(value="nUserGroupService")
public class NUserGroupService
implements IUserGroupService {
    public static final Logger logger = LoggerFactory.getLogger(NUserGroupService.class);
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    AclEvaluate aclEvaluate;
    @Autowired
    @Qualifier(value="userService")
    UserService userService;

    @Override
    public List<String> getAllUserGroups() {
        return this.getUserGroupManager().getAllGroupNames();
    }

    @Override
    public List<ManagedUser> getGroupMembersByName(String name) throws IOException {
        List<ManagedUser> users = this.userService.listUsers();
        users.removeIf(user -> !user.getAuthorities().contains(new SimpleGrantedAuthority(name)));
        return users;
    }

    @Override
    @Transaction
    public void addGroup(String name) {
        this.aclEvaluate.checkIsGlobalAdmin();
        this.getUserGroupManager().add(name);
    }

    @Override
    @Transaction
    public void deleteGroup(String name) throws IOException {
        this.aclEvaluate.checkIsGlobalAdmin();
        this.checkGroupCanBeDeleted(name);
        SimpleGrantedAuthority simpleAuthority = new SimpleGrantedAuthority(name);
        this.userService.listUsers(false).stream().filter(user -> user.getAuthorities().parallelStream().anyMatch(authority -> authority.equals((Object)simpleAuthority))).forEach(user -> {
            user.removeAuthorities(name);
            this.userService.updateUser((UserDetails)user);
        });
        this.accessService.revokeProjectPermission(name, "group");
        this.getUserGroupManager().delete(name);
    }

    @Override
    @Transaction
    public void modifyGroupUsers(String groupName, List<String> users) throws IOException {
        ManagedUser managedUser;
        this.aclEvaluate.checkIsGlobalAdmin();
        this.checkGroupNameExist(groupName);
        List groupUsers = this.getGroupMembersByName(groupName).stream().map(ManagedUser::getUsername).collect(Collectors.toList());
        ArrayList moveInUsers = Lists.newArrayList(users);
        ArrayList moveOutUsers = Lists.newArrayList(groupUsers);
        moveInUsers.removeAll(groupUsers);
        moveOutUsers.removeAll(users);
        Message msg = MsgPicker.getMsg();
        String currentUser = this.aclEvaluate.getCurrentUserName();
        ArrayList moveList = Lists.newArrayList();
        moveList.addAll(moveInUsers);
        moveList.addAll(moveOutUsers);
        List<String> superAdminList = this.userService.listSuperAdminUsers();
        for (String user : moveList) {
            if (!CollectionUtils.isEmpty(superAdminList) && superAdminList.stream().filter(superAdmin -> superAdmin.equalsIgnoreCase(user)).collect(Collectors.toList()).size() > 0) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getChangeGlobaladmin());
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)currentUser, (CharSequence)user)) continue;
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_USER, msg.getSelfEditForbidden());
        }
        for (String in : moveInUsers) {
            managedUser = (ManagedUser)this.userService.loadUserByUsername(in);
            managedUser.addAuthorities(groupName);
            this.userService.updateUser((UserDetails)managedUser);
        }
        for (String out : moveOutUsers) {
            managedUser = (ManagedUser)this.userService.loadUserByUsername(out);
            managedUser.removeAuthorities(groupName);
            this.userService.updateUser((UserDetails)managedUser);
        }
    }

    @Override
    public List<String> listAllAuthorities() {
        this.aclEvaluate.checkIsGlobalAdmin();
        return this.getAllUserGroups();
    }

    @Override
    public List<String> getAuthoritiesFilterByGroupName(String userGroupName) {
        this.aclEvaluate.checkIsGlobalAdmin();
        return StringUtils.isEmpty((CharSequence)userGroupName) ? this.getAllUserGroups() : this.getAllUserGroups().stream().filter(userGroup -> StringUtils.containsIgnoreCase((CharSequence)userGroup, (CharSequence)userGroupName)).collect(Collectors.toList());
    }

    @Override
    public List<UserGroup> listUserGroups() {
        return this.getUserGroupManager().getAllGroups();
    }

    @Override
    public List<UserGroup> getUserGroupsFilterByGroupName(String userGroupName) {
        this.aclEvaluate.checkIsGlobalAdmin();
        if (StringUtils.isEmpty((CharSequence)userGroupName)) {
            return this.listUserGroups();
        }
        return this.getUserGroupManager().getGroupsByName(userGroupName, true);
    }

    @Override
    public String getGroupNameByUuid(String uuid) {
        List groups = this.getUserGroupManager().getAllGroups();
        for (UserGroup group : groups) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)uuid, (CharSequence)group.getUuid())) continue;
            return group.getGroupName();
        }
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.USERGROUP_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getGroupUuidNotExist(), uuid));
    }

    @Override
    public String getUuidByGroupName(String groupName) {
        if (StringUtils.isEmpty((CharSequence)groupName)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.USERGROUP_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getUserGroupNotExist(), groupName));
        }
        Optional optional = this.getUserGroupManager().getGroupsByName(groupName, false).stream().findFirst();
        if (!optional.isPresent()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.USERGROUP_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getUserGroupNotExist(), groupName));
        }
        return ((UserGroup)optional.get()).getUuid();
    }

    @Override
    public boolean exists(String name) {
        return this.getUserGroupManager().exists(name);
    }

    public ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
    }

    private void checkGroupNameExist(String groupName) {
        List<String> groups = this.getAllUserGroups();
        if (!groups.contains(groupName)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getUserGroupNotExist(), groupName));
        }
    }

    @Override
    public Map<String, List<String>> getUserAndUserGroup() throws IOException {
        HashMap result = Maps.newHashMap();
        List userNames = this.userService.getManagedUsersByFuzzMatching(null, false).stream().map(ManagedUser::getUsername).collect(Collectors.toList());
        List<String> groupNames = this.getAllUserGroups();
        result.put("user", userNames);
        result.put("group", groupNames);
        return result;
    }

    @Override
    public Set<String> listUserGroups(String username) {
        ManagedUser user = NKylinUserManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).get(username);
        if (Objects.isNull(user)) {
            return Collections.emptySet();
        }
        return user.getAuthorities().stream().map(GrantedAuthority::getAuthority).filter(this::exists).collect(Collectors.toSet());
    }

    private NUserGroupManager getUserGroupManager() {
        return NUserGroupManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
    }

    @Override
    public List<UserGroupResponseKI> getUserGroupResponse(List<UserGroup> userGroups) throws IOException {
        ArrayList<UserGroupResponseKI> result = new ArrayList<UserGroupResponseKI>();
        List groupNames = userGroups.stream().map(UserGroup::getGroupName).collect(Collectors.toList());
        Map groupMembersMap = this.userService.listUsers(false).parallelStream().filter(user -> user.getAuthorities().stream().anyMatch(authority -> groupNames.contains(authority.getAuthority()))).map(user -> user.getAuthorities().stream().map(SimpleGrantedAuthority::getAuthority).filter(groupNames::contains).collect(Collectors.toMap(Function.identity(), authority -> user.getUsername()))).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
        for (UserGroup group : userGroups) {
            result.add(new UserGroupResponseKI(group.getUuid(), group.getGroupName(), groupMembersMap.getOrDefault(group.getGroupName(), new HashSet())));
        }
        return result;
    }

    @Override
    @Transaction
    public void addGroups(List<String> groups) {
        this.aclEvaluate.checkIsGlobalAdmin();
        this.getUserGroupManager().batchAdd(groups);
    }

    protected List<UserGroup> getUserGroupSpecialUuid() {
        List<String> groups = this.getAllUserGroups();
        ArrayList<UserGroup> result = new ArrayList<UserGroup>();
        for (String group : groups) {
            UserGroup userGroup = new UserGroup();
            userGroup.setUuid(group);
            userGroup.setGroupName(group);
            result.add(userGroup);
        }
        return result;
    }

    private void checkGroupCanBeDeleted(String groupName) {
        if (groupName.equals("ALL_USERS") || groupName.equals("ROLE_ADMIN")) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_USERGROUP_NAME, "Failed to delete user group, user groups of ALL_USERS and ROLE_ADMIN cannot be deleted.");
        }
    }
}

