/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.transaction.AclGrantEventNotifier;
import org.apache.kylin.common.persistence.transaction.AclRevokeEventNotifier;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.acl.AclTCR;
import org.apache.kylin.metadata.acl.AclTCRManager;
import org.apache.kylin.metadata.acl.DependentColumn;
import org.apache.kylin.metadata.acl.SensitiveDataMask;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.table.ATable;
import org.apache.kylin.metadata.user.NKylinUserManager;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.request.AccessRequest;
import org.apache.kylin.rest.request.AclTCRRequest;
import org.apache.kylin.rest.response.AclTCRResponse;
import org.apache.kylin.rest.security.MutableAclRecord;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.AclTCRServiceSupporter;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.model.Permission;
import org.springframework.stereotype.Component;

@Component(value="aclTCRService")
public class AclTCRService
extends BasicService
implements AclTCRServiceSupporter {
    private static final Logger logger = LoggerFactory.getLogger(AclTCRService.class);
    private static final String IDENTIFIER_FORMAT = "%s.%s";
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private AccessService accessService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private UserService userService;

    public void revokeAclTCR(String uuid, String sid, boolean principal) {
        this.getManager(NProjectManager.class).listAllProjects().stream().filter(p -> p.getUuid().equals(uuid)).findFirst().ifPresent(prj -> EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            this.revokePrjAclTCR(prj.getName(), sid, principal);
            return null;
        }, (String)prj.getName()));
    }

    public void revokeAclTCR(String sid, boolean principal) {
        this.projectService.getOwnedProjects().parallelStream().forEach(prj -> EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            this.revokePrjAclTCR((String)prj, sid, principal);
            return null;
        }, (String)prj));
    }

    private void revokePrjAclTCR(String project, String sid, boolean principal) {
        logger.info("revoke project table, column and row acls of project={}, sid={}, principal={}", new Object[]{project, sid, principal});
        this.getManager(AclTCRManager.class, project).revokeAclTCR(sid, principal);
    }

    @Override
    @Transaction(project=0)
    public void unloadTable(String project, String dbTblName) {
        this.getManager(AclTCRManager.class, project).unloadTable(dbTblName);
    }

    @Override
    public List<AclTCRResponse> getAclTCRResponse(String project, String sid, boolean principal, boolean authorizedOnly) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        AclTCRManager aclTCRManager = this.getManager(AclTCRManager.class, project);
        if (this.hasAdminPermissionInProject(sid, principal, project)) {
            return this.getAclTCRResponse(project, aclTCRManager.getAllDbAclTable(project));
        }
        AclTCR authorized = aclTCRManager.getAclTCR(sid, principal);
        if (Objects.isNull(authorized)) {
            return Lists.newArrayList();
        }
        if (Objects.isNull(authorized.getTable())) {
            return this.getAclTCRResponse(project, aclTCRManager.getAllDbAclTable(project));
        }
        if (authorizedOnly) {
            return this.tagTableNum(this.getAclTCRResponse(project, aclTCRManager.getDbAclTable(project, authorized)), this.getDbTblColNum(project));
        }
        return this.getAllTablesAclTCRResponse(project, aclTCRManager.getDbAclTable(project, authorized));
    }

    @Override
    public boolean hasAdminPermissionInProject(String sid, boolean principal, String project) throws IOException {
        if (principal) {
            MutableAclRecord acl;
            if (this.userService.isGlobalAdmin(sid)) {
                return true;
            }
            Set<String> groupsOfUser = this.accessService.getGroupsOfExecuteUser(sid);
            Set groupsInProject = AclPermissionUtil.filterGroupsInProject(groupsOfUser, (MutableAclRecord)(acl = AclPermissionUtil.getProjectAcl((String)project)));
            boolean hasAdminPermission = AclPermissionUtil.isSpecificPermissionInProject((String)sid, (Set)groupsInProject, (Permission)BasePermission.ADMINISTRATION, (MutableAclRecord)acl);
            if (hasAdminPermission) {
                return true;
            }
        } else {
            if (this.userGroupService.isAdminGroup(sid)) {
                return true;
            }
            if (AclPermissionUtil.isSpecificPermissionInProject((String)sid, (String)project, (Permission)BasePermission.ADMINISTRATION)) {
                return true;
            }
        }
        return false;
    }

    public void updateAclTCR(String project, String sid, boolean principal, List<AclTCRRequest> requests) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.checkAclTCRRequest(project, requests, sid, principal, true);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            this.updateAclTCR(project, sid, principal, this.transformRequests(project, requests));
            return null;
        }, (String)project);
    }

    public void mergeAclTCR(String project, String sid, boolean principal, List<AclTCRRequest> requests) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.checkAclTCRRequest(project, requests, sid, principal, false);
        NTableMetadataManager manager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        AclTCRManager aclTCRManager = this.getManager(AclTCRManager.class, project);
        AclTCR aclTCR = aclTCRManager.getAclTCR(sid, principal);
        if (aclTCR == null) {
            aclTCR = new AclTCR();
        }
        this.checkACLTCRRequestRowAuthValid(manager, requests, Optional.ofNullable(aclTCR.getTable()).orElse(new AclTCR.Table()));
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            this.updateAclTCR(project, sid, principal, this.mergeRequests(project, sid, principal, requests));
            return null;
        }, (String)project);
    }

    private void checkAclTCRRequestDataBaseValid(AclTCRRequest db, Set<String> requestDatabases) {
        Message msg = MsgPicker.getMsg();
        if (StringUtils.isEmpty((CharSequence)db.getDatabaseName())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, msg.getEmptyDatabaseName());
        }
        db.setDatabaseName(db.getDatabaseName().toUpperCase(Locale.ROOT));
        if (requestDatabases.contains(db.getDatabaseName())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, msg.getDatabaseParameterDuplicate(), db.getDatabaseName()));
        }
        requestDatabases.add(db.getDatabaseName());
        if (CollectionUtils.isEmpty(db.getTables())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, msg.getEmptyTableList());
        }
    }

    private void checkAclTCRRequestTableValid(NTableMetadataManager manager, AclTCRRequest db, AclTCRRequest.Table table, Set<String> requestTables, boolean isIncludeAll) {
        Message msg = MsgPicker.getMsg();
        if (StringUtils.isEmpty((CharSequence)table.getTableName())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, msg.getEmptyTableName());
        }
        table.setTableName(table.getTableName().toUpperCase(Locale.ROOT));
        String tableName = String.format(Locale.ROOT, IDENTIFIER_FORMAT, db.getDatabaseName(), table.getTableName());
        if (requestTables.contains(tableName)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, msg.getTableParameterDuplicate(), tableName));
        }
        requestTables.add(tableName);
        if (!isIncludeAll) {
            return;
        }
        if (table.getRows() == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, msg.getEmptyRowList());
        }
        table.getRows().forEach(row -> AclTCRService.checkRow(msg, row));
        TableDesc tableDesc = manager.getTableDesc(tableName);
        if (CollectionUtils.isEmpty(table.getColumns()) && tableDesc.getColumns() != null && tableDesc.getColumns().length > 0) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, msg.getEmptyColumnList());
        }
    }

    private static void checkRow(Message msg, AclTCRRequest.Row row) {
        if (StringUtils.isEmpty((CharSequence)row.getColumnName())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, msg.getEmptyColumnName());
        }
        if (CollectionUtils.isEmpty(row.getItems())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, msg.getEmptyItems());
        }
    }

    private void checkAClTCRRequestParameterValid(NTableMetadataManager manager, Set<String> databases, Set<String> tables, Set<String> columns, List<AclTCRRequest> requests, boolean isIncludeAll) {
        Message msg = MsgPicker.getMsg();
        HashSet requestDatabases = Sets.newHashSet();
        HashSet requestTables = Sets.newHashSet();
        HashSet requestColumns = Sets.newHashSet();
        requests.forEach(db -> {
            this.checkAclTCRRequestDataBaseValid((AclTCRRequest)db, requestDatabases);
            db.getTables().forEach(table -> {
                this.checkAclTCRRequestTableValid(manager, (AclTCRRequest)db, (AclTCRRequest.Table)table, requestTables, isIncludeAll);
                String tableName = String.format(Locale.ROOT, IDENTIFIER_FORMAT, db.getDatabaseName(), table.getTableName());
                if (table.getColumns() == null) {
                    return;
                }
                table.getColumns().forEach(column -> {
                    String columnName = String.format(Locale.ROOT, IDENTIFIER_FORMAT, tableName, column.getColumnName());
                    if (StringUtils.isEmpty((CharSequence)column.getColumnName())) {
                        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, msg.getEmptyColumnName());
                    }
                    column.setColumnName(column.getColumnName().toUpperCase(Locale.ROOT));
                    if (requestColumns.contains(columnName)) {
                        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, msg.getColumnParameterDuplicate(), columnName));
                    }
                    requestColumns.add(columnName);
                });
            });
        });
        if (!isIncludeAll) {
            return;
        }
        Collection notIncludeDatabase = CollectionUtils.removeAll(databases, (Collection)requestDatabases);
        if (!notIncludeDatabase.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, msg.getDatabaseParameterMissing(), StringUtils.join((Iterable)notIncludeDatabase, (String)",")));
        }
        Collection notIncludeTables = CollectionUtils.removeAll(tables, (Collection)requestTables);
        if (!notIncludeTables.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, msg.getTableParameterMissing(), StringUtils.join((Iterable)notIncludeTables, (String)",")));
        }
        Collection notIncludeColumns = CollectionUtils.removeAll(columns, (Collection)requestColumns);
        if (!notIncludeColumns.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, msg.getColumnParameterMissing(), StringUtils.join((Iterable)notIncludeColumns, (String)",")));
        }
    }

    private void checkAClTCRExist(Set<String> databases, Set<String> tables, Set<String> columns, List<AclTCRRequest> requests) {
        Message msg = MsgPicker.getMsg();
        requests.forEach(db -> {
            if (!databases.contains(db.getDatabaseName())) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, msg.getDatabaseNotExist(), db.getDatabaseName()));
            }
            db.getTables().forEach(table -> {
                String tableName = String.format(Locale.ROOT, IDENTIFIER_FORMAT, db.getDatabaseName(), table.getTableName());
                if (!tables.contains(tableName)) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, msg.getTableNotFound(), tableName));
                }
                Optional.ofNullable(table.getRows()).map(Collection::stream).orElseGet(Stream::empty).forEach(row -> {
                    String columnName = String.format(Locale.ROOT, IDENTIFIER_FORMAT, tableName, row.getColumnName());
                    if (!columns.contains(columnName)) {
                        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, msg.getColumnNotExist(), columnName));
                    }
                });
                Optional.ofNullable(table.getColumns()).map(Collection::stream).orElseGet(Stream::empty).forEach(column -> {
                    String columnName = String.format(Locale.ROOT, IDENTIFIER_FORMAT, tableName, column.getColumnName());
                    if (!columns.contains(columnName)) {
                        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, msg.getColumnNotExist(), columnName));
                    }
                });
            });
        });
    }

    private void checkAclTCRRequest(String project, List<AclTCRRequest> requests, String sid, boolean principal, boolean isIncludeAll) throws IOException {
        HashSet databases = Sets.newHashSet();
        HashSet tables = Sets.newHashSet();
        HashSet columns = Sets.newHashSet();
        NTableMetadataManager manager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        List all = manager.listAllTables();
        all.forEach(table -> {
            String dbName = table.getDatabase();
            databases.add(dbName);
            String tbName = table.getIdentity();
            tables.add(tbName);
            Arrays.stream(table.getColumns()).forEach(col -> columns.add(String.format(Locale.ROOT, IDENTIFIER_FORMAT, dbName, col.getIdentity())));
        });
        if (this.hasAdminPermissionInProject(sid, principal, project)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getAdminPermissionUpdateAbandon());
        }
        this.checkAClTCRRequestParameterValid(manager, databases, tables, columns, requests, isIncludeAll);
        AclTCRManager aclTCRManager = this.getManager(AclTCRManager.class, project);
        AclTCR aclTCR = aclTCRManager.getAclTCR(sid, principal);
        if (aclTCR == null) {
            aclTCR = new AclTCR();
        }
        this.checkACLTCRRequestRowAuthValid(manager, requests, Optional.ofNullable(aclTCR.getTable()).orElse(new AclTCR.Table()));
        this.checkAClTCRExist(databases, tables, columns, requests);
    }

    private void checkACLTCRRequestRowAuthValid(NTableMetadataManager manager, List<AclTCRRequest> requests, AclTCR.Table aclTables) {
        for (AclTCRRequest request : requests) {
            String database = request.getDatabaseName();
            request.getTables().stream().forEach(table -> this.checkRowAuthHelper(manager, database, (AclTCRRequest.Table)table, aclTables));
        }
    }

    private void checkRowAuthHelper(NTableMetadataManager manager, String database, AclTCRRequest.Table table, AclTCR.Table aclTables) {
        int ROWFILTERTHRESHOLD;
        boolean isV2Used;
        boolean requestRlsV1 = table.getRows() != null || table.getLikeRows() != null;
        boolean requestRlsV2 = table.getRowFilter() != null && CollectionUtils.isNotEmpty(table.getRowFilter().getFilterGroups());
        AclTCR.ColumnRow columnRow = (AclTCR.ColumnRow)aclTables.get((Object)(database + "." + table.getTableName()));
        boolean bl = columnRow != null ? columnRow.getRowFilter() != null : (isV2Used = false);
        if (requestRlsV1 && (isV2Used || requestRlsV2)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.ACL_INVALID_ROW_FIELD, MsgPicker.getMsg().getInvalidRowACLUpdate());
        }
        String tableName = table.getTableName();
        HashMap<String, String> columnTypes = new HashMap<String, String>();
        TableDesc tableDesc = manager.getTableDesc(database + "." + tableName);
        if (tableDesc == null) {
            return;
        }
        for (ColumnDesc columnDesc : tableDesc.getColumns()) {
            columnTypes.put(columnDesc.getName(), columnDesc.getTypeName());
        }
        Optional.ofNullable(table.getLikeRows()).map(Collection::stream).orElseGet(Stream::empty).forEach(likeRow -> this.validateLikeColumnType(likeRow.getColumnName(), columnTypes));
        if (!requestRlsV2) {
            return;
        }
        int filterCount = table.getRowFilter().getFilterGroups().stream().map(AclTCRRequest.FilterGroup::getFilters).map(List::size).reduce(0, Integer::sum);
        if (filterCount > (ROWFILTERTHRESHOLD = KylinConfig.getInstanceFromEnv().getRowFilterLimit())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.ACL_INVALID_ROW_FIELD, String.format(Locale.ROOT, MsgPicker.getMsg().getRowFilterExceedLimit(), filterCount, ROWFILTERTHRESHOLD));
        }
        table.getRowFilter().getFilterGroups().stream().map(AclTCRRequest.FilterGroup::getFilters).forEach(filters -> {
            for (AclTCRRequest.Filter filter : filters) {
                int itemCount = Optional.ofNullable(filter.getInItems()).orElse(Lists.newArrayList()).size() + Optional.ofNullable(filter.getLikeItems()).orElse(Lists.newArrayList()).size();
                if (itemCount > ROWFILTERTHRESHOLD) {
                    throw new KylinException((ErrorCodeSupplier)ServerErrorCode.ACL_INVALID_ROW_FIELD, String.format(Locale.ROOT, MsgPicker.getMsg().getRowFilterItemExceedLimit(), filter.getColumnName(), itemCount, ROWFILTERTHRESHOLD));
                }
                if (CollectionUtils.isEmpty(filter.getLikeItems())) continue;
                this.validateLikeColumnType(filter.getColumnName(), columnTypes);
            }
        });
    }

    private void validateLikeColumnType(String columnName, Map<String, String> columnTypes) {
        String type = columnTypes.get(columnName);
        if (type == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getColumnNotExist(), columnName));
        }
        if (!(type.startsWith("varchar") || type.equals("string") || type.startsWith("char"))) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.ACL_INVALID_COLUMN_DATA_TYPE, MsgPicker.getMsg().getRowAclNotStringType());
        }
    }

    public void updateAclTCR(String uuid, List<AccessRequest> requests) {
        boolean defaultAuthorized = KapConfig.getInstanceFromEnv().isProjectInternalDefaultPermissionGranted();
        this.getManager(NProjectManager.class).listAllProjects().stream().filter(p -> p.getUuid().equals(uuid)).findFirst().ifPresent(prj -> EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            requests.stream().filter(r -> StringUtils.isNotEmpty((CharSequence)r.getSid())).forEach(r -> {
                AclTCR aclTCR = new AclTCR();
                if (!defaultAuthorized && !AclPermissionUtil.isProjectAdminPermission((String)r.getPermission())) {
                    aclTCR.setTable(new AclTCR.Table());
                }
                this.updateAclTCR(prj.getName(), r.getSid(), r.isPrincipal(), aclTCR);
            });
            return null;
        }, (String)prj.getName()));
    }

    private void updateAclTCR(String project, String sid, boolean principal, AclTCR aclTCR) {
        this.checkDependentColumnUpdate(aclTCR, this.getManager(AclTCRManager.class, project), sid, principal);
        this.getManager(AclTCRManager.class, project).updateAclTCR(aclTCR, sid, principal);
    }

    private List<AclTCRResponse.Column> getColumns(String project, String tableIdentity, AclTCR.ColumnRow columnRow, boolean isTableAuthorized, AclTCR.ColumnRow authorizedColumnRow) {
        if (Objects.isNull(columnRow) || Objects.isNull(columnRow.getColumn())) {
            return Lists.newArrayList();
        }
        boolean isNull = Objects.isNull(authorizedColumnRow);
        Map maskMap = isNull ? new HashMap() : authorizedColumnRow.getColumnSensitiveDataMaskMap();
        Map dependentColumnMap = isNull ? new HashMap() : authorizedColumnRow.getDependentColMap();
        Map<String, DataType> columnTypeMap = this.getTableColumnTypeMap(project, tableIdentity);
        return columnRow.getColumn().stream().map(colName -> {
            AclTCRResponse.Column col = new AclTCRResponse.Column();
            col.setColumnName((String)colName);
            col.setAuthorized(false);
            col.setDatatype(((DataType)columnTypeMap.get(colName)).toString());
            if (isTableAuthorized && (isNull || Objects.isNull(authorizedColumnRow.getColumn()))) {
                col.setAuthorized(true);
            } else if (!isNull && Objects.nonNull(authorizedColumnRow.getColumn())) {
                col.setAuthorized(authorizedColumnRow.getColumn().contains(colName));
            }
            if (maskMap.get(colName) != null) {
                col.setDataMaskType(((SensitiveDataMask)maskMap.get(colName)).getType());
            }
            if (dependentColumnMap.get(col.getColumnName()) != null) {
                col.setDependentColumns((Collection)dependentColumnMap.get(col.getColumnName()));
            }
            return col;
        }).collect(Collectors.toList());
    }

    private List<AclTCRResponse.Table> getTables(String project, String databaseName, AclTCR.Table table, AclTCR.Table authorizedTable) {
        if (Objects.isNull(table)) {
            return Lists.newArrayList();
        }
        boolean nonNull = Objects.nonNull(authorizedTable);
        return table.entrySet().stream().map(te -> {
            AclTCRResponse.Table tbl = new AclTCRResponse.Table();
            tbl.setTableName((String)te.getKey());
            tbl.setAuthorized(false);
            AclTCR.ColumnRow authorizedColumnRow = null;
            if (nonNull) {
                tbl.setAuthorized(authorizedTable.containsKey(te.getKey()));
                authorizedColumnRow = (AclTCR.ColumnRow)authorizedTable.get(te.getKey());
            }
            String tableIdentity = String.format(Locale.ROOT, IDENTIFIER_FORMAT, databaseName, te.getKey());
            List<AclTCRResponse.Column> columns = this.getColumns(project, tableIdentity, (AclTCR.ColumnRow)te.getValue(), tbl.isAuthorized(), authorizedColumnRow);
            tbl.setTotalColumnNum(columns.size());
            tbl.setAuthorizedColumnNum(columns.stream().filter(AclTCRResponse.Column::isAuthorized).mapToInt(i -> 1).sum());
            tbl.setColumns(columns);
            if (Objects.isNull(authorizedColumnRow)) {
                tbl.setRows(Lists.newArrayList());
                tbl.setLikeRows(Lists.newArrayList());
            } else {
                ArrayList notNullRowList = authorizedColumnRow.getRow() == null ? Lists.newArrayList() : this.transformResponseRow(authorizedColumnRow.getRow());
                tbl.setRows(notNullRowList);
                ArrayList notNullLikeRowList = authorizedColumnRow.getLikeRow() == null ? Lists.newArrayList() : this.transformResponseRow(authorizedColumnRow.getLikeRow());
                tbl.setLikeRows(notNullLikeRowList);
                if (authorizedColumnRow.getRowFilter() == null) {
                    tbl.setRowFilter(this.transformResponseFromOld(authorizedColumnRow.getRow(), authorizedColumnRow.getLikeRow()));
                } else {
                    tbl.setRowFilter(this.transformResponseRowFilter(authorizedColumnRow.getRowFilter()));
                }
            }
            return tbl;
        }).collect(Collectors.toList());
    }

    private AclTCRResponse.RowFilter transformResponseFromOld(AclTCR.Row row, AclTCR.Row likeRow) {
        AclTCRResponse.RowFilter respRowFilter = new AclTCRResponse.RowFilter();
        row = Optional.ofNullable(row).orElse(new AclTCR.Row());
        likeRow = Optional.ofNullable(likeRow).orElse(new AclTCR.Row());
        if (row.isEmpty() && likeRow.isEmpty()) {
            return respRowFilter;
        }
        HashSet columns = Sets.newHashSet();
        columns.addAll(row.keySet());
        columns.addAll(likeRow.keySet());
        ArrayList filterGroups = Lists.newArrayList();
        for (String columnName : columns) {
            AclTCRResponse.FilterGroup filterGroup = new AclTCRResponse.FilterGroup();
            filterGroup.setGroup(false);
            AclTCRResponse.Filter filter = new AclTCRResponse.Filter();
            filter.setColumnName(columnName);
            ArrayList inList = row.get((Object)columnName) != null ? Lists.newArrayList((Iterable)((Iterable)row.get((Object)columnName))) : Lists.newArrayList();
            filter.setInItems(inList);
            ArrayList likeList = likeRow.get((Object)columnName) != null ? Lists.newArrayList((Iterable)((Iterable)likeRow.get((Object)columnName))) : Lists.newArrayList();
            filter.setLikeItems(likeList);
            filterGroup.setFilters(Lists.newArrayList((Object[])new AclTCRResponse.Filter[]{filter}));
            filterGroups.add(filterGroup);
        }
        respRowFilter.setFilterGroups(filterGroups);
        return respRowFilter;
    }

    private List<AclTCRResponse> getAllTablesAclTCRResponse(String project, SortedMap<String, AclTCR.Table> authorized) {
        return this.getManager(AclTCRManager.class, project).getAllDbAclTable(project).entrySet().stream().map(de -> {
            AclTCRResponse response = new AclTCRResponse();
            response.setDatabaseName((String)de.getKey());
            response.setAuthorizedTableNum(Objects.isNull(authorized.get(de.getKey())) ? 0 : ((AclTCR.Table)authorized.get(de.getKey())).size());
            response.setTotalTableNum(((AclTCR.Table)de.getValue()).size());
            response.setTables(this.getTables(project, (String)de.getKey(), (AclTCR.Table)de.getValue(), (AclTCR.Table)authorized.get(de.getKey())));
            return response;
        }).collect(Collectors.toList());
    }

    private List<AclTCRResponse> getAclTCRResponse(String project, SortedMap<String, AclTCR.Table> db2AclTable) {
        return db2AclTable.entrySet().stream().map(de -> {
            AclTCRResponse response = new AclTCRResponse();
            response.setDatabaseName((String)de.getKey());
            response.setAuthorizedTableNum(((AclTCR.Table)de.getValue()).size());
            response.setTotalTableNum(((AclTCR.Table)de.getValue()).size());
            response.setTables(((AclTCR.Table)de.getValue()).entrySet().stream().map(te -> {
                Map maskMap = te.getValue() == null ? new HashMap() : ((AclTCR.ColumnRow)te.getValue()).getColumnSensitiveDataMaskMap();
                Map dependentColumnMap = te.getValue() == null ? new HashMap() : ((AclTCR.ColumnRow)te.getValue()).getDependentColMap();
                String tableIdentity = String.format(Locale.ROOT, IDENTIFIER_FORMAT, de.getKey(), te.getKey());
                Map<String, DataType> columnTypeMap = this.getTableColumnTypeMap(project, tableIdentity);
                AclTCRResponse.Table tbl = new AclTCRResponse.Table();
                tbl.setTableName((String)te.getKey());
                tbl.setAuthorized(true);
                tbl.setTotalColumnNum(((AclTCR.ColumnRow)te.getValue()).getColumn().size());
                tbl.setAuthorizedColumnNum(((AclTCR.ColumnRow)te.getValue()).getColumn().size());
                tbl.setColumns(((AclTCR.ColumnRow)te.getValue()).getColumn().stream().map(colName -> {
                    AclTCRResponse.Column col = new AclTCRResponse.Column();
                    col.setColumnName((String)colName);
                    col.setDatatype(((DataType)columnTypeMap.get(colName)).toString());
                    col.setAuthorized(true);
                    if (maskMap.get(colName) != null) {
                        col.setDataMaskType(((SensitiveDataMask)maskMap.get(colName)).getType());
                    }
                    if (dependentColumnMap.get(col.getColumnName()) != null) {
                        col.setDependentColumns((Collection)dependentColumnMap.get(col.getColumnName()));
                    }
                    return col;
                }).collect(Collectors.toList()));
                tbl.setRows(this.transformResponseRow(((AclTCR.ColumnRow)te.getValue()).getRow()));
                tbl.setLikeRows(this.transformResponseRow(((AclTCR.ColumnRow)te.getValue()).getLikeRow()));
                if (((AclTCR.ColumnRow)te.getValue()).getRowFilter() == null) {
                    tbl.setRowFilter(this.transformResponseFromOld(((AclTCR.ColumnRow)te.getValue()).getRow(), ((AclTCR.ColumnRow)te.getValue()).getLikeRow()));
                } else {
                    tbl.setRowFilter(this.transformResponseRowFilter(((AclTCR.ColumnRow)te.getValue()).getRowFilter()));
                }
                return tbl;
            }).collect(Collectors.toList()));
            return response;
        }).collect(Collectors.toList());
    }

    private List<AclTCRResponse.Row> transformResponseRow(AclTCR.Row aclRow) {
        if (MapUtils.isEmpty((Map)aclRow)) {
            return Lists.newArrayList();
        }
        return aclRow.entrySet().stream().filter(e -> Objects.nonNull(e.getValue())).map(entry -> {
            AclTCRResponse.Row row = new AclTCRResponse.Row();
            row.setColumnName((String)entry.getKey());
            row.setItems(Lists.newArrayList((Iterable)((Iterable)entry.getValue())));
            return row;
        }).collect(Collectors.toList());
    }

    private AclTCRResponse.RowFilter transformResponseRowFilter(List<AclTCR.FilterGroup> rowFilter) {
        AclTCRResponse.RowFilter respRowFilter = new AclTCRResponse.RowFilter();
        if (CollectionUtils.isEmpty(rowFilter)) {
            return respRowFilter;
        }
        respRowFilter.setType(rowFilter.get(0).getType().toString());
        rowFilter.forEach(filterGroup -> {
            AclTCR.Filters aclFilters = filterGroup.getFilters();
            AclTCRResponse.FilterGroup respFilterGroups = new AclTCRResponse.FilterGroup();
            respFilterGroups.setGroup(filterGroup.isGroup());
            if (aclFilters != null && aclFilters.size() > 0) {
                AclTCR.FilterItems aclFilter = (AclTCR.FilterItems)aclFilters.values().iterator().next();
                respFilterGroups.setType(aclFilter.getType().toString());
                ArrayList respFilters = Lists.newArrayList();
                for (Map.Entry entry : aclFilters.entrySet()) {
                    AclTCRResponse.Filter respFilter = new AclTCRResponse.Filter();
                    respFilter.setColumnName((String)entry.getKey());
                    AclTCR.FilterItems aclFilterItem = (AclTCR.FilterItems)entry.getValue();
                    respFilter.setInItems(Lists.newArrayList((Iterable)aclFilterItem.getInItems()));
                    respFilter.setLikeItems(Lists.newArrayList((Iterable)aclFilterItem.getLikeItems()));
                    respFilters.add(respFilter);
                }
                respFilterGroups.setFilters(respFilters);
            }
            respRowFilter.getFilterGroups().add(respFilterGroups);
        });
        return respRowFilter;
    }

    private List<AclTCRResponse> tagTableNum(List<AclTCRResponse> responses, Map<String, Map<String, Integer>> dbTblColNum) {
        responses.forEach(r -> {
            r.setTotalTableNum(((Map)dbTblColNum.get(r.getDatabaseName())).size());
            r.getTables().forEach(t -> t.setTotalColumnNum((Integer)((Map)dbTblColNum.get(r.getDatabaseName())).get(t.getTableName())));
        });
        return responses;
    }

    private void slim(String project, AclTCR aclTCR) {
        if (aclTCR == null || aclTCR.getTable() == null) {
            return;
        }
        aclTCR.getTable().forEach((dbTblName, columnRow) -> {
            if (Objects.isNull(columnRow)) {
                return;
            }
            if (Objects.nonNull(columnRow.getColumn()) && Optional.ofNullable(this.getManager(NTableMetadataManager.class, project).getTableDesc(dbTblName).getColumns()).map(Arrays::stream).orElseGet(Stream::empty).map(ColumnDesc::getName).allMatch(colName -> columnRow.getColumn().contains(colName) && columnRow.getColumnSensitiveDataMask() == null && columnRow.getDependentColumns() == null)) {
                columnRow.setColumn(null);
            }
            if (columnRow.isAllRowGranted() && Objects.isNull(columnRow.getColumn())) {
                aclTCR.getTable().put(dbTblName, null);
            }
        });
        if (this.getManager(NTableMetadataManager.class, project).listAllTables().stream().map(ATable::getIdentity).allMatch(dbTblName -> aclTCR.getTable().containsKey(dbTblName)) && aclTCR.getTable().entrySet().stream().allMatch(e -> Objects.isNull(e.getValue()))) {
            aclTCR.setTable(null);
        }
    }

    private AclTCR transformRequests(String project, List<AclTCRRequest> requests) {
        AclTCR aclTCR = new AclTCR();
        AclTCR.Table aclTable = new AclTCR.Table();
        this.checkAclRequestParam(project, requests);
        requests.stream().filter(d -> StringUtils.isNotEmpty((CharSequence)d.getDatabaseName())).forEach(d -> d.getTables().stream().filter(t -> t.isAuthorized() && StringUtils.isNotEmpty((CharSequence)t.getTableName())).forEach(t -> this.setColumnRow(aclTable, (AclTCRRequest)d, (AclTCRRequest.Table)t)));
        if (requests.stream().allMatch(d -> Optional.ofNullable(d.getTables()).map(Collection::stream).orElseGet(Stream::empty).allMatch(AclTCRRequest.Table::isAuthorized))) {
            this.getManager(NTableMetadataManager.class, project).listAllTables().stream().filter(t -> !aclTable.containsKey((Object)t.getIdentity())).map(ATable::getIdentity).forEach(dbTblName -> {
                AclTCR.ColumnRow cfr_ignored_0 = (AclTCR.ColumnRow)aclTable.put(dbTblName, null);
            });
        }
        aclTCR.setTable(aclTable);
        this.slim(project, aclTCR);
        this.checkDependentColumnUpdate(aclTCR);
        return aclTCR;
    }

    private AclTCR mergeRequests(String project, String sid, boolean principal, List<AclTCRRequest> requests) {
        this.checkAclRequestParam(project, requests);
        AclTCRManager aclTCRManager = this.getManager(AclTCRManager.class, project);
        AclTCR aclTCR = aclTCRManager.getAclTCR(sid, principal);
        if (aclTCR == null) {
            aclTCR = new AclTCR();
        }
        SortedMap allDbAclTable = aclTCRManager.getAllDbAclTable(project);
        AclTCR.Table aclTable = this.initTableAcl(aclTCR, allDbAclTable);
        for (AclTCRRequest request : requests) {
            String databaseName = request.getDatabaseName();
            List<AclTCRRequest.Table> tables = request.getTables();
            if (tables == null) continue;
            for (AclTCRRequest.Table table : tables) {
                String tableIdentity = String.format(Locale.ROOT, IDENTIFIER_FORMAT, databaseName, table.getTableName());
                if (!table.isAuthorized()) {
                    aclTable.remove((Object)String.format(Locale.ROOT, IDENTIFIER_FORMAT, databaseName, table.getTableName()));
                    continue;
                }
                AclTCR.ColumnRow columnRow = (AclTCR.ColumnRow)aclTable.get((Object)tableIdentity);
                if (columnRow == null) {
                    columnRow = new AclTCR.ColumnRow();
                    columnRow.setColumn(((AclTCR.ColumnRow)((AclTCR.Table)allDbAclTable.get(databaseName)).get((Object)table.getTableName())).getColumn());
                }
                this.updateColumnAcl(columnRow, table.getColumns());
                if (table.getRowFilter() != null) {
                    table.setRows(Lists.newArrayList());
                    table.setLikeRows(Lists.newArrayList());
                }
                this.updateRowAcl(columnRow, table.getRows(), table.getLikeRows());
                this.updateRowFilter(columnRow, table.getRowFilter());
                aclTable.put((Object)tableIdentity, (Object)columnRow);
            }
        }
        aclTCR.setTable(aclTable);
        this.slim(project, aclTCR);
        this.checkDependentColumnUpdate(aclTCR);
        this.checkRowAcl(aclTCR);
        return aclTCR;
    }

    private AclTCR.Table initTableAcl(AclTCR aclTCR, Map<String, AclTCR.Table> allDbAclTable) {
        AclTCR.Table aclTable = aclTCR.getTable();
        if (aclTable == null) {
            aclTable = new AclTCR.Table();
            for (Map.Entry<String, AclTCR.Table> entry : allDbAclTable.entrySet()) {
                for (Map.Entry tableColumnRowEntry : entry.getValue().entrySet()) {
                    aclTable.put((Object)String.format(Locale.ROOT, IDENTIFIER_FORMAT, entry.getKey(), tableColumnRowEntry.getKey()), tableColumnRowEntry.getValue());
                }
            }
            aclTCR.setTable(aclTable);
        }
        return aclTable;
    }

    private void updateColumnAcl(AclTCR.ColumnRow columnRow, List<AclTCRRequest.Column> columns) {
        if (columns == null) {
            return;
        }
        HashSet<SensitiveDataMask> masks = new HashSet<SensitiveDataMask>(Optional.ofNullable(columnRow.getColumnSensitiveDataMask()).orElse(new ArrayList()));
        HashSet<DependentColumn> dependentColumns = new HashSet<DependentColumn>(Optional.ofNullable(columnRow.getDependentColumns()).orElse(new ArrayList()));
        for (AclTCRRequest.Column column : columns) {
            masks.removeIf(sensitiveDataMask -> sensitiveDataMask.getColumn().equals(column.getColumnName()));
            dependentColumns.removeIf(dependentColumn -> dependentColumn.getColumn().equals(column.getColumnName()));
            if (column.isAuthorized()) {
                if (columnRow.getColumn() != null) {
                    columnRow.getColumn().add((Object)column.getColumnName());
                }
                if (column.getDataMaskType() != null) {
                    masks.add(new SensitiveDataMask(column.getColumnName(), column.getDataMaskType()));
                }
                if (column.getDependentColumns() == null) continue;
                for (AclTCRRequest.DependentColumnData dependentColumn2 : column.getDependentColumns()) {
                    dependentColumns.add(new DependentColumn(column.getColumnName(), dependentColumn2.getColumnIdentity(), dependentColumn2.getValues()));
                }
                continue;
            }
            columnRow.getColumn().remove((Object)column.getColumnName());
        }
        columnRow.setColumnSensitiveDataMask(new ArrayList(masks));
        columnRow.setDependentColumns(new ArrayList(dependentColumns));
    }

    private void updateRowAcl(AclTCR.ColumnRow columnRow, List<AclTCRRequest.Row> rows, List<AclTCRRequest.Row> likeRows) {
        if (rows != null) {
            columnRow.setRow(this.rowConverter(rows));
        }
        if (likeRows != null) {
            columnRow.setLikeRow(this.rowConverter(likeRows));
        }
    }

    private void updateRowFilter(AclTCR.ColumnRow columnRow, AclTCRRequest.RowFilter rowFilter) {
        if (rowFilter != null) {
            columnRow.setRowFilter(this.rowFilterConverter(rowFilter));
        }
    }

    private void setColumnRow(AclTCR.Table aclTable, AclTCRRequest req, AclTCRRequest.Table table) {
        AclTCR.Column aclColumn;
        String dbTblName = String.format(Locale.ROOT, IDENTIFIER_FORMAT, req.getDatabaseName(), table.getTableName());
        AclTCR.ColumnRow columnRow = new AclTCR.ColumnRow();
        if (Optional.ofNullable(table.getColumns()).map(Collection::stream).orElseGet(Stream::empty).allMatch(col -> col.isAuthorized() && col.getDataMaskType() == null && col.getDependentColumns() == null)) {
            aclColumn = null;
        } else {
            aclColumn = new AclTCR.Column();
            aclColumn.addAll((Collection)Optional.ofNullable(table.getColumns()).map(Collection::stream).orElseGet(Stream::empty).filter(AclTCRRequest.Column::isAuthorized).map(AclTCRRequest.Column::getColumnName).collect(Collectors.toSet()));
        }
        columnRow.setColumn(aclColumn);
        LinkedList<SensitiveDataMask> masks = new LinkedList<SensitiveDataMask>();
        for (AclTCRRequest.Column column : table.getColumns()) {
            if (column.getDataMaskType() == null) continue;
            masks.add(new SensitiveDataMask(column.getColumnName(), column.getDataMaskType()));
        }
        columnRow.setColumnSensitiveDataMask(masks);
        LinkedList<DependentColumn> dependentColumns = new LinkedList<DependentColumn>();
        for (AclTCRRequest.Column column : table.getColumns()) {
            if (column.getDependentColumns() == null) continue;
            for (AclTCRRequest.DependentColumnData dependentColumn : column.getDependentColumns()) {
                dependentColumns.add(new DependentColumn(column.getColumnName(), dependentColumn.getColumnIdentity(), dependentColumn.getValues()));
            }
        }
        columnRow.setDependentColumns(dependentColumns);
        AclTCR.Row row = this.rowConverter(table.getRows());
        columnRow.setRow(row);
        AclTCR.Row aclLikeRow = this.rowConverter(table.getLikeRows());
        columnRow.setLikeRow(aclLikeRow);
        aclTable.put((Object)dbTblName, (Object)columnRow);
    }

    private List<AclTCR.FilterGroup> rowFilterConverter(AclTCRRequest.RowFilter reqRowFilter) {
        ArrayList aclRowFilter = Lists.newArrayList();
        if (reqRowFilter == null || reqRowFilter.getFilterGroups() == null) {
            return aclRowFilter;
        }
        HashMap uniqueFilter = Maps.newHashMap();
        AclTCR.OperatorType reqGroupType = AclTCR.OperatorType.stringToEnum((String)reqRowFilter.getType());
        reqRowFilter.getFilterGroups().stream().forEach(reqFilterGroup -> {
            AclTCR.FilterGroup filterGroup = new AclTCR.FilterGroup();
            filterGroup.setType(reqGroupType);
            filterGroup.setGroup(reqFilterGroup.isGroup());
            AclTCR.OperatorType reqFilterType = AclTCR.OperatorType.stringToEnum((String)reqFilterGroup.getType());
            AclTCR.Filters filters = new AclTCR.Filters();
            if (reqFilterGroup.isGroup()) {
                reqFilterGroup.getFilters().stream().map(reqFilter -> new AbstractMap.SimpleEntry<String, AclTCR.FilterItems>(reqFilter.getColumnName(), new AclTCR.FilterItems((SortedSet)Sets.newTreeSet(reqFilter.getInItems()), (SortedSet)Sets.newTreeSet(reqFilter.getLikeItems()), reqFilterType))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> AclTCR.FilterItems.merge((AclTCR.FilterItems)v1, (AclTCR.FilterItems)v2))).forEach((columnName, FilterItems2) -> {
                    AclTCR.FilterItems cfr_ignored_0 = (AclTCR.FilterItems)filters.put(columnName, FilterItems2);
                });
            } else {
                AclTCRRequest.Filter reqFilter2 = reqFilterGroup.getFilters().get(0);
                AclTCR.FilterItems newFilterItem = new AclTCR.FilterItems((SortedSet)Sets.newTreeSet(reqFilter2.getInItems()), (SortedSet)Sets.newTreeSet(reqFilter2.getLikeItems()), reqFilterType);
                if (!uniqueFilter.containsKey(reqFilter2.getColumnName())) {
                    filters.put((Object)reqFilter2.getColumnName(), (Object)newFilterItem);
                }
                uniqueFilter.merge(reqFilter2.getColumnName(), newFilterItem, (v1, v2) -> AclTCR.FilterItems.merge((AclTCR.FilterItems)v1, (AclTCR.FilterItems)v2));
            }
            if (!filters.isEmpty()) {
                filterGroup.setFilters(filters);
                aclRowFilter.add(filterGroup);
            }
        });
        for (AclTCR.FilterGroup filterGroup : aclRowFilter) {
            if (filterGroup.isGroup()) continue;
            String columnName = (String)filterGroup.getFilters().keySet().iterator().next();
            filterGroup.getFilters().put((Object)columnName, uniqueFilter.get(columnName));
        }
        return aclRowFilter;
    }

    private AclTCR.Row rowConverter(List<AclTCRRequest.Row> requestRows) {
        AclTCR.Row aclRow;
        if (Optional.ofNullable(requestRows).map(Collection::stream).orElseGet(Stream::empty).allMatch(r -> CollectionUtils.isEmpty(r.getItems()))) {
            aclRow = null;
        } else {
            aclRow = new AclTCR.Row();
            requestRows.stream().filter(r -> CollectionUtils.isNotEmpty(r.getItems())).map(r -> new AbstractMap.SimpleEntry<String, HashSet>(r.getColumnName(), Sets.newHashSet(r.getItems()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
                v1.addAll(v2);
                return v1;
            })).forEach((colName, rows) -> {
                AclTCR.RealRow realRow = new AclTCR.RealRow();
                realRow.addAll((Collection)rows);
                aclRow.put(colName, (Object)realRow);
            });
        }
        return aclRow;
    }

    private void checkDependentColumnUpdate(AclTCR aclTCR, AclTCRManager aclTCRManager, String sid, boolean principal) {
        if (!principal) {
            return;
        }
        Set<String> groups = this.userGroupService.listUserGroups(sid);
        List aclTCRs = aclTCRManager.getAclTCRs(sid, groups);
        aclTCRs.add(aclTCR);
        this.checkDependentColumnUpdate(aclTCRs);
    }

    private void checkDependentColumnUpdate(AclTCR aclTCR) {
        this.checkDependentColumnUpdate(Lists.newArrayList((Object[])new AclTCR[]{aclTCR}));
    }

    private void checkRowAcl(AclTCR aclTCR) {
        this.checkRowAcl(Lists.newArrayList((Object[])new AclTCR[]{aclTCR}));
    }

    private void checkDependentColumnUpdate(List<AclTCR> aclTCRList) {
        Set dependentColumnIdentities = aclTCRList.stream().filter(Objects::nonNull).filter(acl -> acl.getTable() != null).flatMap(acl -> acl.getTable().values().stream()).filter(Objects::nonNull).filter(cr -> cr.getDependentColumns() != null).flatMap(cr -> cr.getDependentColumns().stream()).map(DependentColumn::getDependentColumnIdentity).collect(Collectors.toSet());
        Set dependsOnDependentColumnSet = aclTCRList.stream().filter(Objects::nonNull).map(AclTCR::getTable).filter(Objects::nonNull).map(TreeMap::entrySet).flatMap(Collection::stream).filter(entry -> entry.getValue() != null).filter(entry -> ((AclTCR.ColumnRow)entry.getValue()).getDependentColumns() != null).map(entry -> ((AclTCR.ColumnRow)entry.getValue()).getDependentColumns().stream().filter(dependentColumn -> dependentColumnIdentities.contains((String)entry.getKey() + "." + dependentColumn.getColumn())).map(DependentColumn::getColumn).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
        if (!dependsOnDependentColumnSet.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getNotSupportNestedDependentCol(), String.join((CharSequence)", ", dependsOnDependentColumnSet)));
        }
        for (String dependentColumnIdentity : dependentColumnIdentities) {
            if (!aclTCRList.stream().noneMatch(acl -> acl.isColumnAuthorized(dependentColumnIdentity))) continue;
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidColumnAccess(), dependentColumnIdentity));
        }
    }

    private void checkRowAcl(List<AclTCR> aclTCRList) {
        aclTCRList.stream().filter(Objects::nonNull).map(AclTCR::getTable).filter(Objects::nonNull).map(TreeMap::entrySet).flatMap(Collection::stream).filter(entry -> entry.getValue() != null).filter(entry -> ((AclTCR.ColumnRow)entry.getValue()).getRow() != null).forEach(entry -> ((AclTCR.ColumnRow)entry.getValue()).getRow().keySet().forEach(column -> {
            if (aclTCRList.stream().noneMatch(acl -> acl.isColumnAuthorized(String.format(Locale.ROOT, IDENTIFIER_FORMAT, entry.getKey(), column)))) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidColumnAccess(), column));
            }
        }));
    }

    public void checkAclRequestParam(String project, List<AclTCRRequest> requests) {
        NTableMetadataManager tableManager = this.getTableMetadataManager(project);
        requests.forEach(d -> d.getTables().stream().filter(AclTCRRequest.Table::isAuthorized).filter(table -> !Optional.ofNullable(table.getRows()).map(Collection::stream).orElseGet(Stream::empty).allMatch(r -> CollectionUtils.isEmpty(r.getItems()))).forEach(table -> {
            String tableName = String.format(Locale.ROOT, IDENTIFIER_FORMAT, d.getDatabaseName(), table.getTableName());
            TableDesc tableDesc = tableManager.getTableDesc(tableName);
            table.getRows().stream().filter(r -> CollectionUtils.isNotEmpty(r.getItems())).forEach(rows -> {
                ColumnDesc columnDesc = tableDesc.findColumnByName(rows.getColumnName());
                if (!columnDesc.getType().isNumberFamily()) {
                    return;
                }
                String columnName = tableName + "." + rows.getColumnName();
                rows.getItems().forEach(item -> {
                    try {
                        Double.parseDouble(item);
                    }
                    catch (Exception e) {
                        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getColumnParameterInvalid(columnName));
                    }
                });
            });
        }));
        requests.forEach(d -> d.getTables().stream().filter(AclTCRRequest.Table::isAuthorized).forEach(table -> {
            String tableName = String.format(Locale.ROOT, IDENTIFIER_FORMAT, d.getDatabaseName(), table.getTableName());
            TableDesc tableDesc = tableManager.getTableDesc(tableName);
            this.checkSensitiveDataMaskRequest((AclTCRRequest.Table)table, tableDesc);
        }));
    }

    private void checkSensitiveDataMaskRequest(AclTCRRequest.Table table, TableDesc tableDesc) {
        if (table.getColumns() == null) {
            return;
        }
        for (AclTCRRequest.Column column : table.getColumns()) {
            if (column.getDataMaskType() != null && !column.isAuthorized()) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidColumnAccess(), column.getColumnName()));
            }
            if (column.getDataMaskType() == null || SensitiveDataMask.isValidDataType((String)tableDesc.findColumnByName(column.getColumnName()).getDatatype())) continue;
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getInvalidSensitiveDataMaskColumnType());
        }
    }

    private Map<String, Map<String, Integer>> getDbTblColNum(String project) {
        HashMap dbTblColNum = Maps.newHashMap();
        this.getManager(NTableMetadataManager.class, project).listAllTables().forEach(tableDesc -> {
            if (!dbTblColNum.containsKey(tableDesc.getDatabase())) {
                dbTblColNum.put(tableDesc.getDatabase(), Maps.newHashMap());
            }
            ((Map)dbTblColNum.get(tableDesc.getDatabase())).put(tableDesc.getName(), tableDesc.getColumnCount());
        });
        return dbTblColNum;
    }

    private Map<String, DataType> getTableColumnTypeMap(String project, String tableIdentity) {
        NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        TableDesc tableDesc = tableMetadataManager.getTableDesc(tableIdentity);
        if (tableDesc == null) {
            return Maps.newHashMap();
        }
        return Arrays.stream(tableDesc.getColumns()).collect(Collectors.toMap(ColumnDesc::getName, ColumnDesc::getType, (u, v) -> u, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
    }

    @VisibleForTesting
    public NKylinUserManager getKylinUserManager() {
        return NKylinUserManager.getInstance((KylinConfig)this.getConfig());
    }

    public List<TableDesc> getAuthorizedTables(String project, String user) {
        Set groups = this.getKylinUserManager().getUserGroups(user);
        return this.getAuthorizedTables(project, user, groups);
    }

    @VisibleForTesting
    public NTableMetadataManager getTableMetadataManager(String project) {
        Preconditions.checkNotNull((Object)project);
        return NTableMetadataManager.getInstance((KylinConfig)this.getConfig(), (String)project);
    }

    @VisibleForTesting
    boolean canUseACLGreenChannel(String project) {
        return AclPermissionUtil.canUseACLGreenChannel((String)project, this.getCurrentUserGroups());
    }

    @VisibleForTesting
    public List<TableDesc> getAuthorizedTables(String project, String user, Set<String> groups) {
        List aclTCRS = this.getManager(AclTCRManager.class, project).getAclTCRs(user, groups);
        return this.getTableMetadataManager(project).listAllTables().stream().filter(tableDesc -> aclTCRS.stream().anyMatch(aclTCR -> aclTCR.isAuthorized(tableDesc.getIdentity()))).collect(Collectors.toList());
    }

    public boolean remoteGrantACL(String projectId, List<AccessRequest> accessRequests) throws IOException {
        AclGrantEventNotifier notifier = new AclGrantEventNotifier(projectId, JsonUtil.writeValueAsString(accessRequests));
        this.updateAclFromRemote(notifier, null);
        return true;
    }

    public boolean remoteRevokeACL(String projectId, String sid, boolean principal) throws IOException {
        AclRevokeEventNotifier notifier = new AclRevokeEventNotifier(projectId, sid, principal);
        this.updateAclFromRemote(null, notifier);
        return true;
    }

    public void updateAclFromRemote(AclGrantEventNotifier grantEventNotifier, AclRevokeEventNotifier revokeEventNotifier) throws IOException {
        if (grantEventNotifier != null) {
            List accessRequest = (List)JsonUtil.readValue((String)grantEventNotifier.getRawAclTCRRequests(), (TypeReference)new TypeReference<List<AccessRequest>>(){});
            this.updateAclTCR(grantEventNotifier.getProjectId(), accessRequest);
        } else if (revokeEventNotifier != null) {
            this.revokeAclTCR(revokeEventNotifier.getProjectId(), revokeEventNotifier.getSid(), revokeEventNotifier.isPrincipal());
        }
    }
}

