/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;

@Profile(value={"ldap", "saml"})
@Configuration
public class LdapSamlProfileConfiguration {
    @Value(value="${kylin.security.ldap.connection-server}")
    private String connectionServer;
    @Value(value="${kylin.security.ldap.connection-username}")
    private String connectionUsername;
    @Value(value="${kylin.security.ldap.connection-password}")
    private String connectionPassword;

    @Bean(value={"ldapSource"})
    public LdapContextSource ldapSource() {
        DefaultSpringSecurityContextSource ldapSource = new DefaultSpringSecurityContextSource(this.connectionServer);
        ldapSource.setUserDn(this.connectionUsername);
        ldapSource.setPassword(this.connectionPassword);
        return ldapSource;
    }
}

