/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.kylin.rest.security.LoginLogFilter;
import org.apache.kylin.rest.util.SecurityLoggerUtils;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SecurityLogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityLogAspect.class);
    @Autowired
    private LoginLogFilter loginLogFilter;

    @AfterReturning(value="(execution(* org.apache.kylin.rest.security.LimitLoginAuthenticationProvider.authenticate(..)) || execution(* org.apache.kylin.rest.security.OpenAuthenticationProvider.authenticate(..))|| execution(* org.apache.kylin.rest.security.LdapAuthenticationProvider.authenticate(..))) && args(authentication)")
    public void doAfterLoginSuccess(Authentication authentication) {
        if (null == this.loginLogFilter.getLoginInfoThreadLocal().get()) {
            this.loginLogFilter.getLoginInfoThreadLocal().set(new LoginLogFilter.LoginInfo());
        }
        this.loginLogFilter.getLoginInfoThreadLocal().get().setUserName(authentication.getName());
        this.loginLogFilter.getLoginInfoThreadLocal().get().setLoginSuccess(Boolean.TRUE);
    }

    @AfterThrowing(pointcut="(execution(* org.apache.kylin.rest.security.LimitLoginAuthenticationProvider.authenticate(..)) || execution(* org.apache.kylin.rest.security.OpenAuthenticationProvider.authenticate(..))|| execution(* org.apache.kylin.rest.security.LdapAuthenticationProvider.authenticate(..))) && args(authentication)", throwing="exception")
    public void doAfterLoginError(Authentication authentication, Exception exception) {
        if (null == this.loginLogFilter.getLoginInfoThreadLocal().get()) {
            this.loginLogFilter.getLoginInfoThreadLocal().set(new LoginLogFilter.LoginInfo());
        }
        this.loginLogFilter.getLoginInfoThreadLocal().get().setUserName(authentication.getName());
        this.loginLogFilter.getLoginInfoThreadLocal().get().setLoginSuccess(Boolean.FALSE);
        this.loginLogFilter.getLoginInfoThreadLocal().get().setException(exception);
    }

    @AfterReturning(value="execution(* org.springframework.security.web.authentication.logout.LogoutSuccessHandler.onLogoutSuccess(..)) && args(request, response, authentication)", argNames="request, response, authentication")
    public void doAfterLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        SecurityLoggerUtils.recordLogout((String)authentication.getName());
    }
}

