/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.util.Collection;
import org.apache.kylin.common.annotation.ThirdPartyDependencies;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.rest.service.NUserGroupService;
import org.apache.kylin.rest.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

@ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"StaticAuthenticationProvider"})})
public abstract class OpenAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(OpenAuthenticationProvider.class);
    @Autowired
    @Qualifier(value="userService")
    UserService userService;
    @Autowired
    @Qualifier(value="userGroupService")
    NUserGroupService userGroupService;

    public UserService getUserService() {
        return this.userService;
    }

    public NUserGroupService getUserGroupService() {
        return this.userGroupService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        ManagedUser user;
        if (!this.authenticateImpl(authentication)) {
            logger.error("Failed to auth user: {}", authentication.getPrincipal());
            throw new BadCredentialsException(ErrorCodeServer.USER_LOGIN_FAILED.getMsg(new Object[0]));
        }
        try {
            user = (ManagedUser)this.getUserService().loadUserByUsername((String)authentication.getPrincipal());
        }
        catch (Exception e) {
            String userName = (String)authentication.getPrincipal();
            String password = (String)authentication.getCredentials();
            user = new ManagedUser(userName, password, Boolean.valueOf(true), new String[]{"ALL_USERS"});
        }
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)user, authentication.getCredentials(), (Collection)user.getAuthorities());
        return token;
    }

    public abstract boolean authenticateImpl(Authentication var1);

    public final boolean supports(Class<?> aClass) {
        return true;
    }
}

