/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.metrics.reporter;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.kylin.common.metrics.reporter.ServerModeMetricFilter;
import org.apache.kylin.common.metrics.service.InfluxDBInstance;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.shaded.influxdb.org.influxdb.InfluxDB;
import org.apache.kylin.shaded.influxdb.org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxdbReporter
extends ScheduledReporter {
    private static final Logger logger = LoggerFactory.getLogger(InfluxdbReporter.class);
    private final ConcurrentHashMap<String, PointBuilder.Point> metrics = new ConcurrentHashMap();
    private final InfluxDBInstance influxInstance;
    private final Clock clock;
    private final Transformer transformer;
    private final String defaultMeasurement;
    private final String host;
    private static final String COUNT = "count";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String MEAN = "mean";
    private static final String STANDARD_DEVIATION = "std-dev";
    private static final String FIFTY_PERCENTILE = "50p";
    private static final String SEVENTY_FIVE_PERCENTILE = "75p";
    private static final String NINETY_FIVE_PERCENTILE = "95p";
    private static final String NINETY_NINE_PERCENTILE = "99p";
    private static final String NINETY_NINE_POINT_NINE_PERCENTILE = "999p";
    private static final String RUN_COUNT = "run-count";
    private static final String ONE_MINUTE = "1-minute";
    private static final String FIVE_MINUTE = "5-minute";
    private static final String FIFTEEN_MINUTE = "15-minute";
    private static final String MEAN_MINUTE = "mean-minute";
    private static final Set<Class> VALID_FIELD_CLASSES = ImmutableSet.of(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, (Object[])new Class[]{Long.class, Short.class, String.class});

    public InfluxdbReporter(InfluxDBInstance influxInstance, String defaultMeasurement, MetricRegistry registry, String name) {
        super(registry, name, (MetricFilter)new ServerModeMetricFilter(), TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
        this.influxInstance = influxInstance;
        this.clock = Clock.defaultClock();
        this.transformer = new Transformer();
        this.defaultMeasurement = defaultMeasurement;
        this.host = AddressUtil.getZkLocalInstance();
    }

    public InfluxDB getInfluxDb() {
        return this.influxInstance.getInfluxDB();
    }

    public ImmutableList<PointBuilder.Point> getMetrics() {
        return ImmutableList.copyOf(this.metrics.values());
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            long startAt = System.currentTimeMillis();
            if (!this.getInfluxDb().ping().isGood()) {
                throw new IllegalStateException("the pinged influxdb is not good.");
            }
            long timestamp = this.clock.getTime();
            ImmutableList points = ImmutableList.builder().addAll(this.transformer.fromGauges(gauges, this.defaultMeasurement, timestamp, TimeUnit.MILLISECONDS)).addAll(this.transformer.fromCounters(counters, this.defaultMeasurement, timestamp, TimeUnit.MILLISECONDS)).addAll(this.transformer.fromHistograms(histograms, this.defaultMeasurement, timestamp, TimeUnit.MILLISECONDS)).addAll(this.transformer.fromMeters(meters, this.defaultMeasurement, timestamp, TimeUnit.MILLISECONDS)).addAll(this.transformer.fromTimers(timers, this.defaultMeasurement, timestamp, TimeUnit.MILLISECONDS)).build();
            points.stream().filter(Objects::nonNull).map(PointBuilder.Point::convert).forEach(p -> this.getInfluxDb().write(p));
            this.getInfluxDb().flush();
            MetricsGroup.counterInc(MetricsName.SUMMARY_COUNTER, MetricsCategory.HOST, this.host);
            MetricsGroup.counterInc(MetricsName.SUMMARY_DURATION, MetricsCategory.HOST, this.host, System.currentTimeMillis() - startAt);
            points.stream().filter(Objects::nonNull).forEach(point -> this.metrics.putIfAbsent(point.getUniqueKey(), (PointBuilder.Point)point));
            logger.debug("kylin.metrics report data: {} points", (Object)points.size());
        }
        catch (Exception e) {
            logger.info("[UNEXPECTED_THINGS_HAPPENED] kylin.metrics report data failed {}", (Object)e.getMessage());
        }
    }

    public static class PointBuilder {
        private final String measurement;
        private final long timestamp;
        private final TimeUnit timeUnit;
        private final Map<String, String> tags = new TreeMap<String, String>();
        private final Map<String, Object> fields = new TreeMap<String, Object>();

        public PointBuilder(String measurement, long timestamp, TimeUnit timeUnit) {
            this.measurement = measurement;
            this.timestamp = timestamp;
            this.timeUnit = timeUnit;
        }

        private String handleCollection(String key, Collection collection) {
            for (Object value : collection) {
                if (this.isValidField(value)) continue;
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Measure collection field '%s' must contain only Strings and primitives: invalid field '%s'", key, value));
            }
            return collection.toString();
        }

        private <T> boolean isValidField(T value) {
            return value == null || VALID_FIELD_CLASSES.contains(value.getClass());
        }

        private <T> Optional<T> handleField(T value) {
            if (value instanceof Float) {
                float f = ((Float)value).floatValue();
                if (!Float.isNaN(f) && !Float.isInfinite(f)) {
                    return Optional.of(value);
                }
            } else if (value instanceof Double) {
                double d = (Double)value;
                if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                    return Optional.of(value);
                }
            } else {
                if (value instanceof Number) {
                    return Optional.of(value);
                }
                if (value instanceof String || value instanceof Character || value instanceof Boolean) {
                    return Optional.of(value);
                }
            }
            return Optional.empty();
        }

        public PointBuilder putTag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public PointBuilder putTags(Map<String, String> items) {
            this.tags.putAll(items);
            return this;
        }

        public <T> PointBuilder putField(String key, T value) {
            if (value instanceof Collection) {
                this.fields.put(key, this.handleCollection(key, (Collection)value));
            } else if (value != null) {
                this.handleField(value).ifPresent(s -> this.fields.put(key, s));
            }
            return this;
        }

        public <T> PointBuilder putFields(Map<String, T> items) {
            items.forEach(this::putField);
            return this;
        }

        public Point build() {
            if (this.fields.isEmpty()) {
                return null;
            }
            return new Point(this.measurement, this.tags, this.timestamp, this.timeUnit, this.fields);
        }

        public static class Point {
            private String measurement;
            private Map<String, String> tags;
            private Long time;
            private TimeUnit precision;
            private Map<String, Object> fields;

            public org.apache.kylin.shaded.influxdb.org.influxdb.dto.Point convert() {
                return org.apache.kylin.shaded.influxdb.org.influxdb.dto.Point.measurement((String)this.measurement).time(this.time.longValue(), this.precision).tag(this.tags).fields(this.fields).build();
            }

            public String getUniqueKey() {
                StringBuilder builder = new StringBuilder();
                builder.append("Point [name=");
                builder.append(this.measurement);
                builder.append(", tags=");
                builder.append(this.tags);
                builder.append(", fields=");
                builder.append(this.fields.keySet());
                builder.append("]");
                return builder.toString();
            }

            @Generated
            public String getMeasurement() {
                return this.measurement;
            }

            @Generated
            public Map<String, String> getTags() {
                return this.tags;
            }

            @Generated
            public Long getTime() {
                return this.time;
            }

            @Generated
            public TimeUnit getPrecision() {
                return this.precision;
            }

            @Generated
            public Map<String, Object> getFields() {
                return this.fields;
            }

            @Generated
            public void setMeasurement(String measurement) {
                this.measurement = measurement;
            }

            @Generated
            public void setTags(Map<String, String> tags) {
                this.tags = tags;
            }

            @Generated
            public void setTime(Long time) {
                this.time = time;
            }

            @Generated
            public void setPrecision(TimeUnit precision) {
                this.precision = precision;
            }

            @Generated
            public void setFields(Map<String, Object> fields) {
                this.fields = fields;
            }

            @Generated
            public Point(String measurement, Map<String, String> tags, Long time, TimeUnit precision, Map<String, Object> fields) {
                this.measurement = measurement;
                this.tags = tags;
                this.time = time;
                this.precision = precision;
                this.fields = fields;
            }
        }
    }

    private class Transformer {
        private Transformer() {
        }

        public List<PointBuilder.Point> fromGauges(Map<String, Gauge> gauges, String measurement, long timestamp, TimeUnit timeUnit) {
            return this.fromGaugesOrCounters(gauges, Gauge::getValue, measurement, timestamp, timeUnit);
        }

        public List<PointBuilder.Point> fromCounters(Map<String, Counter> counters, String measurement, long timestamp, TimeUnit timeUnit) {
            return this.fromGaugesOrCounters(counters, Counter::getCount, measurement, timestamp, timeUnit);
        }

        public List<PointBuilder.Point> fromHistograms(Map<String, Histogram> histograms, String measurement, long timestamp, TimeUnit timeUnit) {
            return histograms.entrySet().stream().map(e -> {
                try {
                    Pair<String, Map<String, String>> nameTags = this.parseNameTags((String)e.getKey());
                    Histogram histogram = (Histogram)e.getValue();
                    Snapshot snapshot = histogram.getSnapshot();
                    return new PointBuilder(measurement, timestamp, timeUnit).putTags((Map)nameTags.getSecond()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.COUNT), snapshot.size()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.MIN), snapshot.getMin()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.MAX), snapshot.getMax()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.MEAN), snapshot.getMean()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.STANDARD_DEVIATION), snapshot.getStdDev()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.FIFTY_PERCENTILE), snapshot.getMedian()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.SEVENTY_FIVE_PERCENTILE), snapshot.get75thPercentile()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.NINETY_FIVE_PERCENTILE), snapshot.get95thPercentile()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.NINETY_NINE_PERCENTILE), snapshot.get99thPercentile()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.NINETY_NINE_POINT_NINE_PERCENTILE), snapshot.get999thPercentile()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.RUN_COUNT), histogram.getCount()).build();
                }
                catch (Exception ex) {
                    logger.error("[UNEXPECTED_THINGS_HAPPENED] kylin.metrics histogram {}", e.getKey(), (Object)ex);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public List<PointBuilder.Point> fromMeters(Map<String, Meter> meters, String measurement, long timestamp, TimeUnit timeUnit) {
            return meters.entrySet().stream().map(e -> {
                try {
                    Pair<String, Map<String, String>> nameTags = this.parseNameTags((String)e.getKey());
                    Meter meter = (Meter)e.getValue();
                    return new PointBuilder(measurement, timestamp, timeUnit).putTags((Map)nameTags.getSecond()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.COUNT), meter.getCount()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.ONE_MINUTE), InfluxdbReporter.this.convertRate(meter.getOneMinuteRate())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.FIVE_MINUTE), InfluxdbReporter.this.convertRate(meter.getFiveMinuteRate())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.FIFTEEN_MINUTE), InfluxdbReporter.this.convertRate(meter.getFifteenMinuteRate())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.MEAN_MINUTE), InfluxdbReporter.this.convertRate(meter.getMeanRate())).build();
                }
                catch (Exception ex) {
                    logger.error("[UNEXPECTED_THINGS_HAPPENED] kylin.metrics meter {}", e.getKey(), (Object)ex);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public List<PointBuilder.Point> fromTimers(Map<String, Timer> timers, String measurement, long timestamp, TimeUnit timeUnit) {
            return timers.entrySet().stream().map(e -> {
                try {
                    Pair<String, Map<String, String>> nameTags = this.parseNameTags((String)e.getKey());
                    Timer timer = (Timer)e.getValue();
                    Snapshot snapshot = timer.getSnapshot();
                    return new PointBuilder(measurement, timestamp, timeUnit).putTags((Map)nameTags.getSecond()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.COUNT), snapshot.size()).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.MIN), InfluxdbReporter.this.convertDuration(snapshot.getMin())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.MAX), InfluxdbReporter.this.convertDuration(snapshot.getMax())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.MEAN), InfluxdbReporter.this.convertDuration(snapshot.getMean())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.STANDARD_DEVIATION), InfluxdbReporter.this.convertDuration(snapshot.getStdDev())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.FIFTY_PERCENTILE), InfluxdbReporter.this.convertDuration(snapshot.getMedian())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.SEVENTY_FIVE_PERCENTILE), InfluxdbReporter.this.convertDuration(snapshot.get75thPercentile())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.NINETY_FIVE_PERCENTILE), InfluxdbReporter.this.convertDuration(snapshot.get95thPercentile())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.NINETY_NINE_PERCENTILE), InfluxdbReporter.this.convertDuration(snapshot.get99thPercentile())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.NINETY_NINE_POINT_NINE_PERCENTILE), InfluxdbReporter.this.convertDuration(snapshot.get999thPercentile())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.ONE_MINUTE), InfluxdbReporter.this.convertRate(timer.getOneMinuteRate())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.FIVE_MINUTE), InfluxdbReporter.this.convertRate(timer.getFiveMinuteRate())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.FIFTEEN_MINUTE), InfluxdbReporter.this.convertRate(timer.getFifteenMinuteRate())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.MEAN_MINUTE), InfluxdbReporter.this.convertRate(timer.getMeanRate())).putField(this.filedName((String)nameTags.getFirst(), InfluxdbReporter.RUN_COUNT), timer.getCount()).build();
                }
                catch (Exception ex) {
                    logger.error("[UNEXPECTED_THINGS_HAPPENED] kylin.metrics timer {}", e.getKey(), (Object)ex);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }

        private <T, R> List<PointBuilder.Point> fromGaugesOrCounters(Map<String, T> items, Function<T, R> valueExtractor, String measurement, long timestamp, TimeUnit timeUnit) {
            return items.entrySet().stream().map(e -> {
                try {
                    Pair<String, Map<String, String>> nameTags = this.parseNameTags((String)e.getKey());
                    Object value = valueExtractor.apply(e.getValue());
                    return new PointBuilder(measurement, timestamp, timeUnit).putTags((Map)nameTags.getSecond()).putField((String)nameTags.getFirst(), value).build();
                }
                catch (Exception ex) {
                    logger.error("[UNEXPECTED_THINGS_HAPPENED] kylin.metrics gauge or counter {}", e.getKey(), (Object)ex);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }

        private Pair<String, Map<String, String>> parseNameTags(String metricName) {
            Preconditions.checkNotNull((Object)metricName);
            String[] nameTags = metricName.split(":", 2);
            Map<String, String> tags = Arrays.asList(nameTags[1].split(",")).stream().map(t -> {
                String[] keyVal = t.split("=", 2);
                return new AbstractMap.SimpleEntry<String, String>(keyVal[0], keyVal[1]);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return Pair.newPair((Object)nameTags[0], tags);
        }

        private String filedName(String prefix, String suffix) {
            return String.join((CharSequence)"_", prefix, suffix);
        }
    }
}

