/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.ArrayTagSet;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.CompositeCounter;
import com.netflix.spectator.api.CompositeDistributionSummary;
import com.netflix.spectator.api.CompositeGauge;
import com.netflix.spectator.api.CompositeTimer;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DefaultId;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.NoopCounter;
import com.netflix.spectator.api.NoopDistributionSummary;
import com.netflix.spectator.api.NoopGauge;
import com.netflix.spectator.api.NoopTimer;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.SwapCounter;
import com.netflix.spectator.api.SwapDistributionSummary;
import com.netflix.spectator.api.SwapGauge;
import com.netflix.spectator.api.SwapTimer;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public final class CompositeRegistry
implements Registry {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock rlock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock wlock = this.lock.writeLock();
    private final Clock clock;
    private final List<Registry> registries;
    private final AtomicLong version;
    private final ConcurrentHashMap<Id, Object> state;

    CompositeRegistry(Clock clock) {
        this.clock = clock;
        this.registries = new ArrayList<Registry>();
        this.version = new AtomicLong();
        this.state = new ConcurrentHashMap();
    }

    <T extends Registry> T find(Class<T> c) {
        for (Registry r : this.registries) {
            if (!c.isAssignableFrom(r.getClass())) continue;
            return (T)r;
        }
        return null;
    }

    public void add(Registry registry) {
        this.wlock.lock();
        try {
            if (!this.registries.contains(registry)) {
                this.registries.add(registry);
                this.version.incrementAndGet();
            }
        }
        finally {
            this.wlock.unlock();
        }
    }

    public void remove(Registry registry) {
        this.wlock.lock();
        try {
            if (this.registries.remove(registry)) {
                this.version.incrementAndGet();
            }
        }
        finally {
            this.wlock.unlock();
        }
    }

    public void removeAll() {
        this.wlock.lock();
        try {
            this.registries.clear();
            this.state.clear();
        }
        finally {
            this.wlock.unlock();
        }
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public Id createId(String name) {
        return new DefaultId(name);
    }

    @Override
    public Id createId(String name, Iterable<Tag> tags) {
        return new DefaultId(name, ArrayTagSet.create(tags));
    }

    @Override
    public void register(Meter meter) {
        PolledMeter.monitorMeter(this, meter);
    }

    @Override
    public ConcurrentMap<Id, Object> state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Counter newCounter(Id id) {
        this.rlock.lock();
        try {
            Counter c;
            switch (this.registries.size()) {
                case 0: {
                    c = NoopCounter.INSTANCE;
                    break;
                }
                case 1: {
                    c = this.registries.get(0).counter(id);
                    break;
                }
                default: {
                    List<Counter> cs = this.registries.stream().map(r -> r.counter(id)).collect(Collectors.toList());
                    c = new CompositeCounter(id, (Collection<Counter>)cs);
                }
            }
            NoopCounter noopCounter = c;
            return noopCounter;
        }
        finally {
            this.rlock.unlock();
        }
    }

    @Override
    public Counter counter(Id id) {
        return new SwapCounter((Registry)this, this.version::get, id, this.newCounter(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DistributionSummary newDistributionSummary(Id id) {
        this.rlock.lock();
        try {
            DistributionSummary t;
            switch (this.registries.size()) {
                case 0: {
                    t = NoopDistributionSummary.INSTANCE;
                    break;
                }
                case 1: {
                    t = this.registries.get(0).distributionSummary(id);
                    break;
                }
                default: {
                    List<DistributionSummary> ds = this.registries.stream().map(r -> r.distributionSummary(id)).collect(Collectors.toList());
                    t = new CompositeDistributionSummary(id, (Collection<DistributionSummary>)ds);
                }
            }
            NoopDistributionSummary noopDistributionSummary = t;
            return noopDistributionSummary;
        }
        finally {
            this.rlock.unlock();
        }
    }

    @Override
    public DistributionSummary distributionSummary(Id id) {
        return new SwapDistributionSummary((Registry)this, this.version::get, id, this.newDistributionSummary(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer newTimer(Id id) {
        this.rlock.lock();
        try {
            Timer t;
            switch (this.registries.size()) {
                case 0: {
                    t = NoopTimer.INSTANCE;
                    break;
                }
                case 1: {
                    t = this.registries.get(0).timer(id);
                    break;
                }
                default: {
                    List<Timer> ts = this.registries.stream().map(r -> r.timer(id)).collect(Collectors.toList());
                    t = new CompositeTimer(id, this.clock, ts);
                }
            }
            NoopTimer noopTimer = t;
            return noopTimer;
        }
        finally {
            this.rlock.unlock();
        }
    }

    @Override
    public Timer timer(Id id) {
        return new SwapTimer((Registry)this, this.version::get, id, this.newTimer(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Gauge newGauge(Id id) {
        this.rlock.lock();
        try {
            Gauge t;
            switch (this.registries.size()) {
                case 0: {
                    t = NoopGauge.INSTANCE;
                    break;
                }
                case 1: {
                    t = this.registries.get(0).gauge(id);
                    break;
                }
                default: {
                    List<Gauge> gs = this.registries.stream().map(r -> r.gauge(id)).collect(Collectors.toList());
                    t = new CompositeGauge(id, (Collection<Gauge>)gs);
                }
            }
            NoopGauge noopGauge = t;
            return noopGauge;
        }
        finally {
            this.rlock.unlock();
        }
    }

    @Override
    public Gauge gauge(Id id) {
        return new SwapGauge((Registry)this, this.version::get, id, this.newGauge(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Gauge newMaxGauge(Id id) {
        this.rlock.lock();
        try {
            Gauge t;
            switch (this.registries.size()) {
                case 0: {
                    t = NoopGauge.INSTANCE;
                    break;
                }
                case 1: {
                    t = this.registries.get(0).maxGauge(id);
                    break;
                }
                default: {
                    List<Gauge> gs = this.registries.stream().map(r -> r.maxGauge(id)).collect(Collectors.toList());
                    t = new CompositeGauge(id, (Collection<Gauge>)gs);
                }
            }
            NoopGauge noopGauge = t;
            return noopGauge;
        }
        finally {
            this.rlock.unlock();
        }
    }

    @Override
    public Gauge maxGauge(Id id) {
        return new SwapGauge((Registry)this, this.version::get, id, this.newMaxGauge(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Meter get(Id id) {
        this.rlock.lock();
        try {
            for (Registry r : this.registries) {
                Meter m = r.get(id);
                if (m == null) continue;
                if (m instanceof Counter) {
                    Counter counter = this.counter(id);
                    return counter;
                }
                if (m instanceof Timer) {
                    Timer timer = this.timer(id);
                    return timer;
                }
                if (m instanceof DistributionSummary) {
                    DistributionSummary distributionSummary = this.distributionSummary(id);
                    return distributionSummary;
                }
                if (m instanceof Gauge) {
                    Gauge gauge = this.gauge(id);
                    return gauge;
                }
                Meter meter = null;
                return meter;
            }
            Iterator<Registry> iterator = null;
            return iterator;
        }
        finally {
            this.rlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Meter> iterator() {
        this.rlock.lock();
        try {
            if (this.registries.isEmpty()) {
                Iterator<Meter> iterator = Collections.emptyIterator();
                return iterator;
            }
            final HashSet<Id> ids = new HashSet<Id>();
            for (Registry r : this.registries) {
                for (Meter m : r) {
                    ids.add(m.id());
                }
            }
            Iterator<Meter> iterator = new Iterator<Meter>(){
                private final Iterator<Id> idIter;
                {
                    this.idIter = ids.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.idIter.hasNext();
                }

                @Override
                public Meter next() {
                    return CompositeRegistry.this.get(this.idIter.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return iterator;
        }
        finally {
            this.rlock.unlock();
        }
    }
}

