/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.Schema;
import org.apache.iceberg.view.ViewHistoryEntry;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewVersion;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ViewMetadata", generator="Immutables")
@Immutable
final class ImmutableViewMetadata
implements ViewMetadata {
    private final String uuid;
    private final int formatVersion;
    private final String location;
    private final List<Schema> schemas;
    private final int currentVersionId;
    private final List<ViewVersion> versions;
    private final List<ViewHistoryEntry> history;
    private final Map<String, String> properties;
    private final List<MetadataUpdate> changes;
    @Nullable
    private final String metadataFileLocation;
    private final Map<Integer, ViewVersion> versionsById;
    private final Map<Integer, Schema> schemasById;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableViewMetadata(String uuid, int formatVersion, String location, Iterable<? extends Schema> schemas, int currentVersionId, Iterable<? extends ViewVersion> versions, Iterable<? extends ViewHistoryEntry> history, Map<String, ? extends String> properties, Iterable<? extends MetadataUpdate> changes, @Nullable String metadataFileLocation) {
        this.uuid = Objects.requireNonNull(uuid, "uuid");
        this.formatVersion = formatVersion;
        this.location = Objects.requireNonNull(location, "location");
        this.schemas = ImmutableViewMetadata.createUnmodifiableList(false, ImmutableViewMetadata.createSafeList(schemas, true, false));
        this.currentVersionId = currentVersionId;
        this.versions = ImmutableViewMetadata.createUnmodifiableList(false, ImmutableViewMetadata.createSafeList(versions, true, false));
        this.history = ImmutableViewMetadata.createUnmodifiableList(false, ImmutableViewMetadata.createSafeList(history, true, false));
        this.properties = ImmutableViewMetadata.createUnmodifiableMap(true, false, properties);
        this.changes = ImmutableViewMetadata.createUnmodifiableList(false, ImmutableViewMetadata.createSafeList(changes, true, false));
        this.metadataFileLocation = metadataFileLocation;
        this.versionsById = this.initShim.versionsById();
        this.schemasById = this.initShim.schemasById();
        this.initShim = null;
    }

    private ImmutableViewMetadata(ImmutableViewMetadata original, String uuid, int formatVersion, String location, List<Schema> schemas, int currentVersionId, List<ViewVersion> versions, List<ViewHistoryEntry> history, Map<String, String> properties, List<MetadataUpdate> changes, @Nullable String metadataFileLocation) {
        this.uuid = uuid;
        this.formatVersion = formatVersion;
        this.location = location;
        this.schemas = schemas;
        this.currentVersionId = currentVersionId;
        this.versions = versions;
        this.history = history;
        this.properties = properties;
        this.changes = changes;
        this.metadataFileLocation = metadataFileLocation;
        this.versionsById = this.initShim.versionsById();
        this.schemasById = this.initShim.schemasById();
        this.initShim = null;
    }

    private Map<Integer, ViewVersion> versionsByIdInitialize() {
        return ViewMetadata.super.versionsById();
    }

    private Map<Integer, Schema> schemasByIdInitialize() {
        return ViewMetadata.super.schemasById();
    }

    @Override
    public String uuid() {
        return this.uuid;
    }

    @Override
    public int formatVersion() {
        return this.formatVersion;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public List<Schema> schemas() {
        return this.schemas;
    }

    @Override
    public int currentVersionId() {
        return this.currentVersionId;
    }

    @Override
    public List<ViewVersion> versions() {
        return this.versions;
    }

    @Override
    public List<ViewHistoryEntry> history() {
        return this.history;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public List<MetadataUpdate> changes() {
        return this.changes;
    }

    @Override
    @Nullable
    public String metadataFileLocation() {
        return this.metadataFileLocation;
    }

    @Override
    public Map<Integer, ViewVersion> versionsById() {
        InitShim shim = this.initShim;
        return shim != null ? shim.versionsById() : this.versionsById;
    }

    @Override
    public Map<Integer, Schema> schemasById() {
        InitShim shim = this.initShim;
        return shim != null ? shim.schemasById() : this.schemasById;
    }

    public final ImmutableViewMetadata withUuid(String value) {
        String newValue = Objects.requireNonNull(value, "uuid");
        if (this.uuid.equals(newValue)) {
            return this;
        }
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(this, newValue, this.formatVersion, this.location, this.schemas, this.currentVersionId, this.versions, this.history, this.properties, this.changes, this.metadataFileLocation));
    }

    public final ImmutableViewMetadata withFormatVersion(int value) {
        if (this.formatVersion == value) {
            return this;
        }
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(this, this.uuid, value, this.location, this.schemas, this.currentVersionId, this.versions, this.history, this.properties, this.changes, this.metadataFileLocation));
    }

    public final ImmutableViewMetadata withLocation(String value) {
        String newValue = Objects.requireNonNull(value, "location");
        if (this.location.equals(newValue)) {
            return this;
        }
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(this, this.uuid, this.formatVersion, newValue, this.schemas, this.currentVersionId, this.versions, this.history, this.properties, this.changes, this.metadataFileLocation));
    }

    public final ImmutableViewMetadata withSchemas(Schema ... elements) {
        List<Schema> newValue = ImmutableViewMetadata.createUnmodifiableList(false, ImmutableViewMetadata.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(this, this.uuid, this.formatVersion, this.location, newValue, this.currentVersionId, this.versions, this.history, this.properties, this.changes, this.metadataFileLocation));
    }

    public final ImmutableViewMetadata withSchemas(Iterable<? extends Schema> elements) {
        if (this.schemas == elements) {
            return this;
        }
        List<Schema> newValue = ImmutableViewMetadata.createUnmodifiableList(false, ImmutableViewMetadata.createSafeList(elements, true, false));
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(this, this.uuid, this.formatVersion, this.location, newValue, this.currentVersionId, this.versions, this.history, this.properties, this.changes, this.metadataFileLocation));
    }

    public final ImmutableViewMetadata withCurrentVersionId(int value) {
        if (this.currentVersionId == value) {
            return this;
        }
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(this, this.uuid, this.formatVersion, this.location, this.schemas, value, this.versions, this.history, this.properties, this.changes, this.metadataFileLocation));
    }

    public final ImmutableViewMetadata withVersions(ViewVersion ... elements) {
        List<ViewVersion> newValue = ImmutableViewMetadata.createUnmodifiableList(false, ImmutableViewMetadata.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(this, this.uuid, this.formatVersion, this.location, this.schemas, this.currentVersionId, newValue, this.history, this.properties, this.changes, this.metadataFileLocation));
    }

    public final ImmutableViewMetadata withVersions(Iterable<? extends ViewVersion> elements) {
        if (this.versions == elements) {
            return this;
        }
        List<ViewVersion> newValue = ImmutableViewMetadata.createUnmodifiableList(false, ImmutableViewMetadata.createSafeList(elements, true, false));
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(this, this.uuid, this.formatVersion, this.location, this.schemas, this.currentVersionId, newValue, this.history, this.properties, this.changes, this.metadataFileLocation));
    }

    public final ImmutableViewMetadata withHistory(ViewHistoryEntry ... elements) {
        List<ViewHistoryEntry> newValue = ImmutableViewMetadata.createUnmodifiableList(false, ImmutableViewMetadata.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(this, this.uuid, this.formatVersion, this.location, this.schemas, this.currentVersionId, this.versions, newValue, this.properties, this.changes, this.metadataFileLocation));
    }

    public final ImmutableViewMetadata withHistory(Iterable<? extends ViewHistoryEntry> elements) {
        if (this.history == elements) {
            return this;
        }
        List<ViewHistoryEntry> newValue = ImmutableViewMetadata.createUnmodifiableList(false, ImmutableViewMetadata.createSafeList(elements, true, false));
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(this, this.uuid, this.formatVersion, this.location, this.schemas, this.currentVersionId, this.versions, newValue, this.properties, this.changes, this.metadataFileLocation));
    }

    public final ImmutableViewMetadata withProperties(Map<String, ? extends String> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableViewMetadata.createUnmodifiableMap(true, false, entries);
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(this, this.uuid, this.formatVersion, this.location, this.schemas, this.currentVersionId, this.versions, this.history, newValue, this.changes, this.metadataFileLocation));
    }

    public final ImmutableViewMetadata withChanges(MetadataUpdate ... elements) {
        List<MetadataUpdate> newValue = ImmutableViewMetadata.createUnmodifiableList(false, ImmutableViewMetadata.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(this, this.uuid, this.formatVersion, this.location, this.schemas, this.currentVersionId, this.versions, this.history, this.properties, newValue, this.metadataFileLocation));
    }

    public final ImmutableViewMetadata withChanges(Iterable<? extends MetadataUpdate> elements) {
        if (this.changes == elements) {
            return this;
        }
        List<MetadataUpdate> newValue = ImmutableViewMetadata.createUnmodifiableList(false, ImmutableViewMetadata.createSafeList(elements, true, false));
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(this, this.uuid, this.formatVersion, this.location, this.schemas, this.currentVersionId, this.versions, this.history, this.properties, newValue, this.metadataFileLocation));
    }

    public final ImmutableViewMetadata withMetadataFileLocation(@Nullable String value) {
        if (Objects.equals(this.metadataFileLocation, value)) {
            return this;
        }
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(this, this.uuid, this.formatVersion, this.location, this.schemas, this.currentVersionId, this.versions, this.history, this.properties, this.changes, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableViewMetadata && this.equalTo(0, (ImmutableViewMetadata)another);
    }

    private boolean equalTo(int synthetic, ImmutableViewMetadata another) {
        return this.uuid.equals(another.uuid) && this.formatVersion == another.formatVersion && this.location.equals(another.location) && this.schemas.equals(another.schemas) && this.currentVersionId == another.currentVersionId && this.versions.equals(another.versions) && this.history.equals(another.history) && this.properties.equals(another.properties) && this.changes.equals(another.changes) && Objects.equals(this.metadataFileLocation, another.metadataFileLocation) && this.versionsById.equals(another.versionsById) && this.schemasById.equals(another.schemasById);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.uuid.hashCode();
        h += (h << 5) + this.formatVersion;
        h += (h << 5) + this.location.hashCode();
        h += (h << 5) + this.schemas.hashCode();
        h += (h << 5) + this.currentVersionId;
        h += (h << 5) + this.versions.hashCode();
        h += (h << 5) + this.history.hashCode();
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.changes.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadataFileLocation);
        h += (h << 5) + this.versionsById.hashCode();
        h += (h << 5) + this.schemasById.hashCode();
        return h;
    }

    public String toString() {
        return "ViewMetadata{uuid=" + this.uuid + ", formatVersion=" + this.formatVersion + ", location=" + this.location + ", schemas=" + this.schemas + ", currentVersionId=" + this.currentVersionId + ", versions=" + this.versions + ", history=" + this.history + ", properties=" + this.properties + ", changes=" + this.changes + ", metadataFileLocation=" + this.metadataFileLocation + ", versionsById=" + this.versionsById + ", schemasById=" + this.schemasById + "}";
    }

    public static ImmutableViewMetadata of(String uuid, int formatVersion, String location, List<Schema> schemas, int currentVersionId, List<ViewVersion> versions, List<ViewHistoryEntry> history, Map<String, String> properties, List<MetadataUpdate> changes, @Nullable String metadataFileLocation) {
        return ImmutableViewMetadata.of(uuid, formatVersion, location, schemas, currentVersionId, versions, history, properties, changes, metadataFileLocation);
    }

    public static ImmutableViewMetadata of(String uuid, int formatVersion, String location, Iterable<? extends Schema> schemas, int currentVersionId, Iterable<? extends ViewVersion> versions, Iterable<? extends ViewHistoryEntry> history, Map<String, ? extends String> properties, Iterable<? extends MetadataUpdate> changes, @Nullable String metadataFileLocation) {
        return ImmutableViewMetadata.validate(new ImmutableViewMetadata(uuid, formatVersion, location, schemas, currentVersionId, versions, history, properties, changes, metadataFileLocation));
    }

    private static ImmutableViewMetadata validate(ImmutableViewMetadata instance) {
        instance.check();
        return instance;
    }

    public static ImmutableViewMetadata copyOf(ViewMetadata instance) {
        if (instance instanceof ImmutableViewMetadata) {
            return (ImmutableViewMetadata)instance;
        }
        return ImmutableViewMetadata.of(instance.uuid(), instance.formatVersion(), instance.location(), instance.schemas(), instance.currentVersionId(), instance.versions(), instance.history(), instance.properties(), instance.changes(), instance.metadataFileLocation());
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableViewMetadata.validate(this);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ViewMetadata", generator="Immutables")
    private final class InitShim {
        private byte versionsByIdBuildStage = 0;
        private Map<Integer, ViewVersion> versionsById;
        private byte schemasByIdBuildStage = 0;
        private Map<Integer, Schema> schemasById;

        private InitShim() {
        }

        Map<Integer, ViewVersion> versionsById() {
            if (this.versionsByIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionsByIdBuildStage == 0) {
                this.versionsByIdBuildStage = (byte)-1;
                this.versionsById = Objects.requireNonNull(ImmutableViewMetadata.this.versionsByIdInitialize(), "versionsById");
                this.versionsByIdBuildStage = 1;
            }
            return this.versionsById;
        }

        Map<Integer, Schema> schemasById() {
            if (this.schemasByIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemasByIdBuildStage == 0) {
                this.schemasByIdBuildStage = (byte)-1;
                this.schemasById = Objects.requireNonNull(ImmutableViewMetadata.this.schemasByIdInitialize(), "schemasById");
                this.schemasByIdBuildStage = 1;
            }
            return this.schemasById;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.versionsByIdBuildStage == -1) {
                attributes.add("versionsById");
            }
            if (this.schemasByIdBuildStage == -1) {
                attributes.add("schemasById");
            }
            return "Cannot build ViewMetadata, attribute initializers form cycle " + attributes;
        }
    }
}

