/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.response.SQLResponseTrace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLResponseV2
implements Serializable {
    protected static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SQLResponseV2.class);
    private List<SelectedColumnMeta> columnMetas;
    private transient Iterable<List<String>> results;
    protected int affectedRowCount;
    @JsonProperty(value="isException")
    protected boolean isException;
    protected String exceptionMessage;
    protected Throwable throwable;
    protected long duration;
    protected boolean isPartial = false;
    private List<Long> scanRows;
    private List<Long> scanBytes;
    private String appMasterURL = "";
    protected int failTimes = -1;
    protected long resultRowCount;
    protected int shufflePartitions;
    protected boolean hitExceptionCache = false;
    protected boolean storageCacheUsed = false;
    protected String storageCacheType;
    @JsonProperty(value="dataFetchTime")
    protected long dataFetchTime;
    @JsonProperty(value="pushDown")
    protected boolean queryPushDown = false;
    @JsonProperty(value="is_prepare")
    private boolean isPrepare = false;
    @JsonProperty(value="is_timeout")
    private boolean isTimeout;
    protected byte[] queryStatistics;
    protected String queryId;
    private String server;
    @JsonProperty(value="is_stop_by_user")
    private boolean isStopByUser;
    private String signature;
    @JsonProperty(value="realizations")
    private List<NativeQueryRealization> nativeRealizations;
    private String engineType;
    private transient List<SQLResponseTrace> traces;
    private String cube;
    private long totalScanCount;
    private boolean isSparderUsed;

    public SQLResponseV2() {
    }

    public SQLResponseV2(SQLResponse sqlResponse) {
        Preconditions.checkNotNull((Object)sqlResponse);
        this.columnMetas = sqlResponse.getColumnMetas();
        this.results = sqlResponse.getResults();
        this.affectedRowCount = sqlResponse.getAffectedRowCount();
        this.isException = sqlResponse.isException();
        this.exceptionMessage = sqlResponse.getExceptionMessage();
        this.throwable = sqlResponse.getThrowable();
        this.duration = sqlResponse.getDuration();
        this.isPartial = sqlResponse.isPartial();
        this.scanRows = sqlResponse.getScanRows();
        this.scanBytes = sqlResponse.getScanBytes();
        this.appMasterURL = sqlResponse.getAppMasterURL();
        this.failTimes = sqlResponse.getFailTimes();
        this.resultRowCount = sqlResponse.getResultRowCount();
        this.shufflePartitions = sqlResponse.getShufflePartitions();
        this.hitExceptionCache = sqlResponse.isHitExceptionCache();
        this.storageCacheUsed = sqlResponse.isStorageCacheUsed();
        this.storageCacheType = sqlResponse.getStorageCacheType();
        this.dataFetchTime = sqlResponse.getDataFetchTime();
        this.queryPushDown = sqlResponse.isQueryPushDown();
        this.isPrepare = sqlResponse.isPrepare();
        this.isTimeout = sqlResponse.isTimeout();
        this.queryStatistics = sqlResponse.getQueryStatistics();
        this.queryId = sqlResponse.getQueryId();
        this.server = sqlResponse.getServer();
        this.isStopByUser = sqlResponse.isStopByUser();
        this.signature = sqlResponse.getSignature();
        this.nativeRealizations = sqlResponse.getNativeRealizations();
        this.engineType = sqlResponse.getEngineType();
        this.traces = sqlResponse.getTraces();
        this.isSparderUsed = CollectionUtils.isNotEmpty(sqlResponse.getNativeRealizations());
        this.cube = this.adapterCubeField(sqlResponse.getNativeRealizations());
    }

    @JsonIgnore
    public Throwable getThrowable() {
        return this.throwable;
    }

    public long getTotalScanRows() {
        return QueryContext.calValueWithDefault(this.scanRows);
    }

    public long getTotalScanBytes() {
        return QueryContext.calValueWithDefault(this.scanBytes);
    }

    public boolean isSparderUsed() {
        return this.isSparderUsed;
    }

    public long getTotalScanCount() {
        long totalCount = QueryContext.calValueWithDefault(this.scanRows);
        return totalCount < 0L ? 0L : totalCount;
    }

    public String adapterCubeField(List<NativeQueryRealization> realizations) {
        String join2;
        if (CollectionUtils.isEmpty(realizations)) {
            return "";
        }
        List relatedModelAlias = realizations.stream().filter(e -> !"Table Index".equals(e.getType())).map(e -> "CUBE[name=" + e.getModelAlias() + "]").distinct().collect(Collectors.toList());
        List relateIndexModelAlias = realizations.stream().filter(e -> "Table Index".equals(e.getType())).map(e -> "INVERTED_INDEX[name=" + e.getModelAlias() + "]").distinct().collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        String join1 = String.join((CharSequence)",", relatedModelAlias);
        if (StringUtils.isNotBlank((CharSequence)join1)) {
            stringBuilder.append(join1);
        }
        if (StringUtils.isNotBlank((CharSequence)(join2 = String.join((CharSequence)",", relateIndexModelAlias)))) {
            stringBuilder.append(StringUtils.isBlank((CharSequence)stringBuilder.toString()) ? "" : ",").append(join2);
        }
        return stringBuilder.toString();
    }

    @Generated
    public List<SelectedColumnMeta> getColumnMetas() {
        return this.columnMetas;
    }

    @Generated
    public Iterable<List<String>> getResults() {
        return this.results;
    }

    @Generated
    public int getAffectedRowCount() {
        return this.affectedRowCount;
    }

    @Generated
    public boolean isException() {
        return this.isException;
    }

    @Generated
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public boolean isPartial() {
        return this.isPartial;
    }

    @Generated
    public List<Long> getScanRows() {
        return this.scanRows;
    }

    @Generated
    public List<Long> getScanBytes() {
        return this.scanBytes;
    }

    @Generated
    public String getAppMasterURL() {
        return this.appMasterURL;
    }

    @Generated
    public long getResultRowCount() {
        return this.resultRowCount;
    }

    @Generated
    public int getShufflePartitions() {
        return this.shufflePartitions;
    }

    @Generated
    public boolean isHitExceptionCache() {
        return this.hitExceptionCache;
    }

    @Generated
    public boolean isStorageCacheUsed() {
        return this.storageCacheUsed;
    }

    @Generated
    public String getStorageCacheType() {
        return this.storageCacheType;
    }

    @Generated
    public long getDataFetchTime() {
        return this.dataFetchTime;
    }

    @Generated
    public boolean isQueryPushDown() {
        return this.queryPushDown;
    }

    @Generated
    public boolean isPrepare() {
        return this.isPrepare;
    }

    @Generated
    public boolean isTimeout() {
        return this.isTimeout;
    }

    @Generated
    public byte[] getQueryStatistics() {
        return this.queryStatistics;
    }

    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public boolean isStopByUser() {
        return this.isStopByUser;
    }

    @Generated
    public List<NativeQueryRealization> getNativeRealizations() {
        return this.nativeRealizations;
    }

    @Generated
    public String getEngineType() {
        return this.engineType;
    }

    @Generated
    public List<SQLResponseTrace> getTraces() {
        return this.traces;
    }

    @Generated
    public String getCube() {
        return this.cube;
    }

    @Generated
    public void setColumnMetas(List<SelectedColumnMeta> columnMetas) {
        this.columnMetas = columnMetas;
    }

    @Generated
    public void setResults(Iterable<List<String>> results) {
        this.results = results;
    }

    @Generated
    public void setAffectedRowCount(int affectedRowCount) {
        this.affectedRowCount = affectedRowCount;
    }

    @Generated
    public void setException(boolean isException) {
        this.isException = isException;
    }

    @Generated
    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    @Generated
    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Generated
    public void setPartial(boolean isPartial) {
        this.isPartial = isPartial;
    }

    @Generated
    public void setScanRows(List<Long> scanRows) {
        this.scanRows = scanRows;
    }

    @Generated
    public void setScanBytes(List<Long> scanBytes) {
        this.scanBytes = scanBytes;
    }

    @Generated
    public void setAppMasterURL(String appMasterURL) {
        this.appMasterURL = appMasterURL;
    }

    @Generated
    public void setResultRowCount(long resultRowCount) {
        this.resultRowCount = resultRowCount;
    }

    @Generated
    public void setShufflePartitions(int shufflePartitions) {
        this.shufflePartitions = shufflePartitions;
    }

    @Generated
    public void setHitExceptionCache(boolean hitExceptionCache) {
        this.hitExceptionCache = hitExceptionCache;
    }

    @Generated
    public void setStorageCacheUsed(boolean storageCacheUsed) {
        this.storageCacheUsed = storageCacheUsed;
    }

    @Generated
    public void setStorageCacheType(String storageCacheType) {
        this.storageCacheType = storageCacheType;
    }

    @Generated
    public void setDataFetchTime(long dataFetchTime) {
        this.dataFetchTime = dataFetchTime;
    }

    @Generated
    public void setQueryPushDown(boolean queryPushDown) {
        this.queryPushDown = queryPushDown;
    }

    @Generated
    public void setPrepare(boolean isPrepare) {
        this.isPrepare = isPrepare;
    }

    @Generated
    public void setTimeout(boolean isTimeout) {
        this.isTimeout = isTimeout;
    }

    @Generated
    public void setQueryStatistics(byte[] queryStatistics) {
        this.queryStatistics = queryStatistics;
    }

    @Generated
    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setStopByUser(boolean isStopByUser) {
        this.isStopByUser = isStopByUser;
    }

    @Generated
    public void setNativeRealizations(List<NativeQueryRealization> nativeRealizations) {
        this.nativeRealizations = nativeRealizations;
    }

    @Generated
    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    @Generated
    public void setTraces(List<SQLResponseTrace> traces) {
        this.traces = traces;
    }

    @Generated
    public void setCube(String cube) {
        this.cube = cube;
    }

    @Generated
    public void setTotalScanCount(long totalScanCount) {
        this.totalScanCount = totalScanCount;
    }

    @Generated
    public void setSparderUsed(boolean isSparderUsed) {
        this.isSparderUsed = isSparderUsed;
    }

    @Generated
    public int getFailTimes() {
        return this.failTimes;
    }

    @Generated
    public void setFailTimes(int failTimes) {
        this.failTimes = failTimes;
    }

    @Generated
    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }
}

